

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMSpoolCopyUnpickedForBackupCopyAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2019  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMSpoolCopyUnpickedForBackupCopyAlert.sp,v $ $Id: MM_SMSpoolCopyUnpickedForBackupCopyAlert.sp,v 1.1.2.1 2020/12/18 12:40:59 bbrindavan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMSpoolCopyUnpickedForBackupCopyAlert')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMSpoolCopyUnpickedForBackupCopyAlert <<<'
	drop procedure MM_SMSpoolCopyUnpickedForBackupCopyAlert
END
IF EXISTS (select * from GxQscripts where name='MM_SMSpoolCopyUnpickedForBackupCopyAlert')
	delete from GxQscripts where name = 'MM_SMSpoolCopyUnpickedForBackupCopyAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSpoolCopyUnpickedForBackupCopyAlert')
	delete from GXDBVersions where aliasname = 'MM_SMSpoolCopyUnpickedForBackupCopyAlert'
GO
print '... Creating Procedure: MM_SMSpoolCopyUnpickedForBackupCopyAlert'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMSpoolCopyUnpickedForBackupCopyAlert
AS
SELECT DISTINCT VOL.SMVolumeId as VolumeId,
				(spCopy.name +' / '+ sp.name) as StoragePolicy,
				CLNT.name as SourceClient,
				(BS.name + ' / ' + APP.subclientName) as SubClient  ,
				APPTYPE.name AS ApplicationType,
				(CASE WHEN VOL.OriginSourcePath <> '' THEN VOL.OriginSourcePath ELSE VOL.SourcePath END) as SourcePath,
				VOL.JobId as SnapJob,
				dbo.UTCToClientLocalTime(dbo.GetDateTime(VOL.CreationTime), 2) as CreationTime,
				CTRL.SmArrayId as Array,
				ENG.SnapEngineName as SnapEngine
FROM    SMVolume VOL WITH (READUNCOMMITTED)
        INNER JOIN	SMVolSnapMap MAP WITH (READUNCOMMITTED) ON VOL.SMVolumeId = MAP.SMVolumeId
        INNER JOIN  SMSnap SNAP WITH (READUNCOMMITTED) ON SNAP.SMSnapId = MAP.SMSnapId
        INNER JOIN  APP_iDAType APPTYPE WITH (READUNCOMMITTED) ON APPTYPE.type = VOL.AppTypeId
		INNER JOIN  JMJobSnapshotStats as jmJob WITH (READUNCOMMITTED) ON jmJob.jobId = VOL.JobId
		INNER JOIN	ArchGroupCopy as spCopy WITH (READUNCOMMITTED) ON  spCopy.archGroupId = jmJob.archGrpId
		INNER JOIN	ArchAgingRule as agingRule WITH (READUNCOMMITTED) ON agingRule.CopyId = spCopy.Id
		INNER JOIN	ArchGroup as sp WITH (READUNCOMMITTED) ON sp.Id = spCopy.archGroupId
		INNER JOIN  APP_Client CLNT WITH (READUNCOMMITTED) ON CLNT.id = (CASE WHEN VOL.AppTypeId =13 THEN VOL.OriginClientId  -- CV_APPTYPE_NAS_FS 13
														 ELSE VOL.SourceClientId END)
		INNER JOIN  APP_Application APP WITH (READUNCOMMITTED) ON VOL.AppId = APP.id
        INNER JOIN  APP_BackupSetName BS WITH (READUNCOMMITTED) ON BS.id = APP.backupSet
		INNER JOIN  SMSnapShotEngine ENG WITH (READUNCOMMITTED) ON SNAP.SnapShotEngineId = ENG.SnapShotEngineId
		INNER JOIN  SMControlHost CTRL WITH (READUNCOMMITTED) ON SNAP.ControlHostId = CTRL.ControlHostId
WHERE	agingRule.retentionDays 	= 	0 					AND
		agingRule.fullCycles 		= 	0					AND   		-- spool copy
		jmJob.materializationStatus > 	100 				AND			-- backup not done  (For BACKUP/AUXCOPY)
		jmJob.disabled 				in (1,16,32,64)			AND			-- backup copy unpicked (CVA_DONOTCOPY_FLAG/CVA_SYSTEM_DONOTCOPY/CVA_AUXCOPY_SKIPPED/CVA_BAD_JOB_FLAG)
VOL.MountStatus 			< 	90 			-- Snap deletion not tried
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMSpoolCopyUnpickedForBackupCopyAlert')
	delete from GxQscripts where name = 'MM_SMSpoolCopyUnpickedForBackupCopyAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSpoolCopyUnpickedForBackupCopyAlert')
	delete from GXDBVersions where aliasname = 'MM_SMSpoolCopyUnpickedForBackupCopyAlert'
GO

insert into GXDBVersions values(2, 'MM_SMSpoolCopyUnpickedForBackupCopyAlert',  '00010001000200010000', 'MM_SMSpoolCopyUnpickedForBackupCopyAlert', '00010001000200010000')
GO

