

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMSnapToReplGroupAssoc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMSnapToReplGroupAssoc.sp,v $ $Id: MM_SMSnapToReplGroupAssoc.sp,v 1.1.4.3 2018/03/20 00:05:46 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMSnapToReplGroupAssoc <<<'

IF EXISTS (select * from sysobjects where name='MM_SMSnapToReplGroupAssoc')
	drop procedure MM_SMSnapToReplGroupAssoc
IF EXISTS (select * from GxQscripts where name='MM_SMSnapToReplGroupAssoc')
	delete from GxQscripts where name = 'MM_SMSnapToReplGroupAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSnapToReplGroupAssoc')
	delete from GXDBVersions where aliasname = 'MM_SMSnapToReplGroupAssoc'
GO
print '... Creating Procedure: MM_SMSnapToReplGroupAssoc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMSnapToReplGroupAssoc
  @i_xmlText XML
AS
  DECLARE @o_MMErrorCode integer
  DECLARE @o_ErrorMsg varchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/*
Input XML
<MM_SMSnapToReplGroupAssoc>
	<CopyId>2222</CopyId>
	<AppId>4444</AppId>
	<Assoc replicaGroupId="30" snapId="245" />
	<Assoc replicaGroupId="32" snapId="545" />
	<Assoc replicaGroupId="31" snapId="645" />
</MM_SMSnapToReplGroupAssoc>
*/
IF OBJECT_ID('tempdb.dbo.#tblSnapToReplGroupMap') IS NOT NULL
	DROP TABLE #tblSnapToReplGroupMap
CREATE TABLE #tblSnapToReplGroupMap
(
	ReplicaGroupId	int,
	SMSnapId		int
)
DECLARE @x_CopyId integer = 0
DECLARE @x_AppId integer = 0
DECLARE @errorString	nvarchar(1024) = ''
DECLARE @errorCode INT = 0
-- Read the inputs from the input XML
SET @x_CopyId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMSnapToReplGroupAssoc/CopyId') R(ref)), 0)
SET @x_AppId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMSnapToReplGroupAssoc/AppId') R(ref)), 0)
-- Read the replica groups
INSERT INTO #tblSnapToReplGroupMap
SELECT	ref.value('@replicaGroupId', 'int'),
		ref.value('@snapId', 'int')
FROM	@i_xmlText.nodes('/MM_SMSnapToReplGroupAssoc/Assoc') R(ref)
BEGIN TRY
	BEGIN TRANSACTION SnapToReplicaGroupAssoc
	-- If a row already exists for the SMSnapId, then update the replica group id
	UPDATE	MAP
	SET		ReplicaGroupId = T.ReplicaGroupId
	FROM	#tblSnapToReplGroupMap T
			INNER JOIN SMSnapToReplicaGroupMap MAP ON T.SMSnapId = MAP.SMSnapId
	INSERT	INTO SMSnapToReplicaGroupMap (SMSnapId, AppId, CopyId, ReplicaGroupId)
	SELECT	T.SMSnapId, @x_AppId, @x_CopyId, T.ReplicaGroupId
	FROM	#tblSnapToReplGroupMap T
			LEFT JOIN SMSnapToReplicaGroupMap MAP ON T.SMSnapId = MAP.SMSnapId
	WHERE MAP.ReplicaGroupId IS NULL
	COMMIT TRANSACTION SnapToReplicaGroupAssoc
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = ERROR_MESSAGE()
	IF XACT_STATE() <> 0
	ROLLBACK TRANSACTION SnapToReplicaGroupAssoc
	SELECT	@errorCode, @errorString
	IF OBJECT_ID('tempdb.dbo.#tblSnapToReplGroupMap') IS NOT NULL
	DROP TABLE #tblSnapToReplGroupMap
	RETURN
END CATCH
	SELECT 0, ''
	IF OBJECT_ID('tempdb.dbo.#tblSnapToReplGroupMap') IS NOT NULL
	DROP TABLE #tblSnapToReplGroupMap
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMSnapToReplGroupAssoc')
	delete from GxQscripts where name = 'MM_SMSnapToReplGroupAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSnapToReplGroupAssoc')
	delete from GXDBVersions where aliasname = 'MM_SMSnapToReplGroupAssoc'
GO

insert into GXDBVersions values(2, 'MM_SMSnapToReplGroupAssoc',  '00010001000400030000', 'MM_SMSnapToReplGroupAssoc', '00010001000400030000')
GO

