

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMSnapReconReport.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMSnapReconReport.sp,v $ $Id: MM_SMSnapReconReport.sp,v 1.1.4.5 2020/12/08 12:05:05 psreepada Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMSnapReconReport')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMSnapReconReport <<<'
	drop procedure MM_SMSnapReconReport
END
IF EXISTS (select * from GxQscripts where name='MM_SMSnapReconReport')
	delete from GxQscripts where name = 'MM_SMSnapReconReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSnapReconReport')
	delete from GXDBVersions where aliasname = 'MM_SMSnapReconReport'
GO
print '... Creating Procedure: MM_SMSnapReconReport'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMSnapReconReport
  @userId INT,
  @displaySnap INT,
  @reserveInt INT,
  @reserveStr VARCHAR(1024)
AS
IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL DROP TABLE #tblSMVolume
CREATE TABLE #tblSMVolume
(
	SMVolumeId int,
	SMSnapId int,
	JobId int,
	CopyId int,
	CommCellId int,
	CreationTime int,
	RetryCount int,
	SourceClientId int,
	OriginClientId int,
	SourcePath nvarchar(1024),
	OriginSourcePath nvarchar(1024),
	AppId int,
	AppTypeId int,
	ReplStatus int,
	PruneFlags int,
	SnapEngineId int,
	ControlHostId int,
	MountStatus int,
	SPName nvarchar(1024),
	ClientName nvarchar(1024),
	AppName nvarchar(1024),
	AppTypeName nvarchar(1024),
	ArrayName nvarchar(1024),
	SnapEngineName nvarchar(1024),
	primary key(SMVolumeId, SMSnapId)
)
INSERT	INTO #tblSMVolume
SELECT	VOL.SMVolumeId, SNAP.SMSnapId, VOL.JobId, VOL.CopyId, VOL.CommCellId, VOL.CreationTime, VOL.RetryCount, VOL.SourceClientId, VOL.OriginClientId,
		VOL.SourcePath, VOL.OriginSourcePath, VOL.AppId, VOL.AppTypeId, 0, VOL.PruneFlags, SNAP.SnapShotEngineId, SNAP.ControlHostId, VOL.MountStatus,
		'N/A', 'N/A', 'N/A', APPTYPE.name, CTRL.SMArrayId, ENG.SnapEngineName
FROM	SMVolume VOL (NOLOCK)
		INNER JOIN SMVolSnapMap MAP (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
		INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
		INNER JOIN SMSnapShotEngine ENG (NOLOCK) ON SNAP.SnapShotEngineId = ENG.SnapShotEngineId
		INNER JOIN SMControlHost CTRL (NOLOCK) ON SNAP.ControlHostId = CTRL.ControlHostId
		INNER JOIN APP_iDAType APPTYPE (NOLOCK) ON APPTYPE.type = VOL.AppTypeId
		LEFT JOIN JMJobInfo JOB (NOLOCK) ON VOL.JobId = JOB.jobId AND VOL.CommCellId = JOB.commCellId
WHERE	VOL.PruneFlags =  (CASE WHEN @displaySnap = 1 THEN 7 /* MM_SM_PRUNEFLAGS_EXT_PRUNED */  WHEN @displaySnap = 2 THEN VOL.PruneFlags /* Show all */ END)
AND	SNAP.SnapShotEngineId <> 51
		AND	JOB.jobId IS NULL
-- Security - remove those where the subclients are not visible for this user.
IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
	DROP TABLE #tblSecCheck
CREATE TABLE #tblSecCheck (
	EntityType int,
	EntityId int,
	EntityVisible int
)
INSERT INTO #tblSecCheck
SELECT DISTINCT 1, CopyId, 0  FROM #tblSMVolume
INSERT INTO #tblSecCheck
SELECT DISTINCT 2, ControlHostId, 0  FROM #tblSMVolume
INSERT INTO #tblSecCheck
SELECT DISTINCT 3, AppId, 0  FROM #tblSMVolume
EXEC sec_isSnapshotVisible @userId
DELETE	A
FROM	#tblSMVolume A
INNER JOIN #tblSecCheck B_Copy ON A.CopyId = B_Copy.EntityId AND B_Copy.EntityType = 1
INNER JOIN #tblSecCheck B_CHost ON A.ControlHostId = B_CHost.EntityId AND B_CHost.EntityType = 2
INNER JOIN #tblSecCheck B_App ON A.AppId = B_App.EntityId AND B_App.EntityType = 3
WHERE	B_Copy.EntityVisible <=0
		AND B_CHost.EntityVisible <=0
		AND B_App.EntityVisible <=0
IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
	DROP TABLE #tblSecCheck
IF @displaySnap = 2
BEGIN
	IF OBJECT_ID('tempdb.dbo.#tblVolReplStatus') IS NOT NULL DROP TABLE #tblVolReplStatus
	CREATE TABLE #tblVolReplStatus
	(
		SMVolumeId INT,
		ReplStatus INT,
		PRIMARY KEY(SMVolumeId)
	)
	INSERT INTO #tblVolReplStatus
	SELECT M.SMVolumeId, MAX(S.ReplicationStatus) AS ReplStatus
			FROM #tblSMVolume V (NOLOCK)
				INNER JOIN SMVolSnapMap M (NOLOCK) ON V.SMVolumeId = M.SMVolumeId
				INNER JOIN SMSnap S (NOLOCK) ON M.SMSnapId = S.SMSnapId
			GROUP BY M.SMVolumeId
	UPDATE	VOL
	SET		VOL.ReplStatus = REP.ReplStatus
	FROM	#tblSMVolume VOL INNER JOIN #tblVolReplStatus REP ON VOL.SMVolumeId = REP.SMVolumeId
	IF OBJECT_ID('tempdb.dbo.#tblVolReplStatus') IS NOT NULL DROP TABLE #tblVolReplStatus
END
UPDATE	VOL
SET		SPName = AG.name + ' / ' + AGC.name
FROM	#tblSMVolume VOL
		INNER JOIN ArchGroupCopy AGC (NOLOCK) ON VOL.CopyId = AGC.id
		INNER JOIN ArchGroup AG (NOLOCK) ON AG.id = AGC.archGroupId
UPDATE  VOL
SET		VOL.ClientName= CLNT.name
FROM	#tblSMVolume VOL
		INNER JOIN APP_Client CLNT (NOLOCK)
ON CLNT.id = (CASE WHEN VOL.AppTypeId = 13 THEN VOL.OriginClientId
							ELSE VOL.SourceClientId END)
UPDATE	VOL
SET		VOL.AppName = BS.name + ' / ' + APP.subclientName
FROM	#tblSMVolume VOL
		INNER JOIN APP_Application APP (NOLOCK) ON VOL.AppId = APP.id
			INNER JOIN APP_BackupSetName BS (NOLOCK) ON BS.id = APP.backupSet
-- Return list of volumes
SELECT	DISTINCT
	A.SMVolumeId			'smVolumeId',
	A.ArrayName				'smArrayId',
	A.SnapEngineName		'snapEngineName',
	A.SPName				'spName',
	A.ClientName			'sourceClientName',
	A.AppName				'appName',
	A.AppTypeName			'appTypeName',
	(CASE WHEN A.OriginSourcePath <> '' THEN A.OriginSourcePath ELSE A.SourcePath END) 'sourcePath',
	A.JobId					'jobId',
	dbo.UTCToClientLocalTime(dbo.GetDateTime(A.CreationTime), 2) 'creationTime',
	(CASE
		WHEN A.replStatus > 0 THEN 'One or more missing snaps'
WHEN A.PruneFlags = 7 THEN 'Not present in Array'
WHEN A.MountStatus = 18 OR A.MountStatus = 38 THEN 'Failed to create snap'
WHEN A.MountStatus < 38 AND A.MountStatus <> 18 THEN 'Creating snap'
WHEN A.MountStatus = 39 THEN 'Successfully created snap'
WHEN A.MountStatus = 58 THEN 'Failed to mount'
WHEN A.MountStatus >= 40 AND A.MountStatus < 58 THEN 'Mounting'
WHEN A.MountStatus = 59 THEN 'Successfully mounted'
WHEN A.MountStatus = 78 THEN 'Failed to unmount'
WHEN A.MountStatus >= 60 AND A.MountStatus < 78 THEN 'Unmounting'
WHEN A.MountStatus = 79 THEN 'Successfully unmounted'
WHEN A.MountStatus >= 80 AND A.MountStatus < 88 THEN 'Reverting'
WHEN A.MountStatus = 88 THEN 'Failed to revert'
WHEN A.MountStatus = 89 THEN 'Successfully reverted'
WHEN A.MountStatus >= 90 AND A.MountStatus < 97 THEN 'Deleting'
WHEN A.MountStatus = 97 THEN 'Externally deleted'
WHEN A.MountStatus = 98 THEN 'Failed to delete'
WHEN A.MountStatus = 99 THEN 'Successfully deleted'
	END)	'mountStatusName'
FROM #tblSMVolume A
IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL DROP TABLE #tblSMVolume

IF EXISTS (select * from GxQscripts where name = 'MM_SMSnapReconReport')
	delete from GxQscripts where name = 'MM_SMSnapReconReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSnapReconReport')
	delete from GXDBVersions where aliasname = 'MM_SMSnapReconReport'
GO

insert into GXDBVersions values(2, 'MM_SMSnapReconReport',  '00010001000400050000', 'MM_SMSnapReconReport', '00010001000400050000')
GO

