

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMSnapReconGetSnaps.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMSnapReconGetSnaps.sp,v $ $Id: MM_SMSnapReconGetSnaps.sp,v 1.1.4.7 2018/06/26 14:02:34 hteli Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMSnapReconGetSnaps <<<'

IF EXISTS (select * from sysobjects where name='MM_SMSnapReconGetSnaps')
	drop procedure MM_SMSnapReconGetSnaps
IF EXISTS (select * from GxQscripts where name='MM_SMSnapReconGetSnaps')
	delete from GxQscripts where name = 'MM_SMSnapReconGetSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSnapReconGetSnaps')
	delete from GXDBVersions where aliasname = 'MM_SMSnapReconGetSnaps'
GO
print '... Creating Procedure: MM_SMSnapReconGetSnaps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMSnapReconGetSnaps
  @i_inputXML XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_SMSnapId INTEGER
  DECLARE @o_MetaDataId INTEGER
  DECLARE @o_MediaAgentId INTEGER
  DECLARE @o_GroupingKey VARCHAR(64)
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
SET NOCOUNT ON
/*
<MM_SMSnapReconGetSnaps>
	<AdminJobId>12345</AdminJobId>
	<LastSnapProcessed></LastSnapProcessed>
	<BatchCount></BatchCount>
	<ControlHostList>
		<ControlHost Id="7"/>
		<ControlHost Id="68"/>
	</ControlHostList>
</MM_SMSnapReconGetSnaps>
*/
DECLARE @VIRT_ENGINE INTEGER = 32768 --SM_SNAPSHOT_ENGINE_CAPABILITY_VIRTUALIZED
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @o_ErrorCode = 0
SET @o_ErrorStr = ''
DECLARE @tblInputCtrlHost TABLE (CtrlHostId INT)
INSERT INTO @tblInputCtrlHost
SELECT  ref.value('@Id', 'int') AS CtrlHostId
		FROM @i_inputXML.nodes('/MM_SMSnapReconGetSnaps/ControlHostList/ControlHost') R(ref)
DECLARE @AdminJobId INT = 0
SET @AdminJobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_inputXML.nodes('/MM_SMSnapReconGetSnaps/AdminJobId') R(ref)), 0)
DECLARE @BatchCount INT
SET @BatchCount = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_inputXML.nodes('/MM_SMSnapReconGetSnaps/BatchCount') R(ref)), 0)
IF @BatchCount <= 0
BEGIN
SET @BatchCount = ISNULL((SELECT Value from MMConfigs WHERE name = 'MMS2_CONFIG_SNAP_RECON_BATCH_COUNT'), 500)
END
DECLARE @LastSnapId INT = 0
SET @LastSnapId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_inputXML.nodes('/MM_SMSnapReconGetSnaps/LastSnapProcessed') R(ref)), 0)
--Currently reconcile operation is supported at array level. In future if multiple control host can be passed in one reconcile job then identify control host corresponding
--to virtual engine and handle error accordingly.
IF EXISTS(SELECT 1
		  FROM   @tblInputCtrlHost TMP
				 INNER JOIN SMSnap snap ON TMP.CtrlHostId = snap.ReserveField2 and snap.OriginalSnapEngineId != 0
				 INNER JOIN SMSnapShotEngine eng ON snap.OriginalSnapEngineId = eng.SnapShotEngineId
		  WHERE  eng.Capabilities & @VIRT_ENGINE = @VIRT_ENGINE
		  )
BEGIN
SET @o_ErrorCode = 60361 /*E_MM_SM_SP_RECON_FAILED_VIRTUAL_ENGINE*/
	SET @o_ErrorStr = 'Snap reconciliation not supported for VPLEX. Please run snap reconciliation on the backend storage arrays directly.'
	SELECT  0, 0, 0, '', @o_ErrorCode, @o_ErrorStr
	RETURN
END
--If Recon job on same array is already running then fail this job. If multiple arrays are given in input for job and if there is already job running for any array then current job will fail.
IF @LastSnapId=0
BEGIN
	DECLARE @arrayId NVARCHAR(1024) = ''
	DECLARE @jobId INT = 0
	SELECT   TOP 1 @jobId = JI.jobId,@arrayId = ctrlHost.SMArrayId
	FROM	 @tblInputCtrlHost TMP
			INNER JOIN SMReconStats recStats ON TMP.CtrlHostId = recStats.ControlHostId and recStats.ReconJobId < @AdminJobId
			INNER JOIN JMJobInfo JI ON recStats.ReconJobId = JI.jobId and recStats.CommCellId = JI.commCellId
			INNER JOIN SMControlHost ctrlHost on TMP.CtrlHostId = ctrlHost.ControlHostId
	IF @jobId > 0
	BEGIN
SET @o_ErrorCode = 60362 /*E_MM_SM_SP_RECON_FAILED_JOB_ALREADY_RUNNING*/
		SET @o_ErrorStr = 'Another Snap Reconciliation job [' +  Convert(varchar(16), @jobId) + '] is running for array [' + @arrayId + '].Please wait till current Snap Reconciliation job is done.'
		SELECT  0, 0, 0, '', @o_ErrorCode, @o_ErrorStr
		RETURN
	END
END
BEGIN TRY
	SELECT	DISTINCT TOP (@BatchCount) SNAP.SMSnapId, MD.MetaDataId, VOL.SourceClientId,
			CONVERT(VARCHAR(10), SNAP.ControlHostId) + '_' + CONVERT(VARCHAR(10), SNAP.SnapShotEngineId) + '_' + CONVERT(VARCHAR(10), VOL.SourceClientId),
			0, ''
	FROM	SMSnap SNAP
			INNER JOIN @tblInputCtrlHost TMP ON SNAP.ControlHostId = TMP.CtrlHostId
			INNER JOIN SMVolSnapMap MAP ON MAP.SMSnapId = SNAP.SMSnapId
			INNER JOIN SMVolume VOL ON MAP.SMVolumeId = VOL.SMVolumeId
INNER JOIN SMMetaData MD ON MD.PruneFlags = 4 AND MD.RefId = SNAP.SMSnapId AND MD.RefType = 2
WHERE	( VOL.PruneFlags = 1/*MM_SM_PRUNEFLAGS_ACTIVE*/ or VOL.PruneFlags = 7/*MM_SM_PRUNEFLAGS_EXT_PRUNED*/ )
AND VOL.SnapSource = 0
			AND SNAP.SMSnapId > @LastSnapId
AND (SNAP.SnapFlags & 2048 = 0) --Do not send hyperv base snaps for Reconciliation
	ORDER BY SNAP.SMSnapId
END TRY
BEGIN CATCH
	SET @o_ErrorCode = ERROR_NUMBER()
	SET @o_ErrorStr = ERROR_MESSAGE()
	SELECT 0, 0, 0, '', @o_ErrorCode, @o_ErrorStr
	RETURN
END CATCH
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMSnapReconGetSnaps')
	delete from GxQscripts where name = 'MM_SMSnapReconGetSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSnapReconGetSnaps')
	delete from GXDBVersions where aliasname = 'MM_SMSnapReconGetSnaps'
GO

insert into GXDBVersions values(2, 'MM_SMSnapReconGetSnaps',  '00010001000400070000', 'MM_SMSnapReconGetSnaps', '00010001000400070000')
GO

