

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMSnapPruningReport.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMSnapPruningReport.sp,v $ $Id: MM_SMSnapPruningReport.sp,v 1.1.4.5 2020/12/18 05:47:11 bbrindavan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMSnapPruningReport')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMSnapPruningReport <<<'
	drop procedure MM_SMSnapPruningReport
END
IF EXISTS (select * from GxQscripts where name='MM_SMSnapPruningReport')
	delete from GxQscripts where name = 'MM_SMSnapPruningReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSnapPruningReport')
	delete from GXDBVersions where aliasname = 'MM_SMSnapPruningReport'
GO
print '... Creating Procedure: MM_SMSnapPruningReport'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMSnapPruningReport
  @userId INT,
  @reserveInt INT,
  @reserveStr VARCHAR(1024)
AS
DECLARE @SM_REPT_OP_TYPE_NORMAL		INTEGER	=	1	/* SM_REPT_OP_TYPE_NORMAL */
DECLARE @SM_REPT_OP_TYPE_SPOOLCOPY	INTEGER	=	2	/* SM_REPT_OP_TYPE_SPOOLCOPY */
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL DROP TABLE #tblSMVolume
CREATE TABLE #tblSMVolume
(
	SMVolumeId int,
	SMSnapId int,
	JobId int,
	CopyId int,
	CommCellId int,
	CreationTime int,
	RetryCount int,
	SourceClientId int,
	OriginClientId int,
	SourcePath nvarchar(1024),
	OriginSourcePath nvarchar(1024),
	AppId int,
	AppTypeId int,
	SnapEngineId int,
	ControlHostId int,
	MountStatus int,
	SPName nvarchar(1024),
	ClientName nvarchar(1024),
	AppName nvarchar(1024),
	AppTypeName nvarchar(1024),
	OperationType int,						-- whether spool copy job or not
	primary key(SMVolumeId, SMSnapId)
)
INSERT INTO #tblSMVolume
SELECT	VOL.SMVolumeId, SNAP.SMSnapId, VOL.JobId, VOL.CopyId, VOL.CommCellId, VOL.CreationTime, VOL.RetryCount, VOL.SourceClientId, VOL.OriginClientId,
		VOL.SourcePath, VOL.OriginSourcePath, VOL.AppId, VOL.AppTypeId, SNAP.SnapShotEngineId, SNAP.ControlHostId, VOL.MountStatus,
		'N/A', 'N/A', 'N/A', APPTYPE.name,@SM_REPT_OP_TYPE_NORMAL												/* @SM_REPT_OP_TYPE_NORMAL = 1 */
FROM	SMVolume VOL (NOLOCK)
		INNER JOIN SMVolSnapMap MAP (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
		INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
		INNER JOIN APP_iDAType APPTYPE (NOLOCK) ON APPTYPE.type = VOL.AppTypeId
WHERE	VOL.MountStatus >= 90 /*SM_VS_DEL_STARTED*/ AND VOL.MountStatus <= 98 /*SM_VS_DEL_FAILED*/
AND SNAP.SnapShotEngineId <> 51
INSERT INTO #tblSMVolume
EXEC MM_SMSpoolCopyUnpickedForBackupCopyReport
-- Security - remove those where the subclients are not visible for this user.
IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
	DROP TABLE #tblSecCheck
CREATE TABLE #tblSecCheck (
	EntityType int,
	EntityId int,
	EntityVisible int
)
INSERT INTO #tblSecCheck
SELECT DISTINCT 1, CopyId, 0  FROM #tblSMVolume
INSERT INTO #tblSecCheck
SELECT DISTINCT 2, ControlHostId, 0  FROM #tblSMVolume
INSERT INTO #tblSecCheck
SELECT DISTINCT 3, AppId, 0  FROM #tblSMVolume
EXEC sec_isSnapshotVisible @userId
DELETE	A
FROM	#tblSMVolume A
INNER JOIN #tblSecCheck B_Copy ON A.CopyId = B_Copy.EntityId AND B_Copy.EntityType = 1
INNER JOIN #tblSecCheck B_CHost ON A.ControlHostId = B_CHost.EntityId AND B_CHost.EntityType = 2
INNER JOIN #tblSecCheck B_App ON A.AppId = B_App.EntityId AND B_App.EntityType = 3
WHERE	B_Copy.EntityVisible <=0
		AND B_CHost.EntityVisible <=0
		AND B_App.EntityVisible <=0
IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
		DROP TABLE #tblSecCheck
UPDATE	VOL
SET		SPName = AG.name + ' / ' + AGC.name
FROM	#tblSMVolume VOL
		INNER JOIN ArchGroupCopy AGC (NOLOCK) ON VOL.CopyId = AGC.id
		INNER JOIN ArchGroup AG (NOLOCK) ON AG.id = AGC.archGroupId
UPDATE  VOL
SET		VOL.ClientName= CLNT.name
FROM	#tblSMVolume VOL
		INNER JOIN APP_Client CLNT (NOLOCK)
ON CLNT.id = (CASE WHEN VOL.AppTypeId = 13 THEN VOL.OriginClientId
							ELSE VOL.SourceClientId END)
UPDATE	VOL
SET		VOL.AppName = BS.name + ' / ' + APP.subclientName
FROM	#tblSMVolume VOL
		INNER JOIN APP_Application APP (NOLOCK) ON VOL.AppId = APP.id
			INNER JOIN APP_BackupSetName BS (NOLOCK) ON BS.id = APP.backupSet
SELECT	DISTINCT
	A.SMVolumeId			'smVolumeId',
	A.SPName				'spName',
	A.ClientName			'sourceClientName',
	A.AppName				'appName',
	A.AppTypeName			'appTypeName',
	(CASE WHEN A.OriginSourcePath <> '' THEN A.OriginSourcePath ELSE A.SourcePath END) 'sourcePath',
	A.JobId					'jobId',
	dbo.UTCToClientLocalTime(dbo.GetDateTime(A.CreationTime), 2) 'creationTime',
	A.RetryCount			'retryCount',
	CTRL.SMArrayId			'smArrayId',
	ENG.SnapEngineName		'snapEngineName',
	(CASE
		WHEN A.OperationType = @SM_REPT_OP_TYPE_SPOOLCOPY THEN 'Snaps with spool retention unpicked for Backup Copy'
WHEN A.MountStatus >= 90 AND A.MountStatus < 97 THEN 'Deleting'
WHEN A.MountStatus = 97 THEN 'Externally deleted'
WHEN A.MountStatus = 98 THEN 'Failed to delete'
WHEN A.MountStatus = 99 THEN 'Successfully deleted'
	END)	'mountStatusName'
FROM	#tblSMVolume A
INNER JOIN SMSnapShotEngine ENG (NOLOCK) ON A.SnapEngineId = ENG.SnapShotEngineId
INNER JOIN SMControlHost CTRL (NOLOCK) ON A.ControlHostId = CTRL.ControlHostId
IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL DROP TABLE #tblSMVolume

IF EXISTS (select * from GxQscripts where name = 'MM_SMSnapPruningReport')
	delete from GxQscripts where name = 'MM_SMSnapPruningReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSnapPruningReport')
	delete from GXDBVersions where aliasname = 'MM_SMSnapPruningReport'
GO

insert into GXDBVersions values(2, 'MM_SMSnapPruningReport',  '00010001000400050000', 'MM_SMSnapPruningReport', '00010001000400050000')
GO

