

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMSnapCloneOperation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMSnapCloneOperation <<<'

IF EXISTS (select * from sysobjects where name='MM_SMSnapCloneOperation')
	drop procedure MM_SMSnapCloneOperation
IF EXISTS (select * from GxQscripts where name='MM_SMSnapCloneOperation')
	delete from GxQscripts where name = 'MM_SMSnapCloneOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSnapCloneOperation')
	delete from GXDBVersions where aliasname = 'MM_SMSnapCloneOperation'
GO
print '... Creating Procedure: MM_SMSnapCloneOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMSnapCloneOperation
  @xmlTextInput XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	declare		@o_outXML			XML
	declare		@i_userID			INT
	declare		@i_operationType	INT
	declare		@i_controlHostId	INT
	declare		@i_AppId			INT
	declare		@i_copyId			INT
	declare		@i_errorCode		INT = 0
	declare		@s_errorString		VARCHAR(256) = ''
	DECLARE		@iDoc				INT
	DECLARE		@OperationDelete INT = 1
	DECLARE		@OperationExtend INT = 2
	DECLARE @nowTime                      int
	SET     @nowTime                      = ISNULL((select dbo.GetUnixTime(GETUTCDATE())),0)
    SET @i_userId = ISNULL(( SELECT ref.value('@userId', 'int')
                            FROM @xmlTextInput.nodes('Api_SnapCloneOperationRequest/userId') R ( ref ) ),
                        0)
    SET @i_operationType = ISNULL(( SELECT ref.value('@operationType', 'int')
                            FROM @xmlTextInput.nodes('Api_SnapCloneOperationRequest') R ( ref ) ),
                        0)
	DECLARE @SnapCloneOperationInput TABLE
	(
		jobId  INT,
		expiryTimeStamp INT
	)
	INSERT  INTO @SnapCloneOperationInput
    SELECT R.ref.value('@jobId', 'int'),
			R.ref.value('@expiryTimeStamp', 'int')
    FROM @xmlTextInput.nodes('/Api_SnapCloneOperationRequest/inputs') R(ref)
	-- Check if user is having permisson
	DECLARE @tempTable TABLE
	(
		CopyId INT,
		AppId INT,
		ControlHostId INT
	)
	INSERT INTO @tempTable
	SELECT	DISTINCT VOL.CopyID, VOL.AppId, SNAP.ControlHostId
	FROM	@SnapCloneOperationInput SCOP INNER JOIN SMMountVolume MVOL (NOLOCK) ON SCOP.jobId = MVOL.MountJobId
				INNER JOIN SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = MVOL.SMVolumeId
				INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = MVOL.SMVolumeId
				INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
	IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
        DROP TABLE #tblSecCheck
	CREATE TABLE #tblSecCheck (
		EntityType int,
		EntityId int,
		EntityVisible int
	)
	INSERT INTO #tblSecCheck
SELECT DISTINCT 2, ControlHostId, 0
	FROM	@tempTable
	INSERT INTO #tblSecCheck
SELECT DISTINCT 1, CopyId, 0
	FROM	@tempTable
	INSERT INTO #tblSecCheck
SELECT DISTINCT 3, AppId, 0
	FROM	@tempTable
	EXEC sec_isSnapshotVisible @i_userId
	IF EXISTS(SELECT  1
		FROM	@SnapCloneOperationInput SCOP INNER JOIN SMMountVolume MVOL (NOLOCK) ON SCOP.jobId = MVOL.MountJobId
				INNER JOIN SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = MVOL.SMVolumeId
				INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = MVOL.SMVolumeId
				INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
INNER JOIN #tblSecCheck B_Copy ON VOL.copyId = B_Copy.EntityId AND B_Copy.EntityType = 1
INNER JOIN #tblSecCheck B_CHost ON SNAP.ControlHostId = B_CHost.EntityId AND B_CHost.EntityType = 2
INNER JOIN #tblSecCheck B_App ON VOL.AppId = B_App.EntityId AND B_App.EntityType = 3
		WHERE	B_Copy.EntityVisible <=0
				AND B_CHost.EntityVisible <=0
				AND B_App.EntityVisible <=0)
	BEGIN
		SET @i_errorCode= 1
		SET @s_errorString = 'User does not have permissions for performing clone operation.'
		GOTO Error_Exit
	END
	IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
		DROP TABLE #tblSecCheck
	IF(@i_operationType NOT IN (@OperationDelete, @OperationExtend))
	BEGIN
		SET @i_errorCode= 2
		SET @s_errorString = 'Unknown Operation type['+Convert(varchar(64), @i_operationType)+'] '
		GOTO Error_Exit
	END
	BEGIN TRAN SnapCloneOperationRequestTran
	IF(@i_operationType = @OperationDelete)
	BEGIN
		UPDATE	MVOL
		SET		MVOL.ExpireTime = MVOL.CreationTime
		FROM	SMMountVolume MVOL
				INNER JOIN @SnapCloneOperationInput SCOP ON SCOP.jobId = MVOL.MountJobId
WHERE	MVOL.MountStatus = 59 /*SM_VS_MNT_MOUNTED*/
		SELECT @i_errorCode = @@ERROR
		IF @i_errorCode <> 0
		BEGIN
			SET @i_errorCode= 3
			SET @s_errorString = 'Failed to update SMMountVolume table during clone delete operation.'
			ROLLBACK TRAN SnapCloneOperationRequestTran
			GOTO Error_Exit
		END
	END
	ELSE IF(@i_operationType = @OperationExtend) -- Mount Extend Reservation
	BEGIN
		--Check if the test clones are mounted. If there is any test clone that is not in mounted state, fail the clone extend operation
		IF EXISTS(SELECT 1  FROM SMMountVolume MVOL WITH (NOLOCK)
		INNER JOIN @SnapCloneOperationInput SCOP ON SCOP.jobId = MVOL.MountJobId
WHERE MVOL.MountStatus <> 59/*SM_VS_MNT_MOUNTED*/)
		BEGIN
			SET @i_errorCode= 4
			SET @s_errorString = 'One or more test clone(s) are not in mounted state.'
			ROLLBACK TRAN SnapCloneOperationRequestTran
			GOTO Error_Exit
		END
		IF EXISTS(SELECT 1  FROM @SnapCloneOperationInput WHERE expiryTimeStamp < @nowTime  )
		BEGIN
			SET @i_errorCode= 5
			SET @s_errorString = 'Time for extending the test clone(s) is less than the current time.'
			ROLLBACK TRAN SnapCloneOperationRequestTran
			GOTO Error_Exit
		END
		UPDATE	MVOL
		SET		MVOL.ExpireTime = SCOP.expiryTimeStamp
		FROM	SMMountVolume MVOL with (nolock)
				INNER JOIN @SnapCloneOperationInput SCOP ON SCOP.jobId = MVOL.MountJobId
WHERE	MVOL.MountStatus = 59/*SM_VS_MNT_MOUNTED*/
		SELECT @i_errorCode = @@ERROR
		IF @i_errorCode <> 0
		BEGIN
			SET @i_errorCode= 6
			SET @s_errorString = 'Failed to update SMMountVolume table during clone extend operation.'
			ROLLBACK TRAN SnapCloneOperationRequestTran
			GOTO Error_Exit
		END
	END
	COMMIT TRAN SnapCloneOperationRequestTran
Error_Exit:
SET @o_outXML = (SELECT @i_errorCode AS '@errorCode', @s_errorString AS '@errorMsg'
				FOR XML PATH('Api_SnapCloneOperationResponse'))
SELECT @o_outXML AS 'Column1'
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMSnapCloneOperation')
	delete from GxQscripts where name = 'MM_SMSnapCloneOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSnapCloneOperation')
	delete from GXDBVersions where aliasname = 'MM_SMSnapCloneOperation'
GO

insert into GXDBVersions values(2, 'MM_SMSnapCloneOperation',  '00000000000000000000', 'MM_SMSnapCloneOperation', '00000000000000000000')
GO

