

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMSnapCleanupReport.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMSnapCleanupReport.sp,v $ $Id: MM_SMSnapCleanupReport.sp,v 1.1.4.5 2020/11/23 03:55:06 psreepada Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMSnapCleanupReport')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMSnapCleanupReport <<<'
	drop procedure MM_SMSnapCleanupReport
END
IF EXISTS (select * from GxQscripts where name='MM_SMSnapCleanupReport')
	delete from GxQscripts where name = 'MM_SMSnapCleanupReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSnapCleanupReport')
	delete from GXDBVersions where aliasname = 'MM_SMSnapCleanupReport'
GO
print '... Creating Procedure: MM_SMSnapCleanupReport'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMSnapCleanupReport
  @userId INT,
  @reserveInt INT,
  @reserveStr VARCHAR(1024)
AS
IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL DROP TABLE #tblSMVolume
CREATE TABLE #tblSMVolume
(
	SMVolumeId int,
	SMSnapId int,
	JobId int,
	CopyId int,
	CommCellId int,
	RetryCount int,
	SourceClientId int,
	OriginClientId int,
	MountHostId int,
	MountPath nvarchar(1024),
	AppId int,
	AppTypeId int,
	SnapEngineId int,
	ControlHostId int,
	MountStatus int,
	SPName nvarchar(1024),
	ClientName nvarchar(1024),
	MountHostName nvarchar(1024),
	AppName nvarchar(1024),
	primary key(SMVolumeId, SMSnapId)
)
INSERT INTO #tblSMVolume
SELECT	VOL.SMVolumeId, SNAP.SMSnapId, VOL.JobId, VOL.CopyId, VOL.CommCellId, VOL.RetryCount, VOL.SourceClientId, VOL.OriginClientId,
		VOL.MountHostId, VOL.MountPath, VOL.AppId, VOL.AppTypeId, SNAP.SnapShotEngineId, SNAP.ControlHostId, VOL.MountStatus,
		'N/A', 'N/A', 'N/A', 'N/A'
FROM	SMVolume VOL (NOLOCK)
		INNER JOIN SMVolSnapMap MAP (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
		INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
WHERE	(VOL.MountStatus = 58 /*SM_VS_MNT_FAILED*/ OR (VOL.MountStatus > 59 /*SM_VS_MNT_MOUNTED*/ AND VOL.MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/ ))
AND	SNAP.SnapShotEngineId <> 51
-- Security - remove those where the subclients are not visible for this user.
IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
	DROP TABLE #tblSecCheck
CREATE TABLE #tblSecCheck (
	EntityType int,
	EntityId int,
	EntityVisible int
)
INSERT INTO #tblSecCheck
SELECT DISTINCT 1, CopyId, 0  FROM #tblSMVolume
INSERT INTO #tblSecCheck
SELECT DISTINCT 2, ControlHostId, 0  FROM #tblSMVolume
INSERT INTO #tblSecCheck
SELECT DISTINCT 3, AppId, 0  FROM #tblSMVolume
EXEC sec_isSnapshotVisible @userId
DELETE	A
FROM	#tblSMVolume A
INNER JOIN #tblSecCheck B_Copy ON A.CopyId = B_Copy.EntityId AND B_Copy.EntityType = 1
INNER JOIN #tblSecCheck B_CHost ON A.ControlHostId = B_CHost.EntityId AND B_CHost.EntityType = 2
INNER JOIN #tblSecCheck B_App ON A.AppId = B_App.EntityId AND B_App.EntityType = 3
WHERE	B_Copy.EntityVisible <=0
		AND B_CHost.EntityVisible <=0
		AND B_App.EntityVisible <=0
IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
	DROP TABLE #tblSecCheck
-- Update Mount path for VSA snaps
DECLARE @EsxServerNameTag		NVARCHAR(32) = N'esxname:'
DECLARE @UserNameTag			NVARCHAR(32) = N',username:'
DECLARE @EsxServerNameTagLen	INTEGER = LEN(@EsxServerNameTag)
DECLARE @UserNameTagLen			INTEGER = LEN(@UserNameTag)
UPDATE	VOL
SET		VOL.MountPath = SUBSTRING(MountPath, (EsxSvrIdx + @EsxServerNameTagLen), (UserNameIdx - (EsxSvrIdx + @EsxServerNameTagLen)))
FROM	#tblSMVolume VOL
		INNER JOIN
			(SELECT	SMVolumeId, CHARINDEX(@EsxServerNameTag, MountPath) AS EsxSvrIdx, CHARINDEX(@UserNameTag, MountPath) AS UserNameIdx
						FROM	#tblSMVolume
WHERE	AppTypeId = 106) TMP
		ON	TMP.SMVolumeId = VOL.SMVolumeId
			AND	TMP.EsxSvrIdx > 0 and TMP.UserNameIdx > 0 and TMP.UserNameIdx > TMP.EsxSvrIdx
UPDATE	VOL
SET		SPName = AG.name + ' / ' + AGC.name
FROM	#tblSMVolume VOL
		INNER JOIN ArchGroupCopy AGC (NOLOCK) ON VOL.CopyId = AGC.id
		INNER JOIN ArchGroup AG (NOLOCK) ON AG.id = AGC.archGroupId
UPDATE  VOL
SET		VOL.ClientName= CLNT.name
FROM	#tblSMVolume VOL
		INNER JOIN APP_Client CLNT (NOLOCK)
ON CLNT.id = (CASE WHEN VOL.AppTypeId = 13 THEN VOL.OriginClientId
							ELSE VOL.SourceClientId END)
UPDATE  VOL
SET		VOL.MountHostName = CLNT.name
FROM	#tblSMVolume VOL
		INNER JOIN APP_Client CLNT (NOLOCK)
			ON CLNT.id = VOL.MountHostId
UPDATE	VOL
SET		VOL.AppName = BS.name + ' / ' + APP.subclientName
FROM	#tblSMVolume VOL
		INNER JOIN APP_Application APP (NOLOCK) ON VOL.AppId = APP.id
			INNER JOIN APP_BackupSetName BS (NOLOCK) ON BS.id = APP.backupSet
SELECT	DISTINCT
	A.SMVolumeId	'smVolumeId',
	A.MountHostName 'mountHostName',
	CASE WHEN A.MountPath is NULL OR A.MountPath = '' THEN 'N/A' ELSE  A.MountPath END	'mountPath',
	A.SPName		'spName',
	A.ClientName	'sourceClientName', -- for NAS Clients
	A.AppName		'appName',
	A.JobId			'snapJobId',
	A.RetryCount	'retryCount',
	(CASE
WHEN A.MountStatus = 58 THEN 'Failed to mount'
WHEN A.MountStatus = 78 THEN 'Failed to unmount'
WHEN A.MountStatus >= 60 AND A.MountStatus < 78 THEN 'Unmounting'
	END)	'mountStatusName',
	CTRL.SMArrayId			'smArrayId',
	ENG.SnapEngineName		'snapEngineName'
FROM	#tblSMVolume A
INNER JOIN SMSnapShotEngine ENG (NOLOCK) ON A.SnapEngineId = ENG.SnapShotEngineId
INNER JOIN SMControlHost CTRL (NOLOCK) ON A.ControlHostId = CTRL.ControlHostId
IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL DROP TABLE #tblSMVolume

IF EXISTS (select * from GxQscripts where name = 'MM_SMSnapCleanupReport')
	delete from GxQscripts where name = 'MM_SMSnapCleanupReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSnapCleanupReport')
	delete from GXDBVersions where aliasname = 'MM_SMSnapCleanupReport'
GO

insert into GXDBVersions values(2, 'MM_SMSnapCleanupReport',  '00010001000400050000', 'MM_SMSnapCleanupReport', '00010001000400050000')
GO

