

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMSetSnapToSnapRelation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMSetSnapToSnapRelation.sp,v $ $Id: MM_SMSetSnapToSnapRelation.sp,v 1.5.210.1 2018/03/20 00:10:55 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMSetSnapToSnapRelation <<<'

IF EXISTS (select * from sysobjects where name='MM_SMSetSnapToSnapRelation')
	drop procedure MM_SMSetSnapToSnapRelation
IF EXISTS (select * from GxQscripts where name='MM_SMSetSnapToSnapRelation')
	delete from GxQscripts where name = 'MM_SMSetSnapToSnapRelation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSetSnapToSnapRelation')
	delete from GXDBVersions where aliasname = 'MM_SMSetSnapToSnapRelation'
GO
print '... Creating Procedure: MM_SMSetSnapToSnapRelation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMSetSnapToSnapRelation
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @ErrorVolId			INTEGER
DECLARE @ErrorCode			INTEGER
DECLARE @ErrorStr			VARCHAR(1024)
DECLARE @SnapToSnapId			INTEGER
DECLARE @CopyId				INTEGER
DECLARE @archGroupId		INTEGER
DECLARE @docHandle			INTEGER
DECLARE @tempRelationSkip TABLE (SnapToSnapId int, CopyId int, archGroupId int)
	EXEC sp_xml_preparedocument @docHandle OUTPUT, @i_xmlTextInput
	SELECT
			tXml.SnapToSnapId			as 'SnapToSnapId',
			tXml.CopyId				as 'CopyId',
			0					as 'archGroupId',
			tXml.flags			as 'flags'
	INTO #tempRelation
	FROM
		OPENXML(@docHandle, 'EVGui_SetSVSMRelationListReq/smRelationList', 0)
		WITH
		(
			SnapToSnapId			INTEGER 	'@SnapToSnapId',
			CopyId				INTEGER		'spCopy/@copyId',
			flags				INTEGER		'@flags'
		) as tXml
	set @ErrorCode = @@ERROR
	if (@ErrorCode <> 0)
	BEGIN
		SET @ErrorStr = 'ERROR: MM_SMSetSnapToSnapRelation -- #tempRelation -- Insert '
		GOTO CX_EXIT
	END
	--delete the relations which are not updated
	DELETE FROM #tempRelation
	WHERE (flags & 4) = 0
	--update the policyId
	update #tempRelation
	set archGroupId = AGC.archGroupId
	from archGroupCopy AGC
	where #tempRelation.CopyId = AGC.id
	-- now check these conditions
	-- when relation is cloned and assigned to a copy, check if its from a different storage policy
	-- first delete all duplicates with same snaptosnapId and archGroupId from the request, since GUI is not doing any validation.
	INSERT INTO @tempRelationSkip
		SELECT T.SnapToSnapId, 0, T.archGroupId FROM #tempRelation T GROUP BY T.SnapToSnapId, T.archGroupId HAVING COUNT(*) > 1
	-- now delete which are same snaptosnapid and archGroupid already in CS table
	INSERT INTO @tempRelationSkip
		SELECT T.SnapToSnapId, T.CopyId, AGC.archGroupId
		FROM #tempRelation T, SMSnapToSnap SM, archGroupCopy AGC
		WHERE T.SnapToSnapId = SM.SnapToSnapId
		and SM.CopyId = AGC.id
		and T.archGroupId = AGC.archGroupId
	--delete all those relations which are to be skipped
	DELETE #tempRelation FROM #tempRelation
		INNER JOIN @tempRelationSkip T ON #tempRelation.SnapToSnapId = T.SnapToSnapId and #tempRelation.CopyId = T.CopyId
	-- when a relation is assigned to a copy check if that copy already has a relation and if so then check if it is a subpath
	-- do this validation only on source path.
	DECLARE curRelations CURSOR FOR
	SELECT SnapToSnapId, CopyId, archGroupId
	FROM #tempRelation TM
	OPEN curRelations
	FETCH NEXT FROM curRelations INTO @SnapToSnapId, @CopyId, @archGroupId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF EXISTS (SELECT * FROM SMSnapToSnap WHERE copyId = @CopyId)
		BEGIN
			IF EXISTS (SELECT * FROM SMSnapToSnap SM WHERE SM.copyId = @CopyId AND SM.srcPath like
					(Select Sub.srcPath from SMSnapToSnap Sub Where SM.SrcCtrlHostId = Sub.SrcCtrlHostId and  Sub.SnapToSnapId = @SnapToSnapId) + '%')
			BEGIN
				-- 'do not add'
				INSERT INTO @tempRelationSkip Values(@SnapToSnapId, @CopyId, @archGroupId)
				--Clean up those relation that do no meet the above criteria/conditions
				DELETE FROM #tempRelation WHERE #tempRelation.SnapToSnapId = @SnapToSnapId and #tempRelation.CopyId = @CopyId
			END
			ELSE
				IF EXISTS (SELECT * FROM SMSnapToSnap SM WHERE SM.CopyId = @CopyId and EXISTS
				(SELECT * FROM SMSnapToSnap SMT WHERE SMT.SnapToSnapId = @SnapToSnapId
				and (PATINDEX(SM.SrcPath + '%', SMT.SrcPath) > 0) and SMT.SrcCtrlHostId = SM.SrcCtrlHostId and SMT.SnapToSnapId > 0))
				BEGIN
					-- 'do not add the relation'
					INSERT INTO @tempRelationSkip Values(@SnapToSnapId, @CopyId, @archGroupId)
					--Clean up those relation that do no meet the above criteria/conditions
					DELETE FROM #tempRelation WHERE #tempRelation.SnapToSnapId = @SnapToSnapId and #tempRelation.CopyId = @CopyId
				END
				ELSE
				BEGIN
					-- 'everything ok - update the relation table'
					UPDATE SMSnapToSnap
					SET CopyId = T.CopyId
					FROM #tempRelation T
					WHERE SMSnapToSnap.SnapToSnapId = T.SnapToSnapId
					AND T.SnapToSnapId = @SnapToSnapId
					AND (T.flags & 2) = 0
				END
		END
		ELSE
			BEGIN
				-- Everything OK, update the relation table
				UPDATE SMSnapToSnap
				SET CopyId = T.CopyId
				FROM #tempRelation T
				WHERE SMSnapToSnap.SnapToSnapId = T.SnapToSnapId
				AND T.SnapToSnapId = @SnapToSnapId
				AND (T.flags & 2) = 0
			END
		FETCH NEXT FROM curRelations INTO @SnapToSnapId, @CopyId, @archGroupId
	END
	--Insert the relations those are cloned relations
	INSERT INTO SMSnapToSnap
	SELECT SM.SrcCtrlHostId, SM.SrcPath, SM.TgtCtrlHostId, SM.TgtPath, T.CopyId, SM.OrigCCId, NEWID(), SM.ReserveField1, 2, ''
	FROM SMSnapToSnap SM, #tempRelation T
	WHERE SM.SnapToSnapId = T.SnapToSnapId
	AND (T.flags & 2) > 0
	IF EXISTS (SELECT * FROM @tempRelationSkip)
	BEGIN
		SELECT
			A.SnapToSnapId				'@SnapToSnapId',
			0					'@srcCtrlHostId',
			''					'@srcCtrlHostName',
			''					'@srcPath',
			0					'@tgtCtrlHostId',
			''					'@tgtCtrlHostName',
			''					'@tgtPath',
			0					'@relationType',
			0					'@flags',
			A.CopyId				'spCopy/@copyId',
			''					'spCopy/@copyName',
			A.archGroupId		'spCopy/@storagePolicyId',
			''					'spCopy/@storagePolicyName'
		FROM @tempRelationSkip A
		FOR XML PATH('smRelationSkipList'), ROOT('EVGui_SetSVSMRelationListResp')
	END
	ELSE
	SELECT '<EVGui_SetSVSMRelationListResp/>'
CX_EXIT:
IF OBJECT_ID('tempdb.dbo.#tempRelation') is not null DROP TABLE #tempRelation
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMSetSnapToSnapRelation')
	delete from GxQscripts where name = 'MM_SMSetSnapToSnapRelation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSetSnapToSnapRelation')
	delete from GXDBVersions where aliasname = 'MM_SMSetSnapToSnapRelation'
GO

insert into GXDBVersions values(2, 'MM_SMSetSnapToSnapRelation',  '00010005021000010000', 'MM_SMSetSnapToSnapRelation', '00010005021000010000')
GO

