

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMSetSMSnapIndexMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMSetSMSnapIndexMA <<<'

IF EXISTS (select * from sysobjects where name='MM_SMSetSMSnapIndexMA')
	drop procedure MM_SMSetSMSnapIndexMA
IF EXISTS (select * from GxQscripts where name='MM_SMSetSMSnapIndexMA')
	delete from GxQscripts where name = 'MM_SMSetSMSnapIndexMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSetSMSnapIndexMA')
	delete from GXDBVersions where aliasname = 'MM_SMSetSMSnapIndexMA'
GO
print '... Creating Procedure: MM_SMSetSMSnapIndexMA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMSetSMSnapIndexMA
  @i_xmlTextInput XML
AS
  DECLARE @errorCode integer
  DECLARE @errorMsg varchar(1024)
  DECLARE @output integer
  DECLARE @jobId integer
  DECLARE @commCellId integer
  DECLARE @snapIndexMAClientId integer
  DECLARE @flags integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE		@i_jobId					INT = 0
	DECLARE		@i_commCellId				INT = 0
	DECLARE		@i_snapIndexMAClientId		INT = 0
	DECLARE		@i_flags					INT = 0
	DECLARE @l_SMSnapIndexMATbl TABLE
			(
			  output					INT,
			  jobId						INT,
			  commCellId				INT,
			  snapIndexMAClientId		INT,
			  flags						INT
			)
	DECLARE 	@o_output					INT = 0
	DECLARE 	@o_errorCode				INT = 0
	DECLARE 	@o_errorMsg  				VARCHAR(512) = ''
	BEGIN TRY
		INSERT INTO @l_SMSnapIndexMATbl
		SELECT 0,
		ISNULL(l_temp_SMSnapIndexMATbl.value('@jobId','INT'),0) AS jobId,
		ISNULL(l_temp_SMSnapIndexMATbl.value('@commCellId','INT'),0) AS commCellId,
		ISNULL(l_temp_SMSnapIndexMATbl.value('@snapIndexMAClientId','INT'),0) AS snapIndexMAClientId,
		ISNULL(l_temp_SMSnapIndexMATbl.value('@flags','INT'),0) AS flags
		FROM
		@i_xmlTextInput.nodes('MM_SMSetSMSnapIndexMAReq/JobIndexMAPair')AS TEMPTABLE(l_temp_SMSnapIndexMATbl)
		BEGIN TRANSACTION
		IF EXISTS (SELECT * FROM @l_SMSnapIndexMATbl WHERE commCellId=0 OR jobId = 0 OR snapIndexMAClientId = 0 )
		BEGIN
			SET @o_errorCode = 1
			SET @o_errorMsg = 'XML is malformed. ['+CONVERT(varchar(max),@i_xmlTextInput)+']'
			GOTO ERROR_EXIT
		END
		UPDATE LSIM
		SET output = Case  when SIM.jobId is NULL THEN 2 /*Pair inserted succesfully*/  ELSE 1 /*Pair already exits*/ END
		FROM @l_SMSnapIndexMATbl AS LSIM
		LEFT JOIN SMSnapIndexMA AS SIM (NOLOCK)
		ON LSIM.jobId = SIM.jobId AND LSIM.commCellId = SIM.commCellId AND LSIM.snapIndexMAClientId = SIM.snapIndexMAClientId
		INSERT INTO SMSnapIndexMA(jobId,commCellId,snapIndexMAClientId,Flags)
		Select LSIM.jobId,LSIM.commCellId,LSIM.snapIndexMAClientId,LSIM.flags
		From @l_SMSnapIndexMATbl AS LSIM WHERE LSIM.output = 2
		COMMIT TRANSACTION
	END TRY
	BEGIN CATCH
		SET @o_errorCode = ERROR_NUMBER()
		SET @o_errorMsg = ERROR_MESSAGE()+' ['+CONVERT(varchar(max),@i_xmlTextInput)+']'
		GOTO ERROR_EXIT
	END CATCH
	ERROR_EXIT:
	IF @o_errorCode > 0
	BEGIN
		SELECT @o_errorCode 'errorCode',@o_errorMsg 'errorMsg',* FROM @l_SMSnapIndexMATbl
		ROLLBACK TRANSACTION
	END
	ELSE
	BEGIN
		SELECT 0 'errorCode','' 'errorMsg',* FROM @l_SMSnapIndexMATbl
	END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMSetSMSnapIndexMA')
	delete from GxQscripts where name = 'MM_SMSetSMSnapIndexMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSetSMSnapIndexMA')
	delete from GXDBVersions where aliasname = 'MM_SMSetSMSnapIndexMA'
GO

insert into GXDBVersions values(2, 'MM_SMSetSMSnapIndexMA',  '00000000000000000000', 'MM_SMSetSMSnapIndexMA', '00000000000000000000')
GO

