

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMSetArchFileReplicationStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMSetArchFileReplicationStatus.sp,v $ $Id: MM_SMSetArchFileReplicationStatus.sp,v 1.8.2.15 2020/06/16 17:14:52 kkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMSetArchFileReplicationStatus')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMSetArchFileReplicationStatus <<<'
	drop procedure MM_SMSetArchFileReplicationStatus
END
IF EXISTS (select * from GxQscripts where name='MM_SMSetArchFileReplicationStatus')
	delete from GxQscripts where name = 'MM_SMSetArchFileReplicationStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSetArchFileReplicationStatus')
	delete from GXDBVersions where aliasname = 'MM_SMSetArchFileReplicationStatus'
GO
print '... Creating Procedure: MM_SMSetArchFileReplicationStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMSetArchFileReplicationStatus
  @i_xmlTextInput XML,
  @i_reserveInt INTEGER,
  @i_reserveStr VARCHAR(255)
AS
/*
--V1 XML
<MM_SMSetArchFileReplicationStatus>
	<JobId>54228</JobId>
	<SMSnapId>146545</SMSnapId>
	<SMSnapId>146546</SMSnapId>
	<SMSnapId>146547</SMSnapId>
</MM_SMSetArchFileReplicationStatus>
--V2 XML has smvolumeIDs too.
<MM_SMSetArchFileReplicationStatus>
	<JobId>54228</JobId>
	<SMVolumeId>162912</SMVolumeId>
	<SMVolumeId>162913</SMVolumeId>
	<SMSnapId>146545</SMSnapId>
	<SMSnapId>146546</SMSnapId>
	<SMSnapId>146547</SMSnapId>
</MM_SMSetArchFileReplicationStatus>
*/
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_errCode INT
  DECLARE @o_errMsg VARCHAR(255)
SET NOCOUNT ON
DECLARE @errCode	INT = 0
DECLARE @errMsg		VARCHAR(255) = ''
SET @errCode = 0
SET @errMsg = ''
DECLARE @tblSMSnap TABLE (SMSnapId INT)
DECLARE @tblSMVolume TABLE (SMVolumeId INT)
DECLARE @isVSAV2Vol INT = 0
DECLARE @tblSMVolSnap TABLE (SMVolumeId INT, SMSnapId INT, jobId INT, archFileId int, commCellId int, copyId int, MountStatus int, replStatus int, SnapShotEngineId	integer)
IF object_id('tempdb.dbo.#SnapArchFiles') IS NOT null DROP TABLE #SnapArchFiles
CREATE TABLE #SnapArchFiles (archFileId int, commCellId int, JobId int, SnapShotEngineId int, copyId int, srcCopyId int )
IF object_id('tempdb.dbo.#tblArchFileCopy') IS NOT NULL DROP TABLE #tblArchFileCopy
CREATE TABLE #tblArchFileCopy (archFileId int, commCellId int, copyId int, isValid int, jobId INT)
CREATE INDEX tblArchFileCopyIndex ON #tblArchFileCopy(archFileId, CommCellId, CopyId)
DECLARE @AuxcopyRetryNoOfDays INT = 0
SET @AuxcopyRetryNoOfDays = ISNULL((select Value from MMConfigs(NOLOCK) where name = 'MMCONFIG_SNAP_AUXCOPY_RETRY_TIME_LIMIT_DAYS'), 5)
DECLARE @AuxcopyRetryCount INT = 0
SET @AuxcopyRetryCount = ISNULL((select Value from MMConfigs(NOLOCK) where name = 'MMCONFIG_SNAP_AUXCOPY_RETRY_COUNT'), 10)
DECLARE @currentTime INT = dbo.getUnixTime(GETUTCDATE())
DECLARE @i_adminJobId INT = 0
DECLARE @SNAPSHOTFLAGS_SECONDARY_SNAP INT = 268435456
DECLARE @SNAPSHOTFLAGS_REPLICA_SNAP INT = 16777216
DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS    INT = 15
SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WITH (READUNCOMMITTED) WHERE NAME = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'), 15)
DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @i_mmErrorCode INTEGER;
INSERT  INTO @tblSMSnap
SELECT R.ref.value('.', 'int')
FROM @i_xmlTextInput.nodes('/MM_SMSetArchFileReplicationStatus/SMSnapId') R(ref)
--insert 0 if not found.
INSERT  INTO @tblSMVolume
SELECT R.ref.value('.', 'int')
FROM @i_xmlTextInput.nodes('/MM_SMSetArchFileReplicationStatus/SMVolumeId') R(ref)
IF EXISTS (SELECT 1 FROM SMVolume VOL WITH (NOLOCK)
						INNER JOIN @tblSMVolume tSMVOL ON tSMVOL.SMVolumeId = VOL.SMVolumeId AND tSMVOL.SMVolumeId > 0
						WHERE (VOL.VolumeFlags & cast(4294967296 /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/ as bigint) > 0)
		  )
SET @isVSAV2Vol = 1
SET @i_adminJobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMSetArchFileReplicationStatus/JobId') R(ref)), 0)
DECLARE @isOfflineSnapReplication INT = 0
IF EXISTS ( SELECT * FROM	@tblSMSnap T_SNAP INNER JOIN SMSnap (NOLOCK) SNAP ON T_SNAP.SMSnapId = SNAP.SMSnapId
				WHERE	SNAP.SnapFlags & @SNAPSHOTFLAGS_REPLICA_SNAP = @SNAPSHOTFLAGS_REPLICA_SNAP/*CVSM_SNAPSHOTFLAGS_REPLICA_SNAP*/ )
BEGIN
	SET @isOfflineSnapReplication = 1
END
ELSE
BEGIN
	SET @isOfflineSnapReplication = 0
END
IF @isOfflineSnapReplication = 0
BEGIN
IF @isVSAV2Vol = 1
BEGIN
    INSERT	INTO @tblSMVolSnap
	SELECT	DISTINCT VOL.SMVolumeId, SNAP.SMSnapId, VOL.jobid, VOL.ArchFileId,
			VOL.CommCellId, VOL.copyId, VOL.MountStatus, SNAP.ReplicationStatus, SNAP.SnapShotEngineId
	FROM	SMVolume VOL (NOLOCK)
			INNER JOIN @tblSMVolume tSMVOL ON tSMVOL.SMVolumeId = VOL.SMVolumeId   -- only on supplied smvolume.
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
			INNER JOIN @tblSMSnap T_SNAP ON SNAP.SMSnapId = T_SNAP.SMSnapId
END
ELSE
BEGIN
	INSERT	INTO @tblSMVolSnap
	SELECT	DISTINCT VOL.SMVolumeId, SNAP.SMSnapId, VOL.jobid, VOL.ArchFileId,
			VOL.CommCellId, VOL.copyId, VOL.MountStatus, SNAP.ReplicationStatus, SNAP.SnapShotEngineId
	FROM	SMVolume VOL (NOLOCK)
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
			INNER JOIN @tblSMSnap T_SNAP ON SNAP.SMSnapId = T_SNAP.SMSnapId
END
	DELETE	@tblSMVolSnap
	WHERE	MountStatus = 10 /*SM_VS_PRP_STARTED*/
	DELETE	@tblSMVolSnap
	FROM	@tblSMVolSnap TMP
			INNER JOIN archGroupCopy AGC (NOLOCK) ON TMP.copyId = AGC.id
	WHERE	AGC.sourceCopyId = 0
	IF NOT EXISTS (SELECT * FROM @tblSMVolSnap)
		GOTO ERR_EXIT
	UPDATE	SNAP
	SET		SNAP.SnapFlags = SNAP.SnapFlags | @SNAPSHOTFLAGS_SECONDARY_SNAP
	FROM	@tblSMVolSnap TMP
			INNER JOIN SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = TMP.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON TMP.SMSnapId = SNAP.SMSnapId
			INNER JOIN archGroupCopy AGC (NOLOCK) ON AGC.id = VOL.CopyId
			INNER JOIN archGroup AG (NOLOCK) ON AGC.archGroupId = AG.id
			LEFT OUTER JOIN ArchGroupControlHost AGCH (NOLOCK) ON AG.id = AGCH.ArchGroupId
WHERE	( (AGC.isSnapCopy = 1 AND AGC.sourceCopyId > 0 AND (AGC.extendedFlags & 256 <> 256))
			OR (AGCH.SMReplicationProtocolType = 1 AND AGC.isSnapCopy = 1 AND AGC.sourceCopyId = 0 ) )
			AND SNAP.SnapFlags & @SNAPSHOTFLAGS_SECONDARY_SNAP <> @SNAPSHOTFLAGS_SECONDARY_SNAP
	-- No Replication errors in current attempt
	UPDATE	archFileCopy
	SET		isValid = 1,
flags = ( CASE WHEN (flags & 16384) = 16384 THEN (flags ^ 16384) ELSE flags END)
	OUTPUT	INSERTED.archFileId, INSERTED.commCellId, INSERTED.archCopyId, INSERTED.isValid, 0
	INTO	#tblArchFileCopy
	FROM	@tblSMVolSnap VOLSNAP
			INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AFC.archFileId = VOLSNAP.archFileId
				AND VOLSNAP.copyId = AFC.archCopyId AND AFC.commCellId = VOLSNAP.commCellId
	WHERE	VOLSNAP.replStatus = 0
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update archFile status for replicated snaps.'
		GOTO ERR_EXIT
	END
	-- Transient Replication errors
	-- Skip the archFile for transient errors.
	UPDATE	archChunkSkipped
	SET		adminJobId = @i_adminJobId,
			tryCount = tryCount + 1,
			tryTime = dbo.getUnixTime(GETUTCDATE()),
			errorCode = VOLSNAP.replStatus
	FROM	@tblSMVolSnap VOLSNAP, archChunkSkipped ACS
	WHERE	ACS.archFileId = VOLSNAP.archFileId
			AND ACS.destCopyId = VOLSNAP.copyId
			AND ACS.commCellId = VOLSNAP.commCellId
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update archFiles with transient replication errors in archChunkSkipped.'
		GOTO ERR_EXIT
	END
	INSERT	INTO archChunkSkipped
	SELECT	0, VOLSNAP.archFileId, VOLSNAP.commCellId, 0, VOLSNAP.copyId, @i_adminJobId,
			VOLSNAP.jobId, 1, dbo.getUnixTime(GETUTCDATE()), VOLSNAP.replStatus, dbo.getUnixTime(GETUTCDATE()), 0, 0, 0
	FROM	@tblSMVolSnap VOLSNAP
			LEFT OUTER JOIN archChunkSkipped ACS
				ON ACS.archFileId = VOLSNAP.archFileId AND ACS.destCopyId = VOLSNAP.copyId AND ACS.commCellId = VOLSNAP.commCellId
WHERE	(VOLSNAP.replStatus & 4 /*SM_REPL_STATUS_VOLUME_OFFLINE_DB*/ ) > 0 -- Volume offline
			AND ACS.archFileId IS NULL
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to add archFiles with transient replication errors to be skipped.'
		GOTO ERR_EXIT
	END
	-- AuxCopy first attempt time in case of transient errors is saved in srcMediaId
	UPDATE	archFileCopy
SET		flags = flags | 16384 /*CVA_JOB_MISSING_SNAPS*/,
			isValid = (CASE
							WHEN	((ACS.srcMediaId + (@AuxcopyRetryNoOfDays * 24 * 60 * 60) < @currentTime)
									AND (ACS.tryCount >= @AuxcopyRetryCount)) THEN 1
							ELSE 0 END)
	OUTPUT	INSERTED.archFileId, INSERTED.commCellId, INSERTED.archCopyId, INSERTED.isValid, 0
	INTO	#tblArchFileCopy
	FROM	@tblSMVolSnap VOLSNAP
			INNER JOIN archFileCopy AFC ON AFC.archFileId = VOLSNAP.archFileId
				AND VOLSNAP.copyId = AFC.archCopyId AND AFC.commCellId = VOLSNAP.commCellId
			INNER JOIN archChunkSkipped ACS (NOLOCK) ON AFC.archFileId = ACS.archFileId
				AND AFC.archCopyId = ACS.destCopyId AND AFC.commCellId = ACS.commCellId
WHERE	(VOLSNAP.replStatus & 4 /*SM_REPL_STATUS_VOLUME_OFFLINE_DB*/ ) > 0 -- Volume offline
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update archFile status for snaps with transient replication errors.'
		GOTO ERR_EXIT
	END
	-- Permanent Replication errors
	UPDATE	archFileCopy
SET		flags = flags | 16384 /*CVA_JOB_MISSING_SNAPS*/,
			isValid = 1
	OUTPUT	INSERTED.archFileId, INSERTED.commCellId, INSERTED.archCopyId, INSERTED.isValid, 0
	INTO	#tblArchFileCopy
	FROM	@tblSMVolSnap VOLSNAP
			INNER JOIN archFileCopy AFC ON AFC.archFileId = VOLSNAP.archFileId
				AND VOLSNAP.copyId = AFC.archCopyId AND AFC.commCellId = VOLSNAP.commCellId
WHERE	(VOLSNAP.replStatus & (1 /*SM_REPL_STATUS_SNAP_DELETED_DB*/ | 2 /*SM_REPL_STATUS_VOLUME_DELETED_DB*/ )) > 0
			AND AFC.isValid = 0
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update archFile status for snaps with permanent replication errors.'
		GOTO ERR_EXIT
	END
	UPDATE	JDS
SET		disabled = disabled | 16384 /*CVA_JOB_MISSING_SNAPS*/
	FROM	JMJobDataStats JDS
			INNER JOIN
				(SELECT	AF.fileType, AFC.archCopyId, AF.jobId, MIN(AFC.isValid) as minIsValid, MAX(AFC.isValid) as maxIsValid
				FROM	(SELECT DISTINCT JobId, CopyId, CommcellId FROM @tblSMVolSnap) VOLSNAP
						INNER JOIN archFile AF (NOLOCK) ON AF.jobId = VOLSNAP.jobId AND AF.fileType = 1
							AND AF.commCellId = VOLSNAP.commCellId
						INNER JOIN archFileCopy AFC (NOLOCK) ON AFC.archFileId = AF.id
							AND AF.commCellId = AFC.commCellId AND AFC.archCopyId = VOLSNAP.copyId
							AND AF.commCellId = VOLSNAP.commCellId
WHERE	(AFC.flags & 16384) = 16384
				GROUP	BY AF.fileType, AFC.archCopyId, AF.jobId ) TMP
	ON		JDS.jobId = TMP.jobId AND JDS.archGrpCopyId = TMP.archCopyId AND JDS.dataType = TMP.fileType
AND (JDS.disabled & 16384) = 0 AND TMP.minIsValid = 1 AND TMP.maxIsValid = 1
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update job status for snaps with replication errors.'
		GOTO ERR_EXIT
	END
	UPDATE	SMVolume
	SET		PruneFlags = 0
	FROM	@tblSMVolSnap VOLSNAP
			INNER JOIN SMVolume VOL ON VOL.SMVolumeId = VOLSNAP.SMVolumeId
			INNER JOIN archFileCopy AFC (NOLOCK) ON AFC.archCopyId = VOLSNAP.copyId
				AND AFC.commCellId = VOLSNAP.commCellId AND VOLSNAP.archFileId = AFC.archFileId
	WHERE	AFC.isValid = 0
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update Volume Prune Flags for snaps with replication errors.'
		GOTO ERR_EXIT
	END
END
ELSE -- Block for offline snap replication
BEGIN
IF @isVSAV2Vol = 1
BEGIN
    INSERT	INTO @tblSMVolSnap
	SELECT	DISTINCT VOL.SMVolumeId, SNAP.SMSnapId, VOL.jobid, VOL.ArchFileId,
			VOL.CommCellId, VOL.copyId, VOL.MountStatus, SNAP.ReplicationStatus, SNAP.SnapShotEngineId
	FROM	SMVolume VOL (NOLOCK)
			INNER JOIN @tblSMVolume t_SMVOL ON t_SMVOL.SMVolumeId = VOL.SMVolumeId   -- only on supplied smvolume.
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
			INNER JOIN @tblSMSnap T_SNAP ON SNAP.SMSnapId = T_SNAP.SMSnapId
END
ELSE
BEGIN
	INSERT	INTO @tblSMVolSnap
	SELECT	DISTINCT VOL.SMVolumeId, SNAP.SMSnapId, VOL.jobid, VOL.ArchFileId,
			VOL.CommCellId, VOL.copyId, VOL.MountStatus, SNAP.ReplicationStatus, SNAP.SnapShotEngineId
	FROM	SMVolume VOL (NOLOCK)
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
			INNER JOIN @tblSMSnap T_SNAP ON SNAP.SMSnapId = T_SNAP.SMSnapId
END
DELETE FROM @tblSMVolSnap WHERE MountStatus NOT IN (39/*SM_VS_CRT_CREATED*/,38/*SM_VS_CRT_FAILED*/,18/*SM_VS_PRP_FAILED*/)
	IF NOT EXISTS (SELECT * FROM @tblSMVolSnap )
	BEGIN
		GOTO ERR_EXIT
	END
	-- No Replication errors in current attempt
IF EXISTS (SELECT 1 FROM @tblSMVolSnap WHERE MountStatus = 39/*SM_VS_CRT_CREATED*/)
	BEGIN
		UPDATE	archFileCopy
		SET		isValid = 1
		OUTPUT	INSERTED.archFileId, INSERTED.commCellId, INSERTED.archCopyId, INSERTED.isValid, 0
		INTO	#tblArchFileCopy
		FROM	@tblSMVolSnap VOLSNAP
				INNER JOIN archFileCopy AFC ON AFC.archFileId = VOLSNAP.archFileId
					AND VOLSNAP.copyId = AFC.archCopyId AND AFC.commCellId = VOLSNAP.commCellId
WHERE	VOLSNAP.MountStatus = 39 /*SM_VS_CRT_CREATED*/ AND AFC.isValid = 0
		SET @errCode = @@ERROR
		IF @errCode <> 0
		BEGIN
			SET	@errMsg = 'Failed to update archFile status for replicated snaps.'
			GOTO ERR_EXIT
		END
	END
	-- Set prune flags to 0 if mount status is create failed.
	UPDATE	SMVolume
	SET		PruneFlags = 0
	FROM	@tblSMVolSnap VOLSNAP
			INNER JOIN SMVolume VOL ON VOL.SMVolumeId = VOLSNAP.SMVolumeId
WHERE	VOLSNAP.MountStatus IN ( 38/*SM_VS_CRT_FAILED*/, 18/*SM_VS_PRP_FAILED*/ ) AND VOL.PruneFlags <> 0
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update Volume Prune Flags for snaps with replication errors.'
		GOTO ERR_EXIT
	END
	-- Set prune flags to 1 if mount status is created successfully.
	UPDATE	SMVolume
	SET		PruneFlags = 1
	FROM	@tblSMVolSnap VOLSNAP
			INNER JOIN SMVolume VOL ON VOL.SMVolumeId = VOLSNAP.SMVolumeId
WHERE	VOLSNAP.MountStatus IN ( 39/*SM_VS_CRT_CREATED*/ ) AND VOL.PruneFlags <> 1
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update Volume Prune Flags for snaps with replication errors.'
		GOTO ERR_EXIT
	END
	UPDATE	archChunkToReplicate
SET		Status = (CASE WHEN VOLSNAP.MountStatus = 39 /*SM_VS_CRT_CREATED*/ THEN 2
WHEN VOLSNAP.MountStatus = 38 /*SM_VS_CRT_FAILED*/ AND VOLSNAP.SnapShotEngineId != 27 THEN 4/*CVA_CHUNK_FAILED*/
WHEN VOLSNAP.MountStatus = 18 /*SM_VS_PRP_FAILED*/ AND VOLSNAP.SnapShotEngineId != 27 THEN 4/*CVA_CHUNK_FAILED*/
							ELSE R.Status
					END)
	FROM	@tblSMVolSnap VOLSNAP
			INNER JOIN archChunkToReplicate R ON R.adminJobId = @i_adminJobId
				AND	R.archFileId = VOLSNAP.archFileId
				AND R.destCopyId = VOLSNAP.CopyId
				AND R.commCellId = VOLSNAP.commCellId
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update archChunkToReplicate status for replicated errors.'
		GOTO ERR_EXIT
	END
	-- Partial aux copy is not supported for offline replicaiton. If some snaps are marked as transferring, and others are successful, then mark all snaps as skipped for that snap job.
	IF EXISTS ( SELECT 1 FROM @tblSMVolSnap VOL1
						INNER JOIN @tblSMVolSnap VOL2 ON VOL1.jobId = VOL2.jobId AND VOL1.commCellId = VOL2.commCellId AND VOL1.copyId = VOL2.copyId
						INNER JOIN SMSnap SNAP WITH (READUNCOMMITTED) ON VOL2.SMSnapId = SNAP.SMSnapId
WHERE	VOL1.replStatus = 8
AND VOL1.SnapShotEngineId != 60 /*AWS we support partial so dont reset status*/
AND VOL2.replStatus <> 8 AND SNAP.SnapStatus IN ( 2/*READY_FOR_SNAP_FAILED*/, 6 /*SNAP_FAILED*/ ))
	BEGIN
		UPDATE	VOLSNAP
		SET		VOLSNAP.replStatus = 0
		FROM	@tblSMVolSnap VOLSNAP
WHERE	VOLSNAP.replStatus = 8
	END
	ELSE
	BEGIN
		-- This is needed as all the relationships could be in a failed state.
IF EXISTS (SELECT 1 FROM @tblSMVolSnap WHERE replStatus = 8)
		BEGIN
			UPDATE	VOLSNAP
SET		VOLSNAP.replStatus = 8
			FROM	@tblSMVolSnap VOLSNAP
WHERE	VOLSNAP.replStatus <> 8
AND VOLSNAP.MountStatus IN ( 18, 38)
		END
	END
SET @i_mmErrorCode = 60919
	-- Skipping jobs in case of transient error
    UPDATE  archChunkToReplicate
SET     Status = 3,
            SkippedCount += 1,
            SkippedForSeconds = (@SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS * 60) * (SkippedCount+1),
SkippedReason = 8,
            ErrorCode = @i_mmErrorCode,
            Modified = @now
    FROM    @tblSMVolSnap VOLSNAP
			INNER JOIN archChunkToReplicate R ON R.adminJobId = @i_adminJobId
				AND	R.archFileId = VOLSNAP.archFileId
				AND R.destCopyId = VOLSNAP.CopyId
				AND R.commCellId = VOLSNAP.commCellId
WHERE	VOLSNAP.replStatus = 8
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update archChunkToReplicate status for skipped snaps.'
		GOTO ERR_EXIT
	END
END
-- Only do partial aux support here for AWS and if it has atleast one offline.
IF EXISTS ( SELECT 1 FROM @tblSMVolSnap WHERE SnapShotEngineId = 60/*SM_SNAPSHOT_ENGINE_AMAZON_AWS*/ AND replStatus & (4 /*SM_REPL_STATUS_VOLUME_OFFLINE_DB*/ | 1 /*SM_REPL_STATUS_SNAP_DELETED_DB*/)  > 0 )
BEGIN
	-- Transient Replication errors
	-- Skip the archFile for transient errors.
	UPDATE	archChunkSkipped
	SET		adminJobId = @i_adminJobId,
			tryCount = tryCount + 1,
			tryTime = dbo.getUnixTime(GETUTCDATE()),
			errorCode = VOLSNAP.replStatus
	FROM	@tblSMVolSnap VOLSNAP, archChunkSkipped ACS
	WHERE	ACS.archFileId = VOLSNAP.archFileId
			AND ACS.destCopyId = VOLSNAP.copyId
			AND ACS.commCellId = VOLSNAP.commCellId
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update archFiles with transient replication errors in archChunkSkipped.'
		GOTO ERR_EXIT
	END
	INSERT	INTO archChunkSkipped
	SELECT	0, VOLSNAP.archFileId, VOLSNAP.commCellId, 0, VOLSNAP.copyId, @i_adminJobId,
			VOLSNAP.jobId, 1, dbo.getUnixTime(GETUTCDATE()), VOLSNAP.replStatus, dbo.getUnixTime(GETUTCDATE()), 0, 0, 0
	FROM	@tblSMVolSnap VOLSNAP
			LEFT OUTER JOIN archChunkSkipped ACS
				ON ACS.archFileId = VOLSNAP.archFileId AND ACS.destCopyId = VOLSNAP.copyId AND ACS.commCellId = VOLSNAP.commCellId
WHERE	(VOLSNAP.replStatus & 4 /*SM_REPL_STATUS_VOLUME_OFFLINE_DB*/ ) > 0 -- Volume offline
			AND ACS.archFileId IS NULL
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to add archFiles with transient replication errors to be skipped.'
		GOTO ERR_EXIT
	END
	-- AuxCopy first attempt time in case of transient errors is saved in srcMediaId
	UPDATE	archFileCopy
SET		flags = flags | 16384 /*CVA_JOB_MISSING_SNAPS*/,
			isValid = (CASE
							WHEN	((ACS.srcMediaId + (@AuxcopyRetryNoOfDays * 24 * 60 * 60) < @currentTime)
									AND (ACS.tryCount >= @AuxcopyRetryCount)) THEN 1
							ELSE 0 END)
	OUTPUT	INSERTED.archFileId, INSERTED.commCellId, INSERTED.archCopyId, INSERTED.isValid, 0
	INTO	#tblArchFileCopy
	FROM	@tblSMVolSnap VOLSNAP
			INNER JOIN archFileCopy AFC ON AFC.archFileId = VOLSNAP.archFileId
				AND VOLSNAP.copyId = AFC.archCopyId AND AFC.commCellId = VOLSNAP.commCellId
			INNER JOIN archChunkSkipped ACS (NOLOCK) ON AFC.archFileId = ACS.archFileId
				AND AFC.archCopyId = ACS.destCopyId AND AFC.commCellId = ACS.commCellId
WHERE	(VOLSNAP.replStatus & 4 /*SM_REPL_STATUS_VOLUME_OFFLINE_DB*/ ) > 0 -- Volume offline
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update archFile status for snaps with transient replication errors.'
		GOTO ERR_EXIT
	END
	-- Permanent Replication errors
	UPDATE	archFileCopy
SET		flags = flags | 16384 /*CVA_JOB_MISSING_SNAPS*/,
			isValid = 1
	OUTPUT	INSERTED.archFileId, INSERTED.commCellId, INSERTED.archCopyId, INSERTED.isValid, 0
	INTO	#tblArchFileCopy
	FROM	@tblSMVolSnap VOLSNAP
			INNER JOIN archFileCopy AFC ON AFC.archFileId = VOLSNAP.archFileId
				AND VOLSNAP.copyId = AFC.archCopyId AND AFC.commCellId = VOLSNAP.commCellId
WHERE	(VOLSNAP.replStatus & (1 /*SM_REPL_STATUS_SNAP_DELETED_DB*/ | 2 /*SM_REPL_STATUS_VOLUME_DELETED_DB*/ )) > 0
			AND AFC.isValid = 0
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update archFile status for snaps with permanent replication errors.'
		GOTO ERR_EXIT
	END
	UPDATE	JDS
SET		disabled = disabled | 16384 /*CVA_JOB_MISSING_SNAPS*/
	FROM	JMJobDataStats JDS
			INNER JOIN
				(SELECT	AF.fileType, AFC.archCopyId, AF.jobId, MIN(AFC.isValid) as minIsValid, MAX(AFC.isValid) as maxIsValid
				FROM	(SELECT DISTINCT JobId, CopyId, CommcellId FROM @tblSMVolSnap) VOLSNAP
						INNER JOIN archFile AF (NOLOCK) ON AF.jobId = VOLSNAP.jobId AND AF.fileType = 1
							AND AF.commCellId = VOLSNAP.commCellId
						INNER JOIN archFileCopy AFC (NOLOCK) ON AFC.archFileId = AF.id
							AND AF.commCellId = AFC.commCellId AND AFC.archCopyId = VOLSNAP.copyId
							AND AF.commCellId = VOLSNAP.commCellId
WHERE	(AFC.flags & 16384) = 16384
				GROUP	BY AF.fileType, AFC.archCopyId, AF.jobId ) TMP
	ON		JDS.jobId = TMP.jobId AND JDS.archGrpCopyId = TMP.archCopyId AND JDS.dataType = TMP.fileType
AND (JDS.disabled & 16384) = 0 AND TMP.minIsValid = 1 AND TMP.maxIsValid = 1
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update job status for snaps with replication errors.'
		GOTO ERR_EXIT
	END
END
DELETE FROM #tblArchFileCopy
WHERE	isValid = 0
SET @errCode = @@ERROR
IF @errCode <> 0
BEGIN
	SET	@errMsg = 'Failed to update Volume Prune Flags for snaps with replication errors.'
	GOTO ERR_EXIT
END
UPDATE	T
SET		JobID = AF.jobId
FROM	#tblArchFileCopy T, archFile AF WITH (READUNCOMMITTED)
WHERE	T.archFileId = AF.id
		AND T.commCellid = AF.commCellId
SET @errCode = @@ERROR
IF @errCode <> 0
BEGIN
	SET	@errMsg = 'Failed to update Volume Prune Flags for snaps with replication errors.'
	GOTO ERR_EXIT
END
DELETE  T
FROM	#tblArchFileCopy T LEFT OUTER JOIN JMVSAAppJobLink J WITH (READUNCOMMITTED) ON T.JobId = J.parentJobId AND T.CommCellId = J.CommCellId
WHERE	J.parentJobId IS NULL
SET @errCode = @@ERROR
IF @errCode <> 0
BEGIN
	SET	@errMsg = 'Failed to update Volume Prune Flags for snaps with replication errors.'
	GOTO ERR_EXIT
END
IF EXISTS (SELECT * FROM #tblArchFileCopy)
BEGIN
	DELETE  T
	FROM	#tblArchFileCopy T, archFile AF WITH (READUNCOMMITTED) LEFT OUTER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AF.id = AFC.archFileId AND AF.CommCellId = AFC.CommCellId
	WHERE	T.JobId = AF.JobId
			AND T.CommCellId = AF.CommCellId
			AND AFC.archCopyId = T.CopyId
			AND AFC.isValid = 0
AND (AF.Flags & 2) = 1
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to update Volume Prune Flags for snaps with replication errors.'
		GOTO ERR_EXIT
	END
	INSERT INTO #SnapArchFiles
	SELECT  DISTINCT AFC.archFileId, AFC.CommCellId, AF.JobId, 0, 0, 0
	FROM	#tblArchFileCopy T
				INNER JOIN JMVSAAppJobLink J WITH (READUNCOMMITTED) ON T.JobId = J.parentJobId AND T.CommCellId = J.CommCellId
				INNER JOIN archFile AF WITH (READUNCOMMITTED) ON J.childJobId = AF.JobId AND J.CommCellId = AF.CommCellId
				INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AF.id = AFC.archFileId AND AF.CommCellId = AFC.CommCellId
WHERE	(AF.Flags & 2) = 2
			AND T.Copyid = AFC.archCopyId
			AND AFC.isValid = 0
	IF (EXISTS (SELECT * FROM #SnapArchFiles))
	BEGIN
		DECLARE @l_sourceCopyId INT = 0
		DECLARE @l_copyId INT = 0
		SELECT	TOP 1 @l_copyId = CopyId
		FROM	#tblArchFileCopy
		SELECT	@l_sourceCopyId = SrcCopyId
		FROM
				(SELECT	TOP 1 archCopyId AS SrcCopyId
				FROM	archChunkToCopy WITH (READUNCOMMITTED)
				WHERE	adminJobId = @i_adminJobId
						AND destCopyId = @l_copyId
				UNION
				SELECT	TOP 1 SrcCopyId AS SrcCopyId
				FROM	archChunkToReplicate WITH (READUNCOMMITTED)
				WHERE	adminJobId = @i_adminJobId
						AND destCopyId = @l_copyId) T
		IF (@l_sourceCopyId = 0)
		BEGIN
			SELECT	@l_sourceCopyId = (CASE WHEN (AGC.isSnapCopy = 1) AND (AGC.sourceCopyId > 0)
												THEN AGC.sourceCopyId
											WHEN (AGC.isSnapCopy = 1) AND (AGC.sourceCopyId = 0)
												THEN AG.defaultSnapCopy
											ELSE 0
										END)
			FROM	archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
			WHERE	AG.id = AGC.archGroupId AND AGC.id = @l_copyId
		END
		UPDATE #SnapArchFiles
		SET copyId = @l_copyId, srcCopyId = @l_sourceCopyId
		BEGIN TRAN POPULATE_SNAP_INFO
		EXEC @errCode = MM_SMPopulateSnapInfo @l_sourceCopyId, @l_copyId
		IF (@errCode = 0)
		BEGIN
			UPDATE	AFC
			SET		isValid = 1
			FROM	archFileCopy AFC, #SnapArchFiles SAF
			WHERE	AFC.archFileId = SAF.archFileId
					AND AFC.CommCellId = SAF.CommCellId
					AND AFC.archCopyId = @l_copyId
					AND AFC.isValid = 0
			SET @errCode = @@ERROR
			IF	@errCode <> 0
			BEGIN
				SET	@errMsg = 'Failed to update isValid value on archFileCopy table.'
				ROLLBACK TRAN	POPULATE_SNAP_INFO
				GOTO ERR_EXIT
			END
			DELETE FROM SAF
			FROM	archVSAAppAFLink L, #SnapArchFiles SAF
			WHERE	L.childAFID = SAF.archFileId
					AND L.CommCellId = SAF.CommCellId
					AND L.copyId = @l_copyId
			SET @errCode = @@ERROR
			IF	@errCode <> 0
			BEGIN
				SET	@errMsg = 'Failed to insert into archVSAAppAFLink.'
				ROLLBACK TRAN	POPULATE_SNAP_INFO
				GOTO ERR_EXIT
			END
			INSERT INTO archVSAAppAFLink (ParentIndexAFId, childAFId, commCellId, flags, VMGUID, mountVMGUID, copyId)
			SELECT	L.ParentIndexAFId, L.childAFId, L.commCellId, L.flags, L.VMGUID, NULL, @l_copyId
			FROM	archVSAAppAFLink L, #SnapArchFiles SAF
			WHERE	L.childAFID = SAF.archFileId
					AND L.CommCellId = SAF.CommCellId
					AND L.copyId = @l_sourceCopyId
			SET @errCode = @@ERROR
			IF	@errCode <> 0
			BEGIN
				SET	@errMsg = 'Failed to insert into archVSAAppAFLink.'
				ROLLBACK TRAN	POPULATE_SNAP_INFO
				GOTO ERR_EXIT
			END
			COMMIT TRAN POPULATE_SNAP_INFO
		END
		ELSE
		BEGIN
			SET	@errMsg = 'Failed to populate SM* tables.'
			ROLLBACK TRAN	POPULATE_SNAP_INFO
			GOTO ERR_EXIT
		END
	END
END
ERR_EXIT:
	IF object_id('tempdb.dbo.#SnapArchFiles') IS NOT null DROP TABLE #SnapArchFiles
	IF object_id('tempdb.dbo.#tblArchFileCopy') IS NOT null DROP TABLE #tblArchFileCopy
	SELECT @errCode, @errMsg
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMSetArchFileReplicationStatus')
	delete from GxQscripts where name = 'MM_SMSetArchFileReplicationStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSetArchFileReplicationStatus')
	delete from GXDBVersions where aliasname = 'MM_SMSetArchFileReplicationStatus'
GO

insert into GXDBVersions values(2, 'MM_SMSetArchFileReplicationStatus',  '00010008000200150000', 'MM_SMSetArchFileReplicationStatus', '00010008000200150000')
GO

