

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMResetPruneFlags.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMResetPruneFlags.sp,v $ $Id: MM_SMResetPruneFlags.sp,v 1.1.2.1 2018/04/27 17:32:11 vimalkumar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMResetPruneFlags <<<'

IF EXISTS (select * from sysobjects where name='MM_SMResetPruneFlags')
	drop procedure MM_SMResetPruneFlags
IF EXISTS (select * from GxQscripts where name='MM_SMResetPruneFlags')
	delete from GxQscripts where name = 'MM_SMResetPruneFlags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMResetPruneFlags')
	delete from GXDBVersions where aliasname = 'MM_SMResetPruneFlags'
GO
print '... Creating Procedure: MM_SMResetPruneFlags'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMResetPruneFlags
  @i_xmlInput XML = NULL,
  @i_reserveInt INT = 0
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
SET NOCOUNT ON
/*
<MM_SMResetPruneFlags >
	<CtrlHostId>1</CtrlHostId>
	<CopyId>1</CopyId>
</MM_SMResetPruneFlags>
*/
SET @o_ErrorCode = 0
SET @o_ErrorStr = ''
IF @i_xmlInput IS NULL
BEGIN
	SET @o_ErrorCode = -1
	SET @o_ErrorStr = 'Input XML Parameter cannot be empty.'
	GOTO PROC_END
END
DECLARE @x_CtrlHostId INTEGER = (SELECT @i_xmlInput.value('(/MM_SMResetPruneFlags/CtrlHostId)[1]','INTEGER'))
DECLARE @x_CopyId INTEGER = (SELECT @i_xmlInput.value('(/MM_SMResetPruneFlags/CopyId)[1]','INTEGER') )
IF @x_CtrlHostId IS NULL AND @x_CopyId IS NULL
BEGIN
	SET @o_ErrorCode = -1
	SET @o_ErrorStr = 'Both Control Host Id and Copy Id cannot be empty.'
	GOTO PROC_END
END
ELSE
BEGIN
	IF object_id('tempdb.dbo.#VolIdsToReset') IS NOT NULL DROP TABLE #VolIdsToReset
	CREATE TABLE #VolIdsToReset (VolId INTEGER)
	--Validate Control Host Id
	IF @x_CtrlHostId IS NOT NULL
	BEGIN
		IF NOT EXISTS ( SELECT 1 from SMControlHost WITH (READUNCOMMITTED) WHERE ControlHostId = @x_CtrlHostId )
		BEGIN
			SET @o_ErrorCode = -1
			SET @o_ErrorStr = 'Invalid Control Host Id.'
			GOTO PROC_END
		END
	END
	--Validate Copy Id
	IF @x_CopyId IS NOT NULL
	BEGIN
		IF NOT EXISTS ( SELECT 1 from archGroupCopy WITH (READUNCOMMITTED) WHERE id = @x_CopyId )
		BEGIN
			SET @o_ErrorCode = -1
			SET @o_ErrorStr = 'Invalid Copy Id.'
			GOTO PROC_END
		END
	END
	INSERT INTO #VolIdsToReset
	SELECT DISTINCT vol.SMVolumeId
	FROM SMVolume vol WITH (READUNCOMMITTED)
	JOIN SMVolSnapMap map  WITH (READUNCOMMITTED) ON map.SMVolumeId=vol.SMVolumeId
	JOIN SMSnap snap WITH (READUNCOMMITTED) ON snap.SMSnapId=map.SMSnapId
	JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AFC.archFileId=vol.ArchFileId AND AFC.archCopyId=vol.CopyId AND AFC.commCellId=vol.commCellId
	WHERE AFC.isValid=1
AND vol.PruneFlags=7  /*MM_SM_PRUNEFLAGS_EXT_PRUNED*/
		AND (@x_CopyId IS NULL OR vol.CopyId=@x_CopyId)
		AND (@x_CtrlHostId IS NULL OR snap.ControlHostId=@x_CtrlHostId)
AND (AFC.flags & 256  = 0) /*CVA_AGED_DATA_FLAG*/
	IF (@@ROWCOUNT > 0)
	BEGIN
		UPDATE vol
		SET vol.PruneFlags=1
		FROM #VolIdsToReset rVol
		JOIN SMVolume vol ON rVol.VolId=vol.SMVolumeId
	END
END
PROC_END:
SELECT @o_ErrorCode, @o_ErrorStr
IF object_id('tempdb.dbo.#VolIdsToReset') IS NOT NULL DROP TABLE #VolIdsToReset
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMResetPruneFlags')
	delete from GxQscripts where name = 'MM_SMResetPruneFlags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMResetPruneFlags')
	delete from GXDBVersions where aliasname = 'MM_SMResetPruneFlags'
GO

insert into GXDBVersions values(2, 'MM_SMResetPruneFlags',  '00010001000200010000', 'MM_SMResetPruneFlags', '00010001000200010000')
GO

