

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMReserveReplicaGroups.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMReserveReplicaGroups.sp,v $ $Id: MM_SMReserveReplicaGroups.sp,v 1.1.2.4 2018/03/19 23:57:12 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMReserveReplicaGroups <<<'

IF EXISTS (select * from sysobjects where name='MM_SMReserveReplicaGroups')
	drop procedure MM_SMReserveReplicaGroups
IF EXISTS (select * from GxQscripts where name='MM_SMReserveReplicaGroups')
	delete from GxQscripts where name = 'MM_SMReserveReplicaGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMReserveReplicaGroups')
	delete from GXDBVersions where aliasname = 'MM_SMReserveReplicaGroups'
GO
print '... Creating Procedure: MM_SMReserveReplicaGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMReserveReplicaGroups
  @i_xmlText XML
AS
  DECLARE @o_inpReplicaGroupId integer
  DECLARE @o_dbReplicaGroupId integer
  DECLARE @o_inpEntityId integer
  DECLARE @o_dbEntityId integer
  DECLARE @o_MMErrorCode integer
  DECLARE @o_ErrorMsg varchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/*
Input XML
<MM_SMReserveReplicaGroups>
	<CopyId>2222</CopyId>
	<AppId>4444</AppId>
	<ReplicaGroup>
		<ReplicaGroupId>-1</ReplicaGroupId>
		<SrcEntityId>-1</SrcEntityId>
		<TgtEntityId>-2</TgtEntityId>
		<GroupId>RelationshipId1</GroupId>
		<GroupName>Relationship1</GroupName>
		<GroupType>1</GroupType>
		<Flags>298954296</Flags>
	</ReplicaGroup>
	<ReplicaEntity>
		<ReplicaEntityId>-1</ReplicaEntityId>
		<ArrayNum>3</ArrayNum>
		<EntityType>1</EntityType>
		<EntityId>VolId1</EntityId>
		<EntityName>VolumeName1</EntityName>
		<Flags>0</Flags>
	</ReplicaEntity>
	<ReplicaEntity>
		<ReplicaEntityId>-2</ReplicaEntityId>
		<ArrayNum>3</ArrayNum>
		<EntityType>1</EntityType>
		<EntityId>VolId2</EntityId>
		<EntityName>VolumeName2</EntityName>
		<Flags>0</Flags>
	</ReplicaEntity>
</MM_SMReserveReplicaGroups>
*/
IF OBJECT_ID('tempdb.dbo.#tblReplGroup') IS NOT NULL
	DROP TABLE #tblReplGroup
CREATE TABLE #tblReplGroup (
	InpReplicaGroupId	int,
	DbReplicaGroupId	int,
	SrcEntity			int,
	DbSrcEntity			int,
	TgtEntity			int,
	DbTgtEntity			int,
	GroupId				nvarchar(128),
	GroupName			nvarchar(1024),
	GroupType			int,
	Flags				bigint,
	errorCode			int,
	errorMsg			nvarchar(2048)
)
IF OBJECT_ID('tempdb.dbo.#tblReplEntity') IS NOT NULL
	DROP TABLE #tblReplEntity
CREATE TABLE #tblReplEntity (
	InpReplicaEntity	int,
	DbReplicaEntity		int,
	ArrayNum			int,
	EntityType			int,
	EntityId			nvarchar(128),
	EntityName			nvarchar(1024),
	Flags				bigint
)
IF OBJECT_ID('tempdb.dbo.#tblReplGroupMappings') IS NOT NULL
	DROP TABLE #tblReplGroupMappings
CREATE TABLE #tblReplGroupMappings (
		ReplicaGroupId INT,
		CopyId INT,
		AppId INT,
		Flags INT
	)
DECLARE @x_CopyId integer = 0
DECLARE @x_AppId integer = 0
DECLARE @archGroupId integer = 0
DECLARE @errorString	nvarchar(1024) = ''
DECLARE @errorCode INT = 0
-- Read the inputs from the input XML
SET @x_CopyId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMReserveReplicaGroups/CopyId') R(ref)), 0)
SET @x_AppId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMReserveReplicaGroups/AppId') R(ref)), 0)
SELECT @archGroupId = archGroupId FROM archGroupCopy (NOLOCK) WHERE id = @x_CopyId
-- Read the replica groups
INSERT INTO #tblReplGroup
SELECT	ref.value('./ReplicaGroupId[1]', 'int'), 0,
		ref.value('./SrcEntityId[1]', 'int'), 0,
		ref.value('./TgtEntityId[1]', 'int'), 0,
		ref.value('./GroupId[1]', 'nvarchar(1024)'),
		ref.value('./GroupName[1]', 'nvarchar(2048)'),
		ref.value('./GroupType[1]', 'int'),
		ref.value('./Flags[1]', 'bigint'),
		0, ''
FROM	@i_xmlText.nodes('/MM_SMReserveReplicaGroups/ReplicaGroup') R(ref)
-- Read the replica entities
INSERT INTO #tblReplEntity
SELECT	ref.value('./ReplicaEntityId[1]', 'int'), 0,
		ref.value('./ArrayNum[1]', 'int'),
		ref.value('./EntityType[1]', 'int'),
		ref.value('./EntityId[1]', 'nvarchar(1024)'),
		ref.value('./EntityName[1]', 'nvarchar(2048)'),
		ref.value('./Flags[1]', 'bigint')
FROM	@i_xmlText.nodes('/MM_SMReserveReplicaGroups/ReplicaEntity') R(ref)
BEGIN TRY
	-- Check if the group exists in the DB using the groupId. Group Id is unique
	UPDATE	TG
	SET		TG.DbReplicaGroupId = G.ReplicaGroupId
	FROM	#tblReplGroup TG
			INNER JOIN SMReplicaGroup G (NOLOCK) ON TG.GroupId = G.GroupId
	INSERT INTO #tblReplGroupMappings
	SELECT MAP.ReplicaGroupId, MAP.CopyId, MAP.AppId, MAP.Flags
	FROM #tblReplGroup G INNER JOIN SMReplicaGroupMap (NOLOCK) MAP ON G.DbReplicaGroupId = MAP.ReplicaGroupId
	DELETE	MAP
	FROM	#tblReplGroupMappings MAP
			LEFT JOIN archGroupCopy AGC (NOLOCK) ON AGC.id = MAP.CopyId
			LEFT JOIN archGroup AG (NOLOCK) ON AGC.archGroupId = AG.id
			LEFT JOIN APP_Application APP (NOLOCK) ON MAP.AppId = APP.id
WHERE	MAP.Flags & 1 = 1 /*SM_REPLICA_GROUP_FLAGS_SHARED_REL*/
			OR APP.id IS NULL OR AGC.id IS NULL OR AG.id IS NULL  -- copy/sp is deleted
OR ( APP.subclientStatus IS NOT NULL AND (APP.subclientStatus & 0x00002 ) = 0x00002  ) -- subclient uninstalled
OR ( APP.subclientStatus IS NOT NULL AND (APP.subclientStatus & 0x00004) = 0x00004 ) -- subclient deleted
			OR ( MAP.CopyId = @x_CopyId ) -- reservation request for same copy/subclient
			OR ( APP.Id = @x_AppId AND @archGroupId <> AG.Id ) -- subclient reassociation
	IF EXISTS (SELECT 1 FROM #tblReplGroupMappings)
	BEGIN
		UPDATE	G
SET		errorCode = 60351,/*E_MM_SM_SP_REPLICA_GROUP_IN_USE_BY_OTHER_COPY*/
				errorMsg = 'Group [' + G.GroupId+'] is used by storage policy [' + ISNULL(AG.name,'N/A') + '] copy [' + ISNULL(AGC.name,'N/A') + ']'
		FROM	#tblReplGroup G INNER JOIN #tblReplGroupMappings MAP ON G.DbReplicaGroupId = MAP.ReplicaGroupId
				INNER JOIN archGroupCopy AGC (NOLOCK) ON AGC.id = MAP.CopyId
				INNER JOIN archGroup AG (NOLOCK) ON AGC.archGroupId = AG.id
	END
	IF EXISTS ( SELECT 1 FROM #tblReplEntity E LEFT JOIN SMControlHost CTRL (NOLOCK) ON E.ArrayNum = CTRL.ControlHostId WHERE CTRL.ControlHostId IS NULL OR CTRL.ControlHostId = 0)
	BEGIN
		UPDATE	SRC_G
SET		errorCode = 60354,/*E_MM_SM_SP_REPLICA_ENTITY_ARRAY_NUM_NOT_VALID*/
				errorMsg = 'Replica Entity [' + E.EntityName +'] has invalid array number.'
		FROM	#tblReplEntity E INNER JOIN #tblReplGroup SRC_G ON E.InpReplicaEntity = SRC_G.SrcEntity
				LEFT JOIN SMControlHost CTRL (NOLOCK) ON E.ArrayNum = CTRL.ControlHostId
		WHERE	CTRL.ControlHostId IS NULL OR CTRL.ControlHostId = 0
		UPDATE	TGT_G
SET		errorCode = 60354,/*E_MM_SM_SP_REPLICA_ENTITY_ARRAY_NUM_NOT_VALID*/
				errorMsg = 'Replica Entity [' + E.EntityName +'] has invalid array number.'
		FROM	#tblReplEntity E INNER JOIN #tblReplGroup TGT_G ON E.InpReplicaEntity = TGT_G.TgtEntity
				LEFT JOIN SMControlHost CTRL (NOLOCK) ON E.ArrayNum = CTRL.ControlHostId
		WHERE	CTRL.ControlHostId IS NULL OR CTRL.ControlHostId = 0
	END
	-- If there is no valid group, return
	IF NOT EXISTS( SELECT 1 FROM #tblReplGroup WHERE errorCode = 0)
	BEGIN
		SELECT	InpReplicaGroupId, 0, 0, 0,errorCode, errorMsg
		FROM	#tblReplGroup
		RETURN
	END
	-- Based on ArrayNum & entity Id, update dbReplicaEntityId in table #tblReplEntity
	UPDATE	TE
	SET		TE.DbReplicaEntity = E.ReplicaEntityId
	FROM	#tblReplEntity TE
			INNER JOIN SMReplicaEntities E (NOLOCK) ON TE.EntityId = E.EntityId AND TE.ArrayNum = E.ArrayNum
	BEGIN TRANSACTION ReserveReplicaGroups
	-- Add all srcEntity, tgtEntity of groups that have errorCode = 0 in the DB
	IF EXISTS (SELECT 1 FROM #tblReplEntity WHERE DbReplicaEntity = 0)
	BEGIN
		-- Add entries in SMRepliceEntities table if they are not already added in the DB
		INSERT INTO SMReplicaEntities (ArrayNum, EntityType, EntityId, EntityName, Flags)
		SELECT	E.ArrayNum, E.EntityType, E.EntityId, E.EntityName, E.Flags
		FROM	#tblReplEntity E
		WHERE	E.InpReplicaEntity IN (
					SELECT SrcEntity FROM #tblReplGroup WHERE errorCode = 0
					UNION
					SELECT TgtEntity FROM #tblReplGroup WHERE errorCode = 0
					)
				AND E.DbReplicaEntity = 0
	END
	-- Based on ArrayNum & entity Id, update dbReplicaEntityId in table #tblReplEntity
	UPDATE	TE
	SET		TE.DbReplicaEntity = E.ReplicaEntityId
	FROM	#tblReplEntity TE
			INNER JOIN SMReplicaEntities E (NOLOCK) ON TE.EntityId = E.EntityId AND TE.ArrayNum = E.ArrayNum
	-- Update srcEntity, tgtEntity in #tblReplGroup
	-- Update db ids in #tblReplGroup
	UPDATE  G
	SET		G.DbSrcEntity = SRC_E.DbReplicaEntity,
			G.DbTgtEntity = TGT_E.DbReplicaEntity
	FROM	#tblReplGroup G
			INNER JOIN #tblReplEntity SRC_E ON G.SrcEntity = SRC_E.InpReplicaEntity
			INNER JOIN #tblReplEntity TGT_E ON G.TgtEntity = TGT_E.InpReplicaEntity
	WHERE	G.errorCode = 0
	-- Update db ids in #tblReplGroup
	UPDATE  G
	SET		G.DbSrcEntity = SRC_E.DbReplicaEntity,
			G.DbTgtEntity = TGT_E.DbReplicaEntity
	FROM	#tblReplGroup G
			INNER JOIN #tblReplEntity SRC_E ON G.SrcEntity = SRC_E.InpReplicaEntity
			INNER JOIN #tblReplEntity TGT_E ON G.TgtEntity = TGT_E.InpReplicaEntity
	WHERE	G.errorCode = 0
	-- Update flags in SMReplicaGroup
	UPDATE	RG
	SET		RG.flags = G.flags
	FROM	#tblReplGroup G INNER JOIN SMReplicaGroup RG ON G.DbReplicaGroupId = RG.ReplicaGroupId AND RG.flags <> G.flags
	-- Insert entries in SMRepliaGroup
	INSERT INTO SMReplicaGroup (SrcEntityId, TgtEntityId, GroupId, GroupName, GroupType, Flags)
	SELECT	DbSrcEntity, DbTgtEntity, GroupId, GroupName, GroupType, Flags
	FROM	#tblReplGroup
	WHERE	errorCode = 0 AND DbReplicaGroupId = 0
	-- Update dbReplGroupId in #tblReplGroup
	UPDATE	TG
	SET		TG.DbReplicaGroupId = G.ReplicaGroupId
	FROM	#tblReplGroup TG
			INNER JOIN SMReplicaGroup G (NOLOCK) ON TG.GroupId = G.GroupId
	-- Insert entries in SMReplicaGroupMap
	INSERT INTO SMReplicaGroupMap (ReplicaGroupId, CopyId, AppId, Flags)
	SELECT	DbReplicaGroupId, @x_CopyId, @x_AppId, 0
	FROM	#tblReplGroup A LEFT JOIN SMReplicaGroupMap MAP ON MAP.ReplicaGroupId = A.DbReplicaGroupId AND MAP.CopyId = @x_CopyId AND MAP.AppId = @x_AppId
	WHERE	errorCode = 0 AND MAP.ReplicaGroupId IS NULL
    COMMIT TRANSACTION ReserveReplicaGroups
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = ERROR_MESSAGE()
    IF XACT_STATE() <> 0
        ROLLBACK TRANSACTION ReserveReplicaGroups
	SELECT	0, 0, 0, 0, @errorCode, @errorString
	IF OBJECT_ID('tempdb.dbo.#tblReplGroup') IS NOT NULL
		DROP TABLE #tblReplGroup
	IF OBJECT_ID('tempdb.dbo.#tblReplEntity') IS NOT NULL
		DROP TABLE #tblReplEntity
	IF OBJECT_ID('tempdb.dbo.#tblReplGroupMappings') IS NOT NULL
		DROP TABLE #tblReplGroupMappings
	RETURN
END CATCH
	-- Select groups for which reservation failed
	SELECT	InpReplicaGroupId, 0, 0, 0, errorCode, errorMsg
	FROM	#tblReplGroup
	WHERE	errorCode > 0
	UNION
	-- Select the replicaGroupIds
	SELECT	InpReplicaGroupId, DbReplicaGroupId, 0, 0, 0, ''
	FROM	#tblReplGroup
	WHERE	errorCode = 0
	UNION
	-- Select the Source Entities
	SELECT	0, 0, SrcEntity, DbSrcEntity, 0, ''
	FROM	#tblReplGroup
	WHERE	errorCode = 0
	UNION
	-- Select the Target Entities
	SELECT	0, 0, TgtEntity, DbTgtEntity, 0, ''
	FROM	#tblReplGroup
	WHERE	errorCode = 0
	IF OBJECT_ID('tempdb.dbo.#tblReplGroup') IS NOT NULL
		DROP TABLE #tblReplGroup
	IF OBJECT_ID('tempdb.dbo.#tblReplEntity') IS NOT NULL
		DROP TABLE #tblReplEntity
	IF OBJECT_ID('tempdb.dbo.#tblReplGroupMappings') IS NOT NULL
		DROP TABLE #tblReplGroupMappings
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMReserveReplicaGroups')
	delete from GxQscripts where name = 'MM_SMReserveReplicaGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMReserveReplicaGroups')
	delete from GXDBVersions where aliasname = 'MM_SMReserveReplicaGroups'
GO

insert into GXDBVersions values(2, 'MM_SMReserveReplicaGroups',  '00010001000200040000', 'MM_SMReserveReplicaGroups', '00010001000200040000')
GO

