

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMProcessSnapPrune.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMProcessSnapPrune.sp,v $ $Id: MM_SMProcessSnapPrune.sp,v 1.14.2.16 2020/07/15 20:35:54 kkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMProcessSnapPrune')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMProcessSnapPrune <<<'
	drop procedure MM_SMProcessSnapPrune
END
IF EXISTS (select * from GxQscripts where name='MM_SMProcessSnapPrune')
	delete from GxQscripts where name = 'MM_SMProcessSnapPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMProcessSnapPrune')
	delete from GXDBVersions where aliasname = 'MM_SMProcessSnapPrune'
GO
print '... Creating Procedure: MM_SMProcessSnapPrune'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMProcessSnapPrune
  @i_xmlText XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_SMVolSnapMapId integer
  DECLARE @o_SMVolumeId integer
  DECLARE @o_SMSnapId integer
  DECLARE @o_SMMetaDataId integer
  DECLARE @o_IsSnapLinked integer
  DECLARE @o_MAForDeletion integer
  DECLARE @o_KeyForDel varchar(1024)
  DECLARE @o_MMErrorCode integer
  DECLARE @o_ErrorMsg varchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	-- Adding this check to check whether there are any rows in the SMVolume table
	-- For Non Snap CS, the snap prune thread is called every minute
	IF NOT EXISTS (SELECT 1 FROM SMVOLUME (NOLOCK))
	BEGIN
		RETURN
	END
	DECLARE	@tblSMVolumeMountStatus TABLE (
			MountStatus integer
		)
INSERT INTO @tblSMVolumeMountStatus SELECT 0					/*SM_VS_NONE*/
INSERT INTO @tblSMVolumeMountStatus SELECT 10			/*SM_VS_PRP_STARTED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 11			/*SM_VS_PRP_DV_DSCVRD*/
INSERT INTO @tblSMVolumeMountStatus SELECT 12	/*SM_VS_PRP_DV_DSCVR_FAILED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 18				/*SM_VS_PRP_FAILED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 19			/*SM_VS_PRP_PREPARED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 20			/*SM_VS_UPRP_STARTED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 28			/*SM_VS_UPRP_FAILED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 29			/*SM_VS_UPRP_FINISHED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 30			/*SM_VS_CRT_STARTED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 38				/*SM_VS_CRT_FAILED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 39			/*SM_VS_CRT_CREATED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 79			/*SM_VS_UMT_UNMOUNTED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 89			/*SM_VS_RVT_REVERTED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 90			/*SM_VS_DEL_STARTED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 97		/*SM_VS_DEL_EXT_DELETED*/
INSERT INTO @tblSMVolumeMountStatus SELECT 98				/*SM_VS_DEL_FAILED*/
	DECLARE @tblSMVolumePruneFlags TABLE (
		PruneFlags integer
		)
INSERT INTO @tblSMVolumePruneFlags SELECT 0		/*MM_SM_PRUNEFLAGS_INACTIVE*/
INSERT INTO @tblSMVolumePruneFlags SELECT 1		/*MM_SM_PRUNEFLAGS_ACTIVE*/
INSERT INTO @tblSMVolumePruneFlags SELECT 2		/*MM_SM_PRUNEFLAGS_TOBEAGED*/
INSERT INTO @tblSMVolumePruneFlags SELECT 6		/*MM_SM_PRUNEFLAGS_PHYSIC*/
	IF object_id('tempdb.dbo.#tblVolToDel') IS NOT Null DROP TABLE #tblVolToDel
	CREATE TABLE #tblVolToDel (
			SMVolumeId integer,
			MAForDeletion integer,
			ControlHostId integer,
			SnapShotEngineId integer,
			JobId integer,
			CopyId integer,
			MasterJobId integer,
			RecoveryPointId integer
		)
	CREATE INDEX #tblVolToDel_Idx1 ON #tblVolToDel (SMVolumeId, ControlHostId, SnapShotEngineId, JobId, CopyId)
	DECLARE @tblAltMA TABLE (
			arrayId		integer,
			sourceMAId	integer,
			altMAId		integer,
			PRIMARY KEY (arrayId,sourceMAId)
		)
	DECLARE @tblAltMAMultiArray TABLE (
			arrayIdKey	VARCHAR(256),
			sourceMAId	integer,
			altMAId		integer,
			PRIMARY KEY(arrayIdKey,sourceMAId)
		)
	DECLARE @MultiArrayJobs TABLE(
			jobId			integer,
			copyid			integer
		)
	IF object_id('tempdb.dbo.#tblMapAged') IS NOT Null DROP TABLE #tblMapAged
	CREATE TABLE #tblMapAged (
		SMVolSnapMapId		integer,
		SMVolumeId			integer,
		SMSnapId			integer,
		MetaDataId			integer,
		IsSnapLinked		integer,
		SnapShotEngineId	integer,
		ControlHostId		integer,
		MAForDeletion		integer,
		KeyForDel			varchar(512),
		JobId				integer,
		CopyId				integer,
		retryCount			integer,
		MountStatusUpdateTime	integer
	)
	DECLARE @DEFAULT_SNAP_PRUNING_TYPE INT = 1
	DECLARE @i_ArrayNum INT = 0
	SET @i_ArrayNum = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMProcessSnapPrune/ArrayNum') R(ref)), 0)
	DECLARE @i_CopyId INT = 0
	SET @i_CopyId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMProcessSnapPrune/CopyId') R(ref)), 0)
	DECLARE @i_ClientId INT = 0
	SET @i_ClientId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMProcessSnapPrune/ClientId') R(ref)), 0)
	DECLARE @i_SubClientId INT = 0
	SET @i_SubClientId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMProcessSnapPrune/SubClientId') R(ref)), 0)
	DECLARE @RetryParam integer = 0
SET @RetryParam = ISNULL((select Value from MMConfigs (NOLOCK) where name = 'MMS2_CONFIG_VOLSNAP_RETRY_COUNT'), 50/*MMS2_CONFIG_VOLSNAP_RETRY_COUNT_DEFAULT*/)
	DECLARE @i_useTran integer = 0
	SET @i_useTran = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMProcessSnapPrune/useTransaction') R(ref)), 0)
	DECLARE @i_callForNewlyAgedSnaps INT = 0
	SET @i_callForNewlyAgedSnaps = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMProcessSnapPrune/callForNewlyAgedSnaps') R(ref)), @DEFAULT_SNAP_PRUNING_TYPE)
	-- Last update time of the Array-MA Config Param
	DECLARE @SCLastUpdateTime INT = 0
	SET @SCLastUpdateTime = ISNULL(( SELECT Value FROM MMConfigs (NOLOCK) WHERE name = 'MMS2_CONFIG_ARRAY_ALTMA_CONFIG_LAST_UPDATE_TIME'),
0/*MMS2_CONFIG_ARRAY_ALTMA_CONFIG_LAST_UPDATE_TIME_DEFAULT*/)
	-- Update interval in minutes of the Array-MA Config Param
	DECLARE @SCLastUpdateInterval INT = 0
	SET @SCLastUpdateInterval = ISNULL(( SELECT Value FROM MMConfigs (NOLOCK) WHERE name = 'MMS2_CONFIG_ARRAY_ALTMA_CONFIG_UPDATE_INTERVAL_MINUTES'),
60/*MMS2_CONFIG_ARRAY_ALTMA_CONFIG_UPDATE_INTERVAL_MINUTES_DEFAULT*/)
	-- Flag to override the time interval
	DECLARE @SCLastUpdateOverrideFlag INT = 0
	SET @SCLastUpdateOverrideFlag = ISNULL(( SELECT Value FROM MMConfigs (NOLOCK) WHERE name = 'MMS2_CONFIG_ARRAY_ALTMA_CONFIG_UPDATE_OVERRIDE_FLAG'),
0/*MMS2_CONFIG_ARRAY_ALTMA_CONFIG_UPDATE_OVERRIDE_FLAG_DEFAULT*/)
	-- Batch hint for the number of snap per request
	DECLARE @SCBatchHintNumOfSnapsPerReq INT = 0
SET @SCBatchHintNumOfSnapsPerReq = ISNULL(( SELECT Value FROM MMConfigs (NOLOCK) WHERE name = 'MMS2_CONFIG_NUM_OF_SNAPS_PER_DEL_REQ'), 100)
	-- Flag to disable the use of alternate snap MA for Deletion
	DECLARE @SCAlternateMADisabled INT = 0
	SET @SCAlternateMADisabled = ISNULL(( SELECT Value FROM MMConfigs (NOLOCK) WHERE name = 'MMS2_CONFIG_ARRAY_ALTMA_CONFIG_DISABLE_FLAG'),
0/*MMS2_CONFIG_ARRAY_ALTMA_CONFIG_DISABLE_FLAG_DEFAULT*/)
	-- Flag to use the source MA when there is no array controller set for pruning
	DECLARE @SCUseSourceMAForSnapPruning INT = 0
SET @SCUseSourceMAForSnapPruning = ISNULL(( SELECT Value FROM MMConfigs (NOLOCK) WHERE name = 'MMS2_CONFIG_USE_SOURCE_MA_FOR_SNAP_PRUNING'), 0)
	DECLARE @CurrentTime	INT = 0
	SET @CurrentTime = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @t_SMVolumeId INTEGER = 0
	DECLARE @retVal integer = 0
	DECLARE @errorMsg	varchar(MAX) =''
	IF (@i_useTran = 1)
	BEGIN
		BEGIN TRANSACTION ProcessSnapPrune
	END
	-----------------------------------
    -- Update the Array-MA config parameter depending on the last update time or the config param
    -- If the override flag is set in the config parameters or the interval has expired.
    -- In both the above cases, call the SP MM_SMUpdateArrayConfigs
    -----------------------------------
	IF ( @SCAlternateMADisabled = 0 ) AND ((@SCLastUpdateOverrideFlag = 1) OR ( (@SCLastUpdateTime + @SCLastUpdateInterval * 60 )  < @CurrentTime ))
    BEGIN
		DECLARE @tblRtnAltMA TABLE (errorCode integer, errorStr varchar(max))
		INSERT INTO @tblRtnAltMA
		EXEC @retVal = MM_SMProcessAlternateSnapMA '<MM_SMProcessAlternateSnapMA><flagSource>1</flagSource></MM_SMProcessAlternateSnapMA>',0,''
		IF @retVal <> 0
		BEGIN
			SET @errorMsg = (SELECT errorStr FROM @tblRtnAltMA)
			GOTO CX_ERROR_EXIT
		END
	END
	-- If this flag is set, prune only the newly aged
	IF @i_callForNewlyAgedSnaps = 1
	BEGIN
		INSERT INTO #tblVolToDel
		SELECT		DISTINCT VOL.SMVolumeId, VOL.SourceClientId, SNAP.ControlHostId, SNAP.SnapShotEngineId, VOL.JobId, VOL.CopyId, VOL.MasterjobId, VOL.RecoveryPointId
		FROM		SMVolume (NOLOCK) VOL
					INNER JOIN SMVolSnapMap (NOLOCK) MAP ON MAP.SMVolumeId = VOL.SMVolumeId
					INNER JOIN SMSnap (NOLOCK) SNAP ON SNAP.SMSnapId = MAP.SMSnapId
					INNER JOIN SMControlHost CTRL (NOLOCK) ON CTRL.ControlHostId = SNAP.ControlHostId
WHERE		((CTRL.Flags & 2) = 0)
					AND VOL.PruneFlags NOT IN (SELECT PruneFlags FROM @tblSMVolumePruneFlags)
					AND VOL.MountStatus IN (SELECT MountStatus FROM @tblSMVolumeMountStatus)
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMSnapResource (NOLOCK))
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMVolAction (NOLOCK))
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMMountVolume (NOLOCK) WHERE MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/ )
					AND VOL.MountStatus < 99 /*SM_VS_DEL_DELETED*/
					AND VOL.RetryCount = 0
					AND VOL.SnapSource = 0 /*SM_SS_CV*/
					AND VOL.CopyId NOT IN (SELECT ID FROM archGroupCopy (NOLOCK) WHERE isSnapCopy = 1 AND isMirrorCopy = 1)
	END
	-- prune the entries which have already been attempted once
	ELSE
	BEGIN
		INSERT INTO #tblVolToDel
		SELECT		DISTINCT VOL.SMVolumeId, VOL.SourceClientId, SNAP.ControlHostId, SNAP.SnapShotEngineId, VOL.JobId, VOL.CopyId, VOL.MasterjobId, VOL.RecoveryPointId
		FROM		SMVolume (NOLOCK) VOL
					INNER JOIN SMVolSnapMap (NOLOCK) MAP ON MAP.SMVolumeId = VOL.SMVolumeId
					INNER JOIN SMSnap (NOLOCK) SNAP ON SNAP.SMSnapId = MAP.SMSnapId
					INNER JOIN SMSnapShotEngine ENG (NOLOCK) ON ENG.SnapShotEngineId = SNAP.SnapshotEngineId
					INNER JOIN SMControlHost CTRL (NOLOCK) ON CTRL.ControlHostId = SNAP.ControlHostId
WHERE		((CTRL.Flags & 2) = 0)
					AND VOL.PruneFlags NOT IN (SELECT PruneFlags FROM @tblSMVolumePruneFlags)
					AND VOL.MountStatus IN (SELECT MountStatus FROM @tblSMVolumeMountStatus)
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMSnapResource (NOLOCK))
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMVolAction (NOLOCK))
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMMountVolume (NOLOCK) WHERE MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/ )
					AND VOL.MountStatus < 99 /*SM_VS_DEL_DELETED*/
					AND VOL.RetryCount > 0 AND VOL.RetryCount <= @RetryParam
					AND VOL.SnapSource = 0 /*SM_SS_CV*/
					AND VOL.CopyId NOT IN (SELECT ID FROM archGroupCopy (NOLOCK) WHERE isSnapCopy = 1 AND isMirrorCopy = 1)
					AND (  (VOL.MountStatusUpdateTime + (ENG.DeleteCleanupInterval * 60)) < @CurrentTime)
	END
	DELETE FROM #tblVolToDel
	WHERE	SMVolumeId IN (
							SELECT	EXT_DEL_VOLS.SMVolumeId
							FROM	(	SELECT	DISTINCT VOL.SMVolumeId, VOL.ArchFileId, VOL.CopyId, VOL.CommCellId
										FROM	#tblVolToDel A INNER JOIN SMVolume VOL (NOLOCK) ON A.SMVolumeId = VOL.SMVolumeId
WHERE	VOL.PruneFlags = 7/*MM_SM_PRUNEFLAGS_EXT_PRUNED*/ ) EXT_DEL_VOLS
							INNER JOIN	archFileCopy AFC(NOLOCK) ON EXT_DEL_VOLS.ArchFileId = AFC.archFileId AND EXT_DEL_VOLS.CopyId = AFC.archCopyId AND EXT_DEL_VOLS.CommCellId = AFC.commCellId
							WHERE AFC.flags & 256/*CVA_AGED_DATA_FLAG*/ = 0 )
	-----------------------------------------------------------------------------------
	-- SKIP deletion of snaps in latest cycle while Synth full job running.
	-----------------------------------------------------------------------------------
	DECLARE @SynthFullJobId INT  = 0
	DECLARE @SnapJobId INT = 0
	DECLARE @BkpLevelSynthFull INT = 64
	DECLARE @jobStatusCompleted INT = 1
	DECLARE @jobStatusCompletedWError INT = 3
	DECLARE @jobStatusCompletedWWarning INT = 14
	declare @tblToSkipForsynthFullJob TABLE ( SynthFullJobId INT, SnapJob INT , AppId INT, SMVolumeId INT)
	--
	-- collect all the snaps which belongs TMP.appid where synthfull job is running
	-- we have to skip all the volume deletion
	--
	INSERT 	INTO @tblToSkipForsynthFullJob
	SELECT	BKPINFO.jobId, TMP.JobId, TMP.AppId, TMP.SMVolumeId
	FROM	#tblVolToDel TMP
				INNER JOIN archGroup AG (READUNCOMMITTED)
					ON TMP.CopyId = AG.defaultSnapCopy
				INNER JOIN APP_SubClientProp PROP (READUNCOMMITTED)
					ON PROP.componentNameId = TMP.AppId
					AND PROP.attrName = 'sys:full cycle num'
					AND PROP.modified = 0
				INNER JOIN JMBkpStats BKP (READUNCOMMITTED)
					ON BKP.jobId = TMP.JobId
					AND BKP.commCellId = TMP.CommCellId
					AND BKP.fullCycleNum = PROP.attrVal
					AND BKP.status IN (@jobStatusCompleted, @jobStatusCompletedWError, @jobStatusCompletedWWarning)
				INNER JOIN JMBkpJobInfo BKPINFO (READUNCOMMITTED)
					ON BKPINFO.applicationId = TMP.AppId
					AND BKPINFO.commcellId = TMP.CommCellId
					AND BKPINFO.bkpLevel = @BkpLevelSynthFull
	WHERE 	BKPINFO.jobId > 0
	--
	-- REMOVE smvolumes entries that we collected above , using appid + smvolumeid for joining
	-- Instead of failing whole batch which has other subclient's snaps too which should be allowed to delete
	-- caused a TR ; SP16 (V11) - ACP IT Solutions GmbH - Austria - FE261 - SP16 - Snapshots not removed from Array - 200312-180 CVLT::0098059027
    DELETE	FROM  VOL
	FROM 	#tblVolToDel AS VOL
			INNER JOIN	@tblToSkipForsynthFullJob SKIP_Synth
				ON	VOL.SMVolumeid = SKIP_Synth.SMVolumeId
				AND VOL.AppId = SKIP_Synth.AppId
	-- Remove volumes whose shared volume is mounted or has entries in smsnapresource as if we let those volumes go
	-- they are causing whole batch of delete failure and causing buildup on file server. This is very common for vsa v2 ( they consider whole masterjob as shared ) .
	    -----------------------------------------------------------------------------
    -- Remove all volumes within SCG or LREP group -- Use RecoveryPointId as Group Id
    -----------------------------------------------------------------------------
	-- 	Validation MM_SMVolSnapsToDelete : line :281
	--    SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM SMSnapResource (READUNCOMMITTED) WHERE SMVolumeId IN (SELECT SMVolumeId FROM @tblSharedVols))
	DELETE	FROM  VOL
	FROM 	#tblVolToDel AS VOL
    INNER JOIN    SMVolume A (READUNCOMMITTED)
		ON VOL.RecoveryPointId  = A.RecoveryPointId
	INNER JOIN    SMSnapResource RES (READUNCOMMITTED)
		ON A.SMVolumeId = RES.SMVolumeId
    WHERE   (
                A.RecoveryPointId > 0
                AND (
						(
A.AppTypeId = 22
							AND
(A.VolumeFlags & 8192 > 0) 	/*CVSM_VOLUMEFLAGS_SCG_VOLUMES*/
						)
						OR
(A.VolumeFlags & 4096 > 0 ) 	/*CVSM_VOLUMEFLAGS_LREP_JOB_ENV_DB*/
					)
            )
	-- Remove VSA V2 volumes too whose shared  volume is reserved
	DELETE	FROM  VOL
	FROM 	#tblVolToDel AS VOL
    INNER JOIN    SMVolume A (READUNCOMMITTED)
		ON A.MasterJobId  = VOL.MasterJobId
	INNER JOIN    SMSnapResource RES (READUNCOMMITTED)
		ON A.SMVolumeId = RES.SMVolumeId
    WHERE   (
                ---- For VSA VMware V2 and Hyper-V V2
                (
(A.AppTypeId = 106        )
                    OR
(A.AppTypeId = 33    )
                )
AND ( A.VolumeFlags & CAST(4294967296 AS BIGINT) > 0)
                AND  A.MasterJobId > 0
            )
	IF NOT EXISTS (SELECT 1 FROM #tblVolToDel)
	BEGIN
		GOTO CX_EXIT
	END
	--Check if any volume that is selected for deletion has the source clientId in the following state below, then we have to check if there is an alternate MA for this array
	--	MA States where in we select the Alternate MA
	--	Offline
	--	Disabled
	--	Uninstalled uninstalled
	--	Client Deleted
	--	MA Deleted
	INSERT INTO @tblAltMA
	SELECT		DISTINCT A.ControlHostId, A.MAForDeletion, 0
	FROM		#tblVolToDel A
				LEFT JOIN MMHost MA (NOLOCK) ON MA.ClientId = A.MAForDeletion
	WHERE		A.ControlHostId > 0
				AND (
						MA.ClientId IS NULL	-- MA Deleted
						OR MA.MMHostSoftState = 0
						OR MA.MMHostEnabled = 0
						OR MA.OfflineReason > 0
				)
	-- If the option to use only the configured array controllers is selected, then try to find the alternate MA for pruining for those array-source MAs
	INSERT	INTO @tblAltMA
	SELECT	DISTINCT VOL.ControlHostId, VOL.MAForDeletion, 0
	FROM	SMControlHost CTRL (NOLOCK) INNER JOIN #tblVolToDel VOL ON CTRL.ControlHostId = VOL.ControlHostId
			LEFT JOIN @tblAltMA ALTMA ON ALTMA.arrayId = VOL.ControlHostId AND ALTMA.sourceMAId = VOL.MAForDeletion
WHERE	CTRL.Flags & 1 = 1/*CVSM_CTRLHOST_FLAGS_USE_ONLY_SELECTED_ARRAY_CTRLS_DB*/
			AND ALTMA.arrayId IS NULL AND ALTMA.sourceMAId IS NULL
	INSERT INTO @MultiArrayJobs
	SELECT		DISTINCT TBLVOL.jobId, TBLVOL.copyId
	FROM		#tblVolToDel TBLVOL INNER JOIN SMSnapShotEngine ENG (NOLOCK) ON ENG.SnapShotEngineId = TBLVOL.SnapShotEngineId
				INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = TBLVOL.SMVolumeId
				INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
WHERE		(( ENG.Capabilities & 131072 ) = 131072 /*SM_SNAPSHOT_ENGINE_CAPABILITY_MULTI_ARRAY_FOR_SNAP_JOB*/)
OR ( SNAP.SnapFlags & CAST (17179869184 AS bigint) = 17179869184 )
	GROUP BY	TBLVOL.JobId, TBLVOL.CopyId
	HAVING		COUNT(DISTINCT TBLVOL.ControlHostId) > 1
	INSERT	INTO @tblAltMAMultiArray
	SELECT		DISTINCT
				STUFF(  (	SELECT '_' + CAST( c.controlhostid AS VARCHAR(10) )
							FROM  @MultiArrayJobs b INNER JOIN #tblVolToDel c on b.jobId = c.JobId and b.copyid = c.CopyId
							WHERE b.jobid = a.jobid and a.copyid = b.copyid
							GROUP BY c.ControlHostId
							FOR XML PATH('')
						),1,1,''), a.MAForDeletion, 0
	FROM		#tblVolToDel a
	INNER JOIN	@MultiArrayJobs b on a.JobId = b.jobId and a.CopyId = b.copyid
	LEFT JOIN	MMHost MA (NOLOCK) ON MA.ClientId = A.MAForDeletion
	INNER JOIN	SMControlHost CTRL (NOLOCK) ON CTRL.ControlHostId = A.ControlHostId
	WHERE		A.ControlHostId > 0
				AND (	(CTRL.Flags & 1 = 1/*CVSM_CTRLHOST_FLAGS_USE_ONLY_SELECTED_ARRAY_CTRLS_DB*/) OR
						(MA.ClientId IS NULL	-- MA Deleted
						OR MA.MMHostSoftState = 0
						OR MA.MMHostEnabled = 0
						OR MA.OfflineReason > 0))
	IF @@ERROR <> 0
	BEGIN
		SET @retVal = 60325/*E_MM_SM_SB_PROCESS_SNAP_PRUNE_FAILED*/
		SET @errorMsg = 'Failed while generating the key for Multi-Array jobs'
		GOTO CX_ERROR_EXIT
	END
	IF @SCAlternateMADisabled = 1
	BEGIN
		DELETE FROM @tblAltMA
	END
	-- If the table @tblAltMA is not empty, it means there are some volumes who need an alternate MA for deletion
	-- Check the table SMAltMAForArray for the alternate MA
	IF EXISTS (	SELECT 1 FROM @tblAltMA )
	BEGIN
		-- If the entry for this array/MA does not exist in the SMAltMAForArray table, then insert such entries in the table.
		INSERT INTO SMAltMAForArray
		SELECT 		TEMP.arrayId,TEMP.sourceMAId,0,0,0,'',@CurrentTime
		FROM		@tblAltMA TEMP
					LEFT JOIN SMAltMAForArray ALTMA (NOLOCK) ON TEMP.arrayId = ALTMA.arrayId AND TEMP.sourceMAId = ALTMA.sourceMAId
		WHERE		ALTMA.arrayId IS NULL AND ALTMA.sourceMAId IS NULL
		-- If the entry for this arrayIdKey/MA does not exist in the SMAltMAForMultiArray table, then insert such entries in the table.
		INSERT INTO SMAltMAForMultiArray
		SELECT 		TEMP.arrayIdKey,TEMP.sourceMAId,0,@CurrentTime,0,0,''
		FROM		@tblAltMAMultiArray TEMP
					LEFT JOIN SMAltMAForMultiArray ALTMA (NOLOCK) ON TEMP.arrayIdKey = ALTMA.arrayIdKey AND TEMP.sourceMAId = ALTMA.sourceMAId
		WHERE		ALTMA.arrayIdKey IS NULL AND ALTMA.sourceMAId IS NULL
		-- Find a new alternate MA ( If within the time interval or 1 hour the alternate MA goes offline or gets deleted, or if the array controller is deconfigured from the array management )
		UPDATE	ALTMA
		SET		ALTMA.alternateMAId = 0
		FROM	@tblAltMA A INNER JOIN SMAltMAForArray ALTMA (NOLOCK) ON ALTMA.arrayId = A.arrayId AND A.sourceMAId = ALTMA.sourceMAId
				LEFT JOIN MMHost MA (NOLOCK) ON MA.ClientId = ALTMA.alternateMAId
				LEFT JOIN SMArrayController AC (NOLOCK) ON AC.ArrayNum = A.arrayId AND AC.MMHostId = ALTMA.alternateMAId
		WHERE	MA.ClientId IS NULL OR MA.MMHostSoftState = 0 OR MA.MMHostEnabled = 0 OR MA.OfflineReason > 0 OR AC.ArrayControllerId IS NULL
				OR AC.Options & 262144/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_SNAP_PRUNING*/ = 0
		UPDATE	ALTMA
		SET		ALTMA.alternateMAId = 0
		FROM	@tblAltMAMultiArray A INNER JOIN SMAltMAForMultiArray ALTMA (NOLOCK) ON ALTMA.arrayIdKey = A.arrayIdKey AND A.sourceMAId = ALTMA.sourceMAId
				LEFT JOIN MMHost MA (NOLOCK) ON MA.ClientId = ALTMA.alternateMAId
				LEFT JOIN SMArrayController AC (NOLOCK) ON AC.MMHostId = ALTMA.alternateMAId AND AC.ArrayNum IN ( SELECT _ID FROM dbo.SplitStringByDelimiter(ALTMA.arrayIdKey,'_'))
		WHERE	MA.ClientId IS NULL OR MA.MMHostSoftState = 0 OR MA.MMHostEnabled = 0 OR MA.OfflineReason > 0 OR AC.ArrayControllerId IS NULL
				OR AC.Options & 262144/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_SNAP_PRUNING*/ = 0
		--If the entry exists, but the alternate MA value is 0 (new entry or the alternate MA does not exist for this array), in such cases
		-- Call the SP to update the alternate MA Value
		IF	EXISTS  (	SELECT 1 FROM @tblAltMA A INNER JOIN SMAltMAForArray ALTMA (NOLOCK) ON ALTMA.arrayId = A.arrayId AND A.sourceMAId = ALTMA.sourceMAId
						WHERE	ALTMA.alternateMAId = 0
					) OR
			EXISTS  (	SELECT 1 FROM @tblAltMAMultiArray A INNER JOIN SMAltMAForMultiArray ALTMA (NOLOCK) ON ALTMA.arrayIdKey = A.arrayIdKey AND A.sourceMAId = ALTMA.sourceMAId
						WHERE ALTMA.alternateMAId = 0
					)
		BEGIN
			DECLARE @tblRtnAltMA1 TABLE (errorCode integer, errorStr varchar(max))
			INSERT INTO @tblRtnAltMA1
			EXEC @retVal = MM_SMProcessAlternateSnapMA '<MM_SMProcessAlternateSnapMA><flagSource>2</flagSource></MM_SMProcessAlternateSnapMA>',0,''
			IF @retVal <> 0
			BEGIN
				SET @errorMsg = (SELECT errorStr FROM @tblRtnAltMA1)
				GOTO CX_ERROR_EXIT
			END
		END
		-- Update the temp table with the alternate MA values from the table SMAltMAForArray.
		UPDATE		@tblAltMA
		SET			altMAId = ALTMA.alternateMAId
		FROM		@tblAltMA A
					INNER JOIN SMAltMAForArray ALTMA (NOLOCK) ON ALTMA.arrayId = A.arrayId AND A.sourceMAId = ALTMA.sourceMAId
		-- Update the temp table with the alternate MA values from the table SMAltMAForMultiArray.
		UPDATE		@tblAltMAMultiArray
		SET			altMAId = ALTMA.alternateMAId
		FROM		@tblAltMAMultiArray A
					INNER JOIN SMAltMAForMultiArray ALTMA (NOLOCK) ON ALTMA.arrayIdKey = A.arrayIdKey AND A.sourceMAId = ALTMA.sourceMAId
		-- If we have any row with the alternate MA as 0, it means that no alternate MA is available for that array/MA combination.
		-- In such cases, do not select the volumes belonging to that array/MA.
		DELETE		TBLVOL
		FROM		#tblVolToDel TBLVOL
					INNER JOIN @tblAltMA ALTMA ON TBLVOL.ControlHostId = ALTMA.arrayId AND TBLVOL.MAForDeletion = ALTMA.sourceMAId
		WHERE		ALTMA.altMAId = 0
					AND NOT EXISTS (SELECT 1 FROM @MultiArrayJobs M WHERE M.jobId = TBLVOL.JobId AND M.copyid = TBLVOL.CopyId)
		DELETE		TBLVOL
		FROM		#tblVolToDel TBLVOL
					INNER JOIN @tblAltMAMultiArray ALTMA ON ALTMA.sourceMAId = TBLVOL.MAForDeletion AND TBLVOL.ControlHostId IN ( SELECT _ID FROM dbo.SplitStringByDelimiter(ALTMA.arrayIdKey,'_') )
					INNER JOIN @MultiArrayJobs M ON M.jobId = TBLVOL.JobId AND M.copyid = TBLVOL.CopyId
		WHERE		ALTMA.altMAId = 0
		UPDATE		#tblVolToDel
		SET			MAForDeletion = ALTMA.altMAId
		FROM		#tblVolToDel TBLVOL
					INNER JOIN @tblAltMA ALTMA ON ALTMA.arrayId = TBLVOL.ControlHostId AND ALTMA.sourceMAId = TBLVOL.MAForDeletion
		WHERE		NOT EXISTS (SELECT 1 FROM @MultiArrayJobs M WHERE M.jobId = TBLVOL.JobId AND M.copyid = TBLVOL.CopyId)
		IF @@ERROR <> 0
		BEGIN
SET @retVal = 60325/*E_MM_SM_SB_PROCESS_SNAP_PRUNE_FAILED*/
			SET @errorMsg = 'Failed while updating the Alternate Media Agent for Snap Prune'
			GOTO CX_ERROR_EXIT
		END
		UPDATE		#tblVolToDel
		SET			MAForDeletion = ALTMA.altMAId
		FROM		#tblVolToDel TBLVOL
					INNER JOIN @tblAltMAMultiArray ALTMA ON ALTMA.sourceMAId = TBLVOL.MAForDeletion AND TBLVOL.ControlHostId IN ( SELECT _ID FROM dbo.SplitStringByDelimiter(ALTMA.arrayIdKey,'_') )
					INNER JOIN @MultiArrayJobs M ON M.jobId = TBLVOL.JobId AND M.copyid = TBLVOL.CopyId
		IF @@ERROR <> 0
		BEGIN
SET @retVal = 60325/*E_MM_SM_SB_PROCESS_SNAP_PRUNE_FAILED*/
			SET @errorMsg = 'Failed while updating the Alternate Media Agent for Snap Prune for Multi-Array jobs'
			GOTO CX_ERROR_EXIT
		END
		DELETE FROM SMAltMAForArray WHERE alternateMAId = 0
		DELETE FROM SMAltMAForMultiArray WHERE alternateMAId = 0
	END
	UPDATE		#tblVolToDel
	SET			ControlHostId = B.controlhostId
	FROM		#tblVolToDel TBLVOL
				INNER JOIN ( SELECT jobId, CopyId, MIN(controlhostId) controlhostId FROM #tblVolToDel GROUP BY JobId, CopyId ) B ON TBLVOL.JobId = B.JobId AND TBLVOL.CopyId = B.CopyId
				INNER JOIN @MultiArrayJobs M ON M.jobId = TBLVOL.JobId AND M.copyid = TBLVOL.CopyId
	INSERT INTO #tblMapAged
	SELECT		map.SMVolSnapMapId, map.SMVolumeId, map.SMSnapId, 0, 0, snap.SnapShotEngineId, snap.ControlHostId,tblvol.MAForDeletion,
				( CAST( tblvol.MAForDeletion AS VARCHAR)+ '_' + CAST(snap.SnapShotEngineId AS VARCHAR)+ '_' + CAST(tblvol.ControlHostId AS VARCHAR) ) ,
				vol.JobId, vol.CopyId, vol.retryCount, vol.MountStatusUpdateTime
	FROM		(SELECT DISTINCT * FROM #tblVolToDel) tblvol INNER JOIN SMVolume vol (NOLOCK) ON vol.SMVolumeId = tblvol.SMVolumeId
				INNER JOIN SMVolSnapMap map (NOLOCK) ON vol.SMVolumeId = map.SMVolumeId
				INNER JOIN SMSnap snap (NOLOCK) ON snap.SMSnapId = map.SMSnapId
	WHERE		snap.SnapShotEngineId > 0
				AND snap.ControlHostId > 0
	ORDER BY	vol.SourceClientId, snap.SnapShotEngineId, snap.ControlHostId
	-- For Native Snap Engines, where ControlHostId is zero
	INSERT	INTO #tblMapAged
	SELECT		map.SMVolSnapMapId, map.SMVolumeId, map.SMSnapId, 0, 0, snap.SnapShotEngineId, snap.ControlHostId, tblvol.MAForDeletion,
				( CAST( tblvol.MAForDeletion AS VARCHAR)+ '_' + CAST(snap.SnapShotEngineId AS VARCHAR)+ '_' + CAST(tblvol.ControlHostId AS VARCHAR) ) ,
				vol.JobId, vol.CopyId, vol.retryCount, vol.MountStatusUpdateTime
	FROM		(SELECT DISTINCT * FROM #tblVolToDel) tblvol INNER JOIN SMVolume vol (NOLOCK) ON vol.SMVolumeId = tblvol.SMVolumeId
				INNER JOIN SMVolSnapMap map (NOLOCK) ON vol.SMVolumeId = map.SMVolumeId
				INNER JOIN SMSnap snap (NOLOCK) ON snap.SMSnapId = map.SMSnapId
				INNER JOIN MMHost host (NOLOCK) ON vol.sourceClientId = host.ClientId
WHERE		snap.SnapShotEngineId IN (1, 53, 48, 58, 59)
				AND host.MmHostEnabled = 1 AND host.MmHostSoftState = 1 AND host.OfflineReason = 0
	ORDER BY	vol.SourceClientId, snap.SnapShotEngineId, snap.ControlHostId
	------------------------------------------------------------------
	-- Batch the delete requests for every (Media Agent - Engine - Array) combination
	------------------------------------------------------------------
	IF OBJECT_ID('tempdb.dbo.#tblBatching') IS NOT Null DROP TABLE #tblBatching
	CREATE TABLE #tblBatching (
		KeyForDel varchar(512),
		JobId integer,
		CopyId integer,
		numOfSnap integer,
		rowNum integer,
		NumOfSnapSum integer
	)
	CREATE INDEX #tblBatching_Idx1 ON #tblBatching (KeyForDel, JobId, CopyId)
	IF @i_callForNewlyAgedSnaps = 1
	BEGIN
		INSERT INTO	#tblBatching
		SELECT		KeyForDel, JobId, CopyId, numOfSnap,  ROW_NUMBER() OVER(PARTITION BY KeyForDel ORDER BY jobid ASC, copyid),0
		FROM		(
						SELECT		KeyForDel, JobId, CopyId, COUNT(DISTINCT SMSnapId) numOfSnap
						FROM		#tblMapAged
						GROUP BY	KeyForDel,JobId,CopyId
					) A
	END
	ELSE
	BEGIN
		INSERT INTO	#tblBatching
		SELECT		KeyForDel, JobId, CopyId, numOfSnap,  ROW_NUMBER() OVER(PARTITION BY KeyForDel ORDER BY A.MountStatusUpdateTime ASC),0
		FROM		(
						SELECT		KeyForDel, JobId, CopyId, COUNT(DISTINCT SMSnapId) numOfSnap, MIN(MountStatusUpdateTime) MountStatusUpdateTime
						FROM		#tblMapAged
						GROUP BY	KeyForDel,JobId,CopyId
					) A
	END
	UPDATE		c
	SET			NumOfSnapSum =  numOfSnapTotal
	FROM		#tblBatching c INNER JOIN
					(
						SELECT		a.KeyForDel, a.JobId, a.CopyId, SUM(b.numOfSnap) numOfSnapTotal
						FROM		#tblBatching a inner join #tblBatching b on a.KeyForDel = b.KeyForDel and a.rowNum >= b.rowNum
						GROUP BY	a.KeyForDel, a.JobId, a.CopyId
					) d on c.KeyForDel = d.KeyForDel and c.JobId = d.JobId and c.CopyId = d.CopyId
	DELETE a
	FROM #tblBatching a
	INNER JOIN (
					SELECT	KeyForDel, MAX(rowNum) +1 AS maxm
					FROM	#tblBatching
					WHERE	NumOfSnapSum <= @SCBatchHintNumOfSnapsPerReq
					GROUP BY KeyForDel) b ON a.keyfordel = b.keyfordel
	WHERE a.rownum > b.maxm
	DELETE MapAged
	FROM #tblMapAged MapAged
	LEFT JOIN #tblBatching Batch ON MapAged.KeyForDel = Batch.KeyForDel AND MapAged.JobId = Batch.JobId and MapAged.CopyId = Batch.CopyId
	WHERE	Batch.JobId IS NULL AND Batch.CopyId IS NULL
	------------------------------------------------------------------
	-- Snap linked to active volumes
	------------------------------------------------------------------
	UPDATE	#tblMapAged SET IsSnapLinked = 1
	FROM	#tblMapAged B INNER JOIN SMVolSnapMap A (NOLOCK) ON A.SMSnapId = B.SMSnapId
			INNER JOIN SMVolume C (NOLOCK) ON A.SMVolumeId = C.SMVolumeId
			LEFT JOIN #tblVolToDel VOL ON C.SMVolumeId = VOL.SMVolumeId
	WHERE	VOL.SMVolumeId IS NULL
			AND C.MountStatus < 99
	------------------------------------------------------------------
	-- Get all metadata for volumes
	------------------------------------------------------------------
	INSERT	INTO #tblMapAged
	SELECT	0, RefId, 0, MetaDataId, 0, 0, 0, 0, '', 0, 0, 0, 0
	FROM	SMMetaData WITH (READUNCOMMITTED)
WHERE	RefType = 1 /*MM_SM_METADATA_REFTYPE_SMVOLUME*/
	AND		RefId in (SELECT DISTINCT SMVolumeId FROM #tblMapAged)
	------------------------------------------------------------------
	-- Get all metadata for snaps
	------------------------------------------------------------------
	INSERT	INTO #tblMapAged
	SELECT	0, 0, RefId, MetaDataId, 0, 0, 0, 0, '', 0, 0, 0, 0
	FROM	SMMetaData WITH (READUNCOMMITTED)
WHERE	RefType = 2 /*MM_SM_METADATA_REFTYPE_SMSNAP*/
	AND		RefId in (SELECT DISTINCT SMSnapId FROM #tblMapAged)
CX_EXIT:
	IF (@i_useTran = 1)
		COMMIT TRANSACTION ProcessSnapPrune
	SELECT SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, IsSnapLinked, MAForDeletion, KeyForDel, @retVal, @errorMsg
	FROM #tblMapAged
	ORDER BY KeyForDel DESC
	IF object_id('tempdb.dbo.#tblMapAged') IS NOT Null DROP TABLE #tblMapAged
	IF object_id('tempdb.dbo.#tblVolToDel') IS NOT Null DROP TABLE #tblVolToDel
	IF object_id('tempdb.dbo.#tblBatching') IS NOT Null DROP TABLE #tblBatching
	RETURN
CX_ERROR_EXIT:
	IF object_id('tempdb.dbo.#tblMapAged') IS NOT Null DROP TABLE #tblMapAged
	IF object_id('tempdb.dbo.#tblVolToDel') IS NOT Null DROP TABLE #tblVolToDel
	IF object_id('tempdb.dbo.#tblBatching') IS NOT Null DROP TABLE #tblBatching
	IF (@i_useTran = 1)
		ROLLBACK TRANSACTION ProcessSnapPrune
	SELECT 0, 0, 0, 0, 0, 0, '', @retVal,@errorMsg
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMProcessSnapPrune')
	delete from GxQscripts where name = 'MM_SMProcessSnapPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMProcessSnapPrune')
	delete from GXDBVersions where aliasname = 'MM_SMProcessSnapPrune'
GO

insert into GXDBVersions values(2, 'MM_SMProcessSnapPrune',  '00010014000200160000', 'MM_SMProcessSnapPrune', '00010014000200160000')
GO

