

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMProcessDatasetsForPruning.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMProcessDatasetsForPruning.sp,v $ $Id: MM_SMProcessDatasetsForPruning.sp,v 1.1.2.2 2017/02/10 20:21:34 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMProcessDatasetsForPruning <<<'

IF EXISTS (select * from sysobjects where name='MM_SMProcessDatasetsForPruning')
	drop procedure MM_SMProcessDatasetsForPruning
IF EXISTS (select * from GxQscripts where name='MM_SMProcessDatasetsForPruning')
	delete from GxQscripts where name = 'MM_SMProcessDatasetsForPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMProcessDatasetsForPruning')
	delete from GXDBVersions where aliasname = 'MM_SMProcessDatasetsForPruning'
GO
print '... Creating Procedure: MM_SMProcessDatasetsForPruning'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMProcessDatasetsForPruning
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_errCode INT
  DECLARE @o_errMsg VARCHAR(255)
SET NOCOUNT ON
DECLARE @errCode	INT = 0
DECLARE @errMsg		VARCHAR(255) = ''
UPDATE	DS
SET		DS.Flags = DS.Flags | 1024
FROM	SMDataSet DS
INNER JOIN SMDataSetToSubClientMap MAP (NOLOCK) ON MAP.DataSetId = DS.DataSetId AND DS.Flags & ( 512 | 1 | 1024) = 0
WHERE	EXISTS (SELECT * FROM SMSnapToDatasetMap SNAPMAP (NOLOCK) WHERE SNAPMAP.DataSetId = MAP.DataSetId AND SNAPMAP.AppId <> MAP.AppId)
SET @errCode = @@ERROR
IF @errCode <> 0
BEGIN
	SET @errMsg = 'Failed to mark datasets not prunable.'
	GOTO ERR_EXIT
END
UPDATE	DS
SET		DS.Flags = DS.Flags & (~1024)
FROM	SMDataSet DS
INNER JOIN SMDataSetToSubClientMap MAP (NOLOCK) ON MAP.DataSetId = DS.DataSetId AND DS.Flags & (512 | 1 | 1024) = 1024
WHERE	NOT EXISTS (SELECT * FROM SMSnapToDatasetMap SNAPMAP (NOLOCK) WHERE SNAPMAP.DataSetId = MAP.DataSetId AND SNAPMAP.AppId <> MAP.AppId)
SET @errCode = @@ERROR
IF @errCode <> 0
BEGIN
	SET @errMsg = 'Failed to mark datasets prunable.'
	GOTO ERR_EXIT
END
ERR_EXIT:
	IF OBJECT_ID('tempdb.dbo.#MM_SMProcessDatasetsForPruningResultTable') IS NOT NULL
	BEGIN
		INSERT INTO #MM_SMProcessDatasetsForPruningResultTable
		SELECT @errCode, @errMsg
	END
	ELSE
		SELECT @errCode, @errMsg
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMProcessDatasetsForPruning')
	delete from GxQscripts where name = 'MM_SMProcessDatasetsForPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMProcessDatasetsForPruning')
	delete from GXDBVersions where aliasname = 'MM_SMProcessDatasetsForPruning'
GO

insert into GXDBVersions values(2, 'MM_SMProcessDatasetsForPruning',  '00010001000200020000', 'MM_SMProcessDatasetsForPruning', '00010001000200020000')
GO

