

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMProcessAlternateSnapMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMProcessAlternateSnapMA.sp,v $ $Id: MM_SMProcessAlternateSnapMA.sp,v 1.6.12.3 2018/03/20 00:10:37 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMProcessAlternateSnapMA <<<'

IF EXISTS (select * from sysobjects where name='MM_SMProcessAlternateSnapMA')
	drop procedure MM_SMProcessAlternateSnapMA
IF EXISTS (select * from GxQscripts where name='MM_SMProcessAlternateSnapMA')
	delete from GxQscripts where name = 'MM_SMProcessAlternateSnapMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMProcessAlternateSnapMA')
	delete from GXDBVersions where aliasname = 'MM_SMProcessAlternateSnapMA'
GO
print '... Creating Procedure: MM_SMProcessAlternateSnapMA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMProcessAlternateSnapMA
  @i_xmlText XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_MMErrorCode INT
  DECLARE @o_ErrorMsg VARCHAR(MAX)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @errorCode	INT = 0
	DECLARE @errorStr	VARCHAR(MAX) = ''
	DECLARE @i_flag_Source	INT = 1
	SET @i_flag_Source = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMProcessAlternateSnapMA/flagSource') R(ref)), 1)
	DECLARE @arrayIdKeyMAMap TABLE (
		arrayidkey		VARCHAR(256),
		controlHostId	INT,
		MAId int
	)
	DECLARE @arrayIdKeyMAMapFinal TABLE (
		arrayidkey		VARCHAR(256),
		controlHostId	INT,
		MAId			INT
	)
	DECLARE @CurrentTime	INT = 0
	SET @CurrentTime = dbo.GetUnixTime(GETUTCDATE())
	-- Get the map like table ( arrayIdKey - arrayId - MA's )
	INSERT INTO @arrayIdKeyMAMap
	SELECT		DISTINCT arrayIdKey, AC.ArrayNum, AC.MMHostId
	FROM		SMAltMAForMultiArray A (NOLOCK) INNER JOIN SMArrayController AC (NOLOCK) ON AC.ArrayNum IN (SELECT _ID FROM dbo.SplitStringByDelimiter(A.arrayIdKey,'_'))
WHERE		AC.Options & 262144/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_SNAP_PRUNING*/ > 0
	-- This table variable has the following entries ( arrayIdKey - arrayId - MA's )
	-- In this table variable, for a given arrayIdKey, the MA's present have access to all the arrays of that combination
	INSERT INTO @arrayIdKeyMAMapFinal
	SELECT		DISTINCT L_TABLE.arrayidkey, L_TABLE.controlHostId, L_TABLE.MAId
	FROM		@arrayIdKeyMAMap L_TABLE
				LEFT OUTER JOIN
				(	SELECT *
					FROM @arrayIdKeyMAMap a
					CROSS APPLY
					(
						(SELECT _ID FROM dbo.SplitStringByDelimiter(a.arrayIdKey,'_'))
						EXCEPT
						(SELECT distinct controlHostId from @arrayIdKeyMAMap b where a.arrayidkey = b.arrayidkey and a.MAId = b.MAId)
					)T
				) R_TABLE
				ON	L_TABLE.arrayidkey = R_TABLE.arrayidkey
					AND L_TABLE.controlHostId = R_TABLE.controlHostId
					AND L_TABLE.MAId= R_TABLE.MAId
	WHERE R_TABLE.arrayidkey IS NULL
	IF @@ERROR <> 0
	BEGIN
SET		@errorCode = 60324/*E_MM_SM_SB_PROCESS_ALTERNATE_SNAP_MA_FAILED*/
		SET		@errorStr = 'Failed to populate map table for alternate snap media agent.'
		GOTO	CX_ERROR_EXIT
	END
	IF @i_flag_Source = 1
	BEGIN
		-- If the highest MA id is reached, then the below queries will set the alternate MA to 0.
		-- After this block, we update the alternate MA for those entries where the alternate MA is 0
		UPDATE	SMAltMAForArray
		SET		alternateMAId = ISNULL(B.alternateMAId,0),
				alternateMAUpdatetime = @CurrentTime
		FROM	SMAltMAForArray ALTMA (NOLOCK)
				LEFT JOIN (
					SELECT		DISTINCT A.arrayId,A.sourceMAId, ISNULL (MIN( AC.MMHostId ),0) alternateMAId
					FROM		SMAltMAForArray A (NOLOCK) LEFT JOIN SMArrayController AC (NOLOCK) ON AC.ArrayNum = A.arrayId
								LEFT JOIN MMHost MMH (NOLOCK) ON MMH.ClientId = AC.MMHostId
					WHERE		( AC.MMHostId > A.alternateMAId )
								AND AC.Options & 262144/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_SNAP_PRUNING*/ > 0
								AND MMH.MmHostEnabled = 1 AND MMH.MmHostSoftState = 1 AND MMH.OfflineReason = 0
								AND MMH.ClientId IS NOT NULL
					GROUP BY	A.arrayId,A.sourceMAId
				) B ON B.arrayId = ALTMA.arrayId AND B.sourceMAId = ALTMA.sourceMAId
		IF @@ERROR <> 0
		BEGIN
SET		@errorCode = 60324/*E_MM_SM_SB_PROCESS_ALTERNATE_SNAP_MA_FAILED*/
			SET		@errorStr = 'Failed to update table SMAltMAForArray for the alternate Snap Media Agent (flag 1).'
			GOTO	CX_ERROR_EXIT
		END
		UPDATE	SMAltMAForMultiArray
		SET		alternateMAId = ISNULL(B.alternateMAId,0),
				alternateMAUpdatetime = @CurrentTime
		FROM	SMAltMAForMultiArray ALTMA (NOLOCK)
				LEFT JOIN (
					SELECT		DISTINCT A.arrayIdKey,A.sourceMAId, ISNULL (MIN( KEYMAP.MAId ),0) alternateMAId
					FROM		SMAltMAForMultiArray A (NOLOCK) LEFT JOIN @arrayIdKeyMAMapFinal KEYMAP ON KEYMAP.arrayidkey = A.arrayIdKey
								LEFT JOIN MMHost MMH (NOLOCK) ON MMH.ClientId = KEYMAP.MAId
					WHERE		( KEYMAP.MAId > A.alternateMAId )
								AND MMH.MmHostEnabled = 1 AND MMH.MmHostSoftState = 1 AND MMH.OfflineReason = 0
								AND MMH.ClientId IS NOT NULL
					GROUP BY	A.arrayIdKey,A.sourceMAId
				) B ON B.arrayIdKey = ALTMA.arrayIdKey AND B.sourceMAId = ALTMA.sourceMAId
IF @@ERROR <> 0
		BEGIN
SET		@errorCode = 60324/*E_MM_SM_SB_PROCESS_ALTERNATE_SNAP_MA_FAILED*/
			SET		@errorStr = 'Failed to update table SMAltMAForMultiArray for the alternate Snap Media Agent (flag 1).'
			GOTO	CX_ERROR_EXIT
		END
	END
	UPDATE	SMAltMAForArray
	SET		alternateMAId = ISNULL(B.alternateMAId,0),
			alternateMAUpdatetime = @CurrentTime
	FROM	SMAltMAForArray ALTMA (NOLOCK)
			LEFT JOIN (
				SELECT		DISTINCT A.arrayId,A.sourceMAId, ISNULL (MIN( AC.MMHostId ),0) alternateMAId
				FROM		SMAltMAForArray A (NOLOCK) INNER JOIN SMArrayController AC (NOLOCK) ON AC.ArrayNum = A.arrayId
							LEFT JOIN MMHost MMH (NOLOCK) ON MMH.ClientId = AC.MMHostId
				WHERE		( AC.MMHostId > A.alternateMAId )
							AND AC.Options & 262144/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_SNAP_PRUNING*/ > 0
							AND MMH.MmHostEnabled = 1 AND MMH.MmHostSoftState = 1 AND MMH.OfflineReason = 0
							AND MMH.ClientId IS NOT NULL
				GROUP BY	A.arrayId,A.sourceMAId
			) B ON B.arrayId = ALTMA.arrayId AND B.sourceMAId = ALTMA.sourceMAId
	WHERE ALTMA.alternateMAId = 0
	IF @@ERROR <> 0
	BEGIN
SET		@errorCode = 60324/*E_MM_SM_SB_PROCESS_ALTERNATE_SNAP_MA_FAILED*/
		SET		@errorStr = 'Failed to update table SMAltMAForArray for the alternate Snap Media Agent.'
		GOTO	CX_ERROR_EXIT
	END
	UPDATE	SMAltMAForMultiArray
	SET		alternateMAId = ISNULL(B.alternateMAId,0),
			alternateMAUpdatetime = @CurrentTime
	FROM	SMAltMAForMultiArray ALTMA (NOLOCK)
			LEFT JOIN (
					SELECT		DISTINCT A.arrayIdKey,A.sourceMAId, ISNULL (MIN( KEYMAP.MAId ),0) alternateMAId
					FROM		SMAltMAForMultiArray A (NOLOCK)
								INNER JOIN	@arrayIdKeyMAMapFinal KEYMAP ON KEYMAP.arrayidkey = A.arrayIdKey
								LEFT JOIN	MMHost MMH (NOLOCK) ON MMH.ClientId = KEYMAP.MAId
					WHERE		( KEYMAP.MAId > A.alternateMAId )
								AND MMH.MmHostEnabled = 1 AND MMH.MmHostSoftState = 1 AND MMH.OfflineReason = 0
								AND MMH.ClientId IS NOT NULL
					GROUP BY	A.arrayIdKey,A.sourceMAId
			 ) B ON B.arrayIdKey = ALTMA.arrayIdKey AND B.sourceMAId = ALTMA.sourceMAId
	WHERE ALTMA.alternateMAId = 0
	IF @@ERROR <> 0
	BEGIN
SET		@errorCode = 60324/*E_MM_SM_SB_PROCESS_ALTERNATE_SNAP_MA_FAILED*/
		SET		@errorStr = 'Failed to update table SMAltMAForMultiArray for the alternate Snap Media Agent.'
		GOTO	CX_ERROR_EXIT
	END
CX_ERROR_EXIT:
	SELECT @errorCode, @errorStr
	RETURN @errorCode

IF EXISTS (select * from GxQscripts where name = 'MM_SMProcessAlternateSnapMA')
	delete from GxQscripts where name = 'MM_SMProcessAlternateSnapMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMProcessAlternateSnapMA')
	delete from GXDBVersions where aliasname = 'MM_SMProcessAlternateSnapMA'
GO

insert into GXDBVersions values(2, 'MM_SMProcessAlternateSnapMA',  '00010006001200030000', 'MM_SMProcessAlternateSnapMA', '00010006001200030000')
GO

