

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMPopulateSnapInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMPopulateSnapInfo.sp,v $ $Id: MM_SMPopulateSnapInfo.sp,v 1.4.12.7 2019/10/24 15:52:07 kkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMPopulateSnapInfo')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMPopulateSnapInfo <<<'
	drop procedure MM_SMPopulateSnapInfo
END
IF EXISTS (select * from GxQscripts where name='MM_SMPopulateSnapInfo')
	delete from GxQscripts where name = 'MM_SMPopulateSnapInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMPopulateSnapInfo')
	delete from GXDBVersions where aliasname = 'MM_SMPopulateSnapInfo'
GO
print '... Creating Procedure: MM_SMPopulateSnapInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMPopulateSnapInfo
  @i_srcCopyId INTEGER,
  @i_auxCopyId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @RetCode			INTEGER = -1
DECLARE @ErrorCode			INTEGER
DECLARE @ErrorStr			VARCHAR(1024)
-- Temp input Table
-- #SnapArchFiles (archFileId int, commCellId int, JobId int, SnapShotEngineId int, copyId int,srcCopyId int PRIMARY KEY(JobId, CommCellId, archFileId, copyId) )
-- FAIL IF #SnapArchFile does not exist
IF  object_id('tempdb.dbo.#SnapArchFiles') IS NULL
BEGIN
	RETURN @RetCode
END
IF @i_srcCopyId = 0 OR @i_auxCopyId = 0
BEGIN
	RETURN @RetCode
END
IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL
	DROP TABLE #tblSMVolume
CREATE TABLE #tblSMVolume (
	OrigSMVolumeId integer,
	GUID uniqueIdentifier,
	NewSMVolumeId integer,
	copyId 		 integer
	)
IF OBJECT_ID('tempdb.dbo.#tblSMSnap') IS NOT NULL
	DROP TABLE #tblSMSnap
CREATE TABLE #tblSMSnap (
	OrigSMSnapId integer,
	GUID uniqueIdentifier,
	NewSMSnapId integer,
	copyId 		 integer
	)
IF OBJECT_ID('tempdb.dbo.#tblSMVolSnapMap') IS NOT NULL
	DROP TABLE #tblSMVolSnapMap
CREATE TABLE #tblSMVolSnapMap (
	OrigSMVolumeId integer,
	OrigSMSnapId integer,
	OrigVolSnapMapId integer,
	NewSMVolumeId integer ,
	NewSMSnapId integer,
	OrigMapMetaDataId integer,
	MapMetaDataGUID uniqueIdentifier,
	NewMapMetaDataId integer,
	copyId 		 integer
	)
DECLARE @currentTime INT
SET @currentTime = dbo.GetUnixTime(GetUTCDate())
--#tblSMVolume
INSERT INTO #tblSMVolume (OrigSMVolumeId,GUID,NewSMVolumeId,copyId)
SELECT A.SMVolumeId, NEWID(),0, B.copyId
FROM SMVolume (NOLOCK) A INNER JOIN #SnapArchFiles(NOLOCK) B
ON A.ArchFileId = B.archFileId AND A.CommCellId = B.CommCellId
WHERE A.CopyId = B.srcCopyId
--#tblSMSnap
INSERT INTO #tblSMSnap(OrigSMSnapId,GUID,NewSMSnapId,copyId)
SELECT B.SMSnapId,NEWID(),0, A.copyId
FROM #tblSMVolume A INNER JOIN SMVolSnapMap(NOLOCK) B  ON A.OrigSMVolumeId = B.SMVolumeId
--#tblSMVolSnapMap
INSERT INTO #tblSMVolSnapMap
SELECT A.OrigSMVolumeId,B.SMSnapId,B.SMVolSnapMapId,0,0, B.MetaDataId, NEWID(), 0, C.copyId
FROM #tblSMVolume A INNER JOIN SMVolSnapMap(NOLOCK) B ON A.OrigSMVolumeId = B.SMVolumeId
INNER JOIN #tblSMSnap C ON B.SMSnapId = C.OrigSMSnapId AND c.copyId = A.copyId
UPDATE	MAP
SET		MAP.MapMetaDataGUID = mdGuid
FROM	#tblSMVolSnapMap map INNER JOIN
		(	SELECT OrigMapMetaDataId, copyId, max(MapMetaDataGUID) mdGuid FROM	#tblSMVolSnapMap WHERE OrigMapMetaDataId > 0 GROUP BY OrigMapMetaDataId, copyId ) A ON MAP.OrigMapMetaDataId = A.OrigMapMetaDataId AND A.copyId = MAP.copyId
WHERE	MAP.OrigMapMetaDataId > 0
--SMVolume
INSERT INTO SMVOLUME (SourceclientId, MountHostId, CommCellId, JobId, ArchFileId,
		CopyId, AppId, AppTypeId, PruneFlags, VolumeFlags, VolumeStatus, VolumeStatusUpdateTime,
		MountStatus, MountStatusUpdateTime, LogicalUnmountTime, CreationTime, RetryCount,
		DevMode, UserId, GroupId, SnapSource, MountProxyId, RemoteOp, RemoteOpStatus, VmHostId,
		RecoveryPointId, OriginClientId, SourcePath, MountPath, SourceGUID, MountGUID,
		SourceDevice, MountDevice, MountOptions, ShadowSetId, ShadowCopyId, RepBasePath, RepRelativePath, OriginSourcePath, GUID,
		ReserveField1, ReserveField2, ReserveFieldStr)
SELECT B.SourceClientId,0, B.CommCellId, B.JobId, B.ArchFileId, A.copyId, B.AppId, B.AppTypeId,
1, B.VolumeFlags, B.VolumeStatus,0, 39, @currentTime, 0,
		@currentTime, 0, B.DevMode, B.userId, B.GroupId, B.SnapSource, 0,
		B.RemoteOp, B.RemoteOpStatus,  B.VmHostId, B.RecoveryPointId, B.OriginClientId, B.SourcePath, '', B.SourceGUID,
		'', B.SourceDevice, '', B.MountOptions, B.ShadowSetId,B.ShadowCopyId, B.RepBasePath, B.RepRelativePath,
		B.OriginSourcePath,A.GUID, B.ReserveField1, B.ReserveField2, B.ReserveFieldStr
FROM #tblSMVolume A INNER JOIN SMVolume B ON A.OrigSMVolumeId = B.SMVolumeId
SET @ErrorCode = @@ERROR
IF @ErrorCode <> 0
BEGIN
	GOTO CX_ERROR_EXIT
END
--UPDATE newSMVolumeId in tempTable
UPDATE A
SET A.NewSMVolumeId = B.SMVolumeId
FROM #tblSMVolume A INNER JOIN SMVolume B ON A.GUID = B.GUID
UPDATE B
SET B.NewSMVolumeId = A.NewSMVolumeId
FROM #tblSMVolume A INNER JOIN #tblSMVolSnapMap B ON A.OrigSMVolumeId = B.OrigSMVolumeId AND A.copyId = B.copyId
--SMSNAP
INSERT INTO SMSnap (SnapShotEngineId, OriginalSnapEngineId, ControlHostId, GroupId, SnapType, SnapFlags, PruneFlags,
		SnapStatus, SnapStatusUpdateTime, CreationTime, ReplicationStatus, DeviceEntryType,
		ConnectionType, SnapSourceDevice, SnapDevice, ShadowCopyId, UniqueIdentifier,
		SourceIdentifier, TargetIdentifier, OrigCCId, GUID,
		ReserveField1, ReserveField2, ReserveFieldStr,
		ArrayVolumeId, LunId, UsedSpaceBytes, ReserveField3, ReserveField4)
SELECT B.SnapShotEngineId, B.OriginalSnapEngineId, B.ControlHostId, B.GroupId, B.SnapType,
B.SnapFlags, 0, 5, 0, @currentTime, B.ReplicationStatus, B.DeviceEntryType, -- 5 CVSO::SNAPED
B.ConnectionType,   B.SnapSourceDevice, B.SnapDevice, B.ShadowCopyId, B.UniqueIdentifier, B.SourceIdentifier,
B.TargetIdentifier, B.OrigCCId, A.GUID, B.ReserveField1,B.ReserveField2, B.ReserveFieldStr,
B.ArrayVolumeId, B.LunId, B.UsedSpaceBytes, B.ReserveField3, B.ReserveField4
FROM #tblSMSnap A INNER JOIN SMSnap B ON A.OrigSMSnapId = B.SMSnapId
SET @ErrorCode = @@ERROR
IF @ErrorCode <> 0
BEGIN
	GOTO CX_ERROR_EXIT
END
UPDATE A
SET A.NewSMSnapId = B.SMSnapId
FROM #tblSMSnap A INNER JOIN SMSnap B ON A.GUID = B.GUID
UPDATE B
SET B.NewSMSnapId = A.NewSMSnapId
FROM #tblSMSnap A INNER JOIN #tblSMVolSnapMap B ON A.OrigSMSnapId = B.OrigSMSnapId AND A.copyId = B.copyId
-- Add LVM Metadata and update #tblSMVolSnapMap
INSERT INTO SMMetaData (MetaDataType, RefType, RefId, PruneFlags, Metadata, OrigCCId, GUID, ReserveField1, ReserveField2, ReserveFieldStr, Flags )
SELECT	DISTINCT MD.MetaDataType, MD.RefType, MD.RefId, MD.PruneFlags, MD.Metadata, MD.OrigCCId, MAP.MapMetaDataGUID, MD.ReserveField1, MD.ReserveField2, MD.ReserveFieldStr, MD.Flags
FROM	SMMetaData MD (NOLOCK)
		INNER JOIN #tblSMVolSnapMap MAP ON MD.MetaDataId = MAP.OrigMapMetaDataId
WHERE	MAP.OrigMapMetaDataId > 0
SET @ErrorCode = @@ERROR
IF @ErrorCode <> 0
BEGIN
	GOTO CX_ERROR_EXIT
END
UPDATE  A
SET		A.NewMapMetaDataId = MD.MetaDataId
FROM	#tblSMVolSnapMap A INNER JOIN SMMetaData MD (NOLOCK) ON A.MapMetaDataGUID = MD.GUID
WHERE	A.OrigMapMetaDataId > 0
SET @ErrorCode = @@ERROR
IF @ErrorCode <> 0
BEGIN
	GOTO CX_ERROR_EXIT
END
INSERT INTO SMVolSnapMap (SMVolumeId, SMSnapId, MetaDataId, GroupId, PruneFlags, OrigCCId, GUID, ReserveField1, ReserveField2, ReserveFieldStr)
SELECT A.NewSMVolumeId, A.NewSMSnapId, NewMapMetaDataId, B.GroupId,B.PruneFlags, B.OrigCCId , NEWID(),
B.ReserveField1, B.ReserveField2, B.ReserveFieldStr
FROM #tblSMVolSnapMap A INNER JOIN SMVolSnapMap B ON A.OrigVolSnapMapId = B.SMVolSnapMapId
SET @ErrorCode = @@ERROR
IF @ErrorCode <> 0
BEGIN
	GOTO CX_ERROR_EXIT
END
--Copy the Volume Metadata
INSERT INTO SMMetaData (MetaDataType, RefType, RefId, PruneFlags, Metadata, OrigCCId, GUID, ReserveField1, ReserveField2, ReserveFieldStr, Flags )
SELECT	DISTINCT MD.MetaDataType, MD.RefType, VOL.NewSMVolumeId, MD.PruneFlags, MD.Metadata, MD.OrigCCId, NEWID(), MD.ReserveField1, MD.ReserveField2, MD.ReserveFieldStr, MD.Flags
FROM	SMMetaData MD (NOLOCK)
		INNER JOIN #tblSMVolume VOL ON MD.RefId = VOL.OrigSMVolumeId
WHERE	MD.RefType = 1 /*SM_MRT_VOLUME*/
SET @ErrorCode = @@ERROR
IF @ErrorCode <> 0
BEGIN
	GOTO CX_ERROR_EXIT
END
--Copy the Snap Metadata
INSERT INTO SMMetaData (MetaDataType, RefType, RefId, PruneFlags, Metadata, OrigCCId, GUID, ReserveField1, ReserveField2, ReserveFieldStr, Flags )
SELECT  DISTINCT MD.MetaDataType, MD.RefType, SNAP.NewSMSnapId, MD.PruneFlags, MD.Metadata, MD.OrigCCId, NEWID(), MD.ReserveField1, MD.ReserveField2, MD.ReserveFieldStr, MD.Flags
FROM    SMMetaData MD (NOLOCK)
        INNER JOIN #tblSMSnap SNAP ON MD.RefId = SNAP.OrigSMSnapId
WHERE   MD.RefType = 2 /*SM_MRT_SNAP*/
SET @ErrorCode = @@ERROR
IF @ErrorCode <> 0
BEGIN
    GOTO CX_ERROR_EXIT
END
SET @RetCode = 0
IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL
	DROP TABLE #tblSMVolume
IF OBJECT_ID('tempdb.dbo.#tblSMSnap') IS NOT NULL
	DROP TABLE #tblSMSnap
IF OBJECT_ID('tempdb.dbo.#tblSMVolSnapMap') IS NOT NULL
	DROP TABLE #tblSMVolSnapMap
RETURN @RetCode
CX_ERROR_EXIT:
	-- transaction is taken care by calling SP
	IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL
		DROP TABLE #tblSMVolume
	IF OBJECT_ID('tempdb.dbo.#tblSMSnap') IS NOT NULL
		DROP TABLE #tblSMSnap
	IF OBJECT_ID('tempdb.dbo.#tblSMVolSnapMap') IS NOT NULL
		DROP TABLE #tblSMVolSnapMap
	RETURN @ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMPopulateSnapInfo')
	delete from GxQscripts where name = 'MM_SMPopulateSnapInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMPopulateSnapInfo')
	delete from GXDBVersions where aliasname = 'MM_SMPopulateSnapInfo'
GO

insert into GXDBVersions values(2, 'MM_SMPopulateSnapInfo',  '00010004001200070000', 'MM_SMPopulateSnapInfo', '00010004001200070000')
GO

