

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMNetAppOpenReplReport.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMNetAppOpenReplReport')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMNetAppOpenReplReport <<<'
	drop procedure MM_SMNetAppOpenReplReport
END
IF EXISTS (select * from GxQscripts where name='MM_SMNetAppOpenReplReport')
	delete from GxQscripts where name = 'MM_SMNetAppOpenReplReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMNetAppOpenReplReport')
	delete from GXDBVersions where aliasname = 'MM_SMNetAppOpenReplReport'
GO
print '... Creating Procedure: MM_SMNetAppOpenReplReport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMNetAppOpenReplReport
  @i_xmlTextInput XML
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_spName nvarchar(510);
  DECLARE @o_copyName nvarchar(510);
  DECLARE @o_copyType nvarchar(510);
  DECLARE @o_clientName nvarchar(510);
  DECLARE @o_subclientName nvarchar(510);
  DECLARE @o_relationshipId nvarchar(510);
  DECLARE @o_relationshipType nvarchar(510);
  DECLARE @o_sourcePath nvarchar(510);
  DECLARE @o_sourceArray nvarchar(510);
  DECLARE @o_targetPath nvarchar(510);
  DECLARE @o_targetArray nvarchar(510);
  DECLARE @o_snapCount INTEGER;
  DECLARE @o_subclientId INTEGER;
  DECLARE @o_copyId INTEGER;
  DECLARE @o_replicaGroupId INTEGER;
  DECLARE @o_storagePolicyId INTEGER;
  DECLARE @o_defaultSPCopy INTEGER;
  DECLARE @o_controlHostId INTEGER;
  DECLARE @o_replicaPairId INTEGER;
SET NOCOUNT ON
DECLARE @copyId INTEGER = 0;
DECLARE @subclientId INTEGER = 0;
select @copyId = ISNULL((SELECT ref.value('@copyId','int') FROM @i_xmlTextInput.nodes('TMMsg_Entity') R ( ref )), 0);
select @subclientId = ISNULL((SELECT ref.value('@subclientId','int') FROM @i_xmlTextInput.nodes('TMMsg_Entity') R ( ref )), 0);
IF OBJECT_ID('tempdb.dbo.#tblReplicaGroupMap') IS NOT NULL
	DROP TABLE #tblReplicaGroupMap
CREATE TABLE #tblReplicaGroupMap
(
	archGroupCopyId		int,
	appId				int,
	clientName			nvarchar(510),
	subclientName		nvarchar(256),
	replicaGroupId		int,
	replicaGroupName	nvarchar(2048),
	replicaGroupFlags	int,
	srcEntityName		nvarchar(2048),
	srcArray			int,
	srcArrayName		nvarchar(2048),
	tgtEntiyName		nvarchar(2048),
	tgtArray			int,
	tgtArrayName		nvarchar(2048),
	SnapCount			int,
	relationshipType	nvarchar(128),
	copyType			nvarchar(128),
	SPName				nvarchar(256),
	SPCopyName			nvarchar(128),
	SPId				int,
	defaultCopyForSp	int,
	smcontrolhostid		int,
	replicaPairId       int
)
CREATE INDEX tblReplicaGroupMap_ReplicaGroupId_Idx ON #tblReplicaGroupMap (replicaGroupId)
CREATE INDEX tblReplicaGroupMap_AppId_Idx ON #tblReplicaGroupMap (appId)
CREATE INDEX tblReplicaGroupMap_CopyId_Idx ON #tblReplicaGroupMap (archGroupCopyId)
INSERT INTO #tblReplicaGroupMap
SELECT	DISTINCT MAP.CopyId, MAP.AppId, 'N/A', 'N/A', G.ReplicaGroupId, G.GroupId, G.Flags, SRC.EntityName, SRC.ArrayNum, '', Tgt.EntityName, Tgt.ArrayNum, '', 0, 'N/A', 'N/A', 'N/A', 'N/A', 0, 0, TGT_CTRL.ControlHostId, 0
FROM	SMReplicaGroupMap MAP (READUNCOMMITTED)
		INNER JOIN SMReplicaGroup G (READUNCOMMITTED) ON MAP.ReplicaGroupId = G.ReplicaGroupId
		INNER JOIN SMReplicaEntities SRC (READUNCOMMITTED) ON G.SrcEntityId = SRC.ReplicaEntityId
		INNER JOIN SMReplicaEntities TGT (READUNCOMMITTED) ON G.TgtEntityId = TGT.ReplicaEntityId
		INNER JOIN SMControlHost SRC_CTRL (READUNCOMMITTED) ON SRC.ArrayNum = SRC_CTRL.ControlHostId
		INNER JOIN SMControlHost TGT_CTRL (READUNCOMMITTED) ON TGT.ArrayNum = TGT_CTRL.ControlHostId
WHERE	SRC_CTRL.SnapVendorName = 'NetApp'
AND TGT_CTRL.SnapVendorName = 'NetApp' AND (MAP.appId = @subclientId or @subclientId = 0) AND (MAP.copyId = @copyId or @copyId = 0)
UPDATE	A
SET		A.subclientName =  APP.subclientName,
		A.clientName = CLNT.name
FROM	#tblReplicaGroupMap A INNER JOIN APP_Application APP (READUNCOMMITTED) ON APP.id = A.appId
		INNER JOIN APP_Client CLNT (READUNCOMMITTED) ON APP.clientId = CLNT.id
UPDATE	A
SET		A.tgtArrayName = (CASE WHEN LEN(ISNULL(CFG_TGT.ValueStr,'')) > 0 THEN CFG_TGT.ValueStr ELSE TGT_ARRAY.SMArrayId END),
		A.srcArrayName = (CASE WHEN LEN(ISNULL(CFG_SRC.ValueStr,'')) > 0 THEN CFG_SRC.ValueStr ELSE SRC_ARRAY.SMArrayId END)
FROM	#tblReplicaGroupMap A INNER JOIN SMControlHost SRC_ARRAY (READUNCOMMITTED) ON A.srcArray = SRC_ARRAY.ControlHostId
		INNER JOIN SMControlHost TGT_ARRAY (READUNCOMMITTED) ON A.tgtArray = TGT_ARRAY.ControlHostId
LEFT JOIN SMConfigs CFG_SRC (READUNCOMMITTED) ON SRC_ARRAY.ControlHostId = CFG_SRC.ArrayId AND CFG_SRC.AssocType = 3 AND CFG_SRC.MasterConfigId = 200
LEFT JOIN SMConfigs CFG_TGT (READUNCOMMITTED) ON TGT_ARRAY.ControlHostId = CFG_TGT.ArrayId AND CFG_TGT.AssocType = 3 AND CFG_TGT.MasterConfigId = 200
UPDATE	A
SET		A.SnapCount = B.SnapCount
FROM	#tblReplicaGroupMap A INNER JOIN (
			SELECT	ReplicaGroupId, COUNT(DISTINCT SMSnapId) SnapCount
			FROM	SMSnapToReplicaGroupMap (READUNCOMMITTED)
			GROUP BY	ReplicaGroupId
		) B ON A.replicaGroupId = B.ReplicaGroupId
UPDATE A
SET 		A.replicaPairId = SAP.ReplicaPairId
FROM 	#tblReplicaGroupMap A
 INNER JOIN SMArrayReplicaPairs SAP (READUNCOMMITTED) ON SAP.TgtArrayNum = A.tgtArray and SAP.SrcArrayNum = SAP.SrcArrayNum and SAP.ArchGroupCopyId = A.archGroupCopyId
-- Update the relationship tpye
UPDATE	MAP
SET		relationshipType = CASE WHEN (MAP.replicaGroupFlags & 2 = 2
AND MAP.replicaGroupFlags & 4 = 4) THEN 'MirrorVault(Deleted)'
WHEN (MAP.replicaGroupFlags & 2 = 2
AND MAP.replicaGroupFlags & 8 = 8) THEN 'Vault(Deleted)'
WHEN (MAP.replicaGroupFlags & 2 = 2
AND MAP.replicaGroupFlags & 16 = 16) THEN 'Mirror(Deleted)'
WHEN (MAP.replicaGroupFlags & 2 = 2
AND MAP.replicaGroupFlags & 32 = 32) THEN 'Version Flexible Mirror(Deleted)'
WHEN  MAP.replicaGroupFlags & 4 = 4 THEN 'MirrorVault'
WHEN  MAP.replicaGroupFlags & 8 = 8 THEN 'Vault'
WHEN  MAP.replicaGroupFlags & 16 = 16 THEN 'Mirror'
WHEN  MAP.replicaGroupFlags & 32 = 32 THEN 'Version Flexible Mirror' ELSE 'N/A' END
FROM	#tblReplicaGroupMap MAP
UPDATE	MAP
SET		relationshipType = 'SVM-DR ' + relationshipType
FROM	#tblReplicaGroupMap MAP
WHERE	MAP.replicaGroupFlags & 64 = 64
-- Update the SPName, SPCopyName, SPCopyType
UPDATE	MAP
SET		SPName = AG.name,
		SPCopyName = AGC.name,
		SPId = AG.id,
		defaultCopyForSp = AG.defaultCopy,
copyType = CASE WHEN (AGC.extendedFlags & 524288 > 0) AND AGC.isMirrorCopy = 1 THEN 'Default Mirror'
			WHEN AGC.isMirrorCopy = 1 THEN 'Mirror'
WHEN AGC.type = 2 AND (AGC.extendedFlags & 524288 > 0) AND AGC.isMirrorCopy = 0 THEN 'Default Selective Vault/Replica'
WHEN (AGC.extendedFlags &  524288 > 0)  AND AGC.isMirrorCopy = 0 THEN 'Default Vault/Replica'
WHEN AGC.type = 2 AND AGC.isMirrorCopy = 0 THEN 'Selective Vault/Replica'
			WHEN AGC.isMirrorCopy = 0 THEN 'Vault/Replica'
			END
FROM	#tblReplicaGroupMap MAP
		INNER JOIN archGroupCopy AGC (READUNCOMMITTED) ON MAP.archGroupCopyId = AGC.id
		INNER JOIN archGroup AG (READUNCOMMITTED) ON AGC.archGroupId = AG.id
SELECT	SPName AS StoragePolicy,
		SPCopyName AS Copy,
		copyType AS CopyType,
		MAP.clientName AS Client,
		MAP.subclientName AS SubClient, replicaGroupName AS RelationshipId,
		relationshipType AS RelationshipType,
		srcEntityName AS SourcePath,
		srcArrayName AS SourceArray,
		tgtEntiyName AS TargetPath,
		tgtArrayName AS TargetArray,
		SnapCount,
		appId AS subclientId,
		archGroupCopyId AS copyId,
		replicaGroupId,
		MAP.SPId as storagePolicyId,
		MAP.defaultCopyForSp AS defaultSPCopy,
		MAP.smcontrolhostid AS controlHostId,
		MAP.replicaPairId AS replicaPairId
FROM	#tblReplicaGroupMap MAP
IF OBJECT_ID('tempdb.dbo.#tblReplicaGroupMap') IS NOT NULL
DROP TABLE #tblReplicaGroupMap
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMNetAppOpenReplReport')
	delete from GxQscripts where name = 'MM_SMNetAppOpenReplReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMNetAppOpenReplReport')
	delete from GXDBVersions where aliasname = 'MM_SMNetAppOpenReplReport'
GO

insert into GXDBVersions values(2, 'MM_SMNetAppOpenReplReport',  '00000000000000000000', 'MM_SMNetAppOpenReplReport', '00000000000000000000')
GO

