

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMManagedSnapCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMManagedSnapCheck.sp,v $ $Id: MM_SMManagedSnapCheck.sp,v 1.3.86.1 2018/03/20 00:12:09 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMManagedSnapCheck <<<'

IF EXISTS (select * from sysobjects where name='MM_SMManagedSnapCheck')
	drop procedure MM_SMManagedSnapCheck
IF EXISTS (select * from GxQscripts where name='MM_SMManagedSnapCheck')
	delete from GxQscripts where name = 'MM_SMManagedSnapCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMManagedSnapCheck')
	delete from GXDBVersions where aliasname = 'MM_SMManagedSnapCheck'
GO
print '... Creating Procedure: MM_SMManagedSnapCheck'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMManagedSnapCheck
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_SnapCount INTEGER
  DECLARE @o_SnapLimit INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
  DECLARE @o_ReserveParam1 INTEGER
  DECLARE @o_ReserveParam2 INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	-----------------------------------------------------------------------------
	-- Process Input XML
	-----------------------------------------------------------------------------
	-- XML Structure for MM_SMManagedSnapCheck
	/*
		<MM_SMManagedSnapCheck>
			<JobId></JobId>
			<CommcellId></CommcellId>
			<AppId></AppId>
			<CopyId></CopyId>
			<Flags></Flags>
		</MM_SMManagedSnapCheck>
	*/
	DECLARE @x_JobId			INTEGER
	DECLARE @x_CommcellId		INTEGER
	DECLARE @x_AppId			INTEGER
	DECLARE @x_CopyId			INTEGER
	DECLARE @x_Flags			INTEGER
	SET @x_JobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMManagedSnapCheck/JobId') R(ref)), 0)
	SET @x_CommcellId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMManagedSnapCheck/CommcellId') R(ref)), 0)
	SET @x_AppId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMManagedSnapCheck/AppId') R(ref)), 0)
	SET @x_CopyId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMManagedSnapCheck/CopyId') R(ref)), 0)
	SET @x_Flags = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMManagedSnapCheck/Flags') R(ref)), 0)
	DECLARE @tblSnap TABLE (
		SMSnapId				integer,
		ControlHostId			integer,
		SnapVolumeName			nvarchar(255)
	)
	INSERT	INTO @tblSnap
	SELECT	SNAP.SMSnapId, SNAP.ControlHostId, SNAP.ReserveFieldStr
	FROM	SMVolume VOL WITH (NOLOCK), SMSnap SNAP WITH (NOLOCK), SMVolSnapMap MAP WITH (NOLOCK)
	WHERE	VOL.AppId = @x_AppId
			AND VOL.CommCellId = @x_CommcellId
			AND VOL.CopyId = @x_CopyId
			AND MAP.SMVolumeId = VOL.SMVolumeId
			AND SNAP.SMSnapId = MAP.SMSnapId
	SELECT	@o_SnapCount = COUNT(SNAP.SMSnapId), @o_SnapCount = ARRAY.SourceId
	FROM	SMControlHost ARRAY WITH (NOLOCK), @tblSnap SNAP
	WHERE	ARRAY.ControlHostId = SNAP.ControlHostId
	GROUP BY SNAP.ControlHostId, SNAP.SnapVolumeName, ARRAY.SourceId
CX_EXIT:
	SELECT @o_SnapCount, @o_SnapCount, @o_ErrorCode, @o_ErrorStr, 0, 0
	RETURN
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMManagedSnapCheck')
	delete from GxQscripts where name = 'MM_SMManagedSnapCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMManagedSnapCheck')
	delete from GXDBVersions where aliasname = 'MM_SMManagedSnapCheck'
GO

insert into GXDBVersions values(2, 'MM_SMManagedSnapCheck',  '00010003008600010000', 'MM_SMManagedSnapCheck', '00010003008600010000')
GO

