

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetVolumesToDelete.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetVolumesToDelete.sp,v $ $Id: MM_SMGetVolumesToDelete.sp,v 1.21.12.4 2018/03/20 00:08:07 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetVolumesToDelete <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetVolumesToDelete')
	drop procedure MM_SMGetVolumesToDelete
IF EXISTS (select * from GxQscripts where name='MM_SMGetVolumesToDelete')
	delete from GxQscripts where name = 'MM_SMGetVolumesToDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetVolumesToDelete')
	delete from GXDBVersions where aliasname = 'MM_SMGetVolumesToDelete'
GO
print '... Creating Procedure: MM_SMGetVolumesToDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetVolumesToDelete
  @i_xmlText XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_SMVolSnapMapId integer
  DECLARE @o_SMVolumeId integer
  DECLARE @o_SMSnapId integer
  DECLARE @o_SMMetaDataId integer
  DECLARE @o_IsSnapLinked integer
  DECLARE @o_MMErrorCode integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE	@tblSMVolumeMountStatus TABLE (
			MountStatus integer
		)
INSERT INTO @tblSMVolumeMountStatus SELECT 0
INSERT INTO @tblSMVolumeMountStatus SELECT 10
INSERT INTO @tblSMVolumeMountStatus SELECT 11
INSERT INTO @tblSMVolumeMountStatus SELECT 12
INSERT INTO @tblSMVolumeMountStatus SELECT 18
INSERT INTO @tblSMVolumeMountStatus SELECT 19
INSERT INTO @tblSMVolumeMountStatus SELECT 20
INSERT INTO @tblSMVolumeMountStatus SELECT 28
INSERT INTO @tblSMVolumeMountStatus SELECT 29
INSERT INTO @tblSMVolumeMountStatus SELECT 30
INSERT INTO @tblSMVolumeMountStatus SELECT 38
INSERT INTO @tblSMVolumeMountStatus SELECT 39
INSERT INTO @tblSMVolumeMountStatus SELECT 79
INSERT INTO @tblSMVolumeMountStatus SELECT 89
INSERT INTO @tblSMVolumeMountStatus SELECT 90
INSERT INTO @tblSMVolumeMountStatus SELECT 98
INSERT INTO @tblSMVolumeMountStatus SELECT 99
	DECLARE @tblSMVolumePruneFlags TABLE (
		PruneFlags integer
		)
INSERT INTO @tblSMVolumePruneFlags SELECT 0
INSERT INTO @tblSMVolumePruneFlags SELECT 1
INSERT INTO @tblSMVolumePruneFlags SELECT 2
INSERT INTO @tblSMVolumePruneFlags SELECT 6
INSERT INTO @tblSMVolumePruneFlags SELECT 7
	DECLARE @t_SMVolumeId INTEGER
	DECLARE	@tblValidateResult TABLE (
			ErrorCode integer,
			ErrorStr varchar(1024),
			MountHostId integer,
			MountStatus integer,
			PruneFlags integer,
MountPath nvarchar(1024),
			IsReserved integer,
			OpCompleted integer,
			UnmountMode integer
		)
	DECLARE	@tblVolToDel TABLE (
			SMVolumeId integer
		)
	DECLARE	@tblMapAged TABLE (
			SMVolSnapMapId integer,
			SMVolumeId integer,
			SMSnapId integer,
			MetaDataId integer,
			IsSnapLinked		integer,
			SnapShotEngineId	integer,
			ControlHostId		integer
		)
	DECLARE @i_hostId INT = 0
	SET @i_hostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMGetVolumesToDelete/HostId') R(ref)), 0)
	-- Check whether any snap volumes exist for this host
	IF NOT EXISTS (SELECT SMVolumeId FROM SMVOLUME (NOLOCK) WHERE SourceClientId = @i_hostId)
	BEGIN
		GOTO CX_EXIT
	END
	DECLARE @RetryParam integer = 0
	SET @RetryParam = ISNULL((select Value from MMConfigs (NOLOCK) where name = 'MMS2_CONFIG_VOLSNAP_RETRY_COUNT'), 50)
	DECLARE @i_useTran INT = 0
	SET @i_useTran = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMGetVolumesToDelete/useTransaction') R(ref)), 0)
	----------------------------------
	-- Prune Snap History Tables
	----------------------------------
	DECLARE @retVal integer
	DECLARE @tblRtn TABLE (retVal integer)
	INSERT INTO @tblRtn
	EXEC @retVal = MM_SMSnapHistoryCleanup ''
	IF @retVal <> 0 GOTO CX_ERROR_EXIT
	IF (@i_useTran = 1)
		BEGIN TRANSACTION GetVolumesToDelTran
	-----------------------------------
    -- Prune snap records
    -----------------------------------
	DECLARE @minHostid INT = 0
	SELECT	@minHostid = MIN(MA.ClientId)
	FROM	MMHost MA (NOLOCK) INNER JOIN SMVolume VOL (NOLOCK) ON MA.ClientId = VOL.SourceCLientId
	WHERE	MA.MmHostEnabled = 1 AND MA.MmHostSoftState = 1 AND MA.OfflineReason = 0
	IF @minHostid = @i_hostId
	BEGIN
		DELETE FROM @tblRtn
		INSERT INTO @tblRtn
		EXEC @retVal = MM_SMDBPruneVolSnaps 0, 0
		IF @retVal <> 0 GOTO CX_ERROR_EXIT
	END
START_GET_VOLUME_TO_DELETE:
	-----------------------------------
	-- Get volume and do validation
	-----------------------------------
--	DECLARE VolToDelCur CURSOR FOR
	INSERT INTO @tblVolToDel
		SELECT SMVolumeId
		FROM SMVolume WITH (NOLOCK)
		WHERE PruneFlags NOT IN (SELECT PruneFlags FROM @tblSMVolumePruneFlags)
		AND MountStatus IN (SELECT MountStatus FROM @tblSMVolumeMountStatus)
		AND SMVolumeId NOT IN (SELECT SMVolumeId FROM SMSnapResource (NOLOCK))
		AND SMVolumeId NOT IN (SELECT SMVolumeId FROM SMVolAction (NOLOCK))
AND SMVolumeId NOT IN (SELECT SMVolumeId FROM SMMountVolume (NOLOCK) WHERE MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/ )
AND MountStatus <> 99
		AND (@i_HostId > 0 AND SourceClientId = @i_HostId OR @i_HostId = 0)
		AND RetryCount < @RetryParam
AND SnapSource = 0
		AND CopyId NOT IN (SELECT ID FROM archGroupCopy WHERE isSnapCopy = 1 AND isMirrorCopy = 1)
	/*
	OPEN VolToDelCur
	FETCH VolToDelCur INTO @t_SMVolumeId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE FROM @tblValidateResult
		INSERT INTO @tblValidateResult
		EXEC MM_SMValidationForDelete @t_SMVolumeId, 0, @i_HostId
		IF EXISTS (SELECT * FROM @tblValidateResult WHERE ErrorCode > 0)
			GOTO FETCH_NEXT
		INSERT INTO @tblVolToDel SELECT @t_SMVolumeId
		FETCH_NEXT:
			FETCH VolToDelCur INTO @t_SMVolumeId
	END
	CLOSE VolToDelCur
	DEALLOCATE VolToDelCur
	*/
	IF NOT EXISTS (SELECT * FROM @tblVolToDel)
	BEGIN
		GOTO CX_EXIT
	END
	------------------------------------------------------------
	------------------------------------------------------------
	INSERT INTO @tblMapAged
	SELECT	map.SMVolSnapMapId, map.SMVolumeId, map.SMSnapId, 0, 0, snap.SnapShotEngineId, snap.ControlHostId
	FROM	SMVolSnapMap map WITH (NOLOCK), SMSnap snap WITH (NOLOCK)
	WHERE	map.SMVolumeId IN (SELECT SMVolumeId FROM @tblVolToDel)
	AND		snap.SMSnapId = map.SMSnapId
	AND		snap.SnapShotEngineId > 0
	AND		snap.ControlHostId > 0
	ORDER BY snap.SnapShotEngineId, snap.ControlHostId
	-- For Native Snap Engines, where ControlHostId is zero
	INSERT	INTO @tblMapAged
	SELECT	map.SMVolSnapMapId, map.SMVolumeId, map.SMSnapId, 0, 0, snap.SnapShotEngineId, snap.ControlHostId
	FROM	SMVolSnapMap map WITH (NOLOCK), SMSnap snap WITH (NOLOCK)
	WHERE	map.SMVolumeId IN (SELECT SMVolumeId FROM @tblVolToDel)
	AND		snap.SMSnapId = map.SMSnapId
AND		snap.SnapShotEngineId IN (1, 53, 48)
	ORDER BY snap.SnapShotEngineId
	------------------------------------------------------------------
	-- Snap linked to active volumes
	------------------------------------------------------------------
	UPDATE @tblMapAged SET IsSnapLinked = 1
	FROM SMVolSnapMap A WITH (NOLOCK), @tblMapAged B, SMVolume C WITH (NOLOCK)
	WHERE A.SMSnapId = B.SMSnapId
	AND A.SMVolumeId = C.SMVolumeId
AND C.MountStatus <> 99
	AND A.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblVolToDel)
	------------------------------------------------------------------
	-- Get all metadata for volumes
	------------------------------------------------------------------
	INSERT	INTO @tblMapAged
	SELECT	0, RefId, 0, MetaDataId, 0, 0, 0
	FROM	SMMetaData WITH (READUNCOMMITTED)
WHERE	RefType = 1
	AND		RefId in (SELECT DISTINCT SMVolumeId FROM @tblMapAged)
	------------------------------------------------------------------
	-- Get all metadata for snaps
	------------------------------------------------------------------
	INSERT	INTO @tblMapAged
	SELECT	0, 0, RefId, MetaDataId, 0, 0, 0
	FROM	SMMetaData WITH (READUNCOMMITTED)
WHERE	RefType = 2
	AND		RefId in (SELECT DISTINCT SMSnapId FROM @tblMapAged)
CX_EXIT:
	IF (@i_useTran = 1)
		COMMIT TRANSACTION GetVolumesToDelTran
	SELECT SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, IsSnapLinked, @retVal
	FROM @tblMapAged
	RETURN
CX_ERROR_EXIT:
	IF (@i_useTran = 1)
		ROLLBACK TRANSACTION GetVolumesToDelTran
	SELECT 0, 0, 0, 0, 0, @retVal
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetVolumesToDelete')
	delete from GxQscripts where name = 'MM_SMGetVolumesToDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetVolumesToDelete')
	delete from GXDBVersions where aliasname = 'MM_SMGetVolumesToDelete'
GO

insert into GXDBVersions values(2, 'MM_SMGetVolumesToDelete',  '00010021001200040000', 'MM_SMGetVolumesToDelete', '00010021001200040000')
GO

