

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetVolumesOfSnapClone.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMGetVolumesOfSnapClone')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetVolumesOfSnapClone <<<'
	drop procedure MM_SMGetVolumesOfSnapClone
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetVolumesOfSnapClone')
	delete from GxQscripts where name = 'MM_SMGetVolumesOfSnapClone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetVolumesOfSnapClone')
	delete from GXDBVersions where aliasname = 'MM_SMGetVolumesOfSnapClone'
GO
print '... Creating Procedure: MM_SMGetVolumesOfSnapClone'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetVolumesOfSnapClone
  @xmlTextInput XML
AS
--This will turn off message: "xxx rows affected".
    SET NOCOUNT ON
	DECLARE		@o_outXML			XML
	DECLARE		@i_controlHostId	INT = 0
	DECLARE		@i_clientId			INT = 0
	DECLARE		@i_appTypeId		INT = 0
	DECLARE		@i_backupSetId		INT = 0
	DECLARE		@i_instanceId		INT = 0
	DECLARE		@i_subClientId		INT = 0
	DECLARE		@i_copyId			INT = 0
	DECLARE		@i_cloneJobId		INT = 0
	DECLARE		@i_flags			INT = 0
	DECLARE		@i_commCellId		INT = 0
	DECLARE		@i_userId   		INT = 0
	DECLARE		@i_sourceDatabaseName NVARCHAR(2048) = N''
	DECLARE     @VIRENGINE INTEGER = 32768 -- 32768
    declare		@i_errorCode		INT = 0
	declare		@s_errorString		NVARCHAR(1024) = N''
	SET @i_commCellId = ISNULL(( SELECT ref.value('@commCellId', 'int')
							FROM @xmlTextInput.nodes('Api_GetVolumesOfSnapCloneRequest') R ( ref ) ),
						0)
	SET @i_controlHostId = ISNULL(( SELECT ref.value('@arrayId', 'int')
							FROM @xmlTextInput.nodes('Api_GetVolumesOfSnapCloneRequest/storageArray') R ( ref ) ),
						0)
	SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
							FROM @xmlTextInput.nodes('Api_GetVolumesOfSnapCloneRequest/subclient') R ( ref ) ),
						0)
	SET @i_appTypeId = ISNULL(( SELECT ref.value('@applicationId', 'int')
							FROM @xmlTextInput.nodes('Api_GetVolumesOfSnapCloneRequest/subclient') R ( ref ) ),
						0)
	SET @i_backupSetId = ISNULL(( SELECT ref.value('@backupsetId', 'int')
							FROM @xmlTextInput.nodes('Api_GetVolumesOfSnapCloneRequest/subclient') R ( ref ) ),
						0)
	SET @i_instanceId = ISNULL(( SELECT ref.value('@instanceId', 'int')
							FROM @xmlTextInput.nodes('Api_GetVolumesOfSnapCloneRequest/subclient') R ( ref ) ),
						0)
	SET @i_subClientId = ISNULL(( SELECT ref.value('@subclientId', 'int')
							FROM @xmlTextInput.nodes('Api_GetVolumesOfSnapCloneRequest/subclient') R ( ref ) ),
						0)
    SET @i_copyId = ISNULL(( SELECT ref.value('@copyId', 'int')
							FROM @xmlTextInput.nodes('Api_GetVolumesOfSnapCloneRequest/copyName') R ( ref ) ),
						0)
    SET @i_userId = ISNULL(( SELECT ref.value('@userId', 'int')
                            FROM @xmlTextInput.nodes('Api_GetVolumesOfSnapCloneRequest/userId') R ( ref ) ),
                        0)
    SET @i_sourceDatabaseName = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@sourceDatabaseName', 'nvarchar(1024)'))
                            FROM @xmlTextInput.nodes('Api_GetVolumesOfSnapCloneRequest') R ( ref ) ),
                        N'')
	SET @i_cloneJobId = ISNULL(( SELECT ref.value('@cloneJobId', 'int')
							FROM @xmlTextInput.nodes('Api_GetVolumesOfSnapCloneRequest') R ( ref ) ),
						0)
	SET @i_flags = ISNULL(( SELECT ref.value('@flags', 'int')
							FROM @xmlTextInput.nodes('Api_GetVolumesOfSnapCloneRequest') R ( ref ) ),
						0)
	DECLARE @nowTime  INT
	SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
	IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL
		DROP TABLE #tblSMVolume
	CREATE TABLE #tblSMVolume
	(
		SMVolumeId int,
		AppId int,
		CopyId int,
		ControlHostId int
	)
	IF OBJECT_ID('tempdb.dbo.#tblCloneDetails') IS NOT NULL
		DROP TABLE #tblCloneDetails
	CREATE TABLE #tblCloneDetails
	(
		MountVolumeId int,
		SMVolumeId int,
		mountJobId int,
		mountPath nvarchar(2048),
		mountDevice nvarchar(2048),
		arrayId	 int,
		arrayName nvarchar(2048),
		snapShotEngineId int,
		snapShotEngineName nvarchar(256)
	)
	IF OBJECT_ID('tempdb.dbo.#tblCloneVolume') IS NOT NULL
		DROP TABLE #tblCloneVolume
	CREATE TABLE #tblCloneVolume
	(
		cloneJobId int,
		sourceInstanceId int,
		sourceClientId int,
		targetClientId int,
		srcDatabaseName nvarchar(1024),
		tgtDatabaseName nvarchar(1024),
		copyId int,
		storagePolicyId int,
		appTypeId int,
		commCellId int,
		snapJobId int,
		snapJobTimeStamp int,
		creationTimeStamp int,
		expiryTimeStamp int,
		cloneStatusId int,
		cloneStatusName nvarchar(1024),
		tgtInstanceName	nvarchar(1024)
	)
	SET @i_appTypeId = ISNULL((SELECT TOP 1 appTypeId FROM APP_Application (NOLOCK) WHERE instance = @i_instanceId), 0)
	IF @i_instanceId > 0
	BEGIN
		--
		-- Get SMVolumeIds for this Instance
		--
		INSERT INTO #tblSMVolume
		SELECT	DISTINCT VOL.SMVolumeId, VOL.AppId, VOL.CopyId, SNAP.ControlHostId
			FROM	SMMountVolume MVOL (NOLOCK)
					INNER JOIN SMVolume VOL (NOLOCK) ON MVOL.SMVolumeId = VOL.SMVolumeId
					INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = VOL.SMVolumeId
					INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
					INNER JOIN APP_Application APP (NOLOCK) ON VOL.AppId = APP.id
			WHERE	APP.instance = @i_instanceId
					AND APP.appTypeId = @i_appTypeId
AND VOL.pruneFlags = 1 /*MM_SM_PRUNEFLAGS_ACTIVE*/
	END
	--
	-- Security - remove those where the subclients are not visible for this user.
	--
	IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
        DROP TABLE #tblSecCheck
	CREATE TABLE #tblSecCheck (
		EntityType int,
		EntityId int,
		EntityVisible int
	)
	INSERT INTO #tblSecCheck
SELECT DISTINCT 1, CopyId, 0  FROM #tblSMVolume
	INSERT INTO #tblSecCheck
SELECT DISTINCT 2, ControlHostId, 0  FROM #tblSMVolume
	INSERT INTO #tblSecCheck
SELECT DISTINCT 3, AppId, 0  FROM #tblSMVolume
	EXEC sec_isSnapshotVisible @i_userId
	DELETE	A
	FROM	#tblSMVolume A
INNER JOIN #tblSecCheck B_Copy ON A.CopyId = B_Copy.EntityId AND B_Copy.EntityType = 1
INNER JOIN #tblSecCheck B_CHost ON A.ControlHostId = B_CHost.EntityId AND B_CHost.EntityType = 2
INNER JOIN #tblSecCheck B_App ON A.AppId = B_App.EntityId AND B_App.EntityType = 3
	WHERE	B_Copy.EntityVisible <=0
			AND B_CHost.EntityVisible <=0
			AND B_App.EntityVisible <=0
	IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
		DROP TABLE #tblSecCheck
	IF NOT EXISTS (SELECT * FROM #tblSMVolume)
	BEGIN
		GOTO proc_exit
	END
	--Lookup in the metadata for the database
IF @i_appTypeId = 81 /*CV_APPTYPE_MSSQL*/
	BEGIN
	--Get Volumes For Clones
		INSERT	INTO #tblCloneVolume
		SELECT	DISTINCT B.MountJobId, max(APP.instance),MAX(VOL.SourceClientId),MAX(B.MountHostId),  Y.sourceDB,Y.cloneDB,MAX(VOL.CopyId), MAX(AGC.archGroupId), MAX(VOL.AppTypeId),
				MAX(VOL.CommCellId), MAX(VOL.JobId), MAX(VOL.CreationTime), MAX(B.CreationTime), MAX(B.ExpireTime), MAX(B.MountStatus), '', Y.tgtInstanceName
		FROM	#tblSMVolume A INNER JOIN SMMountVolume B WITH (NOLOCK) ON A.SMVolumeId = B.SMVolumeId
				INNER JOIN SMVolume VOL (NOLOCK) ON A.SMVolumeId = VOL.SMVolumeId
				INNER JOIN APP_Application APP (NOLOCK) ON VOL.AppId = APP.id
				INNER JOIN APP_InstanceName INST (NOLOCK) ON INST.id = APP.instance
				INNER JOIN archGroupCopy AGC (NOLOCK) ON AGC.id = VOL.CopyId
				inner join (
					SELECT	DISTINCT SQLiDA.databaseList.value('./@databaseName','nvarchar(max)') cloneDB,
							SQLiDA.databaseList.value('./@sourceDatabaseName','nvarchar(max)') sourceDB, Z.CloneJobId,
							SQLiDA.databaseList.value('(/SQLiDA_AttachDBMsg/@instanceName)[1]','nvarchar(max)') tgtInstanceName
					FROM	(
								SELECT	MVOL.MountJobId AS CloneJobId, CONVERT(xml,REPLACE(MD.Metadata, 'UTF-8', 'UTF-16')) as cloneMetaData
								FROM	#tblSMVolume X INNER JOIN SMMountVolume MVOL  (NOLOCK) ON X.SMVolumeId = MVOL.SMVolumeId
										INNER JOIN SMMetaData MD (NOLOCK) ON MVOL.Id=MD.RefId
WHERE	MD.MetaDataType= 38 /*SM_MDT_TEST_ENV_APP_INFO*/
AND MD.RefType= 10 /*SM_MRT_MOUNT_VOLUME*/
							) Z
					CROSS APPLY	Z.cloneMetaData.nodes('/SQLiDA_AttachDBMsg/databaseList') SQLiDA(databaseList)
				) Y ON Y.CloneJobId = B.MountJobId
		WHERE	(@i_cloneJobId = 0 OR B.MountJobId = @i_cloneJobId)
AND B.MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/
AND B.MountStatus >= 59 /*SM_VS_MNT_MOUNTED*/
AND B.MountFlags & 2048 = 2048 /*CVSM_VOLUMEFLAGS_TEST_CLONE_ENV_DB*/
				GROUP BY B.MountJobId, y.cloneDB, Y.sourceDB, Y.tgtInstanceName
	END
	ELSE
	BEGIN
		--Get Volumes For Clones
		INSERT	INTO #tblCloneVolume
		SELECT	DISTINCT B.MountJobId, max(APP.instance),MAX(VOL.SourceClientId),MAX(B.MountHostId), MAX(INST.name),'',MAX(VOL.CopyId), MAX(AGC.archGroupId), MAX(VOL.AppTypeId),
				MAX(VOL.CommCellId), MAX(VOL.JobId), MAX(VOL.CreationTime), MAX(B.CreationTime), MAX(B.ExpireTime), MAX(B.MountStatus),'',''
		FROM	#tblSMVolume A INNER JOIN SMMountVolume B WITH (NOLOCK) ON A.SMVolumeId = B.SMVolumeId
				INNER JOIN SMVolume VOL (NOLOCK) ON A.SMVolumeId = VOL.SMVolumeId
				INNER JOIN APP_Application APP (NOLOCK) ON VOL.AppId = APP.id
				INNER JOIN APP_InstanceName INST (NOLOCK) ON INST.id = APP.instance
				INNER JOIN archGroupCopy AGC (NOLOCK) ON AGC.id = VOL.CopyId
		WHERE	(@i_cloneJobId = 0 OR B.MountJobId = @i_cloneJobId)
AND B.MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/
AND B.MountStatus >= 59 /*SM_VS_MNT_MOUNTED*/
AND B.MountFlags & 2048 = 2048 /*CVSM_VOLUMEFLAGS_TEST_CLONE_ENV_DB*/
		GROUP BY B.MountJobId
		UPDATE	#tblCloneVolume
		SET		tgtDatabaseName = ISNULL(T.S.value('./@instance', 'nvarchar(1024)'), ''),
				tgtInstanceName = ISNULL(T.S.value('./@instance', 'nvarchar(1024)'), ''),
				targetClientId = ISNULL (T.S.value('./@clientId', 'int'), 0)
		FROM	#tblCloneVolume TC
			INNER JOIN
			(
				SELECT	A.cloneJobId, CONVERT(XML,REPLACE(MAX(MD.Metadata), 'UTF-8', 'UTF-16')) metadata
					FROM	#tblCloneVolume A
						INNER JOIN SMMountVolume MVOL (NOLOCK) ON A.cloneJobId = MVOL.MountJobId
INNER JOIN SMMetaData MD (NOLOCK) ON MD.RefId = MVOL.Id AND MD.RefType = 10 AND MD.MetaDataType = 38
				GROUP BY A.cloneJobId ) B ON TC.cloneJobId = B.cloneJobId
		CROSS APPLY B.metadata.nodes('/Ida_OracleTestCloneMetaData/cloneDb') T(S)
	END
	IF (@i_flags & 1 = 1)
	BEGIN
	INSERT INTO #tblCloneDetails
	SELECT	DISTINCT MVOL.id, MVOL.SMVolumeId, A.cloneJobId, MVOL.MountPath, MVOL.MountDevice, SNAP.ControlHostId, ARRAY.SMArrayId, SNAP.SnapShotEngineId, ENG.SnapEngineName
	FROM	#tblCloneVolume A INNER JOIN SMMountVolume MVOL (NOLOCK) ON A.cloneJobId = MVOL.MountJobId
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = MVOL.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
			INNER JOIN SMControlHost ARRAY (NOLOCK) ON ARRAY.ControlHostId = SNAP.ControlHostId
			INNER JOIN SMSnapShotEngine ENG (NOLOCK) ON ENG.SnapShotEngineId = SNAP.SnapShotEngineId
	END
proc_exit:
IF EXISTS (SELECT * FROM #tblCloneVolume)
BEGIN
DECLARE @listOfClones             XML
SET @listOfClones = (
					SELECT	CL.commCellId AS '@commCellId',
							CL.snapJobId AS '@snapJobId',
							CL.cloneJobId AS '@cloneJobId',
							CL.snapJobTimeStamp AS '@snapJobTimeStamp',
							CL.creationTimeStamp AS '@creationTimeStamp',
							CL.expiryTimeStamp AS '@expiryTimeStamp',
							CL.sourceInstanceId AS 'sourceInstance/@instanceId',
							INST.name AS 'sourceInstance/@instanceName',
							CL.sourceClientId AS 'sourceInstance/@clientId',
							SRC_CLNT.name AS'sourceInstance/@clientName',
							SRC_CLNT.displayName AS'sourceInstance/@displayName',
							CL.targetClientId AS 'targetInstance/@clientId',
							TGT_CLNT.name AS'targetInstance/@clientName',
							TGT_CLNT.displayName AS'targetInstance/@displayName',
							CL.tgtInstanceName AS 'targetInstance/@instanceName',
							CL.srcDatabaseName AS 'srcDatabase/@name',
							CL.tgtDatabaseName AS 'tgtDatabase/@name',
							CL.copyId AS 'copyName/@copyId',
							CL.storagePolicyId AS 'storagePolicyName/@storagePolicyId',
							CL.appTypeId AS 'appType/@applicationId',
							CL.cloneStatusId AS 'cloneStatus/@id',
							(CASE WHEN CL.cloneStatusId = 59 AND @nowTime>=expiryTimeStamp  THEN 'Expired'
								WHEN CL.cloneStatusId = 59  THEN 'Created'
								WHEN CL.cloneStatusId > 59 THEN 'Deleting'
								END) AS 'cloneStatus/@name',
							(
								SELECT	DET.mountPath AS '@mountPath',
										DET.mountDevice AS '@mountDevice',
										DET.arrayId AS 'array/@arrayId',
										DET.arrayName AS 'array/@arrayName',
										DET.snapShotEngineId AS 'engine/@id',
										DET.snapShotEngineName AS 'engine/@name'
								FROM	#tblCloneDetails DET
								WHERE	DET.mountJobId = CL.cloneJobId
								FOR XML PATH ('cloneDetails'), TYPE
							)
					FROM #tblCloneVolume CL
					INNER JOIN APP_InstanceName INST (NOLOCK) ON INST.id = CL.sourceInstanceId
					INNER JOIN APP_Client SRC_CLNT (NOLOCK) ON SRC_CLNT.id = CL.sourceClientId
					INNER JOIN APP_Client TGT_CLNT (NOLOCK) ON TGT_CLNT.id = CL.targetClientId
					FOR XML PATH ('listOfClones'))
    SET @o_outXML = (SELECT  @i_errorCode 'errorCode', @s_errorString 'errorMsg', @listOfClones
					FOR XML PATH ( 'Api_GetVolumesOfSnapCloneResponse' ), ELEMENTS)
END
ELSE
BEGIN
    SET @o_outXML = (SELECT ''
					FOR XML PATH('Api_GetVolumesOfSnapCloneResponse'))
END
SELECT @o_outXML AS 'Column1'
IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL
		DROP TABLE #tblSMVolume
IF OBJECT_ID('tempdb.dbo.#tblCloneDetails') IS NOT NULL
		DROP TABLE #tblCloneDetails
IF OBJECT_ID('tempdb.dbo.#tblCloneVolume') IS NOT NULL
		DROP TABLE #tblCloneVolume
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetVolumesOfSnapClone')
	delete from GxQscripts where name = 'MM_SMGetVolumesOfSnapClone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetVolumesOfSnapClone')
	delete from GXDBVersions where aliasname = 'MM_SMGetVolumesOfSnapClone'
GO

insert into GXDBVersions values(2, 'MM_SMGetVolumesOfSnapClone',  '00000000000000000000', 'MM_SMGetVolumesOfSnapClone', '00000000000000000000')
GO

