

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetVolumesOfSnapBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetVolumesOfSnapBackup.sp,v $ $Id: MM_SMGetVolumesOfSnapBackup.sp,v 1.38.12.16 2020/10/14 17:25:33 kkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMGetVolumesOfSnapBackup')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetVolumesOfSnapBackup <<<'
	drop procedure MM_SMGetVolumesOfSnapBackup
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetVolumesOfSnapBackup')
	delete from GxQscripts where name = 'MM_SMGetVolumesOfSnapBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetVolumesOfSnapBackup')
	delete from GXDBVersions where aliasname = 'MM_SMGetVolumesOfSnapBackup'
GO
print '... Creating Procedure: MM_SMGetVolumesOfSnapBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetVolumesOfSnapBackup
  @xmlTextInput XML,
  @i_userId integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	declare		@i_controlHostId	INT
	declare		@i_clientId			INT
	declare		@i_appTypeId		INT
	declare		@i_backupSetId		INT
	declare		@i_instanceId		INT
	declare		@i_subClientId		INT
	declare		@i_copyId			INT
	declare		@i_jobId			INT
	declare		@i_commCellId		INT
	declare		@i_volumeId			INT
	declare		@i_snapId			INT
	declare		@i_flagJobListForWebConsole	INT
	declare		@i_startTime		INT
	declare		@i_endTime			INT
	declare		@i_databaseName		nvarchar(1024)
	DECLARE @maxIntVal INT = 2147483647
	DECLARE @VIRT_ENGINE INTEGER = 32768 -- SM_SNAPSHOT_ENGINE_CAPABILITY_VIRTUALIZED
	SET @i_controlHostId = ISNULL(( SELECT ref.value('@controlHostId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq') R ( ref ) ),
						0)
	SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq/appId') R ( ref ) ),
						0)
	SET @i_appTypeId = ISNULL(( SELECT ref.value('@apptypeId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq/appId') R ( ref ) ),
						0)
	SET @i_backupSetId = ISNULL(( SELECT ref.value('@backupsetId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq/appId') R ( ref ) ),
						0)
	SET @i_instanceId = ISNULL(( SELECT ref.value('@instanceId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq/appId') R ( ref ) ),
						0)
	SET @i_subClientId = ISNULL(( SELECT ref.value('@subclientId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq/appId') R ( ref ) ),
						0)
	SET @i_copyId = ISNULL(( SELECT ref.value('@copyId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq') R ( ref ) ),
						0)
	SET @i_jobId = ISNULL(( SELECT ref.value('@jobId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq') R ( ref ) ),
						0)
	SET @i_commCellId = ISNULL(( SELECT ref.value('@commCellId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq') R ( ref ) ),
						0)
	SET @i_volumeId = ISNULL(( SELECT ref.value('@smVolumeId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq') R ( ref ) ),
						0)
	SET @i_snapId = ISNULL(( SELECT ref.value('@smSnapId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq') R ( ref ) ),
						0)
	SET @i_flagJobListForWebConsole = ISNULL(( SELECT ref.value('@flagJobListForWebConsole', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq') R ( ref ) ),
						0)
	SET @i_startTime = ISNULL(( SELECT ref.value('@startTime', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq') R ( ref ) ),
						0)
	SET @i_endTime = ISNULL(( SELECT ref.value('@endTime', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq') R ( ref ) ),
						0)
	--SET @i_databaseName = ISNULL(( SELECT ref.value('@databaseName', 'nvarchar(1024)')
	--						FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq') R ( ref ) ),
	--					0)
	SET @i_databaseName = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@databaseName', 'nvarchar(1024)'))
							FROM @xmlTextInput.nodes('EVGui_GetVolumesOfSnapBackupReq') R ( ref ) ),
						N'')
	declare @tblSMSnap		TABLE (t_SMSnapId int)
	IF OBJECT_ID('tempdb.dbo.#tbl_GVOSB_SMVolume') IS NOT NULL
		DROP TABLE #tbl_GVOSB_SMVolume
	CREATE TABLE #tbl_GVOSB_SMVolume
	(
		t_SMVolumeId int,
		t_MountVolumeId int,
		t_ArchFileId int,
		t_JobId int,
		t_CopyId int,
		t_CommCellId int,
		t_AppId int,
		t_AppTypeId int,
		t_SnapEngineId int,
		t_Capabilities bigint,
		t_SnapEngineName nvarchar(1024),
		t_ControlHostId int,
		t_SMArrayId nvarchar(1024),
		t_SMHostName nvarchar(1024),
		t_sMountPath nvarchar(1024),
		t_MountStatus int,
		t_replStatus int
	)
	CREATE INDEX tbl_GVOSB_SMVolume_SMVolumeId_Idx ON #tbl_GVOSB_SMVolume (t_SMVolumeId)
	IF @i_snapId > 0
	BEGIN
		--
		-- Get SMVolumeId for this snap
		--
		INSERT INTO #tbl_GVOSB_SMVolume
		SELECT	DISTINCT A.SMVolumeId, 0, A.ArchFileId, A.JobId, A.CopyId, A.CommCellId, A.AppId, A.AppTypeId, 0, 0, N'', 0, N'', N'', A.MountPath, A.MountStatus, 0
			FROM	SMVolume A WITH (NOLOCK), SMVolSnapMap B WITH (NOLOCK)
			WHERE	A.SMVolumeId = B.SMVolumeId AND B.SMSnapId = @i_snapId
			AND		(@i_copyId = 0 OR A.CopyId = @i_copyId)
	END
	ELSE IF @i_volumeId > 0
	BEGIN
		--
		-- Get SMVolumeId for this volume
		--
		INSERT INTO #tbl_GVOSB_SMVolume
		SELECT	DISTINCT A.SMVolumeId, 0, A.ArchFileId, A.JobId, A.CopyId, A.CommCellId, A.AppId, A.AppTypeId, 0, 0, N'', 0, N'', N'', A.MountPath, A.MountStatus, 0
			FROM	SMVolume A WITH (NOLOCK)
			WHERE	A.SMVolumeId = @i_volumeId
			AND		(@i_copyId = 0 OR A.CopyId = @i_copyId)
	END
	ELSE IF @i_jobId > 0
	BEGIN
		--
		-- Get SMVolumeId for this job
		--
		INSERT INTO #tbl_GVOSB_SMVolume
		SELECT	DISTINCT A.SMVolumeId, 0, A.ArchFileId, A.JobId, A.CopyId, A.CommCellId, A.AppId, A.AppTypeId, 0, 0, N'', 0, N'', N'', A.MountPath, A.MountStatus, 0
			FROM	SMVolume A WITH (NOLOCK)
			WHERE	A.JobId = @i_jobId AND A.CommCellId = @i_commCellId
			AND		(@i_copyId = 0 OR A.CopyId = @i_copyId)
	END
	ELSE IF @i_controlHostId > 0
	BEGIN
		--
		-- Get SMVolumeId for this Control Host (Array)
		--
		INSERT INTO #tbl_GVOSB_SMVolume
		SELECT	DISTINCT VOL.SMVolumeId, 0, VOL.ArchFileId, VOL.JobId, VOL.CopyId, VOL.CommCellId, VOL.AppId, VOL.AppTypeId, 0, 0, N'', 0, N'', N'', VOL.MountPath, VOL.MountStatus, 0
			FROM	SMVolume VOL WITH (NOLOCK)
					INNER JOIN SMVolSnapMap MAP WITH (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
					INNER JOIN SMSnap SNAP WITH (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
					LEFT OUTER JOIN SMSnapShotEngine OE WITH (NOLOCK) ON OE.SnapShotEngineId = SNAP.OriginalSnapEngineId
			WHERE	(SNAP.ControlHostId = @i_controlHostId OR (OE.Capabilities & @VIRT_ENGINE = @VIRT_ENGINE AND SNAP.ReserveField2 = @i_controlHostId))
					AND		(@i_copyId = 0 OR VOL.CopyId = @i_copyId)
					AND		(@i_clientId = 0 OR VOL.SourceClientId = @i_clientId)
					AND		(@i_appTypeId = 0 OR VOL.AppTypeId = @i_appTypeId)
	END
	ELSE IF @i_subClientId > 0
	BEGIN
		--
		-- Get SMVolumeIds for this Subclient
		--
		INSERT INTO #tbl_GVOSB_SMVolume
		SELECT	DISTINCT A.SMVolumeId, 0, A.ArchFileId, A.JobId, A.CopyId, A.CommCellId, A.AppId, A.AppTypeId, 0, 0, N'', 0, N'', N'', A.MountPath, A.MountStatus, 0
			FROM	SMVolume A WITH (NOLOCK), ArchFile AF WITH (NOLOCK)
			WHERE	A.AppId = @i_subClientId
			AND		(@i_copyId = 0 OR A.CopyId = @i_copyId)
			AND
			(
				(A.ArchFileId = AF.id AND A.CommCellId = AF.CommCellId  AND	 AF.isValid = 1 )
				OR 	-- DONT DO AFILE VALIDATION FOR VSA V2 PARENT VOL ENTRY
				(
					A.MasterJobId > 0
					AND A.MasterJobId = A.JobId
AND ( A.VolumeFlags & cast ( 4294967296 AS BIGINT) /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/ > 0 )
				)
			)
	END
	ELSE IF @i_backupSetId > 0
	BEGIN
		--
		-- Get SMVolumeId for this backupset
		--
		INSERT INTO #tbl_GVOSB_SMVolume
		SELECT	DISTINCT A.SMVolumeId, 0, A.ArchFileId, A.JobId, A.CopyId, A.CommCellId, AF.AppId, A.AppTypeId, 0, 0, N'', 0, N'', N'', A.MountPath, A.MountStatus, 0
			FROM	SMVolume A WITH (NOLOCK), ArchFile AF WITH (NOLOCK)
			WHERE	A.AppId in (SELECT id FROM APP_Application WITH (NOLOCK) WHERE ClientId = @i_clientId AND AppTypeId = @i_appTypeId AND BackupSet = @i_backupSetId)
			AND		(@i_copyId = 0 OR A.CopyId = @i_copyId)
			AND
			(
				(A.ArchFileId = AF.id AND A.CommCellId = AF.CommCellId  AND	 AF.isValid = 1 )
				OR  -- DONT DO AFILE VALIDATION FOR VSA V2 PARENT VOL ENTRY
				(
					A.MasterJobId > 0
					AND A.MasterJobId = A.JobId
AND (A.VolumeFlags & cast ( 4294967296 AS BIGINT) /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/ > 0 )
				)
			)
	END
	ELSE IF @i_instanceId > 0
	BEGIN
		--
		-- Get SMVolumeIds for this Instance
		--
		INSERT INTO #tbl_GVOSB_SMVolume
		SELECT	DISTINCT A.SMVolumeId, 0, A.ArchFileId, A.JobId, A.CopyId, A.CommCellId, A.AppId, A.AppTypeId, 0, 0, N'', 0, N'', N'', A.MountPath, A.MountStatus, 0
			FROM	SMVolume A WITH (NOLOCK), ArchFile AF WITH (NOLOCK), APP_Application APP WITH (NOLOCK)
			WHERE	APP.instance = @i_instanceId AND A.AppId = APP.id AND APP.appTypeId = @i_appTypeId AND APP.clientId = @i_clientId
			AND		(@i_copyId = 0 OR A.CopyId = @i_copyId)
			AND		A.ArchFileId = AF.id AND A.CommCellId = AF.CommCellId
			AND		AF.isValid = 1
	END
	ELSE IF @i_clientId > 0
	BEGIN
		--
		-- Get SMVolumeId for this client
		--
		INSERT INTO #tbl_GVOSB_SMVolume
		SELECT	DISTINCT A.SMVolumeId, 0, A.ArchFileId, A.JobId, A.CopyId, A.CommCellId, AF.AppId, A.AppTypeId, 0, 0, N'', 0, N'', N'', A.MountPath, A.MountStatus, 0
			FROM	SMVolume A WITH (NOLOCK), ArchFile AF WITH (NOLOCK)
			WHERE	AF.AppId in (SELECT id FROM APP_Application WITH (NOLOCK) WHERE ClientId = @i_clientId AND AppTypeId = @i_appTypeId)
			AND		(@i_copyId = 0 OR A.CopyId = @i_copyId)
			AND     A.ArchFileId = AF.id AND A.CommCellId = AF.CommCellId
			AND		AF.isValid = 1
	END
	ELSE IF @i_copyId > 0
	BEGIN
		--
		-- Get SMVolumeId for this Copy
		--
		INSERT INTO #tbl_GVOSB_SMVolume
		SELECT	DISTINCT A.SMVolumeId, 0, A.ArchFileId, A.JobId, A.CopyId, A.CommCellId, A.AppId, A.AppTypeId, 0, 0, N'', 0, N'', N'', A.MountPath, A.MountStatus, 0
			FROM	SMVolume A WITH (NOLOCK), ArchFile AF WITH (NOLOCK), ArchFileCopy AFC WITH (NOLOCK)
			WHERE	A.CopyId = @i_copyId
			AND		A.CopyId = AFC.ArchCopyId
			AND     A.ArchFileId = AF.id AND A.CommCellId = AF.CommCellId
			AND     AFC.ArchFileId = AF.id AND AFC.CommCellId = AF.CommCellId
			AND		AF.isValid = 1
			AND		AFC.isValid = 1
	END
	if (@@ROWCOUNT = 0)
	BEGIN
		GOTO proc_exit
	END
	--
	-- Security - remove those where the subclients are not visible for this user.
	--
	IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
        DROP TABLE #tblSecCheck
	CREATE TABLE #tblSecCheck (
		EntityType int,
		EntityId int,
		EntityVisible int
	)
	UPDATE #tbl_GVOSB_SMVolume
		SET t_ControlHostId = Snap.ControlHostId
		FROM #tbl_GVOSB_SMVolume Vol WITH (READUNCOMMITTED)
			INNER JOIN SMVolSnapMap Map WITH (READUNCOMMITTED) ON Vol.t_SMVolumeId = Map.SMVolumeId
			INNER JOIN SMSnap Snap WITH (READUNCOMMITTED) ON Map.SMSnapId = Snap.SMSnapId
	INSERT INTO #tblSecCheck
SELECT DISTINCT 1, t_CopyId, 0  FROM #tbl_GVOSB_SMVolume
	INSERT INTO #tblSecCheck
SELECT DISTINCT 2, t_ControlHostId, 0  FROM #tbl_GVOSB_SMVolume
	INSERT INTO #tblSecCheck
SELECT DISTINCT 3, t_AppId, 0  FROM #tbl_GVOSB_SMVolume
	EXEC sec_isSnapshotVisible @i_userId
	DELETE	A
	FROM	#tbl_GVOSB_SMVolume A
INNER JOIN #tblSecCheck B_Copy ON A.t_CopyId = B_Copy.EntityId AND B_Copy.EntityType = 1
INNER JOIN #tblSecCheck B_CHost ON A.t_ControlHostId = B_CHost.EntityId AND B_CHost.EntityType = 2
INNER JOIN #tblSecCheck B_App ON A.t_AppId = B_App.EntityId AND B_App.EntityType = 3
	WHERE	B_Copy.EntityVisible <=0
			AND B_CHost.EntityVisible <=0
			AND B_App.EntityVisible <=0
	IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
		DROP TABLE #tblSecCheck
	--
	-- Safety - remove those snapshots that are part of a running job
	--
	if (@i_jobId <= 0)
	BEGIN
		DELETE #tbl_GVOSB_SMVolume
		FROM #tbl_GVOSB_SMVolume a, JMJobInfo b WITH (NOLOCK)
		WHERE a.t_CommCellId = b.CommCellId AND a.t_JobId = b.JobId
	END
	--
	-- Only return valid archive files
	--
	IF (@i_jobId > 0 or @i_jobId = 0 and @i_controlhostId = 0 and @i_volumeId = 0 and @i_snapId = 0)
	BEGIN
		DELETE #tbl_GVOSB_SMVolume
		FROM #tbl_GVOSB_SMVolume A, SMVolume B WITH (NOLOCK)
WHERE A.t_SMVolumeId = B.SMVolumeId AND B.pruneFlags != 1
	END
	-- Clone Environments
	INSERT	INTO #tbl_GVOSB_SMVolume
	SELECT	DISTINCT A.t_SMVolumeId, B.Id, A.t_ArchFileId, B.MountJobId, A.t_CopyId, B.CommCellId, A.t_AppId, A.t_AppTypeId, 0, 0, N'', 0, N'', N'', B.MountPath, B.MountStatus, 0
	FROM	#tbl_GVOSB_SMVolume A INNER JOIN SMMountVolume B WITH (NOLOCK) ON A.t_SMVolumeId = B.SMVolumeId
WHERE	B.MountStatus = 59 AND B.MountFlags & 32 = 0
	IF @i_controlHostId > 0
	BEGIN
		INSERT	INTO #tbl_GVOSB_SMVolume
		SELECT	DISTINCT A.t_SMVolumeId, B.Id, A.t_ArchFileId, B.MountJobId, A.t_CopyId, B.CommCellId, A.t_AppId, A.t_AppTypeId, 0, 0, N'', 0, N'', N'', B.MountPath, B.MountStatus, 0
		FROM	#tbl_GVOSB_SMVolume A INNER JOIN SMMountVolume B WITH (NOLOCK) ON A.t_SMVolumeId = B.SMVolumeId
		WHERE	B.MountStatus <> 79 AND A.t_MountVolumeId <> B.Id
	END
	/* Partial AuxCopy Changes - Setting Mount Status as 'One or more Missing Snaps' for any errors (Transient / Permanent Errors) */
	UPDATE	#tbl_GVOSB_SMVolume
	SET		t_replStatus = T.ReplStatus
	FROM	#tbl_GVOSB_SMVolume VOL
			INNER JOIN
			(SELECT DISTINCT VOL.t_SMVolumeId, MAX(SNAP.ReplicationStatus) AS ReplStatus
			FROM	#tbl_GVOSB_SMVolume VOL
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON VOL.t_SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId
			GROUP BY VOL.t_SMVolumeId) T
	ON		T.t_SMvolumeId = VOL.t_SMVolumeId
	UPDATE	#tbl_GVOSB_SMVolume
	SET		t_SnapEngineId = C.SnapShotEngineId,
			t_ControlHostId = C.ControlHostId
	FROM	#tbl_GVOSB_SMVolume A, SMVolSnapMap B WITH (NOLOCK), SMSnap C WITH (NOLOCK)
	WHERE	B.SMVolumeId = A.t_SMVolumeId AND C.SMSnapId = B.SMSnapId
	UPDATE	#tbl_GVOSB_SMVolume
	SET		t_SnapEngineName = B.SnapEngineName, t_Capabilities = B.Capabilities
	FROM	#tbl_GVOSB_SMVolume A, SMSnapShotEngine B WITH (NOLOCK)
	WHERE	A.t_SnapEngineId = B.SnapShotEngineId
	UPDATE	#tbl_GVOSB_SMVolume
	SET		t_SMArrayId = B.SMArrayId, t_SMHostName = B.SMHostName
	FROM	#tbl_GVOSB_SMVolume A, SMControlHost B WITH (NOLOCK)
	WHERE	A.t_ControlHostId = B.ControlHostId
	--
	-- Delete Volumes which belong to External Backup Engine
	--
	BEGIN
		DELETE #tbl_GVOSB_SMVolume
		FROM #tbl_GVOSB_SMVolume A
WHERE A.t_SnapEngineId =  51
	END
	DECLARE @tblVolMntPath TABLE
	(
		t_SMVolumeId int,
		t_MountVolumeId int,
		t_sMountPath nvarchar(1024),
		t_EsxSvrIdx	int,
		t_UserNameIdx int,
		t_sEsxServerName nvarchar(1024)
	)
	DECLARE @EsxServerNameTag		NVARCHAR(32)
	DECLARE @UserNameTag			NVARCHAR(32)
	DECLARE @EsxServerNameTagLen	INTEGER
	DECLARE @UserNameTagLen			INTEGER
DECLARE @106	INTEGER
	DECLARE @CVOPTYPE_RESTORE		INTEGER
	SET @EsxServerNameTag = N'esxname:'
	SET @UserNameTag = N',username:'
	SET @EsxServerNameTagLen = LEN(@EsxServerNameTag)
	SET @UserNameTagLen = LEN(@UserNameTag)
SET @106 = 106
	SET @CVOPTYPE_RESTORE = 5
	INSERT	INTO @tblVolMntPath
	SELECT	DISTINCT t_SMVolumeId, t_MountVolumeId, t_sMountPath, CHARINDEX(@EsxServerNameTag, t_sMountPath), CHARINDEX(@UserNameTag, t_sMountPath), N''
	FROM	#tbl_GVOSB_SMVolume
WHERE	t_AppTypeId = @106
			AND t_sMountPath <> N''
	UPDATE	@tblVolMntPath
	SET		t_sEsxServerName = SUBSTRING(t_sMountPath, (t_EsxSvrIdx + @EsxServerNameTagLen), (t_UserNameIdx - (t_EsxSvrIdx + @EsxServerNameTagLen)))
	WHERE	t_EsxSvrIdx > 0 and t_UserNameIdx > 0 and t_UserNameIdx > t_EsxSvrIdx
	UPDATE	#tbl_GVOSB_SMVolume
	SET		t_sMountPath = VMP.t_sEsxServerName
	FROM	#tbl_GVOSB_SMVolume VOL, @tblVolMntPath VMP
	WHERE	VOL.t_SMVolumeId = VMP.t_SMVolumeId AND VOL.t_MountVolumeId = VMP.t_MountVolumeId
			AND VMP.t_sEsxServerName <> N''
	---- In case VSA proxyless, the ESXi Host details are printed instead of the local device path.
	UPDATE	VOL
	SET		VOL.t_sMountPath = MSNAP.SnapDevice
FROM	#tbl_GVOSB_SMVolume VOL	INNER JOIN SMMountVolume MVOL (READUNCOMMITTED) ON VOL.t_MountVolumeId = MVOL.Id AND VOL.t_AppTypeId = @106 AND VOL.t_sMountPath <> N'' AND VOL.t_MountVolumeId <> 0
									INNER JOIN SMMountMap MMAP (READUNCOMMITTED) ON MVOL.Id = MMAP.SMMountVolumeId
									INNER JOIN SMMountSnap MSNAP (READUNCOMMITTED) ON MMAP.SMMountSnapId = MSNAP.Id
WHERE	(CASE WHEN (ISNUMERIC(MVOL.MountOptions) = 1) then  ( MVOL.MountOptions & 4) ELSE 0 END ) > 0
	UPDATE	A
SET		A.t_sMountPath = CASE	WHEN (B.MountFlags & 2048 > 0)			THEN ('DevTest - ' + A.t_sMountPath)			/*CVSM_VOLUMEFLAGS_TEST_CLONE_ENV_DB*/
WHEN (B.MountFlags & 64 > 0)	THEN ('SCSI Server Mount - ' + A.t_sMountPath) /*CVSM_VOLUMEFLAGS_SCSI_SERVER_CLIENT_MOUNT_DB*/
									WHEN (B.MountJobId < 0) THEN ('Live Browse - ' + A.t_sMountPath)
WHEN ( ISNUMERIC(B.MountOptions) = 1 ) THEN (CASE WHEN  (  (B.MountOptions & 1 = 1) OR
(B.MountOptions & 2	= 2)
										 )
										 THEN ('Multi-Node Mount - ' + A.t_sMountPath)	/*SM_VSA_MOUNT_MODE_COORDINATOR Or SM_VSA_MOUNT_MODE_CONTROLLER*/ END )
									WHEN (B.MountJobId in (SELECT jobId FROM JMJobInfo JOB (READUNCOMMITTED) WHERE JOB.OpType = @CVOPTYPE_RESTORE /* Restore */)) THEN ('Restore - ' + A.t_sMountPath)
									ELSE ('Mount - ' + A.t_sMountPath)
							 END
	FROM	#tbl_GVOSB_SMVolume A INNER JOIN SMMountVolume B (NOLOCK) ON A.t_MountVolumeId = B.Id
	WHERE	A.t_MountVolumeId > 0
proc_exit:
IF (@i_flagJobListForWebConsole = 1)
	BEGIN
		DECLARE @tblTempJobDetails TABLE
		(
			t_jobId			int,
			t_commCellId	int,
			t_creationTime	int
		)
		DECLARE @defaultCommcellId integer = 2
IF @i_appTypeId=81
		DECLARE @listOfVolumes	XML
		INSERT INTO @tblTempJobDetails
		SELECT		DISTINCT A.JobId,A.CommCellId,A.CreationTime
		FROM		SMVolume A WITH (NOLOCK)
					INNER JOIN	#tbl_GVOSB_SMVolume B ON A.SMVolumeId = B.t_SMVolumeId
					INNER JOIN	archGroupCopy AGC WITH (NOLOCK) ON A.CopyId = AGC.id
					INNER JOIN	archGroup AG WITH (NOLOCK) ON AGC.archGroupId = AG.id
								AND A.CopyId = AG.defaultSnapCopy
								AND A.PruneFlags = 1 /*MM_SM_PRUNEFLAGS_ACTIVE*/
		WHERE	B.t_MountVolumeId = 0
				AND (@i_startTime=0 OR A.CreationTime >= @i_startTime )
				AND (@i_endTime=0 OR A.CreationTime <= @i_endTime)
				AND A.CommCellId=@defaultCommcellId
		SET @listOfVolumes = (
			SELECT DISTINCT	DBInfo.jobId '@jobId',TMPJOB.t_creationTime '@creationTime'--DBInfo.backup_start_Date '@creationTime'
			FROM			sqldbbackupinfo DBInfo WITH (NOLOCK)
			INNER JOIN		app_application APP WITH (NOLOCK) ON DBInfo.appId = APP.id
			INNER JOIN		SQLNames SN WITH (NOLOCK) ON DBInfo.sqlNameId = SN.id
			INNER JOIN		SQLNames2 SN2 WITH (NOLOCK)ON SN2.id = SN.sqlId
			INNER JOIN		@tblTempJobDetails TMPJOB ON TMPJOB.t_jobId=DBInfo.jobId
			WHERE
				SN.type = 1 AND SN2.type = 1
				AND SN2.name=@i_databaseName
				ORDER BY DBInfo.jobId	DESC
				FOR XML PATH('listOfVolumes'))
		IF (@listOfVolumes IS NULL)
		BEGIN
			SET @listOfVolumes = (SELECT '' FOR XML PATH ('EVGui_GetVolumesOfSnapBackupResponse'))
			SELECT @listOfVolumes AS Column1
		END
		ELSE
		BEGIN
			SET @listOfVolumes = (SELECT @listOfVolumes FOR XML PATH ('EVGui_GetVolumesOfSnapBackupResponse'))
			SELECT @listOfVolumes AS Column1
		END
	END
	ELSE
	BEGIN
		-- Return list of volumes
	IF EXISTS (SELECT 1 FROM #tbl_GVOSB_SMVolume)
	BEGIN
	-- Lets create volumelevelTree xml for passing with volume list.
	-- this xml will have only VSA V2 tree
	DECLARE @VolumeLevelTree XML = ''
	SET @VolumeLevelTree = (
		SELECT DISTINCT Level0.SMVolumeId
			,Level1.SMVolumeId
		FROM SMVolume Level0 WITH(NOLOCK)
		INNER JOIN SMVolume Level1 WITH(NOLOCK)
			ON Level0.MasterJobId = Level1.MasterJobId
			AND Level0.JobId = Level0.MasterJobId
			AND Level1.JobId != Level1.MasterJobId
		INNER JOIN #tbl_GVOSB_SMVolume TEMP
			ON TEMP.t_SMVolumeId = Level1.SMVolumeId --only for given list of volume should have child.
		INNER JOIN SMVolSnapMap MAP WITH(NOLOCK) ON MAP.SMVolumeId = Level0.SMVolumeId
		INNER JOIN SMVolSnapMap MAP2 ON MAP2.SMVolumeId = Level1.SMVolumeId
		WHERE MAP.smsnapid = MAP2.smsnapid
AND TEMP.t_AppTypeId = 106
AND ( Level0.VolumeFlags & cast ( 4294967296 AS BIGINT) /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/ > 0 )
		ORDER BY Level0.SMVolumeId DESC
		FOR XML auto ,root('volumeLevelTree')
		)
	DECLARE @outPutXml XML = (
	SELECT	DISTINCT
		A.SMVolumeId			'@smVolumeId',
(CASE WHEN A.AppTypeId = 13 THEN A.OriginClientId ELSE A.SourceClientId END)	'@sourceClientId',	-- for NAS Clients
(CASE WHEN A.AppTypeId = 13 THEN (SELECT CL.[name] FROM APP_Client CL WITH (NOLOCK) WHERE CL.id = A.OriginClientId) ELSE (SELECT CL.[name] FROM APP_Client CL WITH (NOLOCK) WHERE CL.id = A.SourceClientId) END) '@souceClientName',	-- for NAS Clients
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.MountHostId ELSE A.MountHostId END)	'@mountHostId',	-- for Clone Environments
		(SELECT CL.[name] FROM APP_Client CL WITH (NOLOCK) WHERE CL.id = (CASE WHEN B.t_MountVolumeId > 0 THEN C.MountHostId ELSE A.MountHostId END))	'@mountHostName',
		A.CommCellId			'@commCellId',
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.MountJobId ELSE A.JobId END)	'@jobId',	-- for Clone Environments
		A.ArchFileId			'@archFileId',
		A.CopyId				'@copyId',
		(SELECT AC.[name] FROM ArchGroupCopy AC WITH (NOLOCK) WHERE AC.id = A.CopyId)	'@copyName',
		(SELECT AG.[name] FROM ArchGroupCopy AC WITH (NOLOCK), ArchGroup AG WITH (NOLOCK) WHERE AC.ArchGroupId = AG.id AND AC.id = A.CopyId)	'@spName',
		A.AppId				'@appId',
		A.AppTypeId         '@appTypeId',
		(SELECT TOP 1 IDA.[name] FROM APP_iDAType IDA WITH (READUNCOMMITTED) INNER JOIN APP_Application APP WITH (READUNCOMMITTED) ON APP.Id = A.AppId WHERE IDA.type = APP.appTypeId) '@appTypeName',
		A.PruneFlags			'@pruneFlags',
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.MountFlags ELSE A.VolumeFlags END)	'@volumeFlags',	-- for Clone Environments
		B.t_MountStatus			'@mountStatus',
		(CASE
			WHEN B.t_replStatus > 0 THEN 'One or more missing snaps'
			WHEN A.PruneFlags = 7 THEN 'Not present in Array'
			WHEN B.t_MountStatus = 18 OR B.t_MountStatus = 38 THEN 'Failed to create snap'
			WHEN B.t_MountStatus < 38 AND B.t_MountStatus <> 18 THEN 'Creating snap'
			WHEN B.t_MountStatus = 39 THEN 'Successfully created snap'
			-- WHEN B.t_MountStatus = 41 OR B.t_MountStatus = 43 OR B.t_MountStatus = 43 THEN 'Snap creation failed'
			WHEN B.t_MountStatus IN (41, 43, 45, 47, 58) THEN 'Failed to mount'
			WHEN B.t_MountStatus >= 40 AND B.t_MountStatus < 58 AND B.t_MountStatus NOT IN (41, 43, 45, 47, 58) THEN 'Mounting'
			WHEN B.t_MountStatus = 59 THEN 'Successfully mounted'
			WHEN B.t_MountStatus IN (64, 66, 62, 68, 78) THEN 'Failed to unmount'
			WHEN B.t_MountStatus >= 60 AND B.t_MountStatus < 78 AND B.t_MountStatus NOT IN (64, 66, 62, 68, 78) THEN 'Unmounting'
			WHEN B.t_MountStatus = 79 THEN 'Successfully unmounted'
			WHEN B.t_MountStatus >= 80 AND B.t_MountStatus < 88 THEN 'Reverting'
			WHEN B.t_MountStatus = 88 THEN 'Failed to revert'
			WHEN B.t_MountStatus = 89 THEN 'Successfully reverted'
			WHEN B.t_MountStatus >= 90 AND B.t_MountStatus < 97 THEN 'Deleting'
			WHEN B.t_MountStatus = 97 THEN 'Externally deleted'
			WHEN B.t_MountStatus = 98 THEN 'Failed to delete'
			WHEN B.t_MountStatus = 99 THEN 'Successfully deleted'
		END)	'@mountStatusName',
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.MountStatusUpdateTime ELSE A.MountStatusUpdateTime END)	'@mountStatusUpdateTime',	-- for Clone Environments
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.LogicalUnmountTime ELSE A.LogicalUnmountTime END)	'@logicalUnmountTime',	-- for Clone Environments
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.CreationTime ELSE A.CreationTime END)	'@creationTime',	-- for Clone Environments
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.RetryCount ELSE A.RetryCount END)	'@retryCount',	-- for Clone Environments
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.DevMode ELSE A.DevMode END)	'@devMode',	-- for Clone Environments
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.UserId ELSE A.UserId END)	'@userId',	-- for Clone Environments
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.GroupId ELSE A.GroupId END)	'@groupId',	-- for Clone Environments
		A.SnapSource			'@snapSource',
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.MountProxyId ELSE A.MountProxyId END)	'@mountProxyId',	-- for Clone Environments
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.RemoteOp ELSE A.RemoteOp END)	'@remoteOp',	-- for Clone Environments
		A.RecoveryPointId		'@recoveryPointId',
		(CASE WHEN A.OriginSourcePath <> '' THEN A.OriginSourcePath ELSE A.SourcePath END) '@sourcePath',
		B.t_sMountPath			'@mountPath',
		A.SourceGUID			'@sourceGUID',
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.MountGUID ELSE A.MountGUID END)	'@mountGUID',	-- for Clone Environments
		A.SourceDevice			'@sourceDevice',
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.MountDevice ELSE A.MountDevice END)	'@mountDevice',	-- for Clone Environments
		(CASE WHEN B.t_MountVolumeId > 0 THEN C.MountOptions ELSE A.MountOptions END)	'@mountOptions',	-- for Clone Environments
		A.ShadowSetId			'@shadowSetId',
		A.ShadowCopyId			'@shadowCopyId',
		B.t_SnapEngineId		'@snapEngineId',
		(B.t_Capabilities & @maxIntVal) '@capabilities',
		B.t_SnapEngineName		'@snapEngineName',
		B.t_ControlHostId		'@controlHostId',
		B.t_SMArrayId			'@smArrayId',
		B.t_SMHostName			'@smHostName',
(SELECT	( CASE 	WHEN (A.VolumeFlags & 4096) = 4096	AND (isMirrorCopy = 1)	THEN (8 | 4) -- (lrep & MIRROR)
WHEN (A.VolumeFlags & 4096) = 4096	THEN (8 | 1 ) -- LREP PRIMARY
WHEN (isMirrorCopy = 1) THEN 4	--mirror
WHEN isSnapCopy = 1 AND AG.id IS null AND AC.extendedFlags & 256 = 256 THEN 16	-- array replica
WHEN isSnapCopy = 1 AND AG.id IS null THEN 2	-- vault
ELSE 1 END)	-- primary
		FROM	ArchGroupCopy AC WITH (NOLOCK) LEFT OUTER JOIN archGroup AG WITH (NOLOCK) ON AC.id = AG.defaultSnapCopy
		WHERE	AC.id = A.CopyId ) '@reserveField1',
		B.t_MountVolumeId		'@reserveField2',
		A.ReserveFieldStr		'@reserveFieldStr',
		A.MasterJobId		'@masterJobId'
	FROM	SMVolume A WITH (NOLOCK) INNER JOIN #tbl_GVOSB_SMVolume B ON A.SMVolumeId = B.t_SMVolumeId LEFT OUTER JOIN SMMountVolume C WITH (NOLOCK) ON C.SMVolumeId = B.t_SMVolumeId AND C.Id = B.t_MountVolumeId
	ORDER BY 21 DESC	-- IMPORTANT: Change the order # accordingly when the columns are added or deleted or the order shifts
	FOR XML PATH('listOfVolumes'))
	--joining volumelevelTree xml with volume list.
	SELECT @outPutXml, @VolumeLevelTree FOR XML PATH(''), ROOT('EVGui_GetVolumesOfSnapBackupResponse')
	END
	ELSE
	BEGIN
		SELECT ''
		FOR XML PATH('EVGui_GetVolumesOfSnapBackupResponse')
	END
END
IF OBJECT_ID('tempdb.dbo.#tbl_GVOSB_SMVolume') IS NOT NULL
	DROP TABLE #tbl_GVOSB_SMVolume
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMGetVolumesOfSnapBackup')
	delete from GxQscripts where name = 'MM_SMGetVolumesOfSnapBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetVolumesOfSnapBackup')
	delete from GXDBVersions where aliasname = 'MM_SMGetVolumesOfSnapBackup'
GO

insert into GXDBVersions values(2, 'MM_SMGetVolumesOfSnapBackup',  '00010038001200160000', 'MM_SMGetVolumesOfSnapBackup', '00010038001200160000')
GO

