

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetVolumesForJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetVolumesForJob.sp,v $ $Id: MM_SMGetVolumesForJob.sp,v 1.13.276.2 2018/03/20 00:12:34 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetVolumesForJob <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetVolumesForJob')
	drop procedure MM_SMGetVolumesForJob
IF EXISTS (select * from GxQscripts where name='MM_SMGetVolumesForJob')
	delete from GxQscripts where name = 'MM_SMGetVolumesForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetVolumesForJob')
	delete from GXDBVersions where aliasname = 'MM_SMGetVolumesForJob'
GO
print '... Creating Procedure: MM_SMGetVolumesForJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MM_SMGetVolumesForJob
  @i_jobId integer,
  @i_archFileId integer,
  @i_commCellId integer,
  @i_copyParam integer,
  @i_copyParamType integer,
  @i_snapActionFlags integer
AS
  DECLARE @o_SMVolSnapMapId integer
  DECLARE @o_SMVolumeId integer
  DECLARE @o_SMSnapId integer
  DECLARE @o_MetaDataId integer
  DECLARE @o_IsValidAF integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @tblArchFile TABLE(
			ArchFileId integer,
			CommCellId int,
			ArchGroupId integer,
			IsValidAF integer
			)
	DECLARE @tblArchFileCopy TABLE(
			ArchFileId integer,
			CommCellId int,
			ArchGroupId integer,
			CopyId integer,
			IsValidAF integer,
			isValidCopy integer
			)
	DECLARE @tblCopyIds TABLE(copyId integer)
	DECLARE	@tblVolSnapInfo TABLE(
			SMVolSnapMapId int,
			SMVolumeId int,
			SMSnapId int,
			MetaDataId int,
			IsValidAF int,
			isValidCopy integer
			)
	DECLARE	@ActionFlags integer
	DECLARE @RecoveryPointId integer
IF @i_snapActionFlags & 64 = 64
	BEGIN
		SET @RecoveryPointId = @i_commCellId
		SET @i_commCellId = 2
	END
IF @i_snapActionFlags & 128 = 128
	BEGIN
		SET @o_SMVolumeId = @i_commCellId
		SET @i_commCellId = 2
	END
	IF @i_commCellId = 0 SET @i_commCellId = 2
	IF @i_jobId > 0
	BEGIN
		INSERT	INTO @tblArchFile
		SELECT	id, commCellId, archGroupId, isValid
		FROM	ArchFile WITH (NOLOCK)
		WHERE	jobId = @i_jobId
		AND commCellId = @i_commCellId
	END
	ELSE IF @i_archFileId > 0
	BEGIN
		INSERT	INTO @tblArchFile
		SELECT	id, commCellId, archGroupId, isValid
		FROM	ArchFile WITH (NOLOCK)
		WHERE	id = @i_archFileId
		AND commCellId = @i_commCellId
	END
	INSERT	INTO @tblArchFileCopy
	SELECT	A.ArchFileId, A.CommCellId, A.ArchGroupId, B.ArchCopyId, A.IsValidAF, B.isValid
	FROM	@tblArchFile A, ArchFileCopy B WITH (NOLOCK)
	WHERE	A.ArchFileId = B.ArchFileId
	AND		A.CommCellId = B.CommCellId
	-- If @i_copyParam is zero, then get the defaultSnapCopy
	IF @i_copyParam = 0
	BEGIN
		INSERT INTO @tblCopyIds
		SELECT defaultSnapCopy
		FROM archGroup WITH (READUNCOMMITTED)
		WHERE id IN (SELECT DISTINCT archGroupId FROM @tblArchFile)
	END
	ELSE
	-- SM_CPT_COPY_ID
	IF @i_copyParamType = 1
		INSERT INTO @tblCopyIds
		SELECT id
		FROM archGroupCopy WITH (READUNCOMMITTED)
		WHERE archGroupid IN (SELECT DISTINCT archGroupId FROM @tblArchFile)
		AND id = @i_copyParam
	ELSE
	-- SM_CPT_COPY_PRECEDENCE
	IF @i_copyParamType = 2
		INSERT INTO @tblCopyIds
		SELECT id
		FROM archGroupCopy WITH (READUNCOMMITTED)
		WHERE archGroupid IN (SELECT DISTINCT archGroupId FROM @tblArchFile)
		AND copy = @i_copyParam
	-- Get only those Volumes, having valid ArchFile Id, for a given Job
SET @ActionFlags = @i_snapActionFlags & 2
IF @i_snapActionFlags & 64 = 64
		INSERT	INTO @tblVolSnapInfo
		SELECT	DISTINCT SMMAP.SMVolSnapMapId, SMMAP.SMVolumeId, SMMAP.SMSnapId, SMMAP.MetaDataId, AFC.IsValidAF, AFC.IsValidCopy
		FROM	SMVolume SMVOL WITH (READUNCOMMITTED),
				SMVolSnapMap SMMAP WITH (READUNCOMMITTED),
				@tblArchFileCopy AFC
		WHERE	SMVOL.SMVolumeId = SMMAP.SMVolumeId AND
				SMVOL.CopyId IN (SELECT copyId FROM @tblCopyIds) AND
				SMVOL.ArchFileId = AFC.archFileId AND
				SMVOL.CommCellId = AFC.commCellId AND
				SMVOL.CopyId = AFC.CopyId AND
				SMVOL.RecoveryPointId = @RecoveryPointId
ELSE IF @i_snapActionFlags & 128 = 128
	BEGIN
		INSERT	INTO @tblVolSnapInfo
		SELECT	DISTINCT SMMAP.SMVolSnapMapId, SMMAP.SMVolumeId, SMMAP.SMSnapId, SMMAP.MetaDataId, 0, AFC.isValid
		FROM	SMVolume SMVOL WITH (READUNCOMMITTED),
				SMVolSnapMap SMMAP WITH (READUNCOMMITTED),
				ArchFileCopy AFC  WITH (READUNCOMMITTED)
		WHERE	SMVOL.SMVolumeId = SMMAP.SMVolumeId AND
				SMVOL.ArchFileId = AFC.archFileId AND
				SMVOL.CommCellId = AFC.commCellId AND
				SMVOL.CopyId = AFC.archCopyId AND
				SMVOL.SMVolumeId = @o_SMVolumeId
		UPDATE @tblVolSnapInfo SET IsValidAF = AF.isValid
		FROM archFile AF, SMVolume SV
		WHERE	SV.SMVolumeId = @o_SMVolumeId AND
				AF.id = SV.ArchFileId
	END
	ELSE
	INSERT	INTO @tblVolSnapInfo
	SELECT	DISTINCT SMMAP.SMVolSnapMapId, SMMAP.SMVolumeId, SMMAP.SMSnapId, SMMAP.MetaDataId, AFC.IsValidAF, AFC.IsValidCopy
	FROM	SMVolume SMVOL WITH (READUNCOMMITTED),
			SMVolSnapMap SMMAP WITH (READUNCOMMITTED),
			@tblArchFileCopy AFC
	WHERE	SMVOL.SMVolumeId = SMMAP.SMVolumeId AND
			SMVOL.CopyId IN (SELECT copyId FROM @tblCopyIds) AND
			SMVOL.ArchFileId = AFC.archFileId AND
			SMVOL.CommCellId = AFC.commCellId AND
			SMVOL.CopyId = AFC.CopyId
	-- ArchFile should be considered invalid if the archfilecopy record is invalid
	UPDATE @tblVolSnapInfo SET IsValidAF = IsValidCopy
	WHERE IsValidCopy <> 1
	IF @ActionFlags > 0
	BEGIN
		-- Return only valid archive file
		DELETE FROM @tblVolSnapInfo WHERE IsValidAF <> 1
	END
	-- Check whether its CDR/DDR. If so, get all volumes/maps for the associated Snaps
	DECLARE @SnapShotEngineId INTEGER
	SET @SnapShotEngineId = 0
	SELECT @SnapShotEngineId = SnapShotEngineId FROM SMSnap
	WHERE SMSnapId = (SELECT TOP 1 SMSnapId FROM @tblVolSnapInfo)
IF @SnapShotEngineId = 11 OR
@SnapShotEngineId = 10 OR
@SnapShotEngineId = 15
	BEGIN
IF @i_snapActionFlags & 512 = 512
		BEGIN
			DECLARE @tblTmpVolSnapInfo TABLE
			(	SMVolSnapMapId int,
				SMVolumeId int,
				SMSnapId int,
				MetaDataId int,
				IsValidAF int,
				isValidCopy integer)
			INSERT INTO @tblTmpVolSnapInfo
			SELECT	DISTINCT SMMAP.SMVolSnapMapId, SMMAP.SMVolumeId, SMMAP.SMSnapId, SMMAP.MetaDataId, 0, 0
			FROM	SMVolSnapMap SMMAP WITH (READUNCOMMITTED)
			WHERE	SMMAP.SMSnapId IN (SELECT DISTINCT SMSnapId FROM @tblVolSnapInfo)
			UPDATE	@tblTmpVolSnapInfo
			SET		IsValidAF = AF.isValid, isValidCopy = AFC.isValid
			FROM	archFile AF, SMVolume SV, @tblTmpVolSnapInfo TVS, archFileCopy AFC
			WHERE	SV.SMVolumeId = TVS.SMVolumeId AND
					AF.id = SV.ArchFileId AND
					AFC.archCopyId = SV.CopyId AND
					AFC.commCellId = SV.CommCellId
			INSERT INTO @tblVolSnapInfo
			SELECT * FROM @tblTmpVolSnapInfo
		END
	END
	-- Get all metadata for volumes
	INSERT	INTO @tblVolSnapInfo
	SELECT	0, RefId, 0, MetaDataId, 0, 0
	FROM	SMMetaData WITH (READUNCOMMITTED)
WHERE	RefType = 1
	AND		RefId in (SELECT DISTINCT SMVolumeId FROM @tblVolSnapInfo)
	-- Get all metadata for snaps
	INSERT	INTO @tblVolSnapInfo
	SELECT	0, 0, RefId, MetaDataId, 0, 0
	FROM	SMMetaData WITH (READUNCOMMITTED)
WHERE	RefType = 2
	AND		RefId in (SELECT DISTINCT SMSnapId FROM @tblVolSnapInfo)
	SELECT	SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, IsValidAF
	FROM	@tblVolSnapInfo
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetVolumesForJob')
	delete from GxQscripts where name = 'MM_SMGetVolumesForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetVolumesForJob')
	delete from GXDBVersions where aliasname = 'MM_SMGetVolumesForJob'
GO

insert into GXDBVersions values(2, 'MM_SMGetVolumesForJob',  '00010013027600020000', 'MM_SMGetVolumesForJob', '00010013027600020000')
GO

