

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetVolSnapsSMT.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetVolSnapsSMT.sp,v $ $Id: MM_SMGetVolSnapsSMT.sp,v 1.1.2.13 2020/03/27 22:07:51 cmarella Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMGetVolSnapsSMT')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetVolSnapsSMT <<<'
	drop procedure MM_SMGetVolSnapsSMT
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetVolSnapsSMT')
	delete from GxQscripts where name = 'MM_SMGetVolSnapsSMT'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetVolSnapsSMT')
	delete from GXDBVersions where aliasname = 'MM_SMGetVolSnapsSMT'
GO
print '... Creating Procedure: MM_SMGetVolSnapsSMT'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetVolSnapsSMT
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_SMVolSnapMapId INTEGER
  DECLARE @o_SMVolumeId INTEGER
  DECLARE @o_SMSnapId INTEGER
  DECLARE @o_MetaDataId INTEGER
  DECLARE @o_IsValidAF INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(MAX)
  DECLARE @o_ReserveParam1 integer
  DECLARE @o_ReserveParam2 integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
    -- Input Paramters from XML String
    DECLARE @x_opCode               INT = 0
    DECLARE @x_flags                INT = 0
    DECLARE @x_arrayName            NVARCHAR(2048) = N''
    DECLARE @x_arrayNum             INT = -1
    DECLARE @x_newArrayVolName      NVARCHAR(2048) = N''
    DECLARE @x_arrayVolName         NVARCHAR(2048) = N''
	DECLARE @x_snapId               INT = 0
	DECLARE @x_batchCount           INT = 500
	DECLARE @x_snapJobId            INT = 0
    -- Local Constants
    DECLARE @C_OPCODE_BEGIN                                 INT = 0
    DECLARE @C_OPCODE_VOLUME_RENAME                         INT = 1
    DECLARE @C_OPCODE_SNAP_RENAME                           INT = 2
    DECLARE @C_OPCODE_ARRAY_RENAME                          INT = 3
    DECLARE @C_OPCODE_ASSOC_NASCLIENT_TO_ARRAY              INT = 4
    DECLARE @C_OPCODE_ARRAY_IF_RENAME                       INT = 5
    DECLARE @C_OPCODE_DFM_DATASET_DELETE                    INT = 6
    DECLARE @C_OPCODE_VOLUME_MOVE                           INT = 7
    DECLARE @C_OPCODE_ARRAY_MIGRATION                       INT = 8
    DECLARE @C_OPCODE_PRERUN                                INT = 9
    DECLARE @C_OPCODE_POSTRUN                               INT = 10
    DECLARE @C_OPCODE_ARRAY_UNIQUEID                        INT = 11
    DECLARE @C_OPCODE_OCUM_RENAME                           INT = 12
    DECLARE @C_OPCODE_SVM_RENAME                            INT = 13
    DECLARE @C_OPCODE_SET_VSERVER_CONFIG                    INT = 14
	DECLARE @C_OPCODE_FIX_MISSING_SNAP_METADATA				INT = 15
    DECLARE @C_OPCODE_END                                   INT = 16
    -- Local Variables
    DECLARE @l_arrayNum             INT = -1
	DECLARE @l_preRunEnabled        INT = 0
    DECLARE @l_isNLRVolume			INT = 0
	IF (OBJECT_ID('tempdb.dbo.#tblVolSnapInfo') IS NOT NULL)
		DROP TABLE #tblVolSnapInfo
	CREATE TABLE #tblVolSnapInfo(
            SMVolSnapMapId          INT,
            SMVolumeId              INT,
            SMSnapId                INT,
            MetaDataId              INT,
            IsValidAF               INT,
            IsValidCopy             INT
            )
	IF (OBJECT_ID('tempdb.dbo.#tblPackedMetadata') IS NOT NULL)
		DROP TABLE #tblPackedMetadata
	CREATE TABLE #tblPackedMetadata(
			MetadataId              INT PRIMARY KEY,
			SMSnapId                INT,
			PruneFlags              INT,
			Metadata                NVARCHAR(MAX)
			)
	IF (OBJECT_ID('tempdb.dbo.#tblMetadataRows') IS NOT NULL)
		DROP TABLE #tblMetadataRows
	CREATE TABLE #tblMetadataRows(
			MetadataId              INT,
            MetadataType            INT DEFAULT 0,
			MetadataRow             NVARCHAR(MAX)
			)
	CREATE INDEX MDR_IDX1 ON #tblMetadataRows(MetadataId, MetadataType)
	IF (OBJECT_ID('tempdb.dbo.#tblMetadata') IS NOT NULL)
		DROP TABLE #tblMetadata
	CREATE TABLE #tblMetadata(
			MetadataId              INT,
			SMSnapId                INT,
			MetadataType            INT,
			Metadata                NVARCHAR(MAX)
			)
	CREATE INDEX MD_IDX1 ON #tblMetadata(MetadataId, MetadataType)
	IF (OBJECT_ID('tempdb.dbo.#tblArrayInfo') IS NOT NULL)
		DROP TABLE #tblArrayInfo
	CREATE TABLE #tblArrayInfo(
        MetadataId              INT,
        MetadataType            INT,
        SMSnapId                INT,
        ArrayName               NVARCHAR(1024),
        ArrayNameIdx            INT,
        VolumeName              NVARCHAR(2048),
        VolumeNameIdx           INT
        )
	CREATE INDEX TAI_IDX1 ON #tblArrayInfo(MetadataType, MetadataId)
    -- Initialize the Output Parameters
    SET @o_SMVolSnapMapId   = 0
    SET @o_SMVolumeId       = 0
    SET @o_SMSnapId         = 0
    SET @o_MetaDataId       = 0
    SET @o_IsValidAF        = 0
    SET @o_ErrorCode        = 0
    SET @o_ErrorStr         = ''
    -- XML Structure for MM_SMGetVolSnapsSMT
    /*
    -- Test XML string
    <MM_SMGetVolSnapsSMT><OpCode>1</OpCode><Flags>0</Flags><ArrayName>mold</ArrayName><ArrayNum>0</ArrayNum><New_ArrayName></New_ArrayName><ArrayVolName>vol1</ArrayVolName></MM_SMGetVolSnapsSMT>
    <MM_SMGetVolSnapsSMT>
        <OpCode></OpCode>
        <Flags></Flags>
        <ArrayName></ArrayName>
        <ArrayNum></ArrayNum>
        <SMSnapId></SMSnapId>
		<BatchSize></BatchSize>
        <SnapJobId></SnapJobId>
        <New_ArrayName></New_ArrayName>
        <ArrayVolName></ArrayVolName>
    </MM_SMGetVolSnapsSMT>
    */
    -- Initialize and set the values for Input Parameters
    -- Opcode
    SET @x_opCode = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnapsSMT/OpCode') R(ref)), 0)
    IF (@x_opCode < @C_OPCODE_BEGIN) OR (@x_opCode >= @C_OPCODE_END)
    BEGIN
        SELECT  0, 0, 0, 0, 0, 60139 /*E_MM_SM_SB_EMPTY_VALID_FLAGS*/, 'OpCode [' + CONVERT(NVARCHAR(8), @x_opCode) + '] sent to MM_SMGetVolSnapsSMT is invalid.', 0, 0
        RETURN
    END
    -- Flags
    SET @x_flags = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnapsSMT/Flags') R(ref)), 0)
    IF @x_flags < 0
    BEGIN
        SELECT  0, 0, 0, 0, 0, 60139 /*E_MM_SM_SB_EMPTY_VALID_FLAGS*/, 'Flags [' + CONVERT(NVARCHAR(8), @x_flags) + '] sent to MM_SMGetVolSnapsSMT is invalid.', 0, 0
        RETURN
    END
    SET @x_arrayName = ISNULL(( SELECT R.ref.value('.', 'nvarchar(2048)') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnapsSMT/ArrayName') R(ref)), N'')
    SET @x_arrayNum = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnapsSMT/ArrayNum') R(ref)), 0)
    SET @x_newArrayVolName = ISNULL(( SELECT R.ref.value('.', 'nvarchar(2048)') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnapsSMT/New_ArrayVolName') R(ref)), N'')
    SET @x_arrayVolName = ISNULL(( SELECT R.ref.value('.', 'nvarchar(2048)') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnapsSMT/ArrayVolName') R(ref)), N'')
    SET @x_snapId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnapsSMT/SMSnapId') R(ref)), 0)
    SET @x_batchCount = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnapsSMT/BatchSize') R(ref)), CASE WHEN (@C_OPCODE_FIX_MISSING_SNAP_METADATA = @x_opCode) THEN 10 ELSE 500 END)
    SET @x_snapJobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnapsSMT/SnapJobId') R(ref)), 0)
    -- Validate the input params.
	-- For Volume Rename / Snap Rename, ArrayName and VolumeName need to be passed
    IF ((@C_OPCODE_VOLUME_RENAME = @x_opCode) OR (@C_OPCODE_SNAP_RENAME = @x_opCode) OR (@C_OPCODE_VOLUME_MOVE = @x_opCode))  -- Volume Rename / Snap Rename / Volume Move
    BEGIN
        IF @x_arrayName = ''
        BEGIN
            SELECT  0, 0, 0, 0, 0, 60139 /*E_MM_SM_SB_EMPTY_VALID_FLAGS*/, 'For Volume Rename, Array name[' + @x_arrayName + '] sent to MM_SMGetVolSnapsSMT is invalid.', 0, 0
            RETURN
        END
        IF @x_arrayVolName = ''
        BEGIN
            SELECT  0, 0, 0, 0, 0, 60139 /*E_MM_SM_SB_EMPTY_VALID_FLAGS*/, 'For Volume Rename, Volume name[' + @x_arrayVolName + '] sent to MM_SMGetVolSnapsSMT is invalid.', 0, 0
            RETURN
        END
    END
	-- For Array Rename, Old Array need to be passed
    IF ((@C_OPCODE_ARRAY_RENAME = @x_opCode) OR (@C_OPCODE_ARRAY_IF_RENAME = @x_opCode) OR
		(@C_OPCODE_ARRAY_MIGRATION = @x_opCode) OR (@C_OPCODE_SVM_RENAME = @x_opCode)) -- Array Rename / Array Interface Rename / 7m-Cm Array Migration
    BEGIN
        IF @x_arrayName = ''
        BEGIN
            SELECT  0, 0, 0, 0, 0, 60139 /*E_MM_SM_SB_EMPTY_VALID_FLAGS*/, 'Array name[' + @x_arrayName + '] sent to MM_SMGetVolSnapsSMT is invalid.', 0, 0
            RETURN
        END
    END
    -- Check whether the given array exists or not
    IF @x_arrayName <> ''
    BEGIN
        SET @l_arrayNum = (SELECT TOP 1 ControlHostId FROM SMControlHost (NOLOCK) WHERE SMArrayId = @x_arrayName)
        IF @l_arrayNum IS NULL
        BEGIN
            SET @l_arrayNum = (SELECT TOP 1 RefId FROM SMHostAlias (NOLOCK) WHERE AliasName = @x_arrayName)
            IF @l_arrayNum IS NULL
            BEGIN
                SELECT  0, 0, 0, 0, 0, 60139 /*E_MM_SM_SB_EMPTY_VALID_FLAGS*/, 'No array found for name[' + @x_arrayName + '].', 0, 0
                RETURN
            END
        END
        IF @x_arrayNum > 0 AND @x_arrayNum <> @l_arrayNum
        BEGIN
            SELECT  0, 0, 0, 0, 0, 60139 /*E_MM_SM_SB_EMPTY_VALID_FLAGS*/, 'Array num[' + CONVERT(NVARCHAR(8), @l_arrayNum) + '] found for array name[' + @x_arrayName + '] is not matching with the passed-in array num[' + CONVERT(NVARCHAR(8), @x_arrayNum)  + '].', 0, 0
            RETURN
        END
    END
	/*Check if we have to use the contents of SMSnapSMT table, initialized from preRun operation*/
	 IF EXISTS(SELECT TOP 1 1 FROM SMSnapSMT (NOLOCK))
		SET @l_preRunEnabled = 1
	/*Following block gets the valid SnapIds, including vaulted/mirrored entries*/
	IF ((@C_OPCODE_VOLUME_RENAME = @x_opCode) OR (@C_OPCODE_SVM_RENAME      = @x_opCode) OR
		(@C_OPCODE_ARRAY_RENAME  = @x_opCode) OR (@C_OPCODE_ARRAY_IF_RENAME = @x_opCode) OR
		(@C_OPCODE_VOLUME_MOVE   = @x_opCode) OR (@C_OPCODE_ARRAY_MIGRATION = @x_opCode)) -- Volume Rename /  Array Rename / Array Interface Rename / 7m-Cm Array Migration, Volume Move
	BEGIN
		IF (@l_preRunEnabled = 0)
		BEGIN
            SELECT  0, 0, 0, 0, 0, 60139 /*E_MM_SM_SB_EMPTY_VALID_FLAGS*/, 'preRun operation needs to be run before current operation.', 0, 0
            RETURN
		END
		ELSE -- (@l_preRunEnabled = 1)
		BEGIN
			INSERT  INTO #tblArrayInfo
			SELECT  MetaDataId, MetadataType, SMSnapId, ArrayName, 0, VolumeName, 0
FROM    SMSnapSMT WHERE MetadataType IN (6, 29)
		END
	END
	-- Check if volume to be renamed is part of NLR relationship
	IF (@C_OPCODE_VOLUME_RENAME = @x_opCode)
	BEGIN
		-- Job based volume rename could have updated the SMReplicaEntities with new volume name.
		-- So to take care of remaining old vol rename, checking for old volume or new volume in SMReplicaEntities.
		SELECT @l_isNLRVolume = 1
		FROM SMReplicaEntities
		WHERE ArrayNum = @l_arrayNum
			AND ((EntityName = @x_arrayName+':'+@x_arrayVolName) OR
			     (EntityName = @x_arrayName+':'+@x_newArrayVolName))
	END
	-- Snap Rename / Volume Rename per job
    IF (((@C_OPCODE_SNAP_RENAME = @x_opCode) OR (@C_OPCODE_VOLUME_RENAME = @x_opCode)) AND (@x_snapJobId > 0))
	BEGIN
		INSERT  INTO #tblVolSnapInfo
		-- Map Metadata has been specifically commented out as its not required for SMT
		SELECT  MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, 0 /*MAP.MetadataId*/, 0/*AFC.IsValid*/, 0
		FROM    SMVolSnapMap MAP (NOLOCK)
				INNER JOIN SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
		WHERE VOL.JobId = @x_snapJobId
	END
	 -- Volume Rename for NLR
	ELSE IF ((@C_OPCODE_VOLUME_RENAME = @x_opCode) AND (1 = @l_isNLRVolume))
	BEGIN
		-- NLR replica (vault/mirror) SMMetaData entries do not have primary snap info (SNAP_UUID with primary array|volume).
		-- To get the replica entries, getting the jobId from SMVolume with matching primary array & volume.
		-- and get all the entries belonging to those snap jobs.
		-- Note it may result in sending snap info of other volume belonging to same job, but will be filtered in SnapManagementTool.exe
		INSERT  INTO #tblVolSnapInfo
		SELECT DISTINCT TOP (@x_batchCount) MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, 0 /*MAP.MetadataId*/, 0/*AFC.IsValid*/, 0
		FROM    SMVolSnapMap MAP (NOLOCK)
				INNER JOIN SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
				INNER JOIN
				(
					SELECT  DISTINCT VOL.JobId
					FROM    #tblArrayInfo TAI
							INNER JOIN SMVolSnapMap MAP (NOLOCK) ON TAI.SMSnapId = MAP.SMSnapId
							INNER JOIN SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
					WHERE ArrayName = @x_arrayName
							AND VolumeName = @x_arrayVolName
				) TMP ON VOL.JobId = TMP.JobId
		WHERE MAP.SMSnapId > @x_snapId
		ORDER BY MAP.SMSnapId
	END
	ELSE IF ((@C_OPCODE_VOLUME_RENAME = @x_opCode) OR (@C_OPCODE_VOLUME_MOVE = @x_opCode))  -- Volume Rename / Volume Move
	BEGIN
		INSERT  INTO #tblVolSnapInfo
		-- Map Metadata has been specifically commented out as its not required for SMT
		SELECT  DISTINCT TOP (@x_batchCount) MAP.SMVolSnapMapId, MAP.SMVolumeId, TAI.SMSnapId, 0 /*MAP.MetadataId*/, 0/*AFC.IsValid*/, 0
		FROM    #tblArrayInfo TAI INNER JOIN SMVolSnapMap MAP (NOLOCK) ON TAI.SMSnapId = MAP.SMSnapId
				INNER JOIN SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
			--	INNER JOIN archFileCopy AFC (NOLOCK) ON VOL.CommCellId = AFC.commCellId AND VOL.CopyId = AFC.archCopyId AND VOL.ArchFileId = AFC.archFileId
		WHERE ArrayName = @x_arrayName
			  AND VolumeName = @x_arrayVolName
			  AND TAI.SMSnapId > @x_snapId
		ORDER BY TAI.SMSnapId
	END
	ELSE IF ((@C_OPCODE_ARRAY_RENAME = @x_opCode) OR (@C_OPCODE_ARRAY_IF_RENAME = @x_opCode) OR
			 (@C_OPCODE_ARRAY_MIGRATION = @x_opCode) OR (@C_OPCODE_SVM_RENAME = @x_opCode)) -- Array Rename / Array Interface Rename / Array Migration / SVM Rename
	BEGIN
		INSERT  INTO #tblVolSnapInfo
		-- Map Metadata has been specifically commented out as its not required for SMT
		SELECT  DISTINCT TOP (@x_batchCount) MAP.SMVolSnapMapId, MAP.SMVolumeId, TAI.SMSnapId, 0 /*MAP.MetadataId*/, 0/*AFC.IsValid*/, 0
		FROM    #tblArrayInfo TAI INNER JOIN SMVolSnapMap MAP (NOLOCK) ON TAI.SMSnapId = MAP.SMSnapId
				INNER JOIN SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
			--	INNER JOIN archFileCopy AFC (NOLOCK) ON VOL.CommCellId = AFC.commCellId AND VOL.CopyId = AFC.archCopyId AND VOL.ArchFileId = AFC.archFileId
		WHERE ArrayName = @x_arrayName
			  AND TAI.SMSnapId > @x_snapId
		ORDER BY TAI.SMSnapId
	END
	ELSE IF (@C_OPCODE_FIX_MISSING_SNAP_METADATA = @x_opCode)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#TEMP_SNAP') IS NOT NULL DROP TABLE #TEMP_SNAP
		-- CREATE TEMP TABLE FOR SMSNAP
		-- VOL1 is wrong copy so its mirror# vault so it must have sourcopyid > 0
		-- vol2 is good
		SELECT DISTINCT TOP (@x_batchCount) SNAP.*, MAP.SMVolSnapMapId, MAP.SMVolumeId, VOL1.CopyId, VOL1.ArchFileId , VOL1.jobid
		INTO #TEMP_SNAP
		FROM SMVolume VOL1
			INNER JOIN SMVolSnapMap MAP
				ON VOL1.SMVolumeId = MAP.SMVolumeId
				AND VOL1.apptypeid  = 106
				AND (VOL1.VolumeFlags & CAST(4294967296 AS bigint)) <>  4294967296 /*not VSA V2 */
				AND VOL1.MasterJobId = 0
			INNER JOIN SMSnap SNAP
				ON MAP.SMSnapId =  SNAP.SMSnapId
				AND SNAP.SnapShotEngineId = 3
			INNER JOIN SMMetaData META
				ON META.RefId = SNAP.SMSnapid
				AND META.RefType = 2
			-- we need to have this only for snap copy which has source non zero , basically for replication.
			INNER JOIN archGroupCopy agcopy
				ON agcopy.id = VOL1.CopyId
				AND agcopy.isSnapCopy = 1
				AND agcopy.sourceCopyId > 0
		WHERE
			VOL1.MasterJobId = 0
			AND (( (meta.MetaData  NOT LIKE '%|SP_2_' + cast(vol1.JobId as nvarchar(20))+ '_%'  AND meta.MetaData LIKE '%|SP_2_%') OR meta.MetaData LIKE '%|MISSING_SNAP_%' )
				OR (snap.UniqueIdentifier NOT LIKE 'SP_2_' + cast(vol1.JobId as nvarchar(20))+ '_%' AND (meta.MetaData LIKE '%|SP_2_%' OR meta.MetaData LIKE '%|MISSING_SNAP_%')))
				AND meta.MetaData NOT LIKE  '%|MISSING_SNAP_SKIPPED_VALIDATION_' + cast(vol1.JobId AS NVARCHAR(20)) +'|%'
		ORDER BY
			VOL1.JobId ASC, SNAP.SMSnapID
		--  AND SMMETADATA
		IF OBJECT_ID('tempdb.dbo.#TEMP_SNAPMETADATA') IS NOT NULL DROP TABLE #TEMP_SNAPMETADATA
		-- CREATE TEMP TABLE FOR SMMETADATA
		SELECT DISTINCT TOP (@x_batchCount) SNAP.SMSnapId, MAP.SMVolSnapMapId, VOL1.CopyId , VOL1.SMVolumeId,VOL1.ArchFileId, SNAP.UniqueIdentifier AS currId,
							VOL1.JobId , META.*, 0 AS startpos1, 0 AS startposSnap, 0 AS endpos1
		INTO #TEMP_SNAPMETADATA
		FROM SMVolume VOL1
			INNER JOIN SMVolSnapMap MAP
				ON VOL1.SMVolumeId = MAP.SMVolumeId
				AND VOL1.apptypeid  = 106
				AND (VOL1.VolumeFlags & CAST(4294967296 AS bigint)) <>  4294967296 /*not VSA V2 */
				AND VOL1.MasterJobId = 0
			INNER JOIN SMSnap SNAP
				ON MAP.SMSnapId =  SNAP.SMSnapId
				AND SNAP.SnapShotEngineId = 3
			INNER JOIN smmetadata meta
				ON META.refid = SNAP.smsnapid
				AND META.reftype = 2
			-- we need to have this only for snap copy which has source nON zero , basically for replication.
			INNER JOIN archGroupCopy agcopy
				ON agcopy.id = VOL1.CopyId
				AND agcopy.isSnapCopy = 1
				AND agcopy.sourceCopyId > 0
		WHERE
			VOL1.MasterJobId = 0
			AND (( (meta.MetaData  NOT LIKE '%|SP_2_' + CAST(vol1.JobId AS NVARCHAR(20))+ '_%'  AND meta.MetaData LIKE '%|SP_2_%' ) OR meta.MetaData LIKE '%|MISSING_SNAP_%' )
				OR (snap.UniqueIdentifier NOT LIKE 'SP_2_' + cast(vol1.JobId as nvarchar(20))+ '_%' AND (meta.MetaData LIKE '%|SP_2_%' OR meta.MetaData LIKE '%|MISSING_SNAP_%')))
				AND meta.MetaData NOT LIKE  '%|MISSING_SNAP_SKIPPED_VALIDATION_' + CAST(vol1.JobId AS NVARCHAR(20)) +'|%'
		ORDER BY
			VOL1.JobId ASC, SNAP.SMSnapID
	  --2#3#33|::|Select02VS2|::||..|3#6|::|Select02VS2|SG_SnapESX4_Vol07_Mirror|SP_2_77501_1573635203|/Select02VS2/SG_SnapESX4_Vol07_Mirror/SG_SnapESX4_Vol07_Q1/SG_SnapESX4_Vol07_Q1_LUN1|::||..|
		UPDATE TS
		SET startpos1=CHARINDEX('3#6|::|',  metadata,0)
		FROM #TEMP_SNAPMETADATA TS
		UPDATE TS
		SET startposSnap=CHARINDEX('|SP_2_',  metadata,  startpos1)
		FROM #TEMP_SNAPMETADATA TS
		UPDATE TS
		SET endpos1 = charindex('|',  metadata, startposSnap+1)
		FROM #TEMP_SNAPMETADATA  TS
		UPDATE TS
		SET  metadata = CASE WHEN (TS.startposSnap>0) THEN substring(TS.metadata,0, TS.startposSnap+1) + 'MISSING_SNAP_' + CAST(TS.JobId AS NVARCHAR(20)) + substring(TS.metadata,TS.endpos1,len(TS.metadata)) ELSE TS.MetaData END
		FROM #TEMP_SNAPMETADATA TS
		--select * from #TEMP_SNAPMETADATA
		DECLARE @snapInserted TABLE
		(
			-- Added additional columns for debugging purpose
			SMSnapId  INT, SMSnapId_Updated  INT, SMVolSnapMapId INT, SMVolumeid INT, Copyid INT, ArchFileId int , JobId INT, UniqueIdentifier NVARCHAR(512)
		)
		MERGE INTO SMSnap AS tarSnap
		USING (SELECT DISTINCT * FROM #TEMP_SNAP) AS srcSnap
		ON
			tarsnap.SnapSourceDevice = srcsnap.SnapSourceDevice
			AND tarsnap.ControlHostId = srcsnap.ControlHostId
			AND (tarSnap.UniqueIdentifier LIKE 'SP_2_' + CAST(srcSnap.JobId AS NVARCHAR(20)) + '_%'  OR tarSnap.UniqueIdentifier = 'MISSING_SNAP_' + CAST(srcSnap.JobId AS NVARCHAR(20)) )
		WHEN NOT MATCHED THEN
		INSERT    ([SnapShotEngineId]
					,[OriginalSnapEngineId]
					,[ControlHostId]
					,[GroupId]
					,[SnapType]
					,[SnapFlags]
					,[PruneFlags]
					,[SnapStatus]
					,[SnapStatusUpdateTime]
					,[CreationTime]
					,[ReplicationStatus]
					,[DeviceEntryType]
					,[ConnectionType]
					,[SnapSourceDevice]
					,[SnapDevice]
					,[ShadowCopyId]
					,[UniqueIdentifier]
					,[SourceIdentifier]
					,[TargetIdentifier]
					,[OrigCCId]
					,[GUID]
					,[ReserveField1]
					,[ReserveField2]
					,[ReserveFieldStr]
					,[ArrayVolumeId]
					,[LunId]
					,[UsedSpaceBytes]
					,[ReserveField3]
					,[ReserveField4]
					,[ArraySrcDevice]
					,[ArrayTgtDevice])
				VALUES (
					srcSnap.SnapShotEngineId
					, srcSnap.OriginalSnapEngineId
					,srcSnap.ControlHostId
					,srcSnap.GroupId
					,srcSnap.SnapType
					,srcSnap.SnapFlags
					,srcSnap.PruneFlags
					,srcSnap.SnapStatus
					,srcSnap.SnapStatusUpdateTime
					,srcSnap.CreationTime
					,srcSnap.ReplicationStatus
					,srcSnap.DeviceEntryType
					,srcSnap.ConnectionType
					,srcSnap.SnapSourceDevice
					,srcSnap.SnapDevice
					,srcSnap.ShadowCopyId
					--,srcSnap.UniqueIdentifier
					,'MISSING_SNAP_' + cast(srcSnap.JobId AS NVARCHAR(20))
					,srcSnap.SourceIdentifier
					,TargetIdentifier
					,OrigCCId
					,GUID
					,ReserveField1
					,ReserveField2
					,ReserveFieldStr
					,ArrayVolumeId
					,LunId
					,UsedSpaceBytes
					,ReserveField3
					,ReserveField4
					,ArraySrcDevice
					,ArrayTgtDevice
					)
				WHEN  MATCHED THEN UPDATE SET tarSnap.SnapStatusUpdateTime = srcSnap.SnapStatusUpdateTime , tarSnap.UniqueIdentifier = 'MISSING_SNAP_' + cast(srcSnap.JobId AS NVARCHAR(20))
		OUTPUT  INSERTED.SMSnapId, DELETED.SMSnapId, srcSnap.SMVolSnapMapId ,srcSnap.SMVolumeId,srcSnap.copyid, srcSnap.archfileid, srcSnap.jobid, srcSnap.UniqueIdentifier INTO @snapInserted;
			--select * FROM @snapInserted
			-- update smvolsnapmapid to correct SMSnapId .
			--select * FROM smvolsnapmap map,@snapInserted INS where MAP.SMVolumeId = INS.SMVolumeid AND MAP.SMVolSnapMapId = INS.SMVolSnapMapId
			UPDATE SMVolSnapMap
			SET SMSnapId = INS.SMSnapId
			FROM @snapInserted INS, SMVolSnapMap MAP
			WHERE MAP.SMVolumeId = INS.SMVolumeid
				AND MAP.SMVolSnapMapId = INS.SMVolSnapMapId
			--select * FROM SMVolSnapMap map,@snapInserted INS where MAP.SMVolumeId = INS.SMVolumeid AND MAP.SMVolSnapMapId = INS.SMVolSnapMapId
			--select * FROM #TEMP_SNAPMETADATA
			INSERT  INTO #tblVolSnapInfo
			-- Map Metadata has been specifically commented out AS its not required for SMT
			SELECT  DISTINCT INS.SMVolSnapMapId, INS.SMVolumeId, INS.SMSnapId, 0 /*MAP.MetadataId*/, 0/*AFC.IsValid*/, 0
			FROM    @snapInserted INS
			ORDER BY INS.SMSnapId
			UPDATE #TEMP_SNAPMETADATA
			SET RefId = INS.SMSnapId
			FROM @snapInserted INS,#temp_snapmetadata TMETA
			WHERE TMETA.SMVolumeId = INS.SMVolumeid
				AND TMETA.SMVolSnapMapId = INS.SMVolSnapMapId
				AND refType = 2
				AND TMETA.JobId = INS.jobid
			DECLARE  @metaDataInserted table
			(
				MetaDataId INT, MetaDataId_Updated INT, RefId INT, MetaData NVARCHAR(MAX)
			)
			-- create smmetadata and update refid to correct SMSnapId.
			MERGE INTO [SMMetaData] AS tarMetaData
			USING (SELECT DISTINCT
						 Metadataid
						,MetaDataType
						,RefType
						,RefId
						,PruneFlags
						,MetaData
						,OrigCCId
						,GUID
						,ReserveField1
						,ReserveField2
						,ReserveFieldStr
						,Flags
						 FROM #temp_snapmetadata) AS srcMetaData
				ON srcMetaData.RefId = tarMetaData.RefId AND srcMetaData.RefType = 2 and  srcMetaData.Metadataid = tarMetaData.Metadataid
			WHEN NOT MATCHED THEN
			INSERT		([MetaDataType]
						,[RefType]
						,[RefId]
						,[PruneFlags]
						,[MetaData]
						,[OrigCCId]
						,[GUID]
						,[ReserveField1]
						,[ReserveField2]
						,[ReserveFieldStr]
						,[Flags])
				VALUES (
						MetaDataType
						,RefType
						,RefId
						,PruneFlags
						,MetaData
						,OrigCCId
						,GUID
						,ReserveField1
						,ReserveField2
						,ReserveFieldStr
						,Flags)
		WHEN MATCHED THEN UPDATE SET tarMetaData.MetaData = srcMetaData.MetaData
		OUTPUT INSERTED.MetaDataId, DELETED.MetaDataId, INSERTED.RefId, INSERTED.metadata INTO @metaDataInserted(MetaDataId , MetaDataId_Updated , RefId, MetaData) ;
		-- Add Snap Metadata
		INSERT INTO #tblVolSnapInfo
		SELECT 0, 0, RefId, MetaDataId, 0, 0
		FROM @metaDataInserted
	END
	IF(@C_OPCODE_FIX_MISSING_SNAP_METADATA <> @x_opCode)
	BEGIN
		-- Add Snap Metadata
		INSERT  INTO #tblVolSnapInfo
		SELECT  0, 0, RefId, MetaDataId, 0, 0
		FROM SMMetaData WITH (READUNCOMMITTED)
WHERE   RefType = 2
			AND RefId in (SELECT DISTINCT SMSnapId FROM #tblVolSnapInfo)
	END
    SELECT  SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, IsValidAF, 0, '', 0, 0
    FROM    #tblVolSnapInfo
    order by SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, IsValidAF
	-- Drop all temporary tables.
	IF (OBJECT_ID('tempdb.dbo.#tblVolSnapInfo') IS NOT NULL)
		DROP TABLE #tblVolSnapInfo
	IF (OBJECT_ID('tempdb.dbo.#tblPackedMetadata') IS NOT NULL)
		DROP TABLE #tblPackedMetadata
	IF (OBJECT_ID('tempdb.dbo.#tblMetadataRows') IS NOT NULL)
		DROP TABLE #tblMetadataRows
	IF (OBJECT_ID('tempdb.dbo.#tblMetadata') IS NOT NULL)
		DROP TABLE #tblMetadata
	IF (OBJECT_ID('tempdb.dbo.#tblArrayInfo') IS NOT NULL)
		DROP TABLE #tblArrayInfo
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetVolSnapsSMT')
	delete from GxQscripts where name = 'MM_SMGetVolSnapsSMT'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetVolSnapsSMT')
	delete from GXDBVersions where aliasname = 'MM_SMGetVolSnapsSMT'
GO

insert into GXDBVersions values(2, 'MM_SMGetVolSnapsSMT',  '00010001000200130000', 'MM_SMGetVolSnapsSMT', '00010001000200130000')
GO

