

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetVolSnaps.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetVolSnaps.sp,v $ $Id: MM_SMGetVolSnaps.sp,v 1.37.2.23 2020/05/29 23:59:05 vimalkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMGetVolSnaps')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetVolSnaps <<<'
	drop procedure MM_SMGetVolSnaps
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetVolSnaps')
	delete from GxQscripts where name = 'MM_SMGetVolSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetVolSnaps')
	delete from GXDBVersions where aliasname = 'MM_SMGetVolSnaps'
GO
print '... Creating Procedure: MM_SMGetVolSnaps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetVolSnaps
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_SMVolSnapMapId INTEGER
  DECLARE @o_SMVolumeId INTEGER
  DECLARE @o_SMSnapId INTEGER
  DECLARE @o_MetaDataId INTEGER
  DECLARE @o_IsValidAF INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(MAX)
  DECLARE @o_ReserveParam1 integer
  DECLARE @o_ReserveParam2 integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	-- Input Paramters from XML String
	DECLARE @x_volumeId				INTEGER = 0
	DECLARE @x_volumeId_count		INTEGER = 0
	DECLARE @x_snapId				INTEGER = 0
	DECLARE @x_recoveryPointId		INTEGER = 0
	DECLARE @x_archFileId			INTEGER = 0
	DECLARE @x_archFileId_count		INTEGER = 0
	DECLARE @x_copyParam			INTEGER = 0
	DECLARE @x_copyParamType		INTEGER = 0
	DECLARE @x_snapJobId			INTEGER = 0
	DECLARE @x_sourceClientId		INTEGER = 0
	DECLARE @x_mountHostId			INTEGER = 0
	DECLARE @x_backupSetId			INTEGER = 0
	DECLARE @x_controlHostId		INTEGER = 0
	DECLARE @x_snapEngineId			INTEGER = 0
	DECLARE @x_commCellId			INTEGER = 0
	DECLARE @x_criteriaFlags		BIGINT = 0
	DECLARE @x_validFlags			INTEGER = 0
	DECLARE @x_DbOptEnabled			INTEGER = 0
	DECLARE @x_arrCfgClientId		INTEGER = 0
	DECLARE @x_mountJobId			BIGINT = 0
	-- Local Variables
	DECLARE @l_archGroupId			INTEGER = 0
	DECLARE @l_copyId				INTEGER = 0
	DECLARE @JOBID_NA INTEGER = -123456
	-- Initialize the Output Parameters
	SET @o_SMVolSnapMapId	= 0
	SET @o_SMVolumeId		= 0
	SET @o_SMSnapId			= 0
	SET @o_MetaDataId		= 0
	SET @o_IsValidAF		= 0
	SET @o_ErrorCode		= 0
	SET @o_ErrorStr			= ''
	-- XML Structure for MM_SMGetVolSnaps
	/*
	<MM_SMGetVolSnaps>
		<ValidFlags></ValidFlags>
		<SnapJobId></SnapJobId>
		<ArchFileList>
			<ArchFileCopy
			ArchFileId = "xxx"
			CommCellId = "x"
			CopyId = "xx"/>
			<ArchFileCopy
			ArchFileId = "xxx"
			CommCellId = "x"
			CopyId = "xx"/>
		</ArchFileList>
		<ArchFileId></ArchFileId>
		<CommCellId></CommCellId>
		<CopyParam></CopyParam>
		<CopyParamType></CopyParamType>
		<CriteriaFlags></CriteriaFlags>
		<RecoveryPointId></RecoveryPointId>
		<VolumeList>
			<SMVolume
			SMVolumeId = "xx"/>
			<SMVolume
			SMVolumeId = "xx"/>
		</VolumeList>
		<VolumeId></VolumeId>
		<SnapId></SnapId>
		<SourceClientId></SourceClientId>
		<ControlHostId></ControlHostId>
		<SnapEngineId></SnapEngineId>
		<DbOptEnabled>%d</DbOptEnabled>
		<ConfigsFromClientId><ConfigsFromClientId>
		<MountJobId></MountJobId>
	</MM_SMGetVolSnaps>
	*/
	SET @x_DbOptEnabled = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/DbOptEnabled') R(ref)), 0)
	-- Initialize and set the values for Input Parameters
	SET @x_validFlags = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/ValidFlags') R(ref)), 0)
	IF @x_validFlags = 0
	BEGIN
SELECT	0, 0, 0, 0, 0, 60139, 'Valid Flags used to MM_SMGetVolSnaps SQL SP is zero.', 0, 0
		-- SET @o_ErrorCode = E_MM_SM_SB_EMPTY_VALID_FLAGS
		-- SET @o_ErrorStr = 'Valid Flags used to MM_SMGetVolSnaps SQL SP is zero.'
		RETURN
	END
IF @x_validFlags & 32 = 32
	BEGIN
		SET @x_criteriaFlags = ISNULL(( SELECT R.ref.value('.', 'bigint') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/CriteriaFlags') R(ref)), 0)
		IF @x_criteriaFlags = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60143, 'Snap Action Flags is set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_CRITERIA_FLAGS
			-- SET @o_ErrorStr = 'Snap Action Flags is set as valid but it is zero.'
			RETURN
		END
	END
	-- Table Variables
	IF object_id('tempdb.dbo.#tblVolSnapInfo') IS NOT Null DROP TABLE #tblVolSnapInfo
	CREATE TABLE #tblVolSnapInfo (
			SMVolSnapMapId			INT,
			SMVolumeId				INT,
			SMSnapId				INT,
			MetaDataId				INT,
			IsValidAF				INT,
			IsValidCopy				INT
			)
	IF object_id('tempdb.dbo.#tblVolSnapReconInfo') IS NOT Null DROP TABLE #tblVolSnapReconInfo
	CREATE TABLE #tblVolSnapReconInfo (
			SMVolSnapMapId			INT,
			SMVolumeId				INT,
			SMSnapId				INT,
			MetaDataId				INT,
			ControlHostId			INT,
			ClientId				INT,
			SnapShotEngineId		INT
			)
	-- Check whether its for Snap Reconciliation after Revert (for NetApp)
IF @x_criteriaFlags > 0 AND @x_criteriaFlags & 8192 = 8192
	BEGIN
		IF object_id('tempdb.dbo.#tblSMSnapsToReconcile') IS NOT Null DROP TABLE #tblSMSnapsToReconcile
		CREATE TABLE #tblSMSnapsToReconcile (UniqueIdentifier		nvarchar(1024))
		INSERT	INTO #tblSMSnapsToReconcile
		SELECT	T._ID
FROM	(SELECT replace(dbo.MM_SMGetMetaData( META.Metadata, 42) , '|', ',') AS DATA
				FROM SMMetaData META (NOLOCK)
INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SnapShotEngineId = 3
AND META.RefType = 2 AND META.RefId = SNAP.SMSnapId ) TMP
				CROSS APPLY dbo.SplitIDString(TMP.DATA) T
		INSERT	INTO #tblVolSnapReconInfo
		SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, SNAP.ControlHostId, VOL.SourceClientId, SNAP.SnapShotEngineId
		FROM	SMVolSnapMap MAP WITH (NOLOCK),
				SMVolume VOL WITH (NOLOCK),
				SMSnap SNAP WITH (NOLOCK)
		WHERE	SNAP.UniqueIdentifier IN (SELECT DISTINCT UniqueIdentifier FROM #tblSMSnapsToReconcile)
				AND VOL.SMVolumeId = MAP.SMVolumeId
AND VOL.PruneFlags = 1
AND VOL.SnapSource = 0
				AND SNAP.SMSnapId = MAP.SMSnapId
				AND VOL.SMVolumeId NOT IN ( SELECT DISTINCT SMVolumeId FROM SMVolAction (NOLOCK) )
		-- Get all metadata for snaps
		INSERT	INTO #tblVolSnapReconInfo
		SELECT	DISTINCT 0, 0, RefId, MetaDataId, 0, 0, 0
		FROM	SMMetaData WITH (NOLOCK)
WHERE	RefType = 2
		AND		RefId in (SELECT DISTINCT SMSnapId FROM #tblVolSnapReconInfo)
		SELECT	DISTINCT SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, ControlHostId, 0, '', 0, 0
		FROM	#tblVolSnapReconInfo
		ORDER BY ClientId, ControlHostId, SnapShotEngineId, SMVolumeId, SMSnapId
		GOTO EXIT_CLEANUP
	END
	-- Check whether its for Snap Reconciliation
IF @x_criteriaFlags > 0 AND @x_criteriaFlags & 4 = 4
	BEGIN
		SET @x_controlHostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/ControlHostId') R(ref)), 0)
		IF @x_controlHostId > 0
		BEGIN
			INSERT	INTO #tblVolSnapReconInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, SNAP.ControlHostId, VOL.SourceClientId, SNAP.SnapShotEngineId
			FROM	SMVolSnapMap MAP WITH (READUNCOMMITTED),
					SMVolume VOL WITH (READUNCOMMITTED),
					SMSnap SNAP WITH (READUNCOMMITTED)
			WHERE	VOL.SMVolumeId = MAP.SMVolumeId
AND VOL.PruneFlags = 1
AND VOL.SnapSource = 0
					AND SNAP.SMSnapId = MAP.SMSnapId
					AND SNAP.ControlHostId=@x_controlHostId
		END
		ELSE
		BEGIN
			INSERT	INTO #tblVolSnapReconInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, SNAP.ControlHostId, VOL.SourceClientId, SNAP.SnapShotEngineId
			FROM	SMVolSnapMap MAP WITH (READUNCOMMITTED),
					SMVolume VOL WITH (READUNCOMMITTED),
					SMSnap SNAP WITH (READUNCOMMITTED)
			WHERE	VOL.SMVolumeId = MAP.SMVolumeId
					AND VOL.PruneFlags = 1
					AND VOL.SnapSource = 0
					AND SNAP.SMSnapId = MAP.SMSnapId
		END
		-- Get all metadata for snaps
		INSERT	INTO #tblVolSnapReconInfo
		SELECT	DISTINCT 0, 0, RefId, MetaDataId, 0, 0, 0
		FROM	SMMetaData WITH (READUNCOMMITTED)
WHERE	RefType = 2
		AND		RefId in (SELECT DISTINCT SMSnapId FROM #tblVolSnapReconInfo)
		SELECT	DISTINCT SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, ControlHostId, 0, '', 0, 0
		FROM	#tblVolSnapReconInfo
		ORDER BY ClientId, ControlHostId, SnapShotEngineId, SMVolumeId, SMSnapId
		GOTO EXIT_CLEANUP
	END
	IF object_id('tempdb.dbo.#GVS_tblAFC') IS NOT Null DROP TABLE #GVS_tblAFC
	CREATE TABLE #GVS_tblAFC (archFileId int, commCellId int, copyId int)
IF @x_validFlags & 16384 = 16384
	BEGIN
		INSERT	INTO #GVS_tblAFC
		SELECT	ref.value('@ArchFileId', 'int') AS ArchFileId,
		ref.value('@CommCellId', 'int') AS CommCellId,
		ref.value('@CopyId', 'int') AS CopyId
		FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/ArchFileList/ArchFileCopy') R(ref)
		SET @x_archFileId_count = @@ROWCOUNT
		IF @x_archFileId_count = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60221, 'Arch File Id list is set as valid but there is no input.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_ARCHFILEID
			-- SET @o_ErrorStr = 'Arch File Id list is set as valid but there is no input.'
			GOTO EXIT_CLEANUP
		END
	END
	IF object_id('tempdb.dbo.#GVS_tblVolume') IS NOT Null DROP TABLE #GVS_tblVolume
	CREATE TABLE #GVS_tblVolume (SMVolumeId int)
IF @x_validFlags & 32768 = 32768
	BEGIN
		INSERT	INTO #GVS_tblVolume
		SELECT	ref.value('@SMVolumeId', 'int') AS SMVolumeId
		FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/VolumeList/SMVolume') R(ref)
		SET @x_volumeId_count = @@ROWCOUNT
		IF @x_volumeId_count = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60237, 'Volume list is set as valid but there is no input.', 0, 0
			GOTO EXIT_CLEANUP
		END
	END
	IF object_id('tempdb.dbo.#GVS_tblMountVolume') IS NOT Null DROP TABLE #GVS_tblMountVolume
	CREATE TABLE #GVS_tblMountVolume (SMVolumeId int, SMMountVolumeId int, MountJobId INT)
IF @x_validFlags & 262144 = 262144
	BEGIN
		INSERT	INTO #GVS_tblMountVolume
		SELECT	ref.value('@SMVolumeId', 'int') AS SMVolumeId,
				ref.value('@SMMountVolumeId', 'int') AS SMMountVolumeId,
				0 AS MountJobId
		FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/MountVolumeList/SMMountVolume') R(ref)
		SET @x_volumeId_count = @@ROWCOUNT
		IF @x_volumeId_count = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60237, 'Mount Volume list is set as valid but there is no input.'
			GOTO EXIT_CLEANUP
		END
	END
IF @x_validFlags & 4 = 4
	BEGIN
		SET @x_commCellId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/CommCellId') R(ref)), 0)
		IF @x_commCellId = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60219, 'CommCell Id is set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_COMMCELLID
			-- SET @o_ErrorStr = 'CommCell Id is set as valid but it is zero.'
			GOTO EXIT_CLEANUP
		END
	END
	IF @x_commCellId = 0
		SET @x_commCellId = 2
IF @x_validFlags & 1 = 1
	BEGIN
		SET @x_snapJobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/SnapJobId') R(ref)), 0)
		IF @x_snapJobId = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60140, 'Snap Job Id is set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_SNAP_JOBID
			-- SET @o_ErrorStr = 'Snap Job Id is set as valid but it is zero.'
			GOTO EXIT_CLEANUP
		END
		SELECT	@l_archGroupId = (case when dataArchGrpId > 0 then dataArchGrpId else logArchGrpId end)
		FROM	JMBkpStats WITH (READUNCOMMITTED)
		WHERE	jobId = @x_snapJobId AND @x_commCellId > 0 AND commCellId = @x_commCellId
	END
IF @x_validFlags & 2 = 2
	BEGIN
	SET @x_archFileId		= ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/ArchFileId') R(ref)), 0)
		IF @x_archFileId = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60221, 'Arch File Id is set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_ARCHFILEID
			-- SET @o_ErrorStr = 'Arch File Id is set as valid but it is zero.'
			GOTO EXIT_CLEANUP
		END
		SELECT	@l_archGroupId = archGroupId
		FROM	archFile WITH (READUNCOMMITTED)
		WHERE	id = @x_archFileId AND commCellId = @x_commCellId
	END
IF @x_validFlags & 16 = 16
	BEGIN
	SET @x_copyParamType	= ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/CopyParamType') R(ref)), 0)
		IF @x_copyParamType = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60142, 'Copy Param Type is set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_COPY_PARAM_TYPE
			-- SET @o_ErrorStr = 'Copy Param Type is set as valid but it is zero.'
			GOTO EXIT_CLEANUP
		END
	END
IF @x_validFlags & 8 = 8
	BEGIN
	SET @x_copyParam		= ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/CopyParam') R(ref)), 0)
		IF @x_copyParam = 0 AND @x_copyParamType <> 2
		BEGIN
SELECT	0, 0, 0, 0, 0, 60141, 'Copy Param is set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_COPY_PARAM
			-- SET @o_ErrorStr = 'Copy Param is set as valid but it is zero.'
			GOTO EXIT_CLEANUP
		END
	END
IF @x_validFlags & 64 = 64
	BEGIN
		SET @x_recoveryPointId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/RecoveryPointId') R(ref)), 0)
		IF @x_recoveryPointId = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60144, 'Recovery Point Id is set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_RECOVERY_POINT_ID
			-- SET @o_ErrorStr = 'Recovery Point Id is set as valid but it is zero.'
			GOTO EXIT_CLEANUP
		END
	END
IF @x_validFlags & 128 = 128
	BEGIN
		SET @x_volumeId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/VolumeId') R(ref)), 0)
		IF @x_volumeId = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60237, 'Volume Id is set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_VOLUME_ID
			-- SET @o_ErrorStr = 'Volume Id is set as valid but it is zero.'
			GOTO EXIT_CLEANUP
		END
	END
IF @x_validFlags & 256 = 256
	BEGIN
		SET @x_snapId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/SnapId') R(ref)), 0)
		IF @x_snapId = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60238, 'Snap Id is set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_SNAP_ID
			-- SET @o_ErrorStr = 'Snap Id is set as valid but it is zero.'
			GOTO EXIT_CLEANUP
		END
	END
IF @x_validFlags & 1024 = 1024
	BEGIN
	SET @x_sourceClientId	= ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/SourceClientId') R(ref)), 0)
		IF @x_sourceClientId = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60218, 'Source Client Id is set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_SOURCECLIENTID
			-- SET @o_ErrorStr = 'Source Client Id is set as valid but it is zero.'
			GOTO EXIT_CLEANUP
		END
	END
IF @x_validFlags & 65536 = 65536
	BEGIN
	SET @x_mountHostId	= ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/MountHostId') R(ref)), 0)
		IF @x_mountHostId = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60126, 'Mount Host Id is set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SA_INVALID_MOUNT_HOST_ID
			-- SET @o_ErrorStr = 'Mount Host Id is set as valid but it is zero.'
			GOTO EXIT_CLEANUP
		END
	END
IF @x_validFlags & 131072 = 131072
	BEGIN
	SET @x_backupSetId	= ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/BackupSetId') R(ref)), 0)
		IF @x_backupSetId = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60311, 'Backup Set Id is set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_BACKUPSETID
			-- SET @o_ErrorStr = 'Backup Set Id is set as valid but it is zero.'
			GOTO EXIT_CLEANUP
		END
	END
IF @x_validFlags & 2048 = 2048
	BEGIN
	SET @x_controlHostId	= ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/ControlHostId') R(ref)), 0)
		IF @x_controlHostId = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60295, 'Control Host Id is set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_CONTROLHOSTID
			-- SET @o_ErrorStr = 'Control Host Id is set as valid but it is zero.'
			GOTO EXIT_CLEANUP
		END
	END
IF @x_validFlags & 4096 = 4096
	BEGIN
	SET @x_snapEngineId		= ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/SnapEngineId') R(ref)), 0)
		IF @x_snapEngineId = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60225, 'Snap Engine ID as set as valid but it is zero.', 0, 0
			-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_SNAPSHOTENGINEID
			-- SET @o_ErrorStr = 'Snap Engine ID as set as valid but it is zero.'
			GOTO EXIT_CLEANUP
		END
	END
IF @x_validFlags & 4194304 = 4194304 /* SM_GVS_MOUNTJOBID_VALID */
	BEGIN
	SET @x_mountJobId	= ISNULL(( SELECT R.ref.value('.', 'BIGINT') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/MountJobId') R(ref)), 0)
		IF @x_mountJobId = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60157/*E_MM_SM_SB_INVALID_MOUNT_JOB_ID*/, 'Mount Job Id is set as valid but it is zero.', 0, 0
			GOTO EXIT_CLEANUP
		END
	END
	-- Check whether all the parameters have zero value. If so, error out now
	IF @x_archFileId = 0 AND @x_snapJobId = 0 AND @x_volumeId = 0 AND @x_snapId = 0 AND @x_copyParam = 0 AND
		@x_copyParamType = 0 AND @x_recoveryPointId	= 0 AND @x_commCellId = 0 AND @x_controlHostId = 0 AND
		@x_snapEngineId = 0 AND @x_criteriaFlags = 0
		AND @x_archFileId_count = 0
		AND @x_volumeId_count = 0
	BEGIN
SELECT	0, 0, 0, 0, 0, 60293, 'All the params passed for MM_SMGetVolSnaps are empty', 0, 0
		-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_PARAMS
		-- SET @o_ErrorStr = 'All the params passed for MM_SMGetVolSnaps are empty'
		GOTO EXIT_CLEANUP
	END
	/*VMLTODO*/
	/*ONLY FOR VSA Live-Browse, when sending the AF list with Copy Precedence instead of Copy Id, this is the quick fix for now. Proper fix needs to be done in SP6A*/
	/*In the AF List passed by VSA, they are populating Copy Precedence in the Copy Id field.*/
IF @x_validFlags & 2097152 = 2097152 /*SM_GVS_ARCHFILE_LIST_COPY_PRECEDENCE*/ AND
			@x_copyParam = 0 AND
			-- @x_copyParamType = 2 /*SM_CPT_COPY_PRECEDENCE*/ AND
@x_validFlags & 16384 = 16384 /*SM_GVS_ARCHFILE_LIST_VALID*/ AND
			@x_archFileId_count > 0
	BEGIN
		/*
		VSA sets the Copy Precedence in ArchFile List where Copyid supposed to be passed-up
		So, in #GVS_tblAFC, the column copyId contains the copy precedence
		Using the Passed-in AF Id (one is good enough as discussed with VSA team to know its always belong to same job),
		get the Storage group id and then from the Storage Group, get the corresponding copy id for the passed-in copy precedence
		*/
		DECLARE @tmpArchGrpId INT = 0
		DECLARE @tmpCopyId INT = 0
		SELECT	@tmpArchGrpId = archGroupId
		FROM	archFile WITH (READUNCOMMITTED)
		WHERE	id = (SELECT TOP 1 archFileId FROM #GVS_tblAFC) AND commCellId = @x_commCellId
		SELECT	@tmpCopyId = id
		FROM	archGroupCopy WITH (READUNCOMMITTED)
		WHERE	archGroupid = @tmpArchGrpId
				AND copy = (SELECT TOP 1 copyId FROM #GVS_tblAFC)
				AND isSnapCopy = 1
		UPDATE	#GVS_tblAFC SET copyId = @tmpCopyId
	END
	-- Check whether CopyParamType is given as CopyId and CopyParam is zero
	IF @x_copyParamType = 1 AND @x_copyParam = 0
	BEGIN
		SELECT 0
			,0
			,0
			,0
			,0
,60294
			,'CoypParamType is CopyId however CopyParam is empty'
			,0
			,0
		-- SET @o_ErrorCode = E_MM_SM_SB_INVALID_COPY_DETAILS
		-- SET @o_ErrorStr = 'CoypParamType is CopyId however CopyParam is empty'
		GOTO EXIT_CLEANUP
	END
	--
	-- Normally CopyParam & CopyParamType need to be used in conjunction with ArchFileId
	-- for backup copy we set i_reserveParam to 1 so that we can pick right copyid as ida does not have backup's source copyId information
	-- so they cannt set it , we get it based on sourceCopy for backupcopy or defaultSnap for backup copy.
	--
	--i_reserveParam is set to 1 for backupcopy jobs
	IF @i_reserveParam = 1
	BEGIN
		-- if groupid is not set we get it from archfilecopy using #GVS_tblAFC, instead of snapjobid ( incase of VSAV1 )
		IF @l_archGroupId = 0 AND @x_archFileId_count > 0
		BEGIN
			SELECT	@l_archGroupId = archgroupid
			FROM	archgroupcopy WITH (READUNCOMMITTED)
			WHERE	id = (
						SELECT	TOP 1 archcopyid
						FROM	archFileCopy Afc WITH (READUNCOMMITTED)
								INNER JOIN #GVS_tblAFC tAfc ON tAfc.archFileId = Afc.archFileId
					)
		END
		SELECT @l_copyId = (
				CASE
					WHEN AMS.sourceCopyId = 0
						THEN AG.defaultSnapCopy
					ELSE AMS.sourceCopyId
					END
				)
		FROM archGroup AG WITH (READUNCOMMITTED)
			,archMaterializeSnapshotProp AMS WITH (READUNCOMMITTED)
		WHERE AG.id = @l_archGroupId
			AND AMS.archGroupId = AG.id
		--
		-- Lets update right copy id , its assumed that all afiles will have same copyid.
		-- Only update copyid if its not passed means its set as 0
		--
		IF @x_archFileId_count > 0
		BEGIN
			UPDATE #GVS_tblAFC
			SET copyId = @l_copyId
			WHERE copyId = 0
		END
	END
	--i_reserveParam set to 2 for catalog jobs
	ELSE IF @i_reserveParam = 2
		SELECT @l_copyId = (
				CASE
					WHEN ADCG.sourceCopyId = 0
						THEN AG.defaultSnapCopy
					ELSE ADCG.sourceCopyId
					END
				)
		FROM archGroup AG WITH (READUNCOMMITTED)
			,archdeferredcatalogprop ADCG WITH (READUNCOMMITTED)
		WHERE AG.id = @l_archGroupId
			AND ADCG.archGroupId = AG.id
	ELSE IF @x_copyParamType = 1
		AND @x_copyParam > 0
		SET @l_copyId = @x_copyParam
	ELSE IF @x_copyParam = 0
	BEGIN
		IF @x_snapJobId > 0
		BEGIN
			BEGIN
				DECLARE @l_isNonSnapCopyEntries INT = 0
				IF EXISTS
				(
					SELECT	1
					FROM 	SMSnap SNAP(NOLOCK)
							INNER JOIN SMVolSnapMap MAP(NOLOCK)
								ON MAP.SMSnapId = SNAP.SMSnapId
							INNER JOIN SMVolume VOL(NOLOCK)
								ON VOL.SMVolumeId = MAP.SMVolumeId
					WHERE 	VOL.JobId = @x_snapJobId
AND SNAP.SnapShotEngineId = 53 /*SM_SNAPSHOT_ENGINE_CVBLOCK_SNAP -- Block engine*/
				)
					SET @l_isNonSnapCopyEntries = 1
				IF @l_isNonSnapCopyEntries = 1
				BEGIN /*Case of Block Snap engine with non-Snap Copy & non-Snap Archive File*/
					SET @l_copyId = (
							SELECT TOP 1 Vol.CopyId
							FROM SMVolume Vol WITH (READUNCOMMITTED)
							JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON (Vol.CopyId = AGC.id)
							JOIN ArchFileCopy AFC WITH (READUNCOMMITTED) ON (
									AFC.archFileId = Vol.ArchFileId
									AND AFC.archCopyId = Vol.copyID
									)
							WHERE Vol.JobId = @x_snapJobId
							ORDER BY AGC.copy
							)
				END
				ELSE
				BEGIN
					SET @l_copyId = (
							SELECT TOP 1 Vol.CopyId
							FROM SMVolume Vol WITH (READUNCOMMITTED)
							JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON (Vol.CopyId = AGC.id)
							JOIN ArchFileCopy AFC WITH (READUNCOMMITTED) ON (
									AFC.archFileId = Vol.ArchFileId
									AND AFC.archCopyId = Vol.copyID
									)
							WHERE Vol.JobId = @x_snapJobId
								AND AGC.isSnapCopy = 1
							ORDER BY AGC.copy
							)
				END
			END
		END
		ELSE IF @x_archFileId > 0
		BEGIN
			IF EXISTS
			(
				SELECT	1
				FROM	SMSnap SNAP(NOLOCK)
						INNER JOIN SMVolSnapMap MAP(NOLOCK)
							ON MAP.SMSnapId = SNAP.SMSnapId
						INNER JOIN SMVolume VOL(NOLOCK)
							ON VOL.SMVolumeId = MAP.SMVolumeId
				WHERE	VOL.ArchFileId = @x_archFileId
AND SNAP.SnapShotEngineId = 53 /*SM_SNAPSHOT_ENGINE_CVBLOCK_SNAP -- Block engine*/
			)
				SET @l_isNonSnapCopyEntries = 1
			IF @l_isNonSnapCopyEntries = 1
			BEGIN /*Case of Block Snap engine with non-Snap Copy & non-Snap Archive File*/
				SET @l_copyId = (
						SELECT TOP 1 Vol.CopyId
						FROM SMVolume Vol WITH (READUNCOMMITTED)
						JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON (Vol.CopyId = AGC.id)
						JOIN ArchFileCopy AFC WITH (READUNCOMMITTED) ON (
								AFC.archFileId = Vol.ArchFileId
								AND AFC.archCopyId = Vol.copyID
								)
						WHERE Vol.ArchFileId = @x_archFileId
						ORDER BY AGC.copy
						)
			END
			ELSE
			BEGIN
				SET @l_copyId = (
						SELECT TOP 1 Vol.CopyId
						FROM SMVolume Vol WITH (READUNCOMMITTED)
						JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON (Vol.CopyId = AGC.id)
						JOIN ArchFileCopy AFC WITH (READUNCOMMITTED) ON (
								AFC.archFileId = Vol.ArchFileId
								AND AFC.archCopyId = Vol.copyID
								)
						WHERE Vol.ArchFileId = @x_archFileId
							AND AGC.isSnapCopy = 1
						ORDER BY AGC.copy
						)
			END
		END
		ELSE
		BEGIN
			SELECT @l_copyId = (
					CASE
						WHEN AMS.sourceCopyId = 0
							THEN AG.defaultSnapCopy
						ELSE AMS.sourceCopyId
						END
					)
			FROM archGroup AG WITH (READUNCOMMITTED)
				,archMaterializeSnapshotProp AMS WITH (READUNCOMMITTED)
			WHERE AG.id = @l_archGroupId
				AND AMS.archGroupId = AG.id
		END
	END
	ELSE IF @x_copyParamType = 2
		SELECT @l_copyId = id
		FROM archGroupCopy WITH (READUNCOMMITTED)
		WHERE archGroupid = @l_archGroupId
			AND copy = @x_copyParam
	-- Get Volumes for the given ArchFileId list
	IF @x_archFileId_count > 0
	BEGIN
		IF EXISTS (SELECT 1 FROM #GVS_tblAFC WHERE copyId = 0)
		BEGIN
			UPDATE	TMP
			SET		TMP.copyId = TAFC.CopyId
			FROM	#GVS_tblAFC TMP
					INNER JOIN
					(
						SELECT	VOL.CopyId, AFC.archFileId, AFC.commCellId, ROW_NUMBER()
								OVER (PARTITION BY AFC.archFileId, AFC.commCellId ORDER BY AGC.Copy) AS rowNum
						FROM	#GVS_tblAFC TMPAFC
								INNER JOIN SMVolume VOL (NOLOCK)
									ON TMPAFC.archFileId = VOL.ArchFileId AND TMPAFC.commCellId = VOL.CommCellId
								INNER JOIN archGroupCopy AGC (NOLOCK)
									ON VOL.CopyId = AGC.id
								INNER JOIN archFileCopy AFC (NOLOCK)
									ON AFC.archFileId = VOL.ArchFileId AND AFC.archCopyId = VOL.copyId
									AND AFC.commCellId = VOL.commCellId AND AFC.isValid = 1
					) TAFC
						ON TMP.archFileId = TAFC.archFileId AND TAFC.commCellId = TMP.commCellId AND TAFC.rowNum = 1
		END
		IF EXISTS (SELECT 1 FROM #GVS_tblAFC WHERE copyId = 0)
		BEGIN
SELECT	0, 0, 0, 0, 0, 60294, 'One or more archive files cannot be found on any copy.', 0, 0
			GOTO EXIT_CLEANUP
		END
		-- Find shared physical snaps across peers who are already aux copied to map them with current volume\afile.
		-- Ex: VSA V2 offline replication shares snaps between Data store and child VMs
IF @x_validFlags & 8388608 = 8388608 /* SM_GVS_SHARED_SNAP_V2_REPLICATION = 8388608 */
		BEGIN
			INSERT INTO #tblVolSnapInfo
			SELECT DISTINCT MAP2.SMVolSnapMapId
				,MAP2.SMVolumeId
				,MAP2.SMSnapId
				,MAP2.MetaDataId
				,0
				,0
			FROM SMVolume VOL WITH (READUNCOMMITTED)
			INNER JOIN SMVolSnapMap MAP WITH (READUNCOMMITTED) ON MAP.SMVolumeId = VOL.SMVolumeId 				-- Middle steps to reach snaps for all volumes in VOL.
			INNER JOIN SMSnap SNAP WITH (READUNCOMMITTED) ON SNAP.SMSnapId = MAP.SMSnapId 						-- We have all the snaps , Lets go find snap entries for given archive file.
			INNER JOIN #GVS_tblAFC AFC WITH (READUNCOMMITTED) ON VOL.ArchFileId = AFC.archFileId 				-- Find afile across copies but will get master jobid from this single afile row.
			INNER JOIN SMVolume VOL2 WITH (READUNCOMMITTED) ON VOL2.MasterJobId = VOL.MasterJobId 				-- get all volume rows for that master job id and selected\current copyid ( peers who are already aux copied )
			INNER JOIN SMVolSnapMap MAP2 WITH (READUNCOMMITTED) ON MAP2.SMVolumeId = VOL2.SMVolumeId 			-- Middle steps to reach snaps for all volumes in VOL2.
			INNER JOIN SMSnap SNAP2 WITH (READUNCOMMITTED) ON snap.SnapSourceDevice = SNAP2.SnapSourceDevice 	-- Find only snap entries from peer snaps for current copy which are same as afile snap entry snapsourcedevice.
			WHERE (
					VOL2.CopyId = AFC.copyId 				-- Snap entries for targeted copy ( current peers )
					AND SNAP2.SMSnapId = MAP2.SMSnapId		-- Lets go find snap entries for peers.
					AND VOL.MasterJobId > 0					-- TR=191007-128 without this check V1 jobs are picked and wrong snaps are associated
			)
		END
		ELSE
		BEGIN
			INSERT	INTO #tblVolSnapInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, 0, 0
			FROM	SMVolume VOL WITH (READUNCOMMITTED),
					SMVolSnapMap MAP WITH (READUNCOMMITTED),
					/**/ #GVS_tblAFC AFC
			WHERE	VOL.ArchFileId = AFC.archFileId AND
					VOL.CommCellId = AFC.commCellId AND
					VOL.CopyId = AFC.CopyId AND
					MAP.SMVolumeId = VOL.SMVolumeId
		END
	END
	-- Get Volumes for the given volume list
	IF @x_volumeId_count > 0
	BEGIN
		INSERT	INTO #tblVolSnapInfo
		SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, 0, 0
		FROM	SMVolume VOL WITH (READUNCOMMITTED),
				SMVolSnapMap MAP WITH (READUNCOMMITTED),
				/**/#GVS_tblVolume tVol
		WHERE	VOL.SMVolumeId = tVol.SMVolumeId AND
				MAP.SMVolumeId = VOL.SMVolumeId
	END
	-- Check whether its for Snap On-Demand Pruning
IF @x_criteriaFlags > 0 AND @x_criteriaFlags & 1024 = 1024
	BEGIN
		INSERT	INTO #tblVolSnapInfo
		SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, AF.isValid, 0
		FROM	SMVolume VOL WITH (READUNCOMMITTED),
				ArchFile AF WITH (READUNCOMMITTED),
				SMVolSnapMap MAP WITH (READUNCOMMITTED),
				SMSnap SNAP WITH (READUNCOMMITTED)
		WHERE	VOL.JobId = @x_snapJobId
				AND VOL.CommCellId = @x_commCellId
				AND VOL.ArchFileId = AF.id
				AND VOL.CommCellId = AF.commCellId
				AND AF.isValid <> 1
				AND MAP.SMVolumeId = VOL.SMVolumeId
				AND SNAP.SMSnapId = MAP.SMSnapId
				AND (SNAP.ControlHostId > 0 OR SNAP.SnapShotEngineId = 1)
		GOTO GET_METADATA
	END
	-- To extract Clone Env
ELSE IF @x_criteriaFlags > 0 AND @x_criteriaFlags & 131072 = 131072
	BEGIN
		IF @x_recoveryPointId > 0 -- instance > 0
		BEGIN
			INSERT INTO #tblVolSnapInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MV.id, MS.id, MMAP.MetaDataId, 0, 0
			FROM	SMVolume SMV WITH (READUNCOMMITTED)
					INNER JOIN SMMountvolume MV WITH (READUNCOMMITTED)
						ON (SMV.SMVolumeId = MV.SMVolumeId)
					JOIN APP_Application APP WITH (READUNCOMMITTED) ON (APP.id = SMV.AppId)
					INNER JOIN SMVolSnapMap MAP WITH (READUNCOMMITTED) ON (MAP.SMVolumeId = MV.SMVolumeId)
					INNER JOIN SMMountSnap MS WITH (READUNCOMMITTED) ON (MS.SMSnapId = MAP.SMSnapId
						AND MV.MountJobId = MS.ReserveField4
						AND MV.CreationTime = MS.CreationTime)
					INNER JOIN SMMountMap MMAP (NOLOCK)
						ON MMAP.SMMountVolumeId = MV.Id AND MMAP.SMMountSnapId = MS.Id
						AND MMAP.SMVolSnapMapId = MAP.SMVolSnapMapId
						AND APP.instance = @x_recoveryPointId
						AND SMV.SourceClientId = @x_sourceClientId
						AND MV.MountHostId = @x_mountHostId
AND MV.MountStatus < 79
		END
		ELSE IF @x_backupSetId > 0 -- appId > 0
		BEGIN
			INSERT	INTO #tblVolSnapInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MV.id, MS.id, MMAP.MetaDataId, 0, 0
			FROM	SMVolume SMV WITH (READUNCOMMITTED)
					INNER JOIN SMMountvolume MV WITH (READUNCOMMITTED)
						ON (SMV.SMVolumeId = MV.SMVolumeId)
					JOIN APP_Application APP WITH (READUNCOMMITTED) ON (APP.id = SMV.AppId)
					INNER JOIN SMVolSnapMap MAP WITH (READUNCOMMITTED) ON (MAP.SMVolumeId = MV.SMVolumeId)
					INNER JOIN SMMountSnap MS WITH (READUNCOMMITTED) ON (MS.SMSnapId = MAP.SMSnapId
						AND MV.MountJobId = MS.ReserveField4
						AND MV.CreationTime = MS.CreationTime)
					INNER JOIN SMMountMap MMAP (NOLOCK) ON MMAP.SMMountVolumeId = MV.Id
						AND MMAP.SMMountSnapId = MS.Id AND MMAP.SMVolSnapMapId = MAP.SMVolSnapMapId
						AND APP.id = @x_backupSetId
						AND SMV.SourceClientId = @x_sourceClientId
						AND MV.MountHostId = @x_mountHostId
AND MV.MountStatus < 79
		END
		ELSE IF @x_mountJobId > 0
		BEGIN
			INSERT	INTO #tblVolSnapInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MV.id, MS.id, MMAP.MetaDataId, 0, 0
			FROM	SMMountvolume MV (READUNCOMMITTED)
					INNER JOIN SMVolume SMV (READUNCOMMITTED)
						ON (SMV.SMVolumeId = MV.SMVolumeId
						AND MV.MountJobId = @x_mountJobId )
					INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED)ON (MAP.SMVolumeId = MV.SMVolumeId)
					INNER JOIN SMMountSnap MS (READUNCOMMITTED) ON (MS.SMSnapId = MAP.SMSnapId
						AND MV.MountJobId = MS.ReserveField4)
					INNER JOIN SMMountMap MMAP (READUNCOMMITTED) ON MMAP.SMMountVolumeId = MV.Id
						AND MMAP.SMMountSnapId = MS.Id AND MMAP.SMVolSnapMapId = MAP.SMVolSnapMapId
WHERE	MV.MountStatus < 79
					AND
					(/* Choose Parent/Child of AppAware TestClone Mount */
MV.MountFlags & 262144/*CVSM_VOLUMEFLAGS_VSA_VSA_SNAP_DB */ =
(CASE WHEN (@x_criteriaFlags& CAST(8589934592 AS BIGINT) > 0)
THEN 262144 /*CVSM_VOLUMEFLAGS_VSA_VSA_SNAP_DB */
							ELSE 0
						END)
					)
		END
		ELSE
		BEGIN
SELECT	0, 0, 0, 0, 0, 60312, 'Invalid Parameters to get Clone Env. Instance, AppId and MountJobId are zero.', 0, 0
			GOTO EXIT_CLEANUP
		END
		SELECT	DISTINCT SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, IsValidAF, 0, '', 0, 0
		FROM	#tblVolSnapInfo
		ORDER BY SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, IsValidAF
		GOTO EXIT_CLEANUP
	END
	-- To get clone details for GUI operations
	ELSE IF (@x_criteriaFlags > 0 AND
((@x_criteriaFlags & 2048 = 2048) OR
(@x_criteriaFlags & 1073741824 = 1073741824)))
	BEGIN
		DECLARE @isSCSIMount INT = 0
		SELECT @isSCSIMount = 1
		FROM #GVS_tblMountVolume TMP
			INNER JOIN SMMountVolume MVOL (NOLOCK) ON TMP.SMMountVolumeId = MVOL.Id
WHERE MountFlags & (32 | 64) > 0
IF @isSCSIMount = 0 AND @x_criteriaFlags & 512 = 512
		BEGIN
			UPDATE	#GVS_tblMountVolume
			SET		MountJobId = MV.MountJobId
			FROM	#GVS_tblMountVolume TMV
					INNER JOIN SMMountVolume MV (NOLOCK) ON MV.Id = TMV.SMMountVolumeId
						AND MV.SMVolumeId = TMV.SMVolumeId
			-- if atleast one volume is a live browse mount ( Job Id -123456) link the volumes using MountMetadataId instead of JobId
			IF EXISTS (SELECT 1 FROM #GVS_tblMountVolume WHERE MountJobId=@JOBID_NA)
			BEGIN
				INSERT	INTO #GVS_tblMountVolume
				SELECT	DISTINCT MVOL.SMVolumeId,MVOL.Id,MVOL.MountJobId
				FROM
						(
							SELECT	DISTINCT MMAP.MountMetaDataId
							FROM	#GVS_tblMountVolume TMV
									JOIN SMMountMap MMAP (NOLOCK) ON TMV.SMMountVolumeId=MMAP.SMMountVolumeId
						) TMP_MD
						JOIN SMMountMap MMAP2 (NOLOCK) ON MMAP2.MountMetaDataId=TMP_MD.MountMetaDataId
						JOIN SMMountVolume MVOL (NOLOCK) ON MVOL.id=MMAP2.SMMountVolumeId
						LEFT JOIN #GVS_tblMountVolume TMV2 ON TMV2.SMMountVolumeId=MVOL.id
				WHERE	TMV2.SMMountVolumeId IS NULL
			END
			ELSE
			BEGIN
				INSERT	INTO #GVS_tblMountVolume
				SELECT	DISTINCT MV.SMVolumeId, MV.Id, MV.MountJobId
				FROM	SMMountVolume MV (NOLOCK)
						INNER JOIN #GVS_tblMountVolume TMV ON MV.MountJobId = TMV.MountJobId
				WHERE	MV.Id NOT IN (SELECT DISTINCT SMMountVolumeId FROM #GVS_tblMountVolume)
			END
		END
		IF EXISTS (SELECT 1 FROM #GVS_tblMountVolume)
		BEGIN
			DELETE FROM #tblVolSnapInfo
			INSERT INTO #tblVolSnapInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MV.id, MS.id, MMAP.MetaDataId, 0, 0
			FROM 	SMVolume SMV (NOLOCK)
					INNER JOIN SMMountvolume MV (NOLOCK)
						ON (SMV.SMVolumeId = MV.SMVolumeId)
					INNER JOIN SMVolSnapMap MAP (NOLOCK) ON (MAP.SMVolumeId = MV.SMVolumeId)
					INNER JOIN SMMountSnap MS (NOLOCK) ON (MS.SMSnapId = MAP.SMSnapId
						AND MV.MountJobId = MS.ReserveField4
						AND MV.CreationTime = MS.CreationTime)
					INNER JOIN SMMountMap MMAP (NOLOCK) ON MMAP.SMMountVolumeId = MV.Id AND MMAP.SMMountSnapId = MS.Id
						AND MMAP.SMVolSnapMapId = MAP.SMVolSnapMapId
					INNER JOIN #GVS_tblMountVolume MVOL ON MV.Id = MVOL.SMMountVolumeId AND MVOL.SMVolumeId = MV.SMVolumeId
						--AND MV.MountStatus = SM_VS_MNT_MOUNTED
		END
		ELSE
		BEGIN
SELECT	0, 0, 0, 0, 0, 60312, 'Invalid Parameters to get Clone Details. Both SMVolumeId and MountVolumeId are empty.', 0, 0
			GOTO EXIT_CLEANUP
		END
		SELECT	DISTINCT SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, IsValidAF, 0, '', 0, 0
		FROM	#tblVolSnapInfo
		ORDER BY SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, IsValidAF
		GOTO EXIT_CLEANUP
	END
	-- Check whether its Array Configs
ELSE IF @x_criteriaFlags > 0 AND @x_criteriaFlags & 16384 = 16384
	BEGIN
		SET @x_arrCfgClientId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetVolSnaps/ConfigsFromClientId') R(ref)), 0)
		DECLARE @arrayConfigs NVARCHAR(MAX) = N''
		DECLARE @xmlArrayConfigsReq NVARCHAR(1024) = N''
		SELECT	@xmlArrayConfigsReq = N'<EVGui_MMSMGetArrayDetailsReq assocType="9" flags="1" copyId="' + CAST ( @x_copyParam AS NVARCHAR(16) ) +
										N'" appId="' + CAST ( @x_recoveryPointId AS NVARCHAR(16) ) + N'"' + CASE WHEN @x_arrCfgClientId > 0 THEN (' clientId="' + CAST(@x_arrCfgClientId AS NVARCHAR(16)) + '"') ELSE '' END +
										N'><array id="' + CAST ( @x_controlHostId AS NVARCHAR(16) ) +
										N'"/></EVGui_MMSMGetArrayDetailsReq>'
		EXEC @arrayConfigs = dbo.MM_SMXMLGetArrayDetails @xmlArrayConfigsReq, 1
		-- SELECT	0, 0, 0, 0, 0, 0, @arrayConfigs
		GOTO EXIT_CLEANUP
	END
	-- Get Volumes for the given SnapEngineId
	IF @x_snapEngineID > 0
	BEGIN
			IF NOT EXISTS (SELECT 1 FROM #tblVolSnapInfo)
			BEGIN
				IF @x_controlHostId = 0
				BEGIN
					INSERT	INTO #tblVolSnapInfo
					SELECT	DISTINCT 0, 0, MAP.SMSnapId, 0, 0, 0
					FROM	SMSnap SNAP WITH (READUNCOMMITTED),
							SMVolSnapMap MAP WITH (READUNCOMMITTED),
							SMVolume VOL WITH (READUNCOMMITTED)
					WHERE
						(
						SNAP.SnapShotEngineId = @x_snapEngineID
						OR
							(
@x_snapEngineID IN (28 /*SM_SNAPSHOT_ENGINE_SYMMETRIX_CLONE*/, 47/*SM_SNAPSHOT_ENGINE_SYMMETRIX_VP_SNAP*/, 4/*SM_SNAPSHOT_ENGINE_SYMMETRIX)*/)
AND SNAP.SnapShotEngineId IN (28 /*SM_SNAPSHOT_ENGINE_SYMMETRIX_CLONE*/, 47/*SM_SNAPSHOT_ENGINE_SYMMETRIX_VP_SNAP*/, 4/*SM_SNAPSHOT_ENGINE_SYMMETRIX*/)
							)
							OR
							(
@x_snapEngineID IN (29 /*SM_SNAPSHOT_ENGINE_ETERNUS_SNAP*/, 30/*SM_SNAPSHOT_ENGINE_ETERNUS_CLONE*/, 41/*SM_SNAPSHOT_ENGINE_ETERNUS_SNAPOPCPLUS)*/)
AND SNAP.SnapShotEngineId IN (29 /*SM_SNAPSHOT_ENGINE_ETERNUS_SNAP*/, 30/*SM_SNAPSHOT_ENGINE_ETERNUS_CLONE*/, 41/*SM_SNAPSHOT_ENGINE_ETERNUS_SNAPOPCPLUS)*/)
							)
						)
						AND
						MAP.SMSnapId = SNAP.SMSnapId AND
						VOL.SMVolumeId = MAP.SMVolumeId AND
						VOL.CommCellId = @x_commCellId
				END
				ELSE
				BEGIN
					INSERT	INTO #tblVolSnapInfo
					SELECT	DISTINCT 0, 0, MAP.SMSnapId, 0, 0, 0
					FROM	SMSnap SNAP WITH (READUNCOMMITTED),
							SMVolSnapMap MAP WITH (READUNCOMMITTED),
							SMVolume VOL WITH (READUNCOMMITTED)
					WHERE
							(
							SNAP.SnapShotEngineId = @x_snapEngineID
							OR
							(
@x_snapEngineID IN (28 /*SM_SNAPSHOT_ENGINE_SYMMETRIX_CLONE*/, 47/*SM_SNAPSHOT_ENGINE_SYMMETRIX_VP_SNAP*/, 4/*SM_SNAPSHOT_ENGINE_SYMMETRIX)*/)
AND SNAP.SnapShotEngineId IN (28 /*SM_SNAPSHOT_ENGINE_SYMMETRIX_CLONE*/, 47/*SM_SNAPSHOT_ENGINE_SYMMETRIX_VP_SNAP*/, 4/*SM_SNAPSHOT_ENGINE_SYMMETRIX*/)
							)
								OR
								(
@x_snapEngineID IN (29 /*SM_SNAPSHOT_ENGINE_ETERNUS_SNAP*/, 30/*SM_SNAPSHOT_ENGINE_ETERNUS_CLONE*/, 41/*SM_SNAPSHOT_ENGINE_ETERNUS_SNAPOPCPLUS)*/)
AND SNAP.SnapShotEngineId IN (29 /*SM_SNAPSHOT_ENGINE_ETERNUS_SNAP*/, 30/*SM_SNAPSHOT_ENGINE_ETERNUS_CLONE*/, 41/*SM_SNAPSHOT_ENGINE_ETERNUS_SNAPOPCPLUS)*/)
								)
							)
							AND
							MAP.SMSnapId = SNAP.SMSnapId AND
							VOL.SMVolumeId = MAP.SMVolumeId AND
							VOL.CommCellId = @x_commCellId AND
								SNAP.ControlHostId = @x_controlHostId
				END
			END
			ELSE
			BEGIN
				DELETE	FROM #tblVolSnapInfo
				FROM	#tblVolSnapInfo VOLSNAP,
						SMSnap SNAP WITH (READUNCOMMITTED)
				WHERE	SNAP.SMSnapId = VOLSNAP.SMSnapId AND
						( (SNAP.SnapShotEngineId != @x_snapEngineID) OR
						( @x_controlHostId !=0 AND SNAP.ControlHostId != @x_controlHostId ) )
			END
		END
	-- Get Volumes for the given ControlHostId
	IF @x_controlHostId > 0 AND @x_snapEngineID = 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM #tblVolSnapInfo)
		BEGIN
			INSERT	INTO #tblVolSnapInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, 0, 0
			FROM	SMSnap SNAP WITH (READUNCOMMITTED),
					SMVolSnapMap MAP WITH (READUNCOMMITTED),
					SMVolume VOL WITH (READUNCOMMITTED)
			WHERE	SNAP.ControlHostId = @x_controlHostId AND
					MAP.SMSnapId = SNAP.SMSnapId AND
					VOL.SMVolumeId = MAP.SMVolumeId AND
					VOL.CommCellId = @x_commCellId
		END
		ELSE
		BEGIN
			DELETE	FROM #tblVolSnapInfo
			FROM	#tblVolSnapInfo VOLSNAP,
					SMSnap SNAP WITH (READUNCOMMITTED),
					SMVolume VOL WITH (READUNCOMMITTED)
			WHERE	SNAP.SMSnapId = VOLSNAP.SMSnapId AND
					SNAP.ControlHostId != @x_controlHostId AND
					VOL.SMVolumeId = VOLSNAP.SMVolumeId AND
					VOL.CommCellId = @x_commCellId
		END
	END
	-- Get Volumes for the given SourceClientId
	IF @x_sourceClientId > 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM #tblVolSnapInfo)
		BEGIN
			INSERT	INTO #tblVolSnapInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, 0, 0
			FROM	SMVolume VOL WITH (READUNCOMMITTED),
					SMVolSnapMap MAP WITH (READUNCOMMITTED)
			WHERE	VOL.SourceClientId = @x_sourceClientId AND
					VOL.CommCellId = @x_commCellId AND
					MAP.SMVolumeId = VOL.SMVolumeId
		END
		ELSE
		BEGIN
			DELETE	FROM #tblVolSnapInfo
			FROM	#tblVolSnapInfo VOLSNAP,
					SMVolume VOL WITH (READUNCOMMITTED)
			WHERE	VOL.SMVolumeId = VOLSNAP.SMVolumeId AND
					VOL.SourceClientId != @x_sourceClientId AND
					VOL.CommCellId = @x_commCellId
		END
	END
	-- Get Volumes for the given SnapJobId
	IF @x_snapJobId > 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM #tblVolSnapInfo)
		BEGIN
			INSERT	INTO #tblVolSnapInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, 0, 0
			FROM	SMVolume VOL WITH (READUNCOMMITTED),
					SMVolSnapMap MAP WITH (READUNCOMMITTED)
			WHERE	VOL.JobId = @x_snapJobId AND
					VOL.CommCellId = @x_commCellId AND
					MAP.SMVolumeId = VOL.SMVolumeId
		END
		ELSE
		BEGIN
			DELETE	FROM #tblVolSnapInfo
			FROM	#tblVolSnapInfo VOLSNAP,
					SMVolume VOL WITH (READUNCOMMITTED)
			WHERE	VOL.SMVolumeId = VOLSNAP.SMVolumeId AND
					VOL.JobId != @x_snapJobId AND
					VOL.CommCellId = @x_commCellId
		END
	END
	-- Get Volumes for the given CopyId
	IF @l_copyId > 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM #tblVolSnapInfo)
		BEGIN
			INSERT	INTO #tblVolSnapInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, 0, 0
			FROM	SMVolume VOL WITH (READUNCOMMITTED),
					SMVolSnapMap MAP WITH (READUNCOMMITTED)
			WHERE	VOL.CopyId = @l_copyId AND
					VOL.CommCellId = @x_commCellId AND
					MAP.SMVolumeId = VOL.SMVolumeId
		END
		ELSE
		BEGIN
			DELETE	FROM #tblVolSnapInfo
			FROM	#tblVolSnapInfo VOLSNAP,
					SMVolume VOL WITH (READUNCOMMITTED)
			WHERE	VOL.SMVolumeId = VOLSNAP.SMVolumeId AND
					VOL.CopyId != @l_copyId AND
					VOL.CommCellId = @x_commCellId
		END
	END
	-- Get Volumes for the given ArchFileId
	IF @x_archFileId > 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM #tblVolSnapInfo)
		BEGIN
			INSERT	INTO #tblVolSnapInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, 0, 0
			FROM	SMVolume VOL WITH (READUNCOMMITTED),
					SMVolSnapMap MAP WITH (READUNCOMMITTED)
			WHERE	VOL.ArchFileId = @x_archFileId AND
					VOL.CommCellId = @x_commCellId AND
					MAP.SMVolumeId = VOL.SMVolumeId
		END
		ELSE
		BEGIN
			DELETE	FROM #tblVolSnapInfo
			FROM	#tblVolSnapInfo VOLSNAP,
					SMVolume VOL WITH (READUNCOMMITTED)
			WHERE	VOL.SMVolumeId = VOLSNAP.SMVolumeId AND
					VOL.ArchFileId != @x_archFileId AND
					VOL.CommCellId = @x_commCellId
		END
	END
	-- Get Volumes for the given RecoveryPointId
	IF @x_recoveryPointId > 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM #tblVolSnapInfo)
		BEGIN
			INSERT	INTO #tblVolSnapInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, 0, 0
			FROM	SMVolume VOL WITH (READUNCOMMITTED),
					SMVolSnapMap MAP WITH (READUNCOMMITTED)
			WHERE	VOL.RecoveryPointId = @x_recoveryPointId AND
					VOL.CommCellId = @x_commCellId AND
					MAP.SMVolumeId = VOL.SMVolumeId
		END
		ELSE
		BEGIN
			DELETE	FROM #tblVolSnapInfo
			FROM	#tblVolSnapInfo VOLSNAP,
					SMVolume VOL WITH (READUNCOMMITTED)
			WHERE	VOL.SMVolumeId = VOLSNAP.SMVolumeId AND
					VOL.RecoveryPointId != @x_recoveryPointId AND
					VOL.CommCellId = @x_commCellId
		END
	END
	-- Get Volumes for the given SnapId
	IF @x_snapId > 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM #tblVolSnapInfo)
		BEGIN
			-- For Getting Base Snaps for Deletion
IF @x_criteriaFlags & 256 = 256
				INSERT	INTO #tblVolSnapInfo
				SELECT	DISTINCT MAP2.SMVolSnapMapId, 0, MAP2.SMSnapId, 0, 0, 0
				FROM	SMSnap SNAP1 WITH (READUNCOMMITTED),
						SMSnap SNAP2 WITH (READUNCOMMITTED),
						SMVolSnapMap MAP1 WITH (READUNCOMMITTED),
						SMVolSnapMap MAP2 WITH (READUNCOMMITTED)
				WHERE	MAP1.SMSnapId = @x_snapId
						AND SNAP1.SMSnapId = MAP1.SMSnapId
AND SNAP1.SnapFlags & 4096 = 4096
						AND MAP1.SMVolumeId = MAP2.SMVolumeId
						AND SNAP2.SMSnapId = MAP2.SMSnapId
AND SNAP2.SnapFlags & 2048 = 2048
			ELSE
				INSERT	INTO #tblVolSnapInfo
				SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, 0, 0
				FROM	SMSnap SNAP WITH (READUNCOMMITTED),
						SMVolSnapMap MAP WITH (READUNCOMMITTED),
						SMVolume VOL WITH (READUNCOMMITTED)
				WHERE	SNAP.SMSnapId = @x_snapId AND
						MAP.SMSnapId = SNAP.SMSnapId AND
						VOL.SMVolumeId = MAP.SMVolumeId AND
						VOL.CommCellId = @x_commCellId
		END
		ELSE
		BEGIN
			DELETE	FROM #tblVolSnapInfo
			FROM	#tblVolSnapInfo VOLSNAP,
					SMVolume VOL WITH (READUNCOMMITTED)
			WHERE	VOLSNAP.SMSnapId != @x_snapId AND
					VOL.SMVolumeId = VOLSNAP.SMVolumeId AND
					VOL.CommCellId = @x_commCellId
		END
	END
	-- Get Volumes for the given VolumeId
	IF @x_volumeId > 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM #tblVolSnapInfo)
		BEGIN
			INSERT	INTO #tblVolSnapInfo
			SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, 0, 0
			FROM	SMVolume VOL WITH (READUNCOMMITTED),
					SMVolSnapMap MAP WITH (READUNCOMMITTED)
			WHERE	VOL.SMVolumeId = @x_volumeId AND
					VOL.CommCellId = @x_commCellId AND
					MAP.SMVolumeId = VOL.SMVolumeId
		END
		ELSE
		BEGIN
			DELETE	FROM #tblVolSnapInfo
			FROM	#tblVolSnapInfo VOLSNAP,
					SMVolume VOL WITH (READUNCOMMITTED)
			WHERE	VOL.SMVolumeId = VOLSNAP.SMVolumeId AND
					VOLSNAP.SMVolumeId != @x_volumeId AND
					VOL.CommCellId = @x_commCellId
		END
	END
	-- Filter out Job IDs not matching passed Job ID
	IF @x_snapJobId > 0
	BEGIN
		DELETE	FROM #tblVolSnapInfo
		FROM	#tblVolSnapInfo VOLSNAP,
				SMVolume VOL WITH (READUNCOMMITTED)
		WHERE	VOL.SMVolumeId = VOLSNAP.SMVolumeId AND
				VOL.JobId != @x_snapJobId AND
				VOL.CommCellId = @x_commCellId
	END
	-- Update ArchFile Details
	UPDATE	#tblVolSnapInfo
	SET		IsValidAF = AF.isValid, IsValidCopy = AFC.isValid
	FROM	archFile AF WITH(READUNCOMMITTED), SMVolume VOL WITH(READUNCOMMITTED), #tblVolSnapInfo VOLSNAP, archFileCopy AFC WITH(READUNCOMMITTED)
	WHERE	VOL.SMVolumeId = VOLSNAP.SMVolumeId AND
			AF.id = VOL.ArchFileId AND
			AF.commCellId = VOL.CommCellId AND
			AFC.archFileId = VOL.ArchFileId AND
			AFC.commCellId = VOL.CommCellId AND
			AFC.archCopyId = VOL.CopyId
	-- ArchFile should be considered invalid if the archfilecopy record is invalid
	UPDATE	#tblVolSnapInfo SET IsValidAF = IsValidCopy
	WHERE	IsValidCopy <> 1
	-- Check whether only Volumes with valid Archive Files need to be fetched
IF @x_criteriaFlags & 2 = 2
		DELETE	FROM #tblVolSnapInfo WHERE	IsValidAF <> 1
	-- Check whether only recovery snaps are returned and not base snaps
IF @x_criteriaFlags & 256 <> 256
		DELETE	FROM #tblVolSnapInfo
		FROM	#tblVolSnapInfo VOLSNAP, SMSnap SNAP WITH (READUNCOMMITTED)
		WHERE	VOLSNAP.SMSnapId = SNAP.SMSnapId
AND SNAP.SnapFlags & 2048 = 2048
	-- Check whether its CDR/DDR. If so, get all volumes/maps for the associated Snaps
	DECLARE @l_snapEngineId INTEGER = 0
	SELECT	@l_snapEngineId = SnapShotEngineId FROM SMSnap WITH(READUNCOMMITTED)
	WHERE 	SMSnapId = (SELECT TOP 1 SMSnapId FROM #tblVolSnapInfo)
IF @l_snapEngineId = 11 OR
@l_snapEngineId = 10 OR
@l_snapEngineId = 15
	BEGIN
IF @x_criteriaFlags & 512 = 512
		BEGIN
			DECLARE @tblTmpVolSnapInfo TABLE
			(	SMVolSnapMapId int,
				SMVolumeId int,
				SMSnapId int,
				MetaDataId int,
				IsValidAF int,
				isValidCopy integer)
			INSERT	INTO @tblTmpVolSnapInfo
			SELECT	DISTINCT SMMAP.SMVolSnapMapId, SMMAP.SMVolumeId, SMMAP.SMSnapId, SMMAP.MetaDataId, 0, 0
			FROM	SMVolSnapMap SMMAP WITH (READUNCOMMITTED)
			WHERE	SMMAP.SMSnapId IN (SELECT DISTINCT SMSnapId FROM #tblVolSnapInfo)
			UPDATE	@tblTmpVolSnapInfo
			SET		IsValidAF = AF.isValid, isValidCopy = AFC.isValid
			FROM	archFile AF WITH(READUNCOMMITTED), SMVolume SV WITH(READUNCOMMITTED), @tblTmpVolSnapInfo TVS, archFileCopy AFC WITH(READUNCOMMITTED)
			WHERE	SV.SMVolumeId = TVS.SMVolumeId AND
					AF.id = SV.ArchFileId AND
					AFC.archCopyId = SV.CopyId AND
					AFC.commCellId = SV.CommCellId
			INSERT INTO #tblVolSnapInfo
			SELECT * FROM @tblTmpVolSnapInfo
		END
	END
	-- AMFAM - Shared Volumes using Snap Consistency Group
	-- Check whether the volume(s) belongs to Snap Consistency Group (SCG)
	DECLARE	@l_scgCount INTEGER = 0
	SELECT	@l_scgCount = COUNT(DISTINCT RecoveryPointId)
	FROM	SMVolume WITH(READUNCOMMITTED)
	WHERE	SMVolumeId IN (SELECT DISTINCT SMVolumeId FROM #tblVolSnapInfo)
AND AppTypeId = 22
AND (VolumeFlags & 8192 = 8192)
	IF @l_scgCount > 1
	BEGIN
IF @x_validFlags & 4096 != 4096
		BEGIN
			SELECT	0, 0, 0, 0, 0, 60125, 'Volumes belonging different Snap Consistent Group(s) or non-Snap Consistent Group(s).', 0, 0
			GOTO EXIT_CLEANUP
		END
	END
	DECLARE	@l_scgId INTEGER = 0
	SELECT	DISTINCT @l_scgId = RecoveryPointId
	FROM	SMVolume WITH(READUNCOMMITTED)
	WHERE	SMVolumeId IN (SELECT DISTINCT SMVolumeId FROM #tblVolSnapInfo)
AND AppTypeId = 22
AND (VolumeFlags & 8192 = 8192)
	IF @l_scgId > 0
	BEGIN
		DECLARE @tblJobs TABLE (JobId INTEGER)
		INSERT	INTO @tblJobs
		SELECT	DISTINCT JobId FROM SMVolume WITH(READUNCOMMITTED) WHERE SMVolumeId IN (SELECT DISTINCT SMVolumeId FROM #tblVolSnapInfo)
		DECLARE @tblMetaDataIds TABLE (MetaDataId INTEGER)
		INSERT	INTO @tblMetaDataIds
		SELECT	DISTINCT MetaDataId FROM #tblVolSnapInfo
		DELETE	FROM @tblTmpVolSnapInfo
		INSERT	INTO @tblTmpVolSnapInfo
		SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, 3/*GETVOLSNAP_FLAGS_SCG_VOLUMES*/, 0
		FROM	@tblJobs JOB INNER JOIN SMVolume VOL WITH(READUNCOMMITTED) on JOB.JobId = VOL.JobId
				INNER JOIN SMVolSnapMap MAP WITH(READUNCOMMITTED) ON VOL.SMVolumeId = MAP.SMVolumeId
				INNER JOIN @tblMetaDataIds META ON META.MetaDataId = MAP.MetaDataId
				LEFT OUTER JOIN #tblVolSnapInfo TVSI ON MAP.SMVolSnapMapId = TVSI.SMVolSnapMapId
		WHERE	TVSI.SMVolumeId IS NULL
		DECLARE @tblVolArchFileIds TABLE (SMVolumeId INTEGER, ArchFileId INTEGER)
		INSERT	INTO @tblVolArchFileIds
		SELECT	TVSI.SMVolumeId, VOL.ArchFileId
		FROM	@tblTmpVolSnapInfo TVSI INNER JOIN SMVolume VOL WITH(READUNCOMMITTED) ON TVSI.SMVolumeId = VOL.SMVolumeId
		DELETE	FROM @tblTmpVolSnapInfo
		FROM	@tblTmpVolSnapInfo TVSI INNER JOIN @tblVolArchFileIds VAF ON TVSI.SMVolumeId = VAF.SMVolumeId
				INNER JOIN archFile AF WITH(READUNCOMMITTED) ON VAF.ArchFileId = AF.id AND AF.isValid = -1
		DELETE	FROM @tblTmpVolSnapInfo
		FROM	@tblTmpVolSnapInfo TVSI INNER JOIN @tblVolArchFileIds VAF ON TVSI.SMVolumeId = VAF.SMVolumeId
				INNER JOIN archFileCopy AFC WITH(READUNCOMMITTED) ON VAF.ArchFileId = AFC.archFileId AND AFC.isValid = -1
		INSERT INTO #tblVolSnapInfo
		SELECT * FROM @tblTmpVolSnapInfo
	END
GET_METADATA:
	-- Get all metadata for volumes
	INSERT	INTO #tblVolSnapInfo
	SELECT	DISTINCT 0, RefId, 0, MetaDataId, 0, 0
	FROM	SMMetaData WITH (READUNCOMMITTED)
WHERE	RefType = 1
			AND RefId in (SELECT DISTINCT SMVolumeId FROM #tblVolSnapInfo WHERE IsValidAF <> 3/*GETVOLSNAP_FLAGS_SCG_VOLUMES*/)
	-- Get all metadata for snaps
	INSERT	INTO #tblVolSnapInfo
	SELECT	DISTINCT 0, 0, RefId, MetaDataId, 0, 0
	FROM	SMMetaData WITH (READUNCOMMITTED)
WHERE	RefType = 2
			AND RefId in (SELECT DISTINCT SMSnapId FROM #tblVolSnapInfo)
	-- Get all metadata for SMMountSnaps
	-- This is needed for reporting engine-specific details of snaps created
	-- by Test Clones and stored as SMMountSnap metadata
IF (@x_validFlags & 4096 = 4096) AND (@x_snapEngineId > 0)
	BEGIN
		INSERT	INTO #tblVolSnapInfo
		SELECT	DISTINCT 0, 0, VS.SMSnapId, MD.MetaDataId, 0, 0
		FROM	#tblVolSnapInfo VS
				INNER JOIN SMMountSnap MS WITH (READUNCOMMITTED) ON MS.SMSnapId = VS.SMSnapId
INNER JOIN SMMetaData MD WITH (READUNCOMMITTED) ON MD.RefType = 12 AND MD.RefId = MS.Id
	END
	-- To retrieve aged volume-snaps
IF @x_criteriaFlags & 8 = 8
	BEGIN
		IF @x_snapJobId = 0
		BEGIN
SELECT	0, 0, 0, 0, 0, 60140, 'Snap Job Id is not set for aged volumes.', 0, 0
			GOTO EXIT_CLEANUP
		END
		-- Get Aged Volumes, Snaps & Maps
		INSERT	INTO #tblVolSnapInfo
SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, 2, 0
		FROM	SMVolumeDeleted VOL WITH (READUNCOMMITTED),
				SMVolSnapMapDeleted MAP WITH (READUNCOMMITTED)
		WHERE	VOL.JobId = @x_snapJobId
				AND VOL.CommCellId = @x_commCellId
				AND MAP.SMVolumeId = VOL.SMVolumeId
		-- Get MetaData for Aged Volumes
		INSERT	INTO #tblVolSnapInfo
SELECT	DISTINCT 0, RefId, 0, MetaDataId, 2, 0
		FROM	SMMetaDataDeleted WITH (READUNCOMMITTED)
WHERE	RefType = 1
				AND RefId in (SELECT DISTINCT SMVolumeId FROM #tblVolSnapInfo)
		-- Get MetaData for Aged Snaps
		INSERT	INTO #tblVolSnapInfo
SELECT	DISTINCT 0, 0, RefId, MetaDataId, 2, 0
		FROM	SMMetaDataDeleted WITH (READUNCOMMITTED)
WHERE	RefType = 2
				AND RefId in (SELECT DISTINCT SMSnapId FROM #tblVolSnapInfo)
	END
	SELECT	DISTINCT SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, IsValidAF, 0, '', 0, 0
	FROM	#tblVolSnapInfo
	ORDER BY SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, IsValidAF
EXIT_CLEANUP:
	IF object_id('tempdb.dbo.#tblVolSnapInfo') IS NOT Null DROP TABLE #tblVolSnapInfo
	IF object_id('tempdb.dbo.#tblVolSnapReconInfo') IS NOT Null DROP TABLE #tblVolSnapReconInfo
	IF object_id('tempdb.dbo.#GVS_tblAFC') IS NOT Null DROP TABLE #GVS_tblAFC
	IF object_id('tempdb.dbo.#GVS_tblVolume') IS NOT Null DROP TABLE #GVS_tblVolume
	IF object_id('tempdb.dbo.#GVS_tblMountVolume') IS NOT Null DROP TABLE #GVS_tblMountVolume
	IF object_id('tempdb.dbo.#tblSMSnapsToReconcile') IS NOT Null DROP TABLE #tblSMSnapsToReconcile
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetVolSnaps')
	delete from GxQscripts where name = 'MM_SMGetVolSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetVolSnaps')
	delete from GXDBVersions where aliasname = 'MM_SMGetVolSnaps'
GO

insert into GXDBVersions values(2, 'MM_SMGetVolSnaps',  '00010037000200230000', 'MM_SMGetVolSnaps', '00010037000200230000')
GO

