

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetSourceCopiesForSnapReplicaCopy.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Munish Tayal
-- Create date: 30/01/2020
-- Description:	Returns the list of Storage policy copies which can be specified as source for a new Vault or Mirror copy
-- Parameters :	App_GetSourceCopiesForSnapReplicaCopyReq XML having storage policy Id
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMGetSourceCopiesForSnapReplicaCopy')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetSourceCopiesForSnapReplicaCopy <<<'
	drop procedure MM_SMGetSourceCopiesForSnapReplicaCopy
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetSourceCopiesForSnapReplicaCopy')
	delete from GxQscripts where name = 'MM_SMGetSourceCopiesForSnapReplicaCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetSourceCopiesForSnapReplicaCopy')
	delete from GXDBVersions where aliasname = 'MM_SMGetSourceCopiesForSnapReplicaCopy'
GO
print '... Creating Procedure: MM_SMGetSourceCopiesForSnapReplicaCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetSourceCopiesForSnapReplicaCopy
  @i_xmlTextInput XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @i_storagePolicyId INT = ISNULL ( ( SELECT R.ref.value('@storagePolicyId', 'integer') FROM @i_xmlTextInput.nodes ( '/App_GetSourceCopiesForSnapReplicaCopyReq' ) R ( ref ) ), 0 )
DECLARE @defaultSnapCopy INT = (SELECT defaultSnapCopy FROM archGroup WHERE id = @i_storagePolicyId)
SET @i_xmlTextInput = 	(SELECT
							(SELECT		id          AS '@storagePolicyId',
										name        AS '@storagePolicyName'
							FROM        archGroup
							WHERE       id = @i_storagePolicyId
							FOR XML PATH('storagePolicy'), TYPE),
							(SELECT		AGC.type				AS '@copyType',
										AGC.isSnapCopy			AS '@isSnapCopy',
										AGC.isMirrorCopy		AS '@isMirrorCopy',
										AGC.isActive			AS '@active',
										AGC.copy				AS '@copyPrecedence',
										(SELECT     AGC.id                      AS '@copyId',
													AGC.name                    AS '@copyName'
										FOR XML PATH('StoragePolicyCopy'), TYPE)
							FROM        archGroupCopy AGC
							WHERE		AGC.archGroupId = @i_storagePolicyId
AND AGC.type <> 5
										AND AGC.isSnapCopy = 1
										AND (AGC.id = @defaultSnapCopy
											OR (AGC.id IN (SELECT id FROM archGroupCopy WHERE sourceCopyId = @defaultSnapCopy)
												AND AGC.id NOT IN (SELECT sourceCopyId FROM archGroupCopy)))
							FOR XML PATH('copy'), TYPE)
						FOR XML PATH('App_StoragePolicyInfoResp'),TYPE)
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetSourceCopiesForSnapReplicaCopy')
	delete from GxQscripts where name = 'MM_SMGetSourceCopiesForSnapReplicaCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetSourceCopiesForSnapReplicaCopy')
	delete from GXDBVersions where aliasname = 'MM_SMGetSourceCopiesForSnapReplicaCopy'
GO

insert into GXDBVersions values(2, 'MM_SMGetSourceCopiesForSnapReplicaCopy',  '00000000000000000000', 'MM_SMGetSourceCopiesForSnapReplicaCopy', '00000000000000000000')
GO

