

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetSnapsOfSnapBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetSnapsOfSnapBackup.sp,v $ $Id: MM_SMGetSnapsOfSnapBackup.sp,v 1.24.12.8 2020/10/14 17:25:36 kkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMGetSnapsOfSnapBackup')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetSnapsOfSnapBackup <<<'
	drop procedure MM_SMGetSnapsOfSnapBackup
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetSnapsOfSnapBackup')
	delete from GxQscripts where name = 'MM_SMGetSnapsOfSnapBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetSnapsOfSnapBackup')
	delete from GXDBVersions where aliasname = 'MM_SMGetSnapsOfSnapBackup'
GO
print '... Creating Procedure: MM_SMGetSnapsOfSnapBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetSnapsOfSnapBackup
  @xmlTextInput XML,
  @i_userId integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	declare		@i_controlHostId	INT
	declare		@i_clientId			INT
	declare		@i_appTypeId		INT
	declare		@i_backupSetId		INT
	declare		@i_subClientId		INT
	declare		@i_copyId			INT
	declare		@i_jobId			INT
	declare		@i_commCellId		INT
	declare		@i_volumeId			INT
	declare		@i_snapId			INT
	DECLARE @VIRT_ENGINE INTEGER = 32768 -- SM_SNAPSHOT_ENGINE_CAPABILITY_VIRTUALIZED
	SET @i_controlHostId = ISNULL(( SELECT ref.value('@controlHostId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsOfSnapBackupReq') R ( ref ) ),
						0)
	SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsOfSnapBackupReq/appId') R ( ref ) ),
						0)
	SET @i_appTypeId = ISNULL(( SELECT ref.value('@apptypeId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsOfSnapBackupReq/appId') R ( ref ) ),
						0)
	SET @i_backupSetId = ISNULL(( SELECT ref.value('@backupsetId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsOfSnapBackupReq/appId') R ( ref ) ),
						0)
	SET @i_subClientId = ISNULL(( SELECT ref.value('@subclientId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsOfSnapBackupReq/appId') R ( ref ) ),
						0)
	SET @i_copyId = ISNULL(( SELECT ref.value('@copyId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsOfSnapBackupReq') R ( ref ) ),
						0)
	SET @i_jobId = ISNULL(( SELECT ref.value('@jobId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsOfSnapBackupReq') R ( ref ) ),
						0)
	SET @i_commCellId = ISNULL(( SELECT ref.value('@commCellId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsOfSnapBackupReq') R ( ref ) ),
						0)
	SET @i_volumeId = ISNULL(( SELECT ref.value('@smVolumeId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsOfSnapBackupReq') R ( ref ) ),
						0)
	SET @i_snapId = ISNULL(( SELECT ref.value('@smSnapId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsOfSnapBackupReq') R ( ref ) ),
						0)
	IF OBJECT_ID('tempdb.dbo.#tbl_GSOSB_SMVolume') IS NOT NULL
		DROP TABLE #tbl_GSOSB_SMVolume
	CREATE TABLE #tbl_GSOSB_SMVolume (t_SMVolumeId int, t_ArchFileId int, t_JobId int, t_CommCellId int, t_AppId int)
	CREATE INDEX tbl_GSOSB_SMVolume_SMVolumeId_Idx ON #tbl_GSOSB_SMVolume (t_SMVolumeId)
	IF OBJECT_ID('tempdb.dbo.#tbl_GSOSB_SMSnap') IS NOT NULL
		DROP TABLE #tbl_GSOSB_SMSnap
	CREATE TABLE #tbl_GSOSB_SMSnap (t_SMSnapId int)
	CREATE INDEX tbl_GSOSB_SMSnap ON #tbl_GSOSB_SMSnap (t_SMSnapId)
	IF @i_snapId > 0
	BEGIN
		--
		-- Get SMVolumeId for this snap
		--
		INSERT INTO #tbl_GSOSB_SMVolume
			SELECT	DISTINCT A.SMVolumeId, A.ArchFileId, A.JobId, A.CommCellId, A.AppId
			FROM	SMVolume A WITH (NOLOCK), SMVolSnapMap B WITH (NOLOCK)
			WHERE	A.SMVolumeId = B.SMVolumeId AND B.SMSnapId = @i_snapId
			AND		(@i_copyId = 0 OR A.CopyId = @i_copyId)
	END
	ELSE IF @i_volumeId > 0
	BEGIN
		--
		-- Get SMVolumeId for this volume
		--
		INSERT INTO #tbl_GSOSB_SMVolume
			SELECT	DISTINCT A.SMVolumeId, A.ArchFileId, A.JobId, A.CommCellId, A.AppId
			FROM	SMVolume A WITH (NOLOCK)
			WHERE	A.SMVolumeId = @i_volumeId
			AND		(@i_copyId = 0 OR A.CopyId = @i_copyId)
	END
	ELSE IF @i_jobId > 0
	BEGIN
		--
		-- Get SMVolumeId for this job
		--
		INSERT INTO #tbl_GSOSB_SMVolume
			SELECT	DISTINCT A.SMVolumeId, A.ArchFileId, A.JobId, A.CommCellId, A.AppId
			FROM	SMVolume A WITH (NOLOCK)
			WHERE	A.JobId = @i_jobId AND A.CommCellId = @i_commCellId
			AND		(@i_copyId = 0 OR A.CopyId = @i_copyId)
	END
	ELSE IF @i_controlHostId > 0
	BEGIN
		--
		-- Get SMVolumeId for this ControlHostId (Array)
		--
		INSERT INTO #tbl_GSOSB_SMVolume
			SELECT  DISTINCT VOL.SMVolumeId, VOL.ArchFileId, VOL.JobId, VOL.CommCellId, VOL.AppId
			FROM    SMVolume VOL WITH (NOLOCK)
					INNER JOIN SMVolSnapMap MAP WITH (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
					INNER JOIN SMSnap SNAP WITH (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
					LEFT OUTER JOIN SMSnapShotEngine OE WITH (NOLOCK) ON OE.SnapShotEngineId = SNAP.OriginalSnapEngineId
			WHERE   (SNAP.ControlHostId = @i_controlHostId OR (OE.Capabilities & @VIRT_ENGINE = @VIRT_ENGINE AND SNAP.ReserveField2 = @i_controlHostId))
					AND (@i_copyId = 0 OR VOL.CopyId = @i_copyId)
	END
	ELSE IF @i_subClientId > 0
	BEGIN
		--
		-- Get SMVolumeId for this Subclient
		--
		INSERT INTO #tbl_GSOSB_SMVolume
			SELECT	DISTINCT A.SMVolumeId, A.ArchFileId, A.JobId, A.CommCellId, A.AppId
			FROM	SMVolume A WITH (NOLOCK), ArchFile AF WITH (NOLOCK)
			WHERE	A.AppId = @i_subClientId
			AND		(@i_copyId = 0 OR A.CopyId = @i_copyId)
			AND
			(
				(A.ArchFileId = AF.id AND A.CommCellId = AF.CommCellId  AND	 AF.isValid = 1 )
				OR  		-- DONT DO AFILE VALID FOR VSA V2 PARENT VOL ENTRY
				(
					A.MasterJobId > 0
					AND A.MasterJobId = A.JobId
AND (A.VolumeFlags & cast ( 4294967296 AS BIGINT) /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/ > 0 )
				)
			)
	END
	ELSE IF @i_backupSetId > 0
	BEGIN
		--
		-- Get SMVolumeId for this backupset
		--
		INSERT INTO #tbl_GSOSB_SMVolume
			SELECT	DISTINCT A.SMVolumeId, A.ArchFileId, A.JobId, A.CommCellId, A.AppId
			FROM	SMVolume A WITH (NOLOCK), ArchFile AF WITH (NOLOCK)
			WHERE	A.AppId in (SELECT id FROM APP_Application WITH (NOLOCK) WHERE ClientId = @i_clientId AND AppTypeId = @i_appTypeId AND BackupSet = @i_backupSetId)
			AND		(@i_copyId = 0 OR A.CopyId = @i_copyId)
			AND     (
						( A.ArchFileId = AF.id AND A.CommCellId = AF.CommCellId AND	AF.isValid = 1)
						OR 			-- DONT DO AFILE VALID FOR VSA V2 PARENT VOL ENTRY
						(
							A.MasterJobId > 0
							AND A.MasterJobId = A.JobId
AND (A.VolumeFlags & cast ( 4294967296 AS BIGINT) /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/ > 0 )
						)
					)
	END
	ELSE IF @i_clientId > 0
	BEGIN
		--
		-- Get SMVolumeId for this client
		--
		INSERT INTO #tbl_GSOSB_SMVolume
			SELECT	DISTINCT A.SMVolumeId, A.ArchFileId, A.JobId, A.CommCellId, A.AppId
			FROM	SMVolume A WITH (NOLOCK), ArchFile AF WITH (NOLOCK)
			WHERE	AF.AppId in (SELECT id FROM APP_Application WITH (NOLOCK) WHERE ClientId = @i_clientId AND AppTypeId = @i_appTypeId)
			AND		(@i_copyId = 0 OR A.CopyId = @i_copyId)
			AND     A.ArchFileId = AF.id AND A.CommCellId = AF.CommCellId
			AND		AF.isValid = 1
	END
	ELSE IF @i_copyId > 0
	BEGIN
		--
		-- Get SMVolumeId for this copy
		--
		INSERT INTO #tbl_GSOSB_SMVolume
			SELECT	DISTINCT A.SMVolumeId, A.ArchFileId, A.JobId, A.CommCellId, A.AppId
			FROM	SMVolume A WITH (NOLOCK), ArchFile AF WITH (NOLOCK), ArchFileCopy AFC WITH (NOLOCK)
			WHERE	A.CopyId = @i_copyId
			AND		A.CopyId = AFC.ArchCopyId
			AND     A.ArchFileId = AF.id AND A.CommCellId = AF.CommCellId
			AND     AFC.ArchFileId = AF.id AND AFC.CommCellId = AF.CommCellId
			AND		AF.isValid = 1
			AND		AFC.isValid = 1
	END
	if (@@ROWCOUNT = 0)
	BEGIN
		GOTO proc_exit
	END
	--
	-- Security - remove those where the subclients are not visible for this user.
	--
	IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
        DROP TABLE #tblSecCheck
	CREATE TABLE #tblSecCheck (
		EntityType int,
		EntityId int,
		EntityVisible int
	)
	INSERT INTO #tblSecCheck
SELECT DISTINCT 1, VOL.CopyId, 0  FROM #tbl_GSOSB_SMVolume A INNER JOIN SMVolume VOL (NOLOCK) ON A.t_SMVolumeId = VOL.SMVolumeId
	INSERT INTO #tblSecCheck
SELECT	DISTINCT 2, SNAP.ControlHostId, 0
	FROM	#tbl_GSOSB_SMVolume A INNER JOIN SMVolume VOL (NOLOCK) ON A.t_SMVolumeId = VOL.SMVolumeId
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = VOL.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
	INSERT INTO #tblSecCheck
SELECT DISTINCT 3, t_AppId, 0  FROM #tbl_GSOSB_SMVolume
	EXEC sec_isSnapshotVisible @i_userId
	DELETE	A
	FROM	#tbl_GSOSB_SMVolume A
			INNER JOIN SMVolume VOL (NOLOCK) ON A.t_SMVolumeId = VOL.SMVolumeId
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = VOL.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
INNER JOIN #tblSecCheck B_Copy ON VOL.copyId = B_Copy.EntityId AND B_Copy.EntityType = 1
INNER JOIN #tblSecCheck B_CHost ON SNAP.ControlHostId = B_CHost.EntityId AND B_CHost.EntityType = 2
INNER JOIN #tblSecCheck B_App ON A.t_AppId = B_App.EntityId AND B_App.EntityType = 3
	WHERE	B_Copy.EntityVisible <=0
			AND B_CHost.EntityVisible <=0
			AND B_App.EntityVisible <=0
	IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
		DROP TABLE #tblSecCheck
	--
	-- Safety - remove those snapshots that are part of a running job
	--
	if (@i_jobId <= 0)
	BEGIN
		DELETE #tbl_GSOSB_SMVolume
		FROM #tbl_GSOSB_SMVolume a, JMJobInfo b WITH (NOLOCK)
		WHERE a.t_CommCellId = b.CommCellId AND a.t_JobId = b.JobId
	END
	--
	-- Only return valid archive files
	--
	IF (@i_jobId > 0 or @i_jobId = 0 and @i_controlhostId = 0 and @i_volumeId = 0 and @i_snapId = 0)
	BEGIN
		DELETE #tbl_GSOSB_SMVolume
		FROM #tbl_GSOSB_SMVolume A, SMVolume B WITH (NOLOCK)
WHERE A.t_SMVolumeId = B.SMVolumeId AND B.pruneFlags != 1
	END
	DECLARE @tblSMSnapType TABLE
		( SnapType integer, SnapTypeName varchar(1024) )
	INSERT INTO @tblSMSnapType SELECT 1, 'Primary'
	DECLARE @tblSMSnapSnapStatus TABLE
		( SnapStatus integer, SnapStatusName varchar(1024) )
	INSERT INTO @tblSMSnapSnapStatus SELECT -1, 'Snap Failure'	/* SNAP_FAIL -- -1 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 0,  'Unknown Status'	/* UNKNOWN -- 0 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 1,  'Array volume ready for snap'	/* READY_FOR_SNAP -- 1 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 2,  'Array volume is not ready for snap'	/* READY_FOR_SNAP_FAILED -- 2 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 3,  'Cancel succeed'	/* CANCELED -- 3 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 4,  'Cancel failed'	/* CANCEL_FAILED -- 4 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 5,  'Snap succeed'	/* SNAPED -- 5 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 6,  'Snap failed'	/* SNAP_FAILED -- 6 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 7,  'Snap is cloned'	/* CLONED -- 7 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 8,  'Cloning failed'	/* CLONED_FAILED -- 8 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 9,  'Snap mapped to the host'	/* MAPPED -- 9 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 10, 'Snap Busy or mapped to different host'	/* MAPPED_BUSY -- 10 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 11, 'Snap map failed'	/* MAPPED_FAILED -- 11 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 12, 'Snap device available on host'	/* DEVICE_FOUND -- 12 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 13, 'Snap device not found'	/* DEVICE_NOT_FOUND -- 13 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 14, 'Snap unmap succeed'	/* UNMAPPED -- 14 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 15, 'Snap unmap failed'	/* UNMAP_FAILED -- 15 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 16, 'Snap clone deleted'	/* DEL_CLONE -- 16 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 17, 'Snap clone delete failed'	/* DEL_CLONE_FAILED -- 17 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 18, 'Snap device deleted on host'	/* DEVICE_DELETED -- 18 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 19, 'Snap device delete on host failed'	/* DEVICE_DELETED_FAILED -- 19 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 20, 'Snap device deleted'	/* DELETED -- 20 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 21, 'Snap device delete failed'	/* DELETE_FAILED -- 21 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 22, 'Snap revert succeed'	/* REVERTED -- 22  */
	INSERT INTO @tblSMSnapSnapStatus SELECT 23, 'Snap revert failed'	/* REVERT_FAILED -- 23 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 24, 'Snap deleted unexpectedly'	/* EXT_DELETE -- 24 */
	INSERT INTO @tblSMSnapSnapStatus SELECT 28, 'Snap metro standalone'	/* METRO_STANDALONE_SNAP -- 28 */
proc_exit:
	IF @i_snapId > 0
	BEGIN
		INSERT INTO #tbl_GSOSB_SMSnap SELECT @i_snapId
	END
	ELSE
	BEGIN
		INSERT INTO #tbl_GSOSB_SMSnap
		SELECT DISTINCT A.SMSnapId
		FROM SMVolSnapMap A WITH (NOLOCK), #tbl_GSOSB_SMVolume B
		WHERE A.SMVolumeId = B.t_SMVolumeId
	END
	IF @i_controlHostId = 0
	BEGIN
		-- Remove the Base Snaps
		DELETE	#tbl_GSOSB_SMSnap
		FROM	#tbl_GSOSB_SMSnap TSNAP INNER JOIN SMSnap SNAP WITH (NOLOCK) ON TSNAP.t_SMSnapId = SNAP.SMSnapId
WHERE	SNAP.SnapFlags & 2048 = 2048
	END
	--
	-- Filter Snap entries which belong to External Backup Engine
	--
	BEGIN
		 DELETE	#tbl_GSOSB_SMSnap
		 FROM	#tbl_GSOSB_SMSnap TSNAP INNER JOIN SMSnap SNAP WITH (NOLOCK) ON TSNAP.t_SMSnapId = SNAP.SMSnapId
WHERE	SNAP.SnapshotEngineId =  51
	END
	IF EXISTS (SELECT 1 FROM #tbl_GSOSB_SMSnap)
	BEGIN
	-- Return list of snaps
	SELECT	DISTINCT
		A.SMSnapId				'@smSnapId',
		A.SnapShotEngineId		'@snapShotEngineId',
		( CASE
		WHEN    (OE.Capabilities & @VIRT_ENGINE = @VIRT_ENGINE AND A.OriginalSnapEngineId > 0) THEN
					( (SELECT ENG.[SnapEngineName] FROM SMSnapShotEngine ENG (NOLOCK) WHERE ENG.SnapShotEngineId = A.OriginalSnapEngineId)
						+ ' (' +
						(SELECT ENG.[SnapEngineName] FROM SMSnapShotEngine ENG (NOLOCK) WHERE ENG.SnapShotEngineId = A.SnapShotEngineId)
						+ ')' )
		ELSE
				(SELECT ENG.[SnapEngineName] FROM SMSnapShotEngine ENG (NOLOCK) WHERE ENG.SnapShotEngineId = A.SnapShotEngineId)
		END)
		'@snapShotEngineName',
		A.ControlHostId			'@controlHostId',
		( CASE
		WHEN    (OE.Capabilities & @VIRT_ENGINE = @VIRT_ENGINE AND A.ReserveField2 > 0) THEN
					( (SELECT (CASE WHEN CH.[SMArrayId] <> '' THEN CH.[SMArrayId] ELSE CH.[SMHostName] END) FROM SMControlHost CH (NOLOCK) WHERE CH.ControlHostId = A.ReserveField2)
						+ ' (' +
						(SELECT (CASE WHEN CH.[SMArrayId] <> '' THEN CH.[SMArrayId] ELSE CH.[SMHostName] END) FROM SMControlHost CH (NOLOCK) WHERE CH.ControlHostId = A.ControlHostId)
						+ ')' )
		ELSE
				(SELECT (CASE WHEN CH.[SMArrayId] <> '' THEN CH.[SMArrayId] ELSE CH.[SMHostName] END) FROM SMControlHost CH (NOLOCK) WHERE CH.ControlHostId = A.ControlHostId)
		END )
		'@controlHostName',
		A.SnapType				'@snapType',
		(SELECT M.[SnapTypeName] FROM @tblSMSnapType M WHERE M.SnapType = A.SnapType)
		'@snapTypeName',
		A.SnapFlags				'@snapFlags',
		A.PruneFlags			'@pruneFlags',
		A.SnapStatus			'@snapStatus',
		( CASE
WHEN A.SnapStatus = 97 THEN 'Not present in Array'
		WHEN A.ReplicationStatus > 0 THEN 'Missing Snap' ELSE
		(SELECT M.[SnapStatusName] FROM @tblSMSnapSnapStatus M WHERE M.SnapStatus = A.SnapStatus)
		END)
		'@snapStatusName',
		A.SnapStatusUpdateTime	'@snapStatusUpdateTime',
		A.CreationTime			'@creationTime',
		A.ReplicationStatus		'@retryCount',
		A.DeviceEntryType		'@deviceEntryType',
		A.ConnectionType		'@connectionType',
		A.SnapSourceDevice		'@snapSourceDevice',
		A.SnapDevice			'@snapDevice',
		A.ShadowCopyId			'@shadowCopyId',
		A.UniqueIdentifier		'@uniqueIdentifier',
		A.SourceIdentifier		'@sourceIdentifier',
		A.TargetIdentifier		'@targetIdentifier',
		A.ReserveField1			'@reserveField1',
		A.ReserveField2			'@reserveField2',
		A.ReserveFieldStr		'@reserveFieldStr'
	FROM        SMSnap A WITH (NOLOCK)
				INNER JOIN #tbl_GSOSB_SMSnap B ON A.SMSnapId = B.t_SMSnapId
				LEFT OUTER JOIN SMSnapShotEngine OE WITH (NOLOCK) ON OE.SnapShotEngineId = A.OriginalSnapEngineId
	ORDER BY A.CreationTime DESC
	FOR XML PATH('listOfSnaps'), ROOT('EVGui_GetSnapsOfSnapBackupResponse')
	END
	ELSE
	BEGIN
		SELECT ''
		FOR XML PATH('EVGui_GetSnapsOfSnapBackupResponse')
	END
	IF OBJECT_ID('tempdb.dbo.#tbl_GSOSB_SMVolume') IS NOT NULL
		DROP TABLE #tbl_GSOSB_SMVolume
	IF OBJECT_ID('tempdb.dbo.#tbl_GSOSB_SMSnap') IS NOT NULL
		DROP TABLE #tbl_GSOSB_SMSnap
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetSnapsOfSnapBackup')
	delete from GxQscripts where name = 'MM_SMGetSnapsOfSnapBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetSnapsOfSnapBackup')
	delete from GXDBVersions where aliasname = 'MM_SMGetSnapsOfSnapBackup'
GO

insert into GXDBVersions values(2, 'MM_SMGetSnapsOfSnapBackup',  '00010024001200080000', 'MM_SMGetSnapsOfSnapBackup', '00010024001200080000')
GO

