

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetSnapToSnap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetSnapToSnap.sp,v $ $Id: MM_SMGetSnapToSnap.sp,v 1.4.210.1 2018/03/20 00:06:18 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetSnapToSnap <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetSnapToSnap')
	drop procedure MM_SMGetSnapToSnap
IF EXISTS (select * from GxQscripts where name='MM_SMGetSnapToSnap')
	delete from GxQscripts where name = 'MM_SMGetSnapToSnap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetSnapToSnap')
	delete from GXDBVersions where aliasname = 'MM_SMGetSnapToSnap'
GO
print '... Creating Procedure: MM_SMGetSnapToSnap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetSnapToSnap
  @i_xmlHostList XML,
  @i_reserveParam integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @serverCount INTEGER
DECLARE @iDoc INTEGER
	SET @serverCount = 0
	exec sp_xml_preparedocument @iDoc OUTPUT, @i_xmlHostList
	SET @serverCount =
     	(
     		SELECT count(hostName)
     		FROM
     			OPENXML(@iDoc, 'EVGui_GetSVSMRelationListReq/filerList', 0)WITH(hostName NVARCHAR(250) '@val')
     	)
	if (@serverCount > 0)
	BEGIN
		SELECT
			tXml.hostName	as 'hostName'
		INTO #tempHostList
		FROM
			OPENXML(@iDoc, 'EVGui_GetSVSMRelationListReq/filerList', 0)
			WITH(hostName NVARCHAR(250) '@val') as tXml
		-- Return list of relations for the selected sourcehost names.
		SELECT
			A.SnapToSnapId				'@SnapToSnapId',
			A.SrcCtrlHostId				'@srcCtrlHostId',
			(SELECT Host.[SMArrayId] FROM SMControlHost Host WITH (NOLOCK) WHERE Host.ControlHostId = A.SrcCtrlHostId)  '@srcCtrlHostName',
			A.SrcPath				'@srcPath',
			A.TgtCtrlHostId				'@tgtCtrlHostId',
			(SELECT Host.[SMArrayId] FROM SMControlHost Host WITH (NOLOCK) WHERE Host.ControlHostId = A.TgtCtrlHostId)  '@tgtCtrlHostName',
			A.TgtPath				'@tgtPath',
			A.ReserveField1				'@relationType',
			A.ReserveField2				'@flags',
			A.CopyId			'spCopy/@copyId',
			ISNULL((SELECT AGC.name from archGroupCopy AGC WITH (NOLOCK) WHERE AGC.id = A.CopyId and AGC.id > 0), '')	'spCopy/@copyName',
			ISNULL((SELECT AGC.archGroupId from archGroupCopy AGC WITH (NOLOCK) WHERE AGC.id = A.CopyId and AGC.id > 0), 0)			'spCopy/@storagePolicyId',
			ISNULL((SELECT AG.name from archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK) WHERE AGC.id = A.CopyId and AGC.archGroupId = AG.id and AGC.id > 0), '')			'spCopy/@storagePolicyName'
		FROM SMSnapToSnap A WITH (NOLOCK), SMControlHost Host WITH (NOLOCK), #tempHostList T
		WHERE A.SnapToSnapId > 0
		and T.hostName = Host.SMArrayId
		and Host.ControlHostId = A.SrcCtrlHostId
		FOR XML PATH('smRelationList')
	END
	ELSE
	BEGIN
		-- Return All list of snap relations
		SELECT
			A.SnapToSnapId				'@SnapToSnapId',
			A.SrcCtrlHostId				'@srcCtrlHostId',
			(SELECT Host.[SMArrayId] FROM SMControlHost Host WITH (NOLOCK) WHERE Host.ControlHostId = A.SrcCtrlHostId)  '@srcCtrlHostName',
			A.SrcPath				'@srcPath',
			A.TgtCtrlHostId				'@tgtCtrlHostId',
			(SELECT Host.[SMArrayId] FROM SMControlHost Host WITH (NOLOCK) WHERE Host.ControlHostId = A.TgtCtrlHostId)  '@tgtCtrlHostName',
			A.TgtPath				'@tgtPath',
			A.ReserveField1				'@relationType',
			A.ReserveField2				'@flags',
			A.CopyId			'spCopy/@copyId',
			ISNULL((SELECT AGC.name from archGroupCopy AGC WITH (NOLOCK) WHERE AGC.id = A.CopyId and AGC.id > 0), '')	'spCopy/@copyName',
			ISNULL((SELECT AGC.archGroupId from archGroupCopy AGC WITH (NOLOCK) WHERE AGC.id = A.CopyId and AGC.id > 0), 0)			'spCopy/@storagePolicyId',
			ISNULL((SELECT AG.name from archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK) WHERE AGC.id = A.CopyId and AGC.archGroupId = AG.id and AGC.id > 0), '')			'spCopy/@storagePolicyName'
		FROM SMSnapToSnap A WITH (NOLOCK)
		WHERE A.SnapToSnapId > 0
		FOR XML PATH('smRelationList')
	END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetSnapToSnap')
	delete from GxQscripts where name = 'MM_SMGetSnapToSnap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetSnapToSnap')
	delete from GXDBVersions where aliasname = 'MM_SMGetSnapToSnap'
GO

insert into GXDBVersions values(2, 'MM_SMGetSnapToSnap',  '00010004021000010000', 'MM_SMGetSnapToSnap', '00010004021000010000')
GO

