

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetSnapShotsForBackupSet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetSnapShotsForBackupSet.sp,v $ $Id: MM_SMGetSnapShotsForBackupSet.sp,v 1.25.86.1 2018/03/20 00:04:45 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetSnapShotsForBackupSet <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetSnapShotsForBackupSet')
	drop procedure MM_SMGetSnapShotsForBackupSet
IF EXISTS (select * from GxQscripts where name='MM_SMGetSnapShotsForBackupSet')
	delete from GxQscripts where name = 'MM_SMGetSnapShotsForBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetSnapShotsForBackupSet')
	delete from GXDBVersions where aliasname = 'MM_SMGetSnapShotsForBackupSet'
GO
print '... Creating Procedure: MM_SMGetSnapShotsForBackupSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetSnapShotsForBackupSet
  @xmlTextInput XML,
  @i_userId integer,
  @i_reserveParam1 integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	declare		@i_clientId			INT
	declare		@i_appTypeId		INT
	declare		@i_backupSetId		INT
	declare		@i_copyId			INT
	declare		@i_jobId			INT
	SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsCreatedDuringSnapBackupReq/appId') R ( ref ) ),
						0)
	SET @i_appTypeId = ISNULL(( SELECT ref.value('@apptypeId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsCreatedDuringSnapBackupReq/appId') R ( ref ) ),
						0)
	SET @i_backupSetId = ISNULL(( SELECT ref.value('@backupsetId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsCreatedDuringSnapBackupReq/appId') R ( ref ) ),
						0)
	SET @i_copyId = ISNULL(( SELECT ref.value('@CopyId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsCreatedDuringSnapBackupReq') R ( ref ) ),
						0)
	SET @i_jobId = ISNULL(( SELECT ref.value('@JobId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetSnapsCreatedDuringSnapBackupReq') R ( ref ) ),
						0)
	--
	-- Temporary table variables
	--
	declare @tblAppIds				TABLE (t_AppId int, t_AppTypeId int)
	declare @tblArchFiles			TABLE (t_ArchFileId int, t_AppId int, t_AppTypeId int)
	declare @tblSnapShots			TABLE (t_SnapShotId int, t_JobId int, t_AppId int, t_AppTypeId int)
	if ( (@i_backupSetId > 0) OR (@i_clientId > 0) )
	begin
		--
		-- Get subclients (appIds) for this backupset
		--
		INSERT INTO @tblAppIds
			SELECT	DISTINCT id, appTypeId
			FROM	APP_Application WITH (READUNCOMMITTED)
			WHERE	( (@i_backupSetId > 0) AND backupSet = @i_backupSetId)
					OR
					( (@i_backupSetId <= 0) AND clientId = @i_clientId AND appTypeId = @i_appTypeId)
		if (@@ROWCOUNT = 0)
		BEGIN
			GOTO proc_exit
		END
		--
		-- Get archFiles for the appIds.
		--
		INSERT INTO @tblArchFiles
			SELECT	DISTINCT AF.id, tAPP.t_AppId, tAPP.t_AppTypeId
			FROM	archFile AF WITH (READUNCOMMITTED), @tblAppIds tAPP
			WHERE	AF.appId = tAPP.t_AppId
		if (@@ROWCOUNT = 0)
		BEGIN
			GOTO proc_exit
		END
		--
		-- Get Snapshots
		--
		INSERT INTO @tblSnapShots
			SELECT	SNAP.SnapShotId, SNAP.JobId, tAF.t_AppId, tAF.t_AppTypeId
			FROM	SMSnapShot SNAP WITH (READUNCOMMITTED), @tblArchFiles tAF
			WHERE	SNAP.ArchFileId = tAF.t_ArchFileId
	end
	else
	if ( (@i_copyId > 0) OR (@i_jobId > 0) )
	begin
		--
		-- Get ArchFiles for the snapshots with this copyId
		--
		INSERT INTO @tblArchFiles
			SELECT	DISTINCT SNAP.ArchFileId, 0, 0
			FROM	SMSnapShot SNAP WITH (READUNCOMMITTED)
			WHERE	(@i_copyId > 0 AND SNAP.CopyId = @i_copyId)
				OR	(@i_jobId > 0 AND SNAP.JobId = @i_jobId)
		UPDATE	@tblArchFiles
		SET		t_AppId = AF.appId, t_AppTypeId = APP.appTypeId
		FROM	ArchFile AF WITH (READUNCOMMITTED), APP_Application APP WITH (READUNCOMMITTED)
		WHERE	t_ArchFileId = AF.id AND AF.appId = APP.id
		INSERT INTO @tblSnapShots
			SELECT	SNAP.SnapShotId, SNAP.JobId, tAF.t_AppId, tAF.t_AppTypeId
			FROM	SMSnapShot SNAP WITH (READUNCOMMITTED), @tblArchFiles tAF
			WHERE	SNAP.ArchFileId = tAF.t_ArchFileId
				AND ( (@i_copyId > 0 AND SNAP.CopyId = @i_copyId) OR
						(@i_jobId > 0 AND SNAP.JobId = @i_jobId) )
	end
	--
	-- Security - remove those where the subclients are not visible for this user.
	--
	DELETE FROM	@tblSnapShots
	WHERE (dbo.isSnapshotVisible (@i_userId, @i_copyId, 0, t_AppId) <= 0)
	--
	-- Safety - remove those snapshots that are part of a running job - see MR 19983 for details.
	--
	if (@i_jobId <= 0)  -- Should still show snapshots for running job if they are browsing snaps from job level.
	BEGIN
		DELETE @tblSnapShots
		FROM @tblSnapShots SNAPS, JMJobInfo JOBS WITH (READUNCOMMITTED)
		WHERE t_JobId = JOBS.JobId
		-- Also delete those snapshots which are having invalid archfile ids - see MR 23757 for details
		DELETE @tblSnapShots
		FROM @tblSnapShots SNAPS, SMSnapShot SMSS, ArchFile ARCHS WITH (READUNCOMMITTED)
		WHERE
			SNAPS.t_SnapShotId = SMSS.SnapShotId AND
			SMSS.ArchFileId = ARCHS.id AND
			ARCHS.isValid != 1
	END
	ELSE -- Browsing Snaps from Job Level so don't delete the Snapshots with invalid ArchFile Ids for that given job - see MR 23757 for details
	BEGIN
		-- Also delete those snapshots which are having invalid archfile ids - see MR 23757 for details
		DELETE @tblSnapShots
		FROM @tblSnapShots SNAPS, SMSnapShot SMSS, ArchFile ARCHS WITH (READUNCOMMITTED)
		WHERE
			SNAPS.t_SnapShotId = SMSS.SnapShotId AND
			SMSS.ArchFileId = ARCHS.id AND
			ARCHS.isValid != 1 AND
			SMSS.JobId NOT IN (SELECT JobId FROM JMJobInfo)
	END
-- fall through
proc_exit:
	--
	-- Now get the snapshots for those archFileIds.
	--
	SELECT
		S.[SnapShotId] '@SnapShotId',
		S.[ExternalSnapId] '@ExternalSnapId',
		S.[SnapShotEngineId] '@SnapShotEngineId',
		(SELECT ENG.[SnapEngineName] FROM SMSnapShotEngine ENG WHERE SnapShotEngineId = S.SnapShotEngineId) '@SnapShotEngineName',
		S.[SourceClientId] '@SourceClientId',
		(SELECT CL.[name] FROM APP_Client CL WHERE id = S.SourceClientId) '@SourceClientName',
		S.[SourceMountPath] '@SourceMountPath',
		S.[SnapMountPath] '@SnapMountPath',
--		S.[MountHostId] '@MountHostId',
		(SELECT CL.[name] FROM APP_Client CL WHERE id = S.MountHostId) '@MountHostId',
		S.[CreationTime] '@CreationTime',
		replace (S.[UniqueIdentifier], char(0x15), ' ') '@UniqueIdentifier',
		S.[ExternalGroup] '@ExternalGroup',
--		S.[ControlHostId] '@ControlHostId',
		(SELECT CH.[SMHostName] FROM SMControlHost CH WHERE CH.ControlHostId = S.ControlHostId) '@ControlHostId',
		S.[sourceVolumeGUID] '@sourceVolumeGUID',
		S.[SnapShotType] '@SnapShotType',
		S.[isActive] '@isActive',
--		S.[CopyId] '@CopyId',
		(SELECT AC.[name] FROM ArchGroupCopy AC WITH (READUNCOMMITTED) WHERE id = S.CopyId) '@CopyId',
		S.[SnapDeviceName] '@SnapDeviceName',
		S.[JobId] '@JobId',
		(
			SELECT AG.[name]
			FROM ArchGroup AG WITH (READUNCOMMITTED), ArchGroupCopy AC WITH (READUNCOMMITTED)
			WHERE AC.id = S.CopyId AND AG.id = AC.archGroupId
		) '@SPName',
		(
			SELECT IDA.name
			FROM APP_iDAType IDA WITH (READUNCOMMITTED)
			WHERE IDA.type = tSnaps.t_AppTypeId
		) '@AppTypeName',
		S.[MountStatus] '@MountStatus',
		S.[ReserveField] '@reserveParam1',
		0 '@reserveParam2',
		S.ReserveFieldStr '@strReserveParam'
	FROM	SMSnapShot S WITH (READUNCOMMITTED), @tblSnapShots tSnaps
	WHERE	S.SnapShotId = tSnaps.t_SnapShotId
	ORDER BY S.CreationTime DESC
	FOR XML PATH('listOfSnaps'), ROOT('EVGui_GetSnapsCreatedDuringSnapBackupResponse')
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetSnapShotsForBackupSet')
	delete from GxQscripts where name = 'MM_SMGetSnapShotsForBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetSnapShotsForBackupSet')
	delete from GXDBVersions where aliasname = 'MM_SMGetSnapShotsForBackupSet'
GO

insert into GXDBVersions values(2, 'MM_SMGetSnapShotsForBackupSet',  '00010025008600010000', 'MM_SMGetSnapShotsForBackupSet', '00010025008600010000')
GO

