

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetSnapPruneStatus.sp] ---------- 

--  +-----------------------------------------------------------------------+
--  |           Procedure : "MM_SMGetSnapPruneStatus"
--  |   This Procedure is used in the Custom Report for displaying the failures in Snap Deletion
--  +-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetSnapPruneStatus <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetSnapPruneStatus')
	drop procedure MM_SMGetSnapPruneStatus
IF EXISTS (select * from GxQscripts where name='MM_SMGetSnapPruneStatus')
	delete from GxQscripts where name = 'MM_SMGetSnapPruneStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetSnapPruneStatus')
	delete from GXDBVersions where aliasname = 'MM_SMGetSnapPruneStatus'
GO
print '... Creating Procedure: MM_SMGetSnapPruneStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetSnapPruneStatus
  @i_ReserveInt INT,
  @i_ReserveStr VARCHAR(255)
AS
  DECLARE @o_ArrayName NVARCHAR(2048)
  DECLARE @o_ArrayVendor NVARCHAR(256)
  DECLARE @o_SnapEngine NVARCHAR(256)
  DECLARE @o_ClientName NVARCHAR(512)
  DECLARE @o_JobId INTEGER
  DECLARE @o_StoragePolicyAndCopy NVARCHAR(512)
  DECLARE @o_SnapName NVARCHAR(2048)
  DECLARE @o_Attempts INTEGER
  DECLARE @o_FailCode INTEGER
  DECLARE @o_FailReason NVARCHAR(1024)
--
SET NOCOUNT ON
--
DECLARE @SnapsToDel TABLE  (
	snapId				INT,
	jobId				INT,
	volumeId			INT,
	sourceClientId		INT,
	copyId				INT,
	pruneFlags			INT,
	mountStatus			INT,
	retryCount			INT,
	controlHostId		INT,
	snapshotEngineId	INT,
	uniqueIdentifier	NVARCHAR(2048),
	failureCode			INT
)
--
DECLARE @failureReason TABLE (
	failureCode			INT,
	failureReason		NVARCHAR(1024)
)
--
--
-- Possible Snap Deletion Failure Reasons
INSERT INTO @failureReason VALUES ( 1,'MediaAgent not available as client is uninstalled' )
INSERT INTO @failureReason VALUES ( 2,'MediaAgent not available' )
INSERT INTO @failureReason VALUES ( 3,'Retries exceeded threshold value' )
INSERT INTO @failureReason VALUES ( 4,'MediaAgent Offline' )
INSERT INTO @failureReason VALUES ( 5,'Hardware or Network based conditions' )
INSERT INTO @failureReason VALUES ( 6,'Ready for snap pruning' )
INSERT INTO @failureReason VALUES ( 7,'Other' )
--
--
DECLARE @retryCountConfig INT
SET @retryCountConfig = ISNULL ((SELECT value FROM MMConfigs (NOLOCK) WHERE name = 'MMS2_CONFIG_VOLSNAP_RETRY_COUNT'),50)
--
--
-- Get the snaps that can be deleted. Also, get the jobIds of such snaps
INSERT	INTO @SnapsToDel
SELECT	DISTINCT SNAP.SMSnapId, VOL.JobId, VOL.SMVolumeId, VOL.SourceClientId, VOL.CopyId, VOL.PruneFlags, VOL.MountStatus, VOL.RetryCount,
		SNAP.ControlHostId, SNAP.SnapShotEngineId, SNAP.UniqueIdentifier,
		0
FROM	SMVolume VOL (NOLOCK) INNER JOIN SMVolSnapMap MAP (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
		INNER JOIN SMSnap SNAP (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId
WHERE	( VOL.PruneFlags = 0  OR VOL.PruneFlags > 1 )
		AND VOL.MountStatus < 99 /*SM_VS_DEL_DELETED*/
--
--
-- Depending on the mount status, the prune flag, retry count, and the client/Media Agent status, set the failure code
UPDATE	@SnapsToDel
SET		failureCode = (
			SELECT CASE
			WHEN ( (CLNT.id IS NULL OR (CLNT.status & 2 = 2/*CV_STATUS_UNINSTALLED*/) ) ) THEN 1 --MA not available as client is uninstalled
			WHEN ( (MA.ClientId IS NULL) ) THEN 2 --MA not available
			WHEN ( (A.mountStatus > 89) AND (A.retryCount >= @retryCountConfig) ) THEN 3 --Retry counts exceeded the threshold value
			WHEN ( (A.mountStatus > 89 OR (A.mountStatus < 90 AND A.retryCount = 0)) AND (A.retryCount < @retryCountConfig) AND (MA.MmHostSoftState = 0 OR MA.MmHostEnabled = 0 OR MA.OfflineReason > 0) ) THEN 4 --MA Offline
			WHEN ( (A.mountStatus > 89) AND (A.retryCount < @retryCountConfig) AND (MA.MmHostSoftState = 1 AND MA.MmHostEnabled = 1 AND MA.OfflineReason = 0) ) THEN 5 --Hardware or Network based conditions
			WHEN ( (A.pruneFlags > 1) AND (A.mountStatus <= 89) AND (A.retryCount = 0 ) AND (MA.MmHostSoftState = 1 AND MA.MmHostEnabled = 1 AND MA.OfflineReason = 0 ) ) THEN 6 --Ready for snap pruning
			ELSE 7 END --Other
		)
FROM	@SnapsToDel A LEFT JOIN MMHost MA (NOLOCK) ON A.sourceClientId = MA.ClientId
		LEFT JOIN APP_Client CLNT (NOLOCK) ON A.sourceClientId = CLNT.id
--
--
SELECT DISTINCT
		(CASE WHEN (LEN(ARRAY.SMArrayId) = 0 AND LEN(ARRAY.SMHostName) > 0) THEN ARRAY.SMHostName ELSE ARRAY.SMArrayId END) + ' (' + CAST (ARRAY.ControlHostId AS NVARCHAR(MAX)) + ')' AS 'Array Name(Id)',
		ARRAY.SnapVendorName AS 'Array Vendor',
		ARRAY.SnapShotEngineName + ' (' + CAST (A.snapShotEngineId AS NVARCHAR(MAX)) + ')'  AS 'Snap Engine',
		ISNULL(CLNT.name,'N/A') + ' (' + CAST (A.sourceClientId AS NVARCHAR(MAX)) + ')'  AS 'Client (Id)',
		A.JobId AS 'Job Id',
		AG.NAME + ' (' + AGC.NAME + ')' AS 'Storage Policy (Copy)',
		A.uniqueIdentifier + ' (' + CAST (A.snapId AS NVARCHAR(MAX)) + ')'  AS 'Snap Name (Id)',
		A.retryCount AS 'Delete Attempts',
		failReason.failureCode AS 'Failure Code',
		failReason.failureReason AS 'Failure Reason'
FROM	@SnapsToDel A	INNER JOIN  @failureReason failReason ON A.failureCode = failReason.failureCode
		INNER JOIN  SMControlHost ARRAY (NOLOCK) ON A.controlHostId = ARRAY.ControlHostId
		INNER JOIN archGroupCopy AGC (NOLOCK) ON AGC.id = A.copyId
		INNER JOIN archGroup AG (NOLOCK) ON AGC.archGroupId = AG.id
		LEFT JOIN   APP_Client CLNT (NOLOCK) ON A.sourceClientId = CLNT.id
ORDER BY failReason.failureCode, A.jobid

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetSnapPruneStatus')
	delete from GxQscripts where name = 'MM_SMGetSnapPruneStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetSnapPruneStatus')
	delete from GXDBVersions where aliasname = 'MM_SMGetSnapPruneStatus'
GO

insert into GXDBVersions values(2, 'MM_SMGetSnapPruneStatus',  '00000000000000000000', 'MM_SMGetSnapPruneStatus', '00000000000000000000')
GO

