

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetSnapMirrorCopyList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetSnapMirrorCopyList.sp,v $ $Id: MM_SMGetSnapMirrorCopyList.sp,v 1.3.210.1 2018/03/20 00:11:49 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetSnapMirrorCopyList <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetSnapMirrorCopyList')
	drop procedure MM_SMGetSnapMirrorCopyList
IF EXISTS (select * from GxQscripts where name='MM_SMGetSnapMirrorCopyList')
	delete from GxQscripts where name = 'MM_SMGetSnapMirrorCopyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetSnapMirrorCopyList')
	delete from GXDBVersions where aliasname = 'MM_SMGetSnapMirrorCopyList'
GO
print '... Creating Procedure: MM_SMGetSnapMirrorCopyList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetSnapMirrorCopyList
  @i_CopyListType integer,
  @i_reserveParam integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	If (@i_CopyListType = 0)
	BEGIN
		-- Return list of snap mirror copies
		SELECT
			A.id				'@copyId',
			A.name				'@copyName',
			B.id				'@storagePolicyId',
			B.name				'@storagePolicyName'
		FROM archGroupCopy A WITH (NOLOCK), archGroup B WITH (NOLOCK)
		WHERE A.archGroupId = B.id
		and A.isMirrorCopy = 1
		and A.id > 0
		FOR XML PATH('spMirrorCopyList')
	END
	else If (@i_CopyListType = 1)
	BEGIN
		-- Return list of snap secondary copies
		SELECT
			A.id				'@copyId',
			A.name				'@copyName',
			B.id				'@storagePolicyId',
			B.name				'@storagePolicyName'
		FROM archGroupCopy A WITH (NOLOCK), archGroup B WITH (NOLOCK)
		WHERE A.archGroupId = B.id
		and A.isSnapCopy = 1
		and A.isMirrorCopy = 0
		and A.id not in (select defaultSnapCopy from archGroup)
		and A.id > 0
		FOR XML PATH('spSecSnapCopyList')
	END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetSnapMirrorCopyList')
	delete from GxQscripts where name = 'MM_SMGetSnapMirrorCopyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetSnapMirrorCopyList')
	delete from GXDBVersions where aliasname = 'MM_SMGetSnapMirrorCopyList'
GO

insert into GXDBVersions values(2, 'MM_SMGetSnapMirrorCopyList',  '00010003021000010000', 'MM_SMGetSnapMirrorCopyList', '00010003021000010000')
GO

