

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetReplicationVendorEntities.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Munish Tayal
-- Create date: 05/02/2020
-- Description:	Returns the list of vendor and their replication entities like SVMs and AWS regions
-- Parameters :	user id
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMGetReplicationVendorEntities')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetReplicationVendorEntities <<<'
	drop procedure MM_SMGetReplicationVendorEntities
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetReplicationVendorEntities')
	delete from GxQscripts where name = 'MM_SMGetReplicationVendorEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetReplicationVendorEntities')
	delete from GXDBVersions where aliasname = 'MM_SMGetReplicationVendorEntities'
GO
print '... Creating Procedure: MM_SMGetReplicationVendorEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetReplicationVendorEntities
  @i_userId integer,
  @i_localeId integer
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @tblReplicationEntity TABLE (
	id	INT,
name NVARCHAR(255),
sourceLabel NVARCHAR(255),
destlabel NVARCHAR(255),
headingLabel NVARCHAR(255)
)
INSERT INTO @tblReplicationEntity
SELECT 	VEN.Id, Ven.Name, LM1.Message, LM2.Message, LM3.Message
FROM 	SMVendorReplicationLabel VRL
		JOIN EvLocaleMsgs LM1 ON VRL.SourceEntityLabel = LM1.MessageID
		JOIN EvLocaleMsgs LM2 ON VRL.DestEntityLabel = LM2.MessageID
		JOIN EvLocaleMsgs LM3 ON VRL.MapHeadingLabel = LM3.MessageID
		JOIN SMVendor VEN ON VRL.VendorId = VEN.Id
WHERE	LM1.LocaleID = @i_localeId
		AND LM2.LocaleID = @i_localeId
		AND LM3.LocaleID = @i_localeId
AND VRL.ShowInGUI = 1
DECLARE @netAppSVMtbl TABLE (
	arrayId INT,
	arrayName NVARCHAR(128)
)
INSERT INTO @netAppSVMtbl
SELECT ControlHostId, SMArrayId
FROM SMControlHost WHERE SnapVendorName = 'NetApp' /* SM_SNAPSHOT_ENGINE_NETAPP_VENDORNAME */ AND (SMHostFlags & 8 /* CVSM_CTRLHOST_CMODE_VSERVER_DB */ <> 0)
IF OBJECT_ID('tempdb.dbo.#GRVEtblArrayWithRight') IS NOT NULL
    DROP TABLE #GRVEtblArrayWithRight
CREATE TABLE #GRVEtblArrayWithRight (arrayId INT)
IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects_InputPermissionsTbl') IS NOT NULL
    DROP TABLE #getNonIdaObjects_InputPermissionsTbl
CREATE TABLE #getNonIdaObjects_InputPermissionsTbl (permissionId    INT)
INSERT INTO #getNonIdaObjects_InputPermissionsTbl VALUES(1)
INSERT INTO #getNonIdaObjects_InputPermissionsTbl VALUES(244)
INSERT INTO #getNonIdaObjects_InputPermissionsTbl VALUES(245)
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 153, -1, '#GRVEtblArrayWithRight'
-- Delete arrays the user cannot access
DELETE FROM @netAppSVMtbl WHERE arrayId NOT IN (SELECT arrayId FROM #GRVEtblArrayWithRight)
IF OBJECT_ID('tempdb.dbo.#GRVEtblArrayWithRight') IS NOT NULL
    DROP TABLE #GRVEtblArrayWithRight
IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects_InputPermissionsTbl') IS NOT NULL
	DROP TABLE #getNonIdaObjects_InputPermissionsTbl
DECLARE @netAppSVMList XML = (SELECT
	arrayId AS '@id',
	arrayName AS '@name'
FROM @netAppSVMtbl
FOR XML PATH ('replicationEntity'),TYPE)
DECLARE @AWSRegionsList XML = (SELECT
	Id AS '@id',
	RegionName AS '@name'
FROM App_CloudVendorRegion
FOR XML PATH ('replicationEntity'), TYPE)
DECLARE @outXML XML =	(SELECT
							(SELECT	sourceLabel AS '@sourceLabel',
									destlabel AS '@destLabel',
									headingLabel AS '@mapHeadingLabel',
									(SELECT
										id	AS '@id',
										name		AS '@name'
									FOR XML PATH ('vendor'), TYPE),
									(CASE
WHEN id = 3 THEN @netAppSVMList
WHEN id = 28 THEN @AWSRegionsList
									END)
							FROM @tblReplicationEntity
							FOR XML PATH ( 'replicationVendor' ), TYPE)
						FOR XML PATH ( 'GetReplicationVendorsResp' ), TYPE)
SELECT @outXML
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetReplicationVendorEntities')
	delete from GxQscripts where name = 'MM_SMGetReplicationVendorEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetReplicationVendorEntities')
	delete from GXDBVersions where aliasname = 'MM_SMGetReplicationVendorEntities'
GO

insert into GXDBVersions values(2, 'MM_SMGetReplicationVendorEntities',  '00000000000000000000', 'MM_SMGetReplicationVendorEntities', '00000000000000000000')
GO

