

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetPRDMMountDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetPRDMMountDetails.sp,v $ $Id: MM_SMGetPRDMMountDetails.sp,v 1.1.2.5 2020/07/30 15:29:05 abhinawkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMGetPRDMMountDetails')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetPRDMMountDetails <<<'
	drop procedure MM_SMGetPRDMMountDetails
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetPRDMMountDetails')
	delete from GxQscripts where name = 'MM_SMGetPRDMMountDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetPRDMMountDetails')
	delete from GXDBVersions where aliasname = 'MM_SMGetPRDMMountDetails'
GO
print '... Creating Procedure: MM_SMGetPRDMMountDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetPRDMMountDetails
  @i_xmlInput XML = NULL,
  @i_reserveInt INT = 0
AS
  DECLARE @o_vCenterHost VARCHAR(1024)
  DECLARE @o_vCenterUser VARCHAR(1024)
  DECLARE @o_vCenterPass VARCHAR(1024)
  DECLARE @o_vVMUUID VARCHAR(1024)
  DECLARE @o_ProxyName VARCHAR(1024)
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
SET NOCOUNT ON
/*
		<MM_SMGetPRDMMountDetails>
			<vCenterName>%s</vCenterName>
			<MountHostId>%d</MountHostId>
		</MM_SMGetPRDMMountDetails>
*/
----------------------------------------------------- ERROR VARIABLES -----------------------------------------------------
SET @o_ErrorCode	= 0
SET @o_ErrorStr		= ''
----------------------------------------------------- CONSTANTS FOR ERROR VALUES ------------------------------------------
DECLARE @ERROR_INVALID_XML_INPUT				INTEGER	= 1
DECLARE @ERROR_INVALID_VCENTER_NAME				INTEGER = 2
DECLARE @ERROR_INVALID_MOUNTHOSTID				INTEGER = 3
DECLARE @ERROR_VCENTER_CLIENT_NOT_FOUND			INTEGER = 4
DECLARE @ERROR_VCENTER_INST_NOT_FOUND			INTEGER = 5
----------------------------------------------------- OTHER CONSTANTS -----------------------------------------------------
DECLARE @VCENTER_APP_TYPE_ID					INTEGER				= 106
DECLARE @CLIENT_PROP_MIN_SP_LEVEL				FLOAT				= 15
DECLARE @VCENTER_PROP_CREDENTIAL_REF_ID			NVARCHAR(1024)		= N'Virtual Server Credential Assoc Id'
DECLARE @VCENTER_PROP_HOST_NAME					NVARCHAR(1024)		= N'Virtual Server Host'
DECLARE @VCENTER_PROP_USERNAME					NVARCHAR(1024)		= N'Virtual Server User'
DECLARE @VCENTER_PROP_PASSWORD					NVARCHAR(1024)		= N'Virtual Server Password'
DECLARE @VCENTER_PROP_PROXY_LIST				NVARCHAR(1024)		= N'Vs Member Servers'
DECLARE @CLIENT_PROP_VM_UUID					NVARCHAR(1024)		= N'Virtual Machine GUID'
DECLARE @CLIENT_PROP_SP_VER_AND_PATCH			NVARCHAR(2048)		= N'SP Version and Patch Info'
DECLARE @CLIENT_PROP_SP_SEACRH_KEYWORD			NVARCHAR(16)		= N'ServicePack:'
DECLARE @CLIENT_PROP_COMA_KEYWORD				NVARCHAR(8)			= N','
----------------------------------------------------- LOCAL VARIABLES -----------------------------------------------------
DECLARE @x_vCenterName			NVARCHAR(256)	= N''
DECLARE	@x_InstanceId			INTEGER			= 0
DECLARE @x_ClientId				INTEGER			= 0
DECLARE @x_MountHostId			INTEGER			= 0
DECLARE @x_ProxyServers			XML				= NULL
DECLARE	@x_vCenterHost			NVARCHAR(1024)	= N''
DECLARE	@x_vCenterUser			NVARCHAR(1024)	= N''
DECLARE @x_vCenterPass			NVARCHAR(1024)	= N''
DECLARE @x_vVMUUID				NVARCHAR(1024)	= N''
----------------------------------------------------- LOCAL TABLES --------------------------------------------------------
DECLARE	@tblVCenterProps		TABLE (
			attrName			NVARCHAR(2048),
			attrVal				NVARCHAR(2048)
)
DECLARE @tblClientIds			TABLE (
			id					INT IDENTITY,
			clientId			INT,
			clientGroupId		INT
)
DECLARE @tblProxyList			TABLE ( id	INT	)
DECLARE @tblTempProxyList		TABLE ( id	INT	)
----------------------------------------------------- INPUT VALIDATION ----------------------------------------------------
IF @i_xmlInput IS NULL
BEGIN
	SET @o_ErrorCode	= @ERROR_INVALID_XML_INPUT
	SET @o_ErrorStr		= 'Input XML Parameter cannot be empty.'
	GOTO PROC_END
END
----------------------------------------------------- INPUT PARSING -------------------------------------------------------
SET @x_vCenterName	= ISNULL((SELECT R.ref.value('.', 'NVARCHAR(256)'	) FROM @i_xmlInput.nodes('/MM_SMGetPRDMMountDetails/vCenterName')	R(ref)),	N''	)
SET @x_MountHostId	= ISNULL((SELECT R.ref.value('.', 'INT'				) FROM @i_xmlInput.nodes('/MM_SMGetPRDMMountDetails/MountHostId')	R(ref)),	0	)
---- EMPTY VCENTER NAME
IF @x_vCenterName = N''
BEGIN
	SET @o_ErrorCode	= @ERROR_INVALID_VCENTER_NAME
	SET @o_ErrorStr		= 'Invalid vCenter Name passed.'
	GOTO PROC_END
END
---- EMPTY MOUNTHOST ID
IF @x_MountHostId = 0
BEGIN
	SET @o_ErrorCode	= @ERROR_INVALID_MOUNTHOSTID
	SET @o_ErrorStr		= 'Invalid MountHostId passed.'
	GOTO PROC_END
END
---- VCENTER CLIENT DOESN'T EXIST
IF NOT EXISTS(SELECT TOP 1 ID FROM APP_CLIENT (READUNCOMMITTED) WHERE NAME = @x_vCenterName)
BEGIN
	SET @o_ErrorCode	= @ERROR_VCENTER_CLIENT_NOT_FOUND
	SET @o_ErrorStr		= 'vCenter client with name-[' + @x_vCenterName + '] not found. Please check the additional settings.'
	GOTO PROC_END
END
-- FETCH VM CLIENT ID
SELECT @x_ClientId = AC.Id from APP_CLIENT AC (READUNCOMMITTED) WHERE AC.name = @x_vCenterName
---- FETCH THE VMWARE INSTANCE ID
SET	@x_InstanceId = (SELECT DISTINCT APP.instance
					FROM	APP_APPLICATION APP (READUNCOMMITTED)
					WHERE	APP.clientId	= @x_ClientId
					AND	APP.AppTypeId		= @VCENTER_APP_TYPE_ID)
---- VMWARE INSTANCE NOT FOUND
IF @x_InstanceId = 0
BEGIN
	SET @o_ErrorCode	= @ERROR_VCENTER_INST_NOT_FOUND
	SET @o_ErrorStr		= 'VMware Instance has not been configured for vCenter client name-[' + @x_vCenterName + '].'
	GOTO PROC_END
END
----------------------------------------------------- MAIN LOGIC ----------------------------------------------------------
INSERT	INTO @tblVCenterProps
SELECT	IPROP.attrName, CASE WHEN IPROP.attrName = @VCENTER_PROP_PASSWORD THEN dbo.pswConvertV5ToV3(IPROP.attrVal) ELSE IPROP.attrVal END
FROM	(	APP_INSTANCENAME INAME (READUNCOMMITTED) INNER JOIN
			APP_INSTANCEPROP IPROP (READUNCOMMITTED) ON
			INAME.id = IPROP.componentNameId			)
WHERE	INAME.id = @x_InstanceId
		AND IPROP.modified = 0
		AND	IPROP.attrName IN (@VCENTER_PROP_HOST_NAME, @VCENTER_PROP_USERNAME, @VCENTER_PROP_PASSWORD, @VCENTER_PROP_PROXY_LIST,@VCENTER_PROP_CREDENTIAL_REF_ID)
DECLARE @credAssocId  INT = 0
SET @credAssocId = ISNULL((SELECT CAST(VCP.attrVal AS INT) FROM @tblVCenterProps VCP WHERE VCP.attrName = @VCENTER_PROP_CREDENTIAL_REF_ID),0)
IF @credAssocId > 0
BEGIN
	-- Update user name and password
	EXEC GetCredentialsFromCredentialAssocIds @credAssocId, @x_vCenterUser OUTPUT, @x_vCenterPass OUTPUT
END
ELSE
BEGIN
	---- Get the Username from vCenter property
	SELECT @x_vCenterUser	= VCP.attrVal FROM @tblVCenterProps VCP WHERE VCP.attrName = @VCENTER_PROP_USERNAME
	---- Get the Password from vCenter property
	SELECT @x_vCenterPass	= VCP.attrVal FROM @tblVCenterProps VCP WHERE VCP.attrName = @VCENTER_PROP_PASSWORD
END
---- Get the HostName from vCenter property
SELECT @x_vCenterHost	= VCP.attrVal FROM @tblVCenterProps VCP WHERE VCP.attrName = @VCENTER_PROP_HOST_NAME
---- Get the Client Ids from the ProxyList property
SELECT @x_ProxyServers	= VCP.attrVal FROM @tblVCenterProps VCP WHERE VCP.attrName = @VCENTER_PROP_PROXY_LIST
INSERT INTO @tblClientIds
SELECT
	[clientId]			= ISNULL(ref.value('client[1]/@clientId'		, 'INTEGER'), 0),
	[clientGroupId]		= ISNULL(ref.value('client[1]/@clientGroupId'	, 'INTEGER'), 0)
FROM	@x_ProxyServers.nodes('App_MemberServers/memberServers') R (ref)
---- Get all the single clients, if any
INSERT	INTO @tblTempProxyList
SELECT	TCL.clientId
FROM	@tblClientIds TCL
WHERE	TCL.clientId <> 0 AND TCL.clientGroupId = 0
---- Get all the clients from Group, if any
INSERT	INTO @tblTempProxyList
SELECT	CGA.clientId
FROM	@tblClientIds TCL INNER JOIN APP_ClientGroupAssoc CGA (READUNCOMMITTED) ON TCL.clientGroupId = CGA.clientGroupId
WHERE		(TCL.clientId = 0)
		AND (CGA.clientId NOT IN (SELECT TTPL.id FROM @tblTempProxyList TTPL))
---- If current mount host is also a VSA proxy, give priority to it.
IF EXISTS (SELECT 1 FROM @tblTempProxyList TTPL WHERE TTPL.id = @x_MountHostId)
BEGIN
	INSERT	INTO @tblProxyList VALUES (@x_MountHostId)
END
---- Add the remaining entries.
INSERT	INTO @tblProxyList
SELECT	TTPL.id
FROM	@tblTempProxyList TTPL
WHERE	TTPL.id NOT IN (SELECT TPL.id FROM @tblProxyList TPL)
---- Remove all the VSA proxies with version less than V11 SP15.
DELETE	FROM @tblProxyList
FROM	@tblProxyList TPL	INNER JOIN APP_Client		APC	 (READUNCOMMITTED) ON	TPL.id = APC.id
							INNER JOIN APP_ClientProp	APCP (READUNCOMMITTED) ON	APC.id = APCP.componentNameId AND APCP.attrName = @CLIENT_PROP_SP_VER_AND_PATCH AND APCP.modified = 0
WHERE		(APC.releaseId < 16)	---- version lesser than 11.0
			OR
			(
				---- version in 11.0 but SP lesser than 15
				-------- the property will be like 'ServicePack:15,Additional Updates:,PreRelease-518-BIN,PreRelease-654-BIN' OR	like 'ServicePack:15'	OR	like 'ServicePack:18.4'
(APC.releaseId = 16)
				AND
				(	@CLIENT_PROP_MIN_SP_LEVEL > CAST (	SUBSTRING(	APCP.attrVal,
																	CHARINDEX(@CLIENT_PROP_SP_SEACRH_KEYWORD, APCP.attrVal) + LEN(@CLIENT_PROP_SP_SEACRH_KEYWORD),
																	CASE	WHEN 0 < CHARINDEX(@CLIENT_PROP_COMA_KEYWORD, APCP.attrVal, CHARINDEX(@CLIENT_PROP_SP_SEACRH_KEYWORD, APCP.attrVal))
																				THEN
																					(	CHARINDEX(@CLIENT_PROP_COMA_KEYWORD, APCP.attrVal, CHARINDEX(@CLIENT_PROP_SP_SEACRH_KEYWORD, APCP.attrVal))
																						- CHARINDEX(@CLIENT_PROP_SP_SEACRH_KEYWORD, APCP.attrVal) - LEN(@CLIENT_PROP_SP_SEACRH_KEYWORD)
																					)
																			ELSE
																				LEN(APCP.attrVal)
																	END
																 ) AS FLOAT
													 )
				)
			)
---- Remove all the VSA proxies where the MA service is not up or MA is not present.
DELETE	FROM @tblProxyList
FROM	@tblProxyList TPL LEFT OUTER JOIN MMHost MH (READUNCOMMITTED) ON TPL.Id = MH.ClientId
WHERE	(MH.ClientId IS NULL) OR (MH.MmHostSoftState = 0) OR (MH.MmHostEnabled = 0)
---- Get the MA's VM UUID
SELECT	@x_vVMUUID = ACP.attrVal
FROM	APP_CLIENTPROP ACP (READUNCOMMITTED)
WHERE	ACP.componentNameId = @x_MountHostId
		AND ACP.attrName	= @CLIENT_PROP_VM_UUID
----------------------------------------------------- RETURN VALUES -------------------------------------------------------
SELECT	@x_vCenterHost, @x_vCenterUser, @x_vCenterPass, @x_vVMUUID, APC.name, @o_ErrorCode, @o_ErrorStr
FROM	@tblProxyList TPL INNER JOIN APP_CLIENT APC (READUNCOMMITTED) ON TPL.id = APC.id
RETURN
PROC_END:
	SELECT '', '', '', '', '', @o_ErrorCode, @o_ErrorStr
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetPRDMMountDetails')
	delete from GxQscripts where name = 'MM_SMGetPRDMMountDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetPRDMMountDetails')
	delete from GXDBVersions where aliasname = 'MM_SMGetPRDMMountDetails'
GO

insert into GXDBVersions values(2, 'MM_SMGetPRDMMountDetails',  '00010001000200050000', 'MM_SMGetPRDMMountDetails', '00010001000200050000')
GO

