

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetMAForReplication.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMGetMAForReplication')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetMAForReplication <<<'
	drop procedure MM_SMGetMAForReplication
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetMAForReplication')
	delete from GxQscripts where name = 'MM_SMGetMAForReplication'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetMAForReplication')
	delete from GXDBVersions where aliasname = 'MM_SMGetMAForReplication'
GO
print '... Creating Procedure: MM_SMGetMAForReplication'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetMAForReplication
  @i_adminJobId INTEGER,
  @i_destCopyId INTEGER,
  @i_isForNewData INTEGER,
  @i_ReserveParam1 INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(1024);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@errVal	INTEGER
DECLARE	@errStr	VARCHAR(1024)
SET @errVal = 0
SET @errStr = 'NO ERROR'
IF OBJECT_ID('tempdb.dbo.#tblArrayControllers') IS NOT NULL
	DROP TABLE #tblArrayControllers
CREATE TABLE #tblArrayControllers (
	CtrlHostId					INTEGER,
	MMHostId					INTEGER,
	HostNumForThisArray			INTEGER,
	TotalHostsForThisArray		INTEGER,
	IsReplicaGroupConfigured	INTEGER
)
IF OBJECT_ID('tempdb.dbo.#tblArchFiles') IS NOT NULL
	DROP TABLE #tblArchFiles
CREATE TABLE #tblArchFiles (
	AdminJobId					INTEGER,
	BackupJobId					INTEGER,
	ArchFileId					INTEGER,
	SrcCopyId					INTEGER,
	DestCopyId					INTEGER,
	SMVolumeId					INTEGER,
	SrcClientId					INTEGER,
	AppId						INTEGER,
	SrcEngineId					INTEGER,
	SrcCtrlHostId				INTEGER,
	StreamId					INTEGER,
	HostNumForThisArray			INTEGER,
	AuxCopyMA					INTEGER,
	CommCellId					INTEGER,
	ArchGroupId					INTEGER,
	ErrorCode					INTEGER,
	OrigAppId					INTEGER,
	MasterJobId					INTEGER
)
DECLARE @tblAppStremInfo TABLE( appId int, destStreamNum int, srcMAId int, mediaGroupId int, streamReaderID int, SrcCtrlHostId int, HostNumForThisArray int )
DECLARE @tblStreamAllocInfo TABLE ( streamNum int, assocAppCount int, idxForAlloc int )
DECLARE @max_stream	INTEGER = 0
DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS    INT = 15
SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WITH (READUNCOMMITTED) WHERE NAME = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'), 15)
-- If some appIds are marked as skipped, then mark newer jobs of those appIds as skipped
	UPDATE	ACR
	SET		DestStreamNum= B.DestStreamNum,
			SrcMAId = B.SrcMAId,
			MediaGroupId = B.MediaGroupId,
			SkippedCount = B.SkippedCount,
			SkippedForSeconds = B.SkippedForSeconds,
			SkippedReason = B.SkippedReason,
			ErrorCode = B.ErrorCode,
			Modified = B.Modified,
Status = 3,
			StreamReaderId = B.StreamReaderId
	FROM	ArchChunkToReplicate ACR INNER JOIN
			(
				SELECT	DISTINCT ACR.appId,
								MAX(DestStreamNum) DestStreamNum,
								MAX(SrcMAId) SrcMAId,
								MAX(MediaGroupId) MediaGroupId,
								MAX(SkippedCount) SkippedCount,
								MAX(SkippedForSeconds) SkippedForSeconds,
								MAX(SkippedReason) SkippedReason,
								MAX(ErrorCode) ErrorCode,
								MAX(Modified) Modified,
								MAX(StreamReaderId) StreamReaderId
				FROM	ArchChunkToReplicate ACR WITH (READUNCOMMITTED)
				WHERE	ACR.AdminJobId = @i_adminJobId
						AND ACR.DestCopyId = @i_destCopyId
						AND ACR.SrcMAId > 0
						AND ACR.fileType = 1
AND ACR.Status IN ( 3, 5 )
				GROUP BY ACR.appId
			) B ON ACR.appId = B.appId
	WHERE	ACR.AdminJobId = @i_adminJobId
			AND ACR.DestCopyId = @i_destCopyId
			AND ACR.fileType = 1
AND ACR.Status = 0
IF @i_isForNewData = 1
BEGIN
	INSERT INTO @tblAppStremInfo
	SELECT	DISTINCT ACR.appId, MAX(STREAM.DestStreamNum), MAX(STREAM.SrcMAId), MAX(ACR.MediaGroupId), MAX(ACR.streamReaderID), 0, 0
	FROM	ArchChunkToReplicate (READUNCOMMITTED) ACR
			INNER JOIN ArchJobStreamStatus STREAM (READUNCOMMITTED) ON ACR.AdminJobId = STREAM.JobId AND ACR.DestCopyId = STREAM.DestCopyId
	WHERE	ACR.AdminJobId = @i_adminJobId
			AND ACR.DestCopyId = @i_destCopyId
			AND ACR.SrcMAId = STREAM.SrcMAId
			AND	ACR.DestStreamNum = STREAM.DestStreamNum
AND STREAM.Status = 0x02
			AND ACR.SrcMAId > 0
			AND ACR.fileType = 1
AND ACR.Status IN ( 0, 1, 3, 5 )
	GROUP BY ACR.appId
	UPDATE	R1
	SET  	R1.DestStreamNum = R2.DestStreamNum,
			R1.SrcMAId = R2.SrcMAId,
			R1.MediaGroupId = R2.MediaGroupId,
			R1.StreamReaderId = R2.StreamReaderId
	FROM	ArchChunkToReplicate R1
			INNER JOIN @tblAppStremInfo R2 ON R1.AppId = R2.AppId
	WHERE	R1.AdminJobId = @i_adminJobId
			AND R1.DestCopyId = @i_destCopyId
AND R1.Status = 0
			AND R1.SrcMAId = 0
			AND R1.fileType = 1
END
-- Build a list of Archive Files with associated Array and Source Client
INSERT INTO	#tblArchFiles
SELECT	ACR.AdminJobId, ACR.BackupJobId, ACR.ArchFileId, ACR.SrcCopyId, ACR.DestCopyId,
		VOL.SMVolumeId, VOL.SourceClientId, 0, SNAP.SnapShotEngineId, SNAP.ControlHostId,
0, 0, 0, ACR.CommCellId, ACR.ArchGroupId, 0, VOL.AppId,  IIF(VOL.VolumeFlags & CAST( 4294967296 AS BIGINT) > 0,VOL.MasterJobId,0)
FROM	ArchChunkToReplicate (NOLOCK) ACR
		INNER JOIN SMVolume (NOLOCK) VOL ON VOL.SMVolumeId = ACR.VolumeId
		INNER JOIN SMVolSnapMap (NOLOCK) MAP ON VOL.SMVolumeId = MAP.SMVolumeId
		INNER JOIN SMSnap (NOLOCK) SNAP ON MAP.SMSnapId = SNAP.SMSnapId
WHERE	ACR.AdminJobId = @i_adminJobId
		AND ACR.DestCopyId = @i_destCopyId
AND ACR.Status = 0
		AND ACR.DestStreamNum > 1
		AND (@i_isForNewData = 0 OR (@i_isForNewData = 1 AND ACR.SrcMAId = 0 ) )
ORDER	BY ACR.SrcCopyId, ACR.DestCopyId, VOL.AppId, ACR.BackupJobId,
		SNAP.SnapShotEngineId, SNAP.ControlHostId, ACR.ArchFileId
IF NOT EXISTS ( SELECT 1 FROM #tblArchFiles )
BEGIN
	SELECT @errVal, @errStr
	RETURN @errVal
END
--Create bucket of all appids of master jobs and all master jobs of appid, Assign same appid number to all of for VSA V2 condition. They all will go to same stream
IF EXISTS( SELECT 1 FROM #tblArchFiles WHERE MasterJobId > 0)
BEGIN
	DECLARE @maxAppId INT = 0
	SELECT	@maxAppId = MAX(OrigAppId) + 1
	FROM	#tblArchFiles
	DECLARE @updatedRowCount INT = 0
	DECLARE @l_MasterJobId INT = 0
	SELECT	@l_MasterJobId = MIN(T.MasterJobId)
	FROM	#tblArchFiles T
	WHERE	T.AppId = 0
			AND T.MasterJobId > 0
	WHILE (@l_MasterJobId > 0)
	BEGIN
		UPDATE	T
		SET		AppId = @maxAppId
		FROM	#tblArchFiles T
		WHERE	T.MasterJobId = @l_MasterJobId
				AND T.AppId = 0
				AND T.MasterJobId > 0
		SET @updatedRowCount = @@ROWCOUNT
		WHILE (@updatedRowCount > 0)
		BEGIN
			SET @updatedRowCount = 0
			UPDATE	T
			SET		AppId = @maxAppId
			FROM	#tblArchFiles T, #tblArchFiles S
			WHERE	T.OrigAppId = S.OrigAppId
					AND T.AppId = 0
					AND T.MasterJobId > 0
					AND S.AppId = @maxAppId
			SET @updatedRowCount = @updatedRowCount + @@ROWCOUNT
			UPDATE	T
			SET		AppId = @maxAppId
			FROM	#tblArchFiles T, #tblArchFiles S
			WHERE	T.MasterJobId = S.MasterJobId
					AND T.AppId = 0
					AND T.MasterJobId > 0
					AND S.AppId = @maxAppId
			SET @updatedRowCount = @updatedRowCount + @@ROWCOUNT
		END
		SELECT	@l_MasterJobId = ISNULL(MIN(T.MasterJobId), 0)
		FROM	#tblArchFiles T
		WHERE	T.AppId = 0
				AND T.MasterJobId > 0
		SET @maxAppId = @maxAppId + 1
	END
END
UPDATE	AF
SET		AppId = OrigAppId
FROM	#tblArchFiles AF
WHERE	AppId = 0
		AND MasterJobId = 0
UPDATE	A
SET		A.AppId = AF.AppId
FROM	@tblAppStremInfo A, #tblArchFiles AF
WHERE	A.AppId = AF.OrigAppId
		AND AF.MasterJobId > 0
IF EXISTS( SELECT 1 FROM #tblArchFiles WHERE MasterJobId > 0)
	AND @i_isForNewData = 1
BEGIN
	UPDATE	R1
	SET  	R1.DestStreamNum = R2.DestStreamNum,
			R1.SrcMAId = R2.SrcMAId,
			R1.MediaGroupId = R2.MediaGroupId,
			R1.StreamReaderId = R2.StreamReaderId
	FROM	ArchChunkToReplicate R1
			INNER JOIN #tblArchFiles AF1 ON R1.AppId = AF1.OrigAppId
			INNER JOIN @tblAppStremInfo R2 ON AF1.AppId = R2.AppId
	WHERE	R1.AdminJobId = @i_adminJobId
			AND R1.DestCopyId = @i_destCopyId
AND R1.Status = 0
			AND R1.SrcMAId = 0
			AND R1.fileType = 1
	IF (@@ROWCOUNT > 0)
	BEGIN
		DELETE	AF
		FROM	#tblArchFiles AF
				INNER JOIN ArchChunkToReplicate R WITH (READUNCOMMITTED)
						ON	AF.AdminJobId = R.AdminJobId
							AND AF.ArchFileId = R.ArchFileId
							AND AF.CommCellID = R.CommCellId
							AND R.DestCopyId = @i_destCopyId
							AND R.SrcMAId > 0
	END
END
-- Fetch the max stream count
SELECT	@max_stream = (CASE WHEN (AGC.flags & 4) = 0 THEN AG.maxStreams ELSE AGC.maxStreamNum END)
FROM	archGroupCopy AGC (NOLOCK)  INNER JOIN archGroup AG (NOLOCK) ON AGC.archgroupId = AG.id
WHERE	AGC.id = @i_destCopyId
-- When max stream is set to 1. Since stream 1 is always used for BCD index. assume 2 streams are available
IF @max_stream = 1
BEGIN
	SET @max_stream = @max_stream + 1
END
-- Build a list of arrays and their array controllers which are online
INSERT	INTO #tblArrayControllers
SELECT	DISTINCT CTRL.ControlHostId, CLUS_AC.MMHostId, 0, 0, 0
FROM	#tblArchFiles ARCH INNER JOIN
		SMControlHost CTRL (NOLOCK) ON ARCH.SrcCtrlHostId = CTRL.ControlHostId
		INNER JOIN SMConfigs CFGS (NOLOCK) ON CTRL.ControlHostId = CFGS.ArrayId
		INNER JOIN APP_VMToPMMap MAP (NOLOCK) ON MAP.VMClientId = CTRL.ClientId
		INNER JOIN SMControlHost CLUSTER (NOLOCK) ON MAP.PMClientId = CLUSTER.ClientId
		INNER JOIN SMArrayController (NOLOCK) CLUS_AC ON CLUSTER.ControlHostId = CLUS_AC.ArrayNum
		INNER JOIN MMHost MMH (NOLOCK) on CLUS_AC.MMHostId = MMH.ClientId
WHERE	MMH.MmHostEnabled = 1
		AND MMH.MmHostSoftState = 1
		AND CFGS.ValueInt = 1
AND CTRL.SMHostFlags & 8 = 8 /*CVSM_CTRLHOST_CMODE_VSERVER_DB*/
		AND CFGS.AssocId = CTRL.ControlHostId
AND CFGS.AssocType = 3 /*MMSM_AT_ARRAY*/
AND CFGS.MasterConfigId = 31 /*SMCONFIG_NETAPP_NAME_USE_TUNNELING*/
INSERT  INTO #tblArrayControllers
SELECT  DISTINCT AC.ArrayNum, AC.MMHostId, 0, 0, 0
FROM    #tblArchFiles ARCH
		INNER JOIN SMArrayController AC (NOLOCK) ON ARCH.SrcCtrlHostId = AC.ArrayNum
		INNER JOIN MMHost MMH (NOLOCK) on AC.MMHostId = MMH.ClientId
		LEFT JOIN #tblArrayControllers CURR_AC ON CURR_AC.CtrlHostId = AC.ArrayNum
WHERE	MMH.MmHostEnabled = 1
		AND MMH.MmHostSoftState = 1
		AND CURR_AC.CtrlHostId  IS NULL
-- For NetApp, if there is a replica group reserved for an array, then the MA should be atleast at SP9
UPDATE	AC
SET		IsReplicaGroupConfigured = 1
FROM	#tblArrayControllers AC INNER JOIN SMReplicaEntities E (NOLOCK) ON AC.CtrlHostId = E.ArrayNum
-- Check for any array, if there are replica groups configured. If configured, then for those arrays, we need to select atleast SP9 Array Controller
IF EXISTS (SELECT 1 FROM #tblArrayControllers WHERE IsReplicaGroupConfigured = 1)
BEGIN
	DELETE	TMP
	FROM    #tblArrayControllers TMP INNER JOIN
			(SELECT	DISTINCT TMP.MMHostId AS ClientId, CLIENT.ReleaseId AS ReleaseId, PKG.HighestSP AS SPMajor,	PKG.SpMinorVersion AS SPMinor
			FROM	#tblArrayControllers TMP
				LEFT OUTER JOIN APP_VMToPMMap MAP (NOLOCK) ON MAP.VMClientId = TMP.MMHostId
				INNER JOIN SimInstalledPackages PKG (NOLOCK) ON PKG.ClientId = ISNULL(MAP.PMClientId, TMP.MMHostId)
				INNER JOIN APP_Client CLIENT (NOLOCK) ON CLIENT.id = ISNULL(MAP.PMClientId, TMP.MMHostId)
WHERE	PKG.simPackageID in (51 /*N_WIN_PACKAGE_MEDIAAGENT*/, 1301 /*N_UNIX_PACKAGES_MEDIA_AGENT*/)
					AND TMP.IsReplicaGroupConfigured = 1) SPL ON TMP.MMHostId = SPL.ClientId
	WHERE   TMP.IsReplicaGroupConfigured = 1
AND (( SPL.ReleaseId = 16 /*SIM_ID_GX_REL110*/	AND SPMajor < 9) OR (SPL.ReleaseId = 15 /*SIM_ID_GX_REL100*/))
END
-- Check for cascade support, if there are any array controllers with version lower than SP14, then remove them.
IF EXISTS (SELECT 1 FROM #tblArrayControllers)
BEGIN
	IF EXISTS (SELECT 1 FROM #tblArchFiles TAF INNER JOIN archGroup AG (NOLOCK) ON AG.id = TAF.ArchGroupId WHERE TAF.SrcCopyId <> AG.defaultSnapCopy)
	BEGIN
		DELETE	TMP
		FROM    #tblArrayControllers TMP INNER JOIN
				(SELECT	DISTINCT TMP.MMHostId AS ClientId, CLIENT.ReleaseId AS ReleaseId, PKG.HighestSP AS SPMajor,	PKG.SpMinorVersion AS SPMinor
				FROM	#tblArrayControllers TMP
					LEFT OUTER JOIN APP_VMToPMMap MAP (NOLOCK) ON MAP.VMClientId = TMP.MMHostId
					INNER JOIN SimInstalledPackages PKG (NOLOCK) ON PKG.ClientId = ISNULL(MAP.PMClientId, TMP.MMHostId)
					INNER JOIN APP_Client CLIENT (NOLOCK) ON CLIENT.id = ISNULL(MAP.PMClientId, TMP.MMHostId)
WHERE	PKG.simPackageID in (51 /*N_WIN_PACKAGE_MEDIAAGENT*/, 1301 /*N_UNIX_PACKAGES_MEDIA_AGENT*/)) SPL ON TMP.MMHostId = SPL.ClientId
WHERE	(( SPL.ReleaseId = 16 /*SIM_ID_GX_REL110*/	AND SPMajor < 14) OR (SPL.ReleaseId = 15 /*SIM_ID_GX_REL100*/))
	END
END
-- If there is no active controller exists for amazon engine, then use the source client as array controller.
IF EXISTS ( SELECT 1 FROM #tblArchFiles TEMP LEFT JOIN #tblArrayControllers AC ON TEMP.SrcCtrlHostId = AC.CtrlHostId AND TEMP.SrcEngineId = 60 WHERE AC.CtrlHostId IS NULL )
BEGIN
		INSERT INTO #tblArrayControllers
		SELECT A.SrcCtrlHostId, A.SrcClientId, 0, 0, 0
		FROM #tblArchFiles A
			INNER JOIN MMHost MMH (NOLOCK) ON MMH.ClientId = A.SrcClientId
			LEFT OUTER JOIN #tblArrayControllers B ON A.SrcCtrlHostId = B.CtrlHostId
WHERE A.SrcEngineId = 60
			AND MMH.MmHostEnabled = 1
			AND MMH.MmHostSoftState = 1
			AND	B.CtrlHostId IS NULL
END
-- For all the arrays that dont have any array controllers configured, update the status
IF EXISTS ( SELECT 1 FROM #tblArchFiles TEMP LEFT JOIN #tblArrayControllers AC ON TEMP.SrcCtrlHostId = AC.CtrlHostId WHERE AC.CtrlHostId IS NULL )
BEGIN
	UPDATE	TEMP
SET		ErrorCode = 60917
	FROM	#tblArchFiles TEMP LEFT JOIN #tblArrayControllers AC ON TEMP.SrcCtrlHostId = AC.CtrlHostId
	WHERE	AC.CtrlHostId IS NULL
	-- Skipping jobs when array controllers are not configured
    UPDATE  archChunkToReplicate
SET     Status = 3,
            SkippedCount += 1,
            SkippedForSeconds = (@SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS * 60) * (SkippedCount+1),
SkippedReason = 0x3,
ErrorCode = 60917,
            Modified = @now
    FROM	ArchChunkToReplicate (NOLOCK) ACR
			INNER JOIN #tblArchFiles TEMP ON ACR.AdminJobId = TEMP.adminJobId
			AND ACR.archFileId = TEMP.archFileId
			AND ACR.CommCellId = TEMP.CommCellId
			AND ACR.DestCopyId = TEMP.DestCopyId
			AND ACR.VolumeId = TEMP.SMVolumeId
AND TEMP.ErrorCode = 60917
	SET @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
		SET	@errStr = 'Failed to update archChunkToReplicate status when no array controllers are configured.'
		SELECT @errVal, @errStr
		RETURN @errVal
	END
DELETE FROM #tblArchFiles WHERE ErrorCode = 60917
	IF NOT EXISTS ( SELECT 1 FROM #tblArrayControllers )
	BEGIN
		SET @errStr = 'No valid array controllers are found. Please ensure that array controllers are configured and are online.'
		SET @errVal = 1
		SELECT @errVal, @errStr
		RETURN @errVal
	END
END
UPDATE	AC
SET		AC.HostNumForThisArray = AC2.HostNumForThisArray
FROM	#tblArrayControllers AC INNER JOIN
		(
			SELECT	CtrlHostId, MMHostId, ROW_NUMBER() OVER (PARTITION BY CtrlHostId ORDER BY MMHostId) HostNumForThisArray
			FROM	#tblArrayControllers
			GROUP BY CtrlHostId, MMHostId
		) AC2 ON AC.CtrlHostId = AC2.CtrlHostId AND AC.MMHostId = AC2.MMHostId
UPDATE	AC
SET		AC.TotalHostsForThisArray = AC2.TotalHostsForThisArray
FROM	#tblArrayControllers AC INNER JOIN
		(
			SELECT	CtrlHostId,  COUNT(distinct MMHostId) TotalHostsForThisArray
			FROM	#tblArrayControllers
			GROUP BY CtrlHostId
		) AC2 ON AC.CtrlHostId = AC2.CtrlHostId
-- For each array assign ranks to Array Controllers of that array
-- and also compute the total number of available array controllers per array
UPDATE Temp
SET HostNumForThisArray = RowNum, TotalHostsForThisArray = TotalPerArray
FROM
(
	SELECT	HostNumForThisArray, ROW_NUMBER() OVER (Partition by CtrlHostId Order by MMHostId) - 1 AS RowNum,
			TotalHostsForThisArray, COUNT(*) OVER (Partition by CtrlHostId) AS TotalPerArray
	FROM	#tblArrayControllers
) AS Temp
IF @i_isForNewData = 1
BEGIN
	-- Insert the subclient that we need to fetch the info for
	-- Added left join below, however we should not need it.
	INSERT INTO @tblAppStremInfo
	SELECT	DISTINCT AF.AppId, 0, 0, 0, 0,MAX(AF.SrcCtrlHostId), 0
	FROM	#tblArchFiles AF
			LEFT JOIN @tblAppStremInfo APP_INFO ON AF.AppId = APP_INFO.appId
	WHERE	APP_INFO.appId IS NULL
	GROUP BY AF.AppId
	-- Generate a table with all the available streams
	;WITH streams(streamNum) AS
	(SELECT 2 AS streamNum
	 UNION ALL
	 SELECT streamNum+1 FROM streams WHERE streamNum<@max_stream
	)
	INSERT INTO @tblStreamAllocInfo(streamNum, assocAppCount, idxForAlloc)
	SELECT streamNum, 0, 0 FROM streams
	OPTION (MAXRECURSION 0);
	-- Calculate the number of subclients associated to each stream
	UPDATE	A
	SET		A.assocAppCount =  AppInfo.appCount
	FROM	@tblStreamAllocInfo A
			INNER JOIN
			(
			SELECT destStreamNum, COUNT(appId) appCount
			FROM	@tblAppStremInfo
			GROUP BY destStreamNum
			) AppInfo ON A.streamNum = AppInfo.destStreamNum
	-- Generate the index for allocation. This gives a lower index to the streams that don't have any subclients associated to them
	UPDATE Temp
	SET idxForAlloc = RowNum
	FROM
	(
		SELECT	idxForAlloc, ROW_NUMBER() OVER (Order by assocAppCount, StreamNum ) - 1 AS RowNum
		FROM	@tblStreamAllocInfo
	) AS Temp
	-- Assign stream numbers for subclient that dont have any streams, if we have free streams available
	UPDATE APP
	SET	 destStreamNum = STREAM_INFO.streamNum
	FROM (
			SELECT 	AppId, destStreamNum, ROW_NUMBER() OVER(Order By AppId) -1 appIdx
			FROM	@tblAppStremInfo
			WHERE	destStreamNum = 0
		 ) APP
		 INNER JOIN @tblStreamAllocInfo STREAM_INFO ON STREAM_INFO.idxForAlloc = APP.appIdx
	WHERE STREAM_INFO.assocAppCount = 0
	UPDATE	STREAM_INFO
	SET		assocAppCount = 1
	FROM	@tblStreamAllocInfo STREAM_INFO
			INNER JOIN @tblAppStremInfo APP_INFO ON STREAM_INFO.streamNum = APP_INFO.destStreamNum
	WHERE	APP_INFO.srcMAId = 0
	-- Assign a dense rank to each different stream for each array
	UPDATE Temp
	SET HostNumForThisArray = RowNum
	FROM
	(
		SELECT S.HostNumForThisArray, DENSE_RANK() OVER (Partition by SrcCtrlHostId Order by deststreamnum) - 1 AS RowNum
		FROM @tblAppStremInfo S
		WHERE srcMAId  = 0
	) AS Temp
	-- Assign MA to each stream
	UPDATE	S
	SET		S.srcMAId = AC.MMHostId
	FROM	@tblAppStremInfo S INNER JOIN #tblArrayControllers AC ON S.SrcCtrlHostId = AC.CtrlHostId
	WHERE	AC.HostNumForThisArray = (S.HostNumForThisArray % AC.TotalHostsForThisArray)
			AND S.destStreamNum > 0
	-- If the we have the number of streams is less than the number of subclients, then we need to assign the remaining subclients to the existing streams
	IF EXISTS( SELECT 1 FROM @tblAppStremInfo WHERE srcMAId = 0 )
	BEGIN
		DECLARE @currAppId Int = 0, @currCtrlHostId Int = 0, @currDestStream int = 0 , @currSrcMAId int = 0
		DECLARE SubClientCursor CURSOR
			FOR SELECT appId, SrcCtrlHostId
				FROM    @tblAppStremInfo
				WHERE	srcMAId = 0
        OPEN SubClientCursor
        FETCH NEXT FROM SubClientCursor INTO @currAppId, @currCtrlHostId
        WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @currDestStream = 0
			SET @currSrcMAId = 0
			SELECT	TOP 1 @currDestStream = destStreamNum,
					@currSrcMAId = srcMAId
			FROM	@tblAppStremInfo APP_INFO
					INNER JOIN #tblArrayControllers AC ON APP_INFO.srcMAId = AC.MMHostId
					INNER JOIN @tblStreamAllocInfo STREAM_INFO ON STREAM_INFO.streamNum = APP_INFO.destStreamNum
			WHERE	AC.CtrlHostId = @currCtrlHostId
					ORDER BY assocAppCount
			IF @currDestStream > 0 AND @currSrcMAId > 0
			BEGIN
				UPDATE	@tblAppStremInfo
				SET		destStreamNum = @currDestStream,
						srcMAId = @currSrcMAId
				FROM	@tblAppStremInfo
				WHERE	AppId = @currAppId
				UPDATE @tblStreamAllocInfo
				SET		assocAppCount = assocAppCount+1
				WHERE	streamNum = @currDestStream
			END
			ELSE -- If MA is not avaiable then skip those archive files
			BEGIN
				UPDATE	#tblArchFiles
SET		ErrorCode = 60920
				WHERE	appid = @currAppId
			END
			FETCH NEXT FROM SubClientCursor INTO @currAppId, @currCtrlHostId
        END
		CLOSE SubClientCursor
		DEALLOCATE SubClientCursor
	END
	-- For the subclients for which we did not find an array controller, mark them as skipped.
	-- Skipping jobs when array controllers are not configured
    UPDATE  archChunkToReplicate
SET     Status = 3,
            SkippedCount += 1,
            SkippedForSeconds = (@SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS * 60) * (SkippedCount+1),
SkippedReason = 0x3,
ErrorCode = 60920,
            Modified = @now
    FROM	ArchChunkToReplicate (NOLOCK) ACR
			INNER JOIN #tblArchFiles TEMP ON ACR.AdminJobId = TEMP.adminJobId
			AND ACR.archFileId = TEMP.archFileId
			AND ACR.CommCellId = TEMP.CommCellId
			AND ACR.DestCopyId = TEMP.DestCopyId
			AND ACR.VolumeId = TEMP.SMVolumeId
AND TEMP.ErrorCode =  60920
	SET @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
		SET	@errStr = 'Failed to update archChunkToReplicate status when no free MAs are available.'
		SELECT @errVal, @errStr
		RETURN @errVal
	END
DELETE FROM #tblArchFiles WHERE ErrorCode = 60920
	--Update temp table
	UPDATE	#tblArchFiles
	SET		AuxCopyMA = APP_INFO.srcMAId,
			StreamId = APP_INFO.destStreamNum
	FROM	#tblArchFiles S INNER JOIN @tblAppStremInfo APP_INFO ON S.AppId = APP_INFO.appId
	WHERE	APP_INFO.srcMAId > 0
END
ELSE
BEGIN
	-- Divide jobs over maximum available streams assigning
	-- all jobs of one AppId to one stream
	UPDATE Temp
	SET streamId = RowNum
	FROM
	(
		SELECT streamId, (((DENSE_RANK() OVER (Order by S.appId)) - 1) % (@max_stream - 1)) + 2 AS RowNum
		FROM #tblArchFiles S
		INNER	JOIN	#tblArrayControllers AC
				ON		S.SrcCtrlHostId = AC.CtrlHostId
	) AS Temp
	-- Assign a dense rank to each different stream for each array
	UPDATE Temp
	SET HostNumForThisArray = RowNum
	FROM
	(
		SELECT S.HostNumForThisArray, DENSE_RANK() OVER (Partition by SrcCtrlHostId Order by StreamId) - 1 AS RowNum
		FROM #tblArchFiles S
	) AS Temp
	-- Assign MA to each stream
	UPDATE	#tblArchFiles
	SET		AuxCopyMA = AC.MMHostId
	FROM	#tblArchFiles S INNER JOIN #tblArrayControllers AC ON S.SrcCtrlHostId = AC.CtrlHostId
	WHERE	AC.HostNumForThisArray = (S.HostNumForThisArray % AC.TotalHostsForThisArray)
END
-- Set assigned stream and AuxCopyMA in ArchChunkToReplicate table
UPDATE	ArchChunkToReplicate
SET		DestStreamNum = (CASE WHEN TEMP.StreamId > 0 AND TEMP.AuxCopyMA > 0 THEN TEMP.StreamId ELSE DestStreamNum END),
		SrcMAId = (CASE WHEN TEMP.StreamId > 0 AND TEMP.AuxCopyMA > 0 THEN TEMP.AuxCopyMA ELSE SrcMAId END),
Status = (CASE WHEN TEMP.StreamId <= 0 OR TEMP.AuxCopyMA <= 0 THEN 4/*CVA_CHUNK_FAILED*/ ELSE Status END),
ErrorCode = (CASE WHEN TEMP.StreamId <= 0 OR TEMP.AuxCopyMA <= 0 THEN 60921 ELSE ACR.ErrorCode END),
		MediaGroupId =  (CASE WHEN TEMP.StreamId > 0 AND TEMP.AuxCopyMA > 0 THEN (( TEMP.srcEngineId * 1024 ) + TEMP.StreamId )ELSE MediaGroupId END)
FROM	ArchChunkToReplicate (NOLOCK) ACR
		INNER JOIN #tblArchFiles TEMP ON ACR.AdminJobId = TEMP.adminJobId
		AND ACR.archFileId = TEMP.archFileId
		AND ACR.CommCellId = TEMP.CommCellId
		AND ACR.DestCopyId = TEMP.DestCopyId
		AND ACR.VolumeId = TEMP.SMVolumeId
WHERE	ACR.Status = 0
SET @errVal = @@ERROR
IF @errVal > 0
BEGIN
	SET @errStr = 'Failed to update table ArchChunkToReplicate.'
	SELECT @errVal, @errStr
	IF OBJECT_ID('tempdb.dbo.#tblArchFiles') IS NOT NULL
		DROP TABLE #tblArchFiles
	IF OBJECT_ID('tempdb.dbo.#tblArrayControllers') IS NOT NULL
		DROP TABLE #tblArrayControllers
	RETURN @errVal
END
SELECT @errVal, @errStr
IF OBJECT_ID('tempdb.dbo.#tblArchFiles') IS NOT NULL
	DROP TABLE #tblArchFiles
IF OBJECT_ID('tempdb.dbo.#tblArrayControllers') IS NOT NULL
	DROP TABLE #tblArrayControllers
RETURN 0
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetMAForReplication')
	delete from GxQscripts where name = 'MM_SMGetMAForReplication'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetMAForReplication')
	delete from GXDBVersions where aliasname = 'MM_SMGetMAForReplication'
GO

insert into GXDBVersions values(2, 'MM_SMGetMAForReplication',  '00000000000000000000', 'MM_SMGetMAForReplication', '00000000000000000000')
GO

