

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetLastSuccessfulAccessNodeForArray.sp] ---------- 

-- 	+-----------------------------------------------------------------------------------------------+
--	| 			Procedure : "MM_SMGetLastSuccessfulAccessNodeForArray"
--	|			Purpose: To retrieve the last successful/last seen access node/MA given an array
-- 	+-----------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMGetLastSuccessfulAccessNodeForArray')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetLastSuccessfulAccessNodeForArray <<<'
	drop procedure MM_SMGetLastSuccessfulAccessNodeForArray
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetLastSuccessfulAccessNodeForArray')
	delete from GxQscripts where name = 'MM_SMGetLastSuccessfulAccessNodeForArray'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetLastSuccessfulAccessNodeForArray')
	delete from GXDBVersions where aliasname = 'MM_SMGetLastSuccessfulAccessNodeForArray'
GO
print '... Creating Procedure: MM_SMGetLastSuccessfulAccessNodeForArray'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMGetLastSuccessfulAccessNodeForArray
  @inputXML XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @o_arrayNum INTEGER
  DECLARE @o_lastSeenAccessNodeId INTEGER
SET NOCOUNT ON
/*<MM_SMGetLastSuccessfulAccessNodeForArrayReq>
	<ArrayNum>102</ArrayNum>
</MM_SMGetLastSuccessfulAccessNodeForArrayReq>*/
DECLARE @arrayNum				INTEGER = 0
DECLARE @lastSeenAccessNodeId	INTEGER = 0
--Read the XML input
SET @arrayNum = ISNULL ((SELECT R.ref.value('ArrayNum[1]', 'integer') FROM @inputXML.nodes ( '/MM_SMGetLastSuccessfulAccessNodeForArrayReq' ) R ( ref ) ), 0 )
SELECT	TOP 1 @lastSeenAccessNodeId = VOL.SourceClientId
FROM	SMSnap SNAP INNER JOIN	SMVolSnapMap MAP ON SNAP.SMSnapId = MAP.SMSnapId
					INNER JOIN	SMVolume VOL ON MAP.SMVolumeId = VOL.SMVolumeId
					INNER JOIN	MMHost HOST ON VOL.SourceClientId = HOST.ClientId
WHERE	SNAP.ControlHostId = @arrayNum
AND 	HOST.MmHostEnabled = 1 AND HOST.MmHostSoftState = 1 AND HOST.OfflineReason = 0
ORDER BY VOL.CreationTime DESC
/*If the above query does not return the last seen access node, then query the corresponding deleted tables.
In cases where spool copy jobs are run, there will not be entries in the SMVolSnapMap, SMVolume and SMSnap tables.*/
IF @lastSeenAccessNodeId = 0
BEGIN
	SELECT	TOP 1 @lastSeenAccessNodeId = VOL.SourceClientId
	FROM	SMSnapDeleted SNAP	INNER JOIN SMVolSnapMapDeleted	MAP ON SNAP.SMSnapId = MAP.SMSnapId
								INNER JOIN SMVolumeDeleted		VOL ON MAP.SMVolumeId = VOL.SMVolumeId
								INNER JOIN MMHost				HOST ON VOL.SourceClientId = HOST.ClientId
	WHERE	SNAP.ControlHostId = @arrayNum
	AND		HOST.MmHostEnabled = 1 AND HOST.MmHostSoftState = 1 AND HOST.OfflineReason = 0
	ORDER BY VOL.CreationTime DESC
END
SELECT @arrayNum, @lastSeenAccessNodeId
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetLastSuccessfulAccessNodeForArray')
	delete from GxQscripts where name = 'MM_SMGetLastSuccessfulAccessNodeForArray'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetLastSuccessfulAccessNodeForArray')
	delete from GXDBVersions where aliasname = 'MM_SMGetLastSuccessfulAccessNodeForArray'
GO

insert into GXDBVersions values(2, 'MM_SMGetLastSuccessfulAccessNodeForArray',  '00000000000000000000', 'MM_SMGetLastSuccessfulAccessNodeForArray', '00000000000000000000')
GO

