

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetHostVolumeSizeDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetHostVolumeSizeDetails.sp,v $ $Id: MM_SMGetHostVolumeSizeDetails.sp,v 1.4.32.2 2018/03/20 00:08:22 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetHostVolumeSizeDetails <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetHostVolumeSizeDetails')
	drop procedure MM_SMGetHostVolumeSizeDetails
IF EXISTS (select * from GxQscripts where name='MM_SMGetHostVolumeSizeDetails')
	delete from GxQscripts where name = 'MM_SMGetHostVolumeSizeDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetHostVolumeSizeDetails')
	delete from GXDBVersions where aliasname = 'MM_SMGetHostVolumeSizeDetails'
GO
print '... Creating Procedure: MM_SMGetHostVolumeSizeDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetHostVolumeSizeDetails
  @i_jobId INT,
  @i_flags INT,
  @i_reserveInt INTEGER,
  @i_reserveStr VARCHAR(255)
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_totalSpace BIGINT
  DECLARE @o_usedSpace BIGINT
  DECLARE @o_errCode INT
  DECLARE @o_errMsg VARCHAR(255)
SET NOCOUNT ON
SET @o_totalSpace = 0
SET @o_usedSpace = 0
DECLARE @errCode	INT = 0
DECLARE @errMsg		VARCHAR(255) = ''
DECLARE     @tSnapFSAppTypes TABLE (AppTypeId   INTEGER)
INSERT      INTO @tSnapFSAppTypes VALUES (13 /*CV_APPTYPE_NAS_FS*/)
INSERT      INTO @tSnapFSAppTypes VALUES (17 /*CV_APPTYPE_HPUX32_FS*/)
INSERT      INTO @tSnapFSAppTypes VALUES (19 /*CV_APPTYPE_SOLARIS32_FS*/)
INSERT      INTO @tSnapFSAppTypes VALUES (21 /*CV_APPTYPE_AIX_FS */)
INSERT      INTO @tSnapFSAppTypes VALUES (29 /*CV_APPTYPE_LINUX_FS*/)
INSERT      INTO @tSnapFSAppTypes VALUES (33 /*CV_APPTYPE_WINDOWS_FILESYSTEM*/)
DECLARE @jobAppType INT = 0
SET @jobAppType = (SELECT tOP 1 AppTypeId FROM SMVolume (NOLOCK) WHERE jobid = @i_jobId)
DECLARE     @jobVolumeSize  TABLE (
			SMVolumeId		  INTEGER,
            AppId             INTEGER,
            AppTypeId         INTEGER,
            JobId             INTEGER,
            CommCellId        INTEGER,
            GroupId			  INTEGER,
            totalSpace		  BIGINT,
            usedSpace         BIGINT )
IF (@jobAppType = 13 /*CV_APPTYPE_NAS_FS*/)
BEGIN
	INSERT	INTO @jobVolumeSize
	SELECT	DISTINCT VOL.SMVolumeId, VOL.appId, VOL.AppTypeId, @i_jobId, VOL.CommCellId,
			SNAP.GroupId,
			CONVERT(BIGINT, SUBSTRING(dbo.MM_SMGetMetaData(CONVERT(NVARCHAR(MAX), MD.Metadata), 47), 0, CHARINDEX('|', dbo.MM_SMGetMetaData(CONVERT(NVARCHAR(MAX), MD.Metadata), 47)))),
			CONVERT(BIGINT, SUBSTRING(dbo.MM_SMGetMetaData(CONVERT(NVARCHAR(MAX), MD.Metadata), 47), (CHARINDEX('|', dbo.MM_SMGetMetaData(CONVERT(NVARCHAR(MAX), MD.Metadata), 47))+1), 32))
			FROM SMVolume (NOLOCK) VOL
			INNER JOIN archFile (NOLOCK) AF
				ON AF.jobId = @i_jobId AND AF.commCellId = VOL.CommCellId
					AND AF.id = VOL.ArchFileId
					AND VOL.AppId = AF.appId AND AF.isValid = 1
			INNER JOIN archGroup AG (NOLOCK) ON AG.id = AF.archGroupId AND VOL.CopyId = AG.defaultSnapCopy
			INNER JOIN SMMetaData (NOLOCK) MD
				ON MD.RefType = 1 /*SM_MRT_VOLUME*/
					AND VOL.SMVolumeId = MD.RefId
			INNER JOIN SMVolSnapMap (NOLOCK) MAP ON MAP.SMVolumeId = VOL.SMVolumeId
			INNER JOIN SMSnap (NOLOCK) SNAP ON MAP.SMSnapId = SNAP.SMSnapId
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errMsg = 'Failed to get volume size details.'
		GOTO PROC_EXIT
	END
	DELETE	@jobVolumeSize
	WHERE	SMVolumeId NOT IN (SELECT MAX(SMVolumeId) FROM @jobVolumeSize GROUP BY JobId, CommCellId, GroupId)
			AND GroupId > 0
END
ELSE
BEGIN
	INSERT	INTO @jobVolumeSize
	SELECT	DISTINCT VOL.SMVolumeId, VOL.appId, VOL.AppTypeId, @i_jobId, VOL.CommCellId, 0,
			CONVERT(BIGINT, SUBSTRING(dbo.MM_SMGetMetaData(CONVERT(NVARCHAR(MAX), MD.Metadata), 47), 0, CHARINDEX('|', dbo.MM_SMGetMetaData(CONVERT(NVARCHAR(MAX), MD.Metadata), 47)))),
			CONVERT(BIGINT, SUBSTRING(dbo.MM_SMGetMetaData(CONVERT(NVARCHAR(MAX), MD.Metadata), 47), (CHARINDEX('|', dbo.MM_SMGetMetaData(CONVERT(NVARCHAR(MAX), MD.Metadata), 47))+1), 32))
			FROM SMVolume (NOLOCK) VOL
			INNER JOIN archFile (NOLOCK) AF
				ON AF.jobId = @i_jobId AND AF.commCellId = VOL.CommCellId
					AND AF.id = VOL.ArchFileId
					AND VOL.AppId = AF.appId AND AF.isValid = 1
			INNER JOIN archGroup AG (NOLOCK) ON AG.id = AF.archGroupId AND VOL.CopyId = AG.defaultSnapCopy
			INNER JOIN SMMetaData (NOLOCK) MD
				ON MD.RefType = 1 /*SM_MRT_VOLUME*/
					AND VOL.SMVolumeId = MD.RefId
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errMsg = 'Failed to get volume size details.'
		GOTO PROC_EXIT
	END
END
SET @o_totalSpace = (SELECT SUM(totalSpace) FROM @jobVolumeSize)
SET @o_usedSpace = (SELECT SUM(usedSpace) FROM @jobVolumeSize)
PROC_EXIT:
	SELECT @o_totalSpace, @o_usedSpace, @errCode, @errMsg
	RETURN
GO
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetHostVolumeSizeDetails')
	delete from GxQscripts where name = 'MM_SMGetHostVolumeSizeDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetHostVolumeSizeDetails')
	delete from GXDBVersions where aliasname = 'MM_SMGetHostVolumeSizeDetails'
GO

insert into GXDBVersions values(2, 'MM_SMGetHostVolumeSizeDetails',  '00010004003200020000', 'MM_SMGetHostVolumeSizeDetails', '00010004003200020000')
GO

