

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetExpiringClones.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetExpiringClones.sp,v $ $Id: MM_SMGetExpiringClones.sp,v 1.3.12.2 2018/03/20 00:08:16 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetExpiringClones <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetExpiringClones')
	drop procedure MM_SMGetExpiringClones
IF EXISTS (select * from GxQscripts where name='MM_SMGetExpiringClones')
	delete from GxQscripts where name = 'MM_SMGetExpiringClones'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetExpiringClones')
	delete from GXDBVersions where aliasname = 'MM_SMGetExpiringClones'
GO
print '... Creating Procedure: MM_SMGetExpiringClones'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetExpiringClones
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_MountJobId INTEGER
  DECLARE @o_MetaDataId INTEGER
  DECLARE @o_UserEmail NVARCHAR(510)
  DECLARE @o_sourceDatabaseName NVARCHAR(1024)
  DECLARE @o_targetDatabaseName NVARCHAR(1024)
  DECLARE @o_cloneExpireTime NVARCHAR(1024)
  DECLARE @o_ErrorCode INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ClonesSelectedForAlert TABLE (
		MountJobId			INT NOT NULL,
		MetaDataId			INT NOT NULL,
		UserEmail			NVARCHAR(510),
		sourceDatabaseName	NVARCHAR(1024),
		targetDatabaseName	NVARCHAR(1024),
		cloneExpireTime		NVARCHAR(1024)
	)
	DECLARE @Expiring_Clone_Alert_Enabled_Flag	INT = 1		-- MMConfigs param for sending alerts for expiring VMs	- (Disabled by default?)
	DECLARE @Expiring_Clone_Alert_Time_Interval INT	= 24			-- MMConfigs param for the time interval in hours. Send an alert for clones expiring within the next x(value) hours
	SET @Expiring_Clone_Alert_Time_Interval = ISNULL((select Value from MMConfigs(NOLOCK) where name = 'MMS2_CONFIG_EXPIRING_CLONE_ALERT_TIME_INTERVAL')
						, @Expiring_Clone_Alert_Time_Interval)
	SET @Expiring_Clone_Alert_Enabled_Flag = ISNULL((select Value from MMConfigs(NOLOCK) where name = 'MMS2_CONFIG_EXPIRING_CLONE_ALERT_ENABLED_FLAG')
						, @Expiring_Clone_Alert_Enabled_Flag)
	--Check if the flag is enabled for sending alerts for clones that are expiring
	/*BEGIN
			INSERT INTO @ClonesSelectedForAlert
			SELECT		MVOL.MountJobId, SM.MetaDataId,U.email,T.sourceDatabaseName,T.targetDatabaseName,dbo.UTCToCellLocalTime(dbo.GetDateTime(MVOL.ExpireTime) ,2)
			FROM		SMMountVolume AS MVOL WITH (NOLOCK)
			INNER JOIN	SMMetaData AS SM WITH(NOLOCK) ON SM.RefId = MVOL.Id
			INNER JOIN	UMUsers AS U WITH (NOLOCK) ON U.id = CAST( CONVERT (NVARCHAR(128),SM.MetaData) AS INT)
			INNER JOIN  (	SELECT		SMD.RefId,
										T.C.value('./@databaseName','nvarchar(1024)') AS targetDatabaseName,
										T.C.value('./@sourceDatabaseName','nvarchar(1024)') AS sourceDatabaseName
							FROM		SMMetaData SMD WITH (NOLOCK)
							CROSS APPLY CONVERT(XML, SMD.MetaData).nodes('/SQLiDA_AttachDBMsg/databaseList') AS T(C)
WHERE		SMD.RefType = 10/*SM_MRT_MOUNT_VOLUME*/
AND		SMD.MetaDataType = 38/*SM_MDT_TEST_ENV_APP_INFO*/
						) T ON T.RefId = MVOL.Id
			WHERE		MVOL.ExpireTime
					BETWEEN		dbo.GetUnixTime(getutcdate()) and DBO.GetUnixTime( DATEADD(HOUR,@Expiring_Clone_Alert_Time_Interval,GETUTCDATE()))
AND	SM.MetaDataType IN (57/*SM_MDT_TEST_ENV_CLONE_USERID*/)
AND SM.RefType = 10/*SM_MRT_MOUNT_VOLUME*/
						AND U.email <> N''
						AND U.email IS NOT NULL
						AND 0 =  CASE WHEN (
									SELECT CAST(CONVERT(NVARCHAR(128),SMD.MetaData)AS INT ) FROM SMMetaData SMD
WHERE SMD.RefId = MVOL.Id AND SMD.RefType = 10/*SM_MRT_MOUNT_VOLUME*/
AND SMD.MetaDataType = 58/*SM_MDT_TEST_ENV_ALERT_SENT_FLAG*/
								)= 0 THEN 0 ELSE 1 END
		END*/
	SELECT	MountJobId,MetaDataId,UserEmail,sourceDatabaseName,targetDatabaseName,cloneExpireTime,0 AS ErrorCode FROM @ClonesSelectedForAlert
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetExpiringClones')
	delete from GxQscripts where name = 'MM_SMGetExpiringClones'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetExpiringClones')
	delete from GXDBVersions where aliasname = 'MM_SMGetExpiringClones'
GO

insert into GXDBVersions values(2, 'MM_SMGetExpiringClones',  '00010003001200020000', 'MM_SMGetExpiringClones', '00010003001200020000')
GO

