

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetDetailsForCloneCreation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetDetailsForCloneCreation.sp,v $ $Id: MM_SMGetDetailsForCloneCreation.sp,v 1.6.2.3 2018/03/20 00:09:09 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetDetailsForCloneCreation <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetDetailsForCloneCreation')
	drop procedure MM_SMGetDetailsForCloneCreation
IF EXISTS (select * from GxQscripts where name='MM_SMGetDetailsForCloneCreation')
	delete from GxQscripts where name = 'MM_SMGetDetailsForCloneCreation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetDetailsForCloneCreation')
	delete from GXDBVersions where aliasname = 'MM_SMGetDetailsForCloneCreation'
GO
print '... Creating Procedure: MM_SMGetDetailsForCloneCreation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetDetailsForCloneCreation
  @i_appTypeId INT,
  @i_clientId INT,
  @i_instanceId INT,
  @i_databaseName NVARCHAR(MAX) = N'',
  @i_snapJobId INT,
  @i_reserveInt INT,
  @i_reserverStr NVARCHAR(1024)
AS
  DECLARE @o_commcellId INTEGER
  DECLARE @o_backupsetName NVARCHAR(255)
  DECLARE @o_backupFinishDate NVARCHAR(255)
  DECLARE @o_database NVARCHAR(255)
  DECLARE @o_LogicalName NVARCHAR(255)
  DECLARE @o_PhysicalPath NVARCHAR(255)
  DECLARE @o_timeZone NVARCHAR(255)
  DECLARE @o_mountPath NVARCHAR(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @commcellId			INT
	DECLARE @backupsetName		NVARCHAR(MAX)
	DECLARE @timeZone			NVARCHAR(MAX)
	DECLARE @mountPath			NVARCHAR(MAX)
	DECLARE @errString			NVARCHAR(MAX) = N''
	DECLARE @tblDatabaseDetails TABLE (
		backupFinishDate	NVARCHAR(1024),
		databaseName		NVARCHAR(1024),
		logicalName			NVARCHAR(1024),
		physicalPath		NVARCHAR(1024)
	)
	IF @i_appTypeId=81/*CV_APPTYPE_MSSQL*/
	BEGIN
		IF NOT EXISTS ( SELECT * FROM
								( SELECT MIN(PruneFlags) minPf, MAX (PruneFlags) maxPf FROM SMVolume VOL (NOLOCK) INNER JOIN archGroup AG (NOLOCK) ON VOL.CopyId = AG.defaultSnapCopy
											WHERE VOL.JobId = @i_snapJobId ) A
WHERE a.minPf = 1/*MM_SM_PRUNEFLAGS_ACTIVE*/ and a.maxPf = 1/*MM_SM_PRUNEFLAGS_ACTIVE*/)
		BEGIN
			SET @errString = 'ERROR: Snap Job may have been aged.'
			GOTO ERROR_EXIT
		END
		SET @commcellId = 2
		SET @backupsetName = ISNULL((SELECT DISTINCT BACKUPSETNAME.name FROM SMVolume VOL WITH (NOLOCK)
							INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.id=VOL.AppId
							INNER JOIN APP_BackupSetName BACKUPSETNAME WITH (NOLOCK) ON BACKUPSETNAME.id=APP.backupSet
							WHERE VOL.JobId=@i_snapJobId),'')
		IF @backupsetName = ''
		BEGIN
			SET @errString = 'ERROR: Backupset name is empty for snap job [' + CAST(@i_snapJobId AS NVARCHAR(MAX)) + '].'
			GOTO ERROR_EXIT
		END
		SET @timeZone  = ISNULL( (SELECT DISTINCT timeZone from APP_CommCell WITH (NOLOCK) where clientId = 2), '')
		IF @timeZone = ''
		BEGIN
			SET @errString = 'ERROR: Time zone is empty for client [' + CAST(2 AS NVARCHAR(MAX)) + '].'
			GOTO ERROR_EXIT
		END
		--SET  @mountPath  = ISNULL((SELECT TOP 1 install_dir + '\MediaAgent\SnapVolumeMounts' FROM APP_Platform WITH (NOLOCK) WHERE clientId = @i_clientId and platformType = 2), N'')
		SET  @mountPath  = ISNULL((SELECT TOP 1 (case when  RIGHT(install_dir,1) = '\' then SUBSTRING(install_dir,1,LEN(install_dir)-1) else install_dir  end ) + '\MediaAgent\SnapVolumeMounts' FROM APP_Platform WITH (NOLOCK) WHERE clientId = @i_clientId and platformType = 2), N'')
		IF @mountPath = ''
		BEGIN
			SET @errString = 'ERROR: Mount Path is empty for clientId [' + CAST(@i_clientId AS NVARCHAR(MAX)) + '].'
			GOTO ERROR_EXIT
		END
       INSERT INTO	@tblDatabaseDetails
	   SELECT		CONVERT (NVARCHAR(MAX),dbo.GetDateTime(DBInfo.backup_finish_date),21),
                    DBName2Tbl.name, LogicalName2Tbl.name, PhysicalName2Tbl.name
	   FROM			 sqlDbBackupInfo DBInfo (NOLOCK), SQLFileBackupInfo SQLFileInfo (NOLOCK),
                    (SELECT  * FROM SQLNames2 (NOLOCK) where type = 1) AS DBName2Tbl,
                    (SELECT  * FROM SQLNames2 (NOLOCK) where type = 4) AS LogicalName2Tbl,
                    (SELECT  * FROM SQLNames2 (NOLOCK) where type = 3) AS PhysicalName2Tbl,
                    (SELECT  * FROM SQLNames (NOLOCK) where type = 4) AS LogicalNameTbl,
                    (SELECT  * FROM SQLNames (NOLOCK) where type = 3) AS PhysicalNameTbl,
                    (SELECT  * FROM SQLNames (NOLOCK) where type = 1) AS DBNameTbl
        WHERE
					SQLFileInfo.sqlDBBackupinfoid = DBInfo.id
					AND SQLFileInfo.sqlNamePhyId = PhysicalNameTbl.id
					AND SQLFileInfo.sqlNameLogId = LogicalNameTbl.id
					AND LogicalNameTbl.sqlid = LogicalName2Tbl.id
					AND PhysicalNameTbl.sqlid = PhysicalName2Tbl.id
					AND DBNameTbl.sqlid = DBName2Tbl.id
					AND DBInfo.sqlNameId = DBNameTbl.id
					AND DBInfo.jobId = @i_snapJobId
					AND DBInfo.instanceId = @i_instanceId
					AND DBName2Tbl.name = @i_databaseName
		IF NOT EXISTS (SELECT * FROM @tblDatabaseDetails)
		BEGIN
			SET @errString = 'ERROR: No database details found for jobId [' + CAST(@i_snapJobId AS NVARCHAR(MAX))
								+ '], instanceId [' + CAST(@i_instanceId AS NVARCHAR(MAX)) + '], database name [' + @i_databaseName + '].'
			GOTO ERROR_EXIT
		END
		SELECT	@commcellId AS 'commcellId', @backupsetName AS 'backupsetName',
                backupFinishDate AS 'backupFinishDate',
                databaseName AS   'database', logicalName AS 'LogicalName', physicalPath AS 'PhysicalPath',
                @timeZone AS 'timeZone',@mountPath AS 'mountPath'
        FROM	@tblDatabaseDetails
		RETURN
	END
ERROR_EXIT:
	RAISERROR (@errString,16,1)
	RETURN 1
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMGetDetailsForCloneCreation')
	delete from GxQscripts where name = 'MM_SMGetDetailsForCloneCreation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetDetailsForCloneCreation')
	delete from GXDBVersions where aliasname = 'MM_SMGetDetailsForCloneCreation'
GO

insert into GXDBVersions values(2, 'MM_SMGetDetailsForCloneCreation',  '00010006000200030000', 'MM_SMGetDetailsForCloneCreation', '00010006000200030000')
GO

