

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetDatabaseDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetDatabaseDetails.sp,v $ $Id: MM_SMGetDatabaseDetails.sp,v 1.4.14.2 2018/03/20 00:18:36 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetDatabaseDetails <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetDatabaseDetails')
	drop procedure MM_SMGetDatabaseDetails
IF EXISTS (select * from GxQscripts where name='MM_SMGetDatabaseDetails')
	delete from GxQscripts where name = 'MM_SMGetDatabaseDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetDatabaseDetails')
	delete from GXDBVersions where aliasname = 'MM_SMGetDatabaseDetails'
GO
print '... Creating Procedure: MM_SMGetDatabaseDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetDatabaseDetails
  @xmlTextInput XML,
  @o_xmlText XML	OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @clientId			integer = 0
SET @clientId = ISNULL (( SELECT ref.value('@clientId', 'INT') FROM @xmlTextInput.nodes ('EVGui_GetClientInfoReq/clientId') R(ref)), @clientId)
DECLARE @databaseInfo TABLE
(
		clientId					INT,
		clientName					NVARCHAR(255),
		appTypeId					INT,
		appTypeName					NVARCHAR(255),
		instanceId					INT,
		instanceName				NVARCHAR(1024),
		subclientId					INT,
		subclientName				NVARCHAR(1024),
		databaseName				NVARCHAR(1024),
		isSnapEnabled				INT,
		CloneCrtSnapTypeAllowed		INT,
		lastbkupTime				INT,
		totalbackupsize				bigint
)
INSERT INTO @databaseInfo
SELECT Temp1.*,ISNULL(Temp2.backup_finish_Date,0),ISNULL(Temp2.backup_size,0) FROM
( SELECT 			APP.clientId,CLNT.name clientName,APP.appTypeId, IDATYPE.name, APP.instance AS instanceId, INST.name AS instanceName,
				APP.id AS subclientId,APP.subclientName AS subclientName, SUBCLNTPROP.attrName AS databaseName,
				(CASE WHEN  (	( SELECT COUNT(*) FROM APP_SubClientProp WITH(NOLOCK) where componentNameId = SUBCLNTPROP.componentNameId
								AND attrName=N'Enable Snap Backups' and attrVal='1' AND modified = 0)  = 1 AND
								( SELECT COUNT(*) FROM APP_SubClientProp SC (NOLOCK) INNER JOIN SMSnapShotEngine ENG (NOLOCK) ON SC.attrVal = ENG.SnapshotEngineId
								WHERE SC.componentNameId = SUBCLNTPROP.componentNameId AND SC.attrName=N'Snap Engine' AND SC.modified = 0 AND ENG.capabilities & 16777216/*SM_SNAPSHOT_ENGINE_CAPABILITY_TESTENV_CREATE*/ = 16777216)  = 1 AND
								( SELECT TOP 1 REL.release FROM APP_Client CL WITH (NOLOCK) INNER JOIN simAllGalaxyRel REL WITH(NOLOCK) ON CL.releaseId=REL.id
								WHERE CL.id = @clientId ) >= 10) THEN 1
					ELSE 0 	END ) AS isSnapEnabled,
										(	SELECT
						case when ENG.capabilities & 33554432/*SM_SNAPSHOT_ENGINE_CAPABILITY_TESTENV_DO_NOT_ALLOW_EXISTING_JOBS*/ = 33554432 then 2 else 7 end
						FROM	APP_SubClientProp SC (NOLOCK)
								INNER JOIN SMSnapShotEngine ENG (NOLOCK) ON SC.attrVal =ENG.snapshotengineid
								where SC.componentNameId = SUBCLNTPROP.componentNameId
                                        AND SC.attrName=N'Snap Engine' AND SC.modified = 0) as a
FROM			APP_Application APP WITH (NOLOCK)
INNER JOIN		APP_InstanceName INST WITH(NOLOCK) ON APP.instance=INST.id AND APP.clientId = @clientId
INNER JOIN		APP_SubClientProp SUBCLNTPROP WITH (NOLOCK) ON APP.id = SUBCLNTPROP.componentNameId
INNER JOIN		APP_Client CLNT WITH(NOLOCK) ON CLNT.id=@clientId
INNER JOIN		APP_iDAType IDATYPE WITH(NOLOCK) ON APP.appTypeId=IDATYPE.type
WHERE			SUBCLNTPROP.attrType=118/*PROPERTY_MSSQL_DB*/
				AND	dbo.IsSubClientValid(APP.appTypeId,APP.subclientStatus,0)  = 1
AND ( APP.subclientStatus & 0x00002 ) <> 0x00002 /*CV_STATUS_UNINSTALLED*/
AND ( APP.subclientStatus & 0x00004 ) <> 0x00004 /*CV_STATUS_DELETED */
				AND APP.appTypeId=81 AND SUBCLNTPROP.modified=0 ) AS Temp1 LEFT JOIN
( SELECT  DBInfo.id as id, DBInfo.appId as appId, DBInfo.InstanceId as InstanceId, SN2.name as DatabaseName,  DBInfo.backup_size, DBInfo.backup_finish_date
  FROM sqldbbackupinfo DBInfo  WITH(NOLOCK) , SQLNames SN  WITH(NOLOCK) , SQLNames2 SN2  WITH(NOLOCK)
  WHERE     DBInfo.sqlNameid = SN.id
		    AND SN.sqlid = SN2.id
		    AND DBInfo.id IN (	SELECT   MAX(dbinfo.id)
								FROM	 sqldbbackupinfo DBInfo  WITH(NOLOCK) , SQLNames SN  WITH(NOLOCK) , SQLNames2 SN2  WITH(NOLOCK)
								WHERE	 DBInfo.sqlNameid = SN.id
										 AND SN.sqlid = SN2.id
										 AND DBInfo.type='D'
								GROUP BY SN2.name,appId ))  Temp2
ON	Temp1.databaseName = Temp2.DatabaseName and Temp1.subclientId = Temp2.appId
SET @o_xmlText  =	(SELECT  0 AS '@errorCode',  N'' AS '@errorMsg',
					(
						SELECT	DBINFO.databaseName AS '@databaseName', DBINFO.isSnapEnabled AS '@isSnapEnabled',
							DBINFO.totalbackupsize AS '@totalBackupSize', DBINFO.lastbkupTime AS '@lastBackupTime',
							DBINFO.clientId AS 'clientId/@clientId', DBINFO.clientName AS 'clientId/@clientName',
							DBINFO.appTypeId AS 'appType/@applicationId',DBINFO.appTypeName AS 'appType/@appName',
							DBINFO.instanceId AS 'instance/@instanceId', DBINFO.instanceName AS 'instance/@instanceName',
							DBINFO.subclientId AS 'subclient/@subclientId' , DBINFO.subclientName AS 'subclient/@subclientName'
						FROM @databaseInfo DBINFO
						ORDER BY DBINFO.databaseName
						FOR XML PATH('databaseDetails'), TYPE
					)
					FOR XML PATH ('EVGui_GetDatabaseDetailsResp'), TYPE
					)
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMGetDatabaseDetails')
	delete from GxQscripts where name = 'MM_SMGetDatabaseDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetDatabaseDetails')
	delete from GXDBVersions where aliasname = 'MM_SMGetDatabaseDetails'
GO

insert into GXDBVersions values(2, 'MM_SMGetDatabaseDetails',  '00010004001400020000', 'MM_SMGetDatabaseDetails', '00010004001400020000')
GO

