

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetDatabaseClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetDatabaseClients.sp,v $ $Id: MM_SMGetDatabaseClients.sp,v 1.3.42.1 2018/03/19 23:57:06 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetDatabaseClients <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetDatabaseClients')
	drop procedure MM_SMGetDatabaseClients
IF EXISTS (select * from GxQscripts where name='MM_SMGetDatabaseClients')
	delete from GxQscripts where name = 'MM_SMGetDatabaseClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetDatabaseClients')
	delete from GXDBVersions where aliasname = 'MM_SMGetDatabaseClients'
GO
print '... Creating Procedure: MM_SMGetDatabaseClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetDatabaseClients
  @xmlTextInput XML,
  @userId int,
  @o_xmlText XML	OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @clientList table (
	clientId 		int not null,
    clientName		nvarchar(255),
    osName			varchar(1024),
	platformName	varchar(1024),
	releaseInfo		varchar(1024)
)
IF object_id('tempdb.dbo.#tempClientObjects') IS NOT Null DROP TABLE #tempClientObjects
create table  #tempClientObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null, [clientGroupId] int	NOT null, [clntId]      int	NOT null, [appTypeId]     int	NOT null, [instanceId]    int	NOT null, [backupsetId]   int	NOT null, [subClientId]   int	NOT null, [mediaAgentId]  int	NOT null, [libraryId]     int	NOT null, [archGroupId]   int	NOT null, [vtContainerId] int	NOT null, [vtPolicyId]    int	NOT null, [vtShelfId]     int	NOT null, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, 2009, 0, '#tempClientObjects'
INSERT @clientList
SELECT		DISTINCT	UM.clientId, '', 0, 0,0
FROM		sec_getClientOwners(1) UM
INNER JOIN	APP_IDAName IDA WITH(NOLOCK) ON UM.clientId = IDA.clientId AND IDA.appTypeId in (81)
WHERE		UM.userId = @userId --'CLIENT_ITEM
DELETE @clientList
WHERE NOT EXISTS (SELECT 1 FROM dbo.APP_Client WITH(NOLOCK) WHERE ID = clientId)
DELETE @clientList
WHERE NOT EXISTS (SELECT * FROM #tempClientObjects WHERE clntId In (0, clientId))
DECLARE @temp varchar(1024)
UPDATE		@clientList
SET			clientName = dbo.GetClientName(A.clientId),
			osName = dbo.GetClientOSName(A.clientId, @temp),
			platformName = dbo.GetClientHardwareName(A.clientId, @temp)
FROM		@clientList A
INNER JOIN	APP_Client CLNT WITH (NOLOCK) ON A.clientId = CLNT.id
UPDATE		@clientList
SET			releaseInfo = PROP.attrVal
FROM		@clientList A
INNER JOIN	APP_Client CLNT WITH (NOLOCK) ON A.clientId = CLNT.id
INNER JOIN	simAllGalaxyRel REL WITH(NOLOCK) ON CLNT.releaseId=REL.id
INNER JOIN	APP_ClientProp PROP WITH (NOLOCK) ON CLNT.id=PROP.componentNameId and prop.attrName = 'SP Version Info'
DROP TABLE #tempClientObjects
SET @o_xmlText =
				(
					SELECT 	0 AS '@errorCode', N'' AS '@errorMsg',
  						(   SELECT
  								CLNTLIST.osName AS '@osName', CLNTLIST.platformName AS '@platform',
								CLNTLIST.releaseInfo AS '@releaseInfo',
								CLNTLIST.clientId AS 'client/@clientId', CLNTLIST.clientName AS 'client/@clientName'
							FROM @clientList CLNTLIST
							ORDER BY CLNTLIST.clientName
							FOR XML PATH('clientInfo'),TYPE
						)
					FOR XML PATH ('EVGui_GetDatabaseClientsResp'),TYPE
				)
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMGetDatabaseClients')
	delete from GxQscripts where name = 'MM_SMGetDatabaseClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetDatabaseClients')
	delete from GXDBVersions where aliasname = 'MM_SMGetDatabaseClients'
GO

insert into GXDBVersions values(2, 'MM_SMGetDatabaseClients',  '00010003004200010000', 'MM_SMGetDatabaseClients', '00010003004200010000')
GO

