

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetCordSnapMetadata.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMGetCordSnapMetadata')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetCordSnapMetadata <<<'
	drop procedure MM_SMGetCordSnapMetadata
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetCordSnapMetadata')
	delete from GxQscripts where name = 'MM_SMGetCordSnapMetadata'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetCordSnapMetadata')
	delete from GXDBVersions where aliasname = 'MM_SMGetCordSnapMetadata'
GO
print '... Creating Procedure: MM_SMGetCordSnapMetadata'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMGetCordSnapMetadata
  @i_xmlInput XML,
  @i_reserveInt INTEGER,
  @i_reserveStr VARCHAR(255)
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_SMMetadataId INT
  DECLARE @o_SMMountSnapId INT
  DECLARE @o_SMSnapId INT
  DECLARE @o_SMMetadata VARCHAR(MAX)
  DECLARE @o_ErrorCode INT = 0
  DECLARE @o_ErrorStr VARCHAR(255) = ''
SET NOCOUNT ON
/*
		<MM_SMGetCordSnapMetadata>
			<MountJobId>%d</MountJobId>
			<MetadataType>%d</MetadataType>
		</MM_SMGetCordSnapMetadata>
*/
----------------------------------------------------- CONSTANTS FOR ERROR VALUES ------------------------------------------
DECLARE @ERROR_INVALID_XML_INPUT				INTEGER	= 1
DECLARE @ERROR_INVALID_JOB_ID					INTEGER = 2
DECLARE @ERROR_INVALID_METADATA_TYPE			INTEGER = 3
----------------------------------------------------- LOCAL VARIABLES -----------------------------------------------------
DECLARE	@x_MountJobId			INTEGER			= 0
DECLARE @x_MetadataType			INTEGER			= 0
DECLARE @x_DefaultCCId INT = 2
-------------------------------- VALIDATION--------------------------------------------------------------------------------
IF @i_xmlInput IS NULL
BEGIN
	SET @o_ErrorCode	= @ERROR_INVALID_XML_INPUT
	SET @o_ErrorStr		= 'Input XML Parameter cannot be empty.'
	GOTO PROC_END
END
----------------------------------------------------- INPUT PARSING -------------------------------------------------------
SET @x_MountJobId	= ISNULL((SELECT R.ref.value('.', 'INT'	) FROM @i_xmlInput.nodes('/MM_SMGetCordSnapMetadata/MountJobId')	R(ref)),	0	)
SET @x_MetadataType	= ISNULL((SELECT R.ref.value('.', 'INT'	) FROM @i_xmlInput.nodes('/MM_SMGetCordSnapMetadata/MetadataType')	R(ref)),	0	)
---- Invalid job
IF @x_MountJobId = 0
BEGIN
	SET @o_ErrorCode	= @ERROR_INVALID_JOB_ID
	SET @o_ErrorStr		= 'Invalid mount job id passed.'
	GOTO PROC_END
END
-- JobId not running
IF	@x_MountJobId > 0 AND
	NOT EXISTS (SELECT 1 FROM JMJobInfo (READUNCOMMITTED) WHERE JobId = @x_MountJobId AND commCellId = @x_DefaultCCId)
BEGIN
	SET @o_ErrorCode	= @ERROR_INVALID_JOB_ID
	SET @o_ErrorStr		= 'Job is not running. JobId [' + Convert(varchar(10), @x_MountJobId) + ']'
	GOTO PROC_END
END
---- EMPTY Metadata type
IF @x_MetadataType = 0
BEGIN
	SET @o_ErrorCode	= @ERROR_INVALID_METADATA_TYPE
	SET @o_ErrorStr		= 'Invalid metadata type passed.'
	GOTO PROC_END
END
----------------------------------------------------- RETURN VALUES -------------------------------------------------------
SELECT  MD.MetadataId, MD.RefId, MS.SMSnapId, MD.Metadata, 0, ''
FROM SMMountVolume MV (READUNCOMMITTED) INNER JOIN SMMountMap MMAP (READUNCOMMITTED) ON MV.Id = MMAP.SMMountVolumeId
INNER JOIN SMMountSnap MS (READUNCOMMITTED) ON MMAP.SMMountSnapId = MS.Id AND MV.MountJobId = MS.ReserveField4
INNER JOIN SMMetaData MD (READUNCOMMITTED) ON MD.RefId = MS.Id
AND MD.RefType = 12 /*SM_MRT_MOUNT_SNAP*/
AND MD.MetaDataType = @x_MetadataType
AND MV.MountJobId = @x_MountJobId
AND ( ( CASE WHEN ISNUMERIC( MV.MountOptions ) = 1 THEN MV.MountOptions ELSE 0 END ) & 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/ = 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/)
RETURN
PROC_END:
	SELECT -1, -1, -1, '', @o_ErrorCode, @o_ErrorStr
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetCordSnapMetadata')
	delete from GxQscripts where name = 'MM_SMGetCordSnapMetadata'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetCordSnapMetadata')
	delete from GXDBVersions where aliasname = 'MM_SMGetCordSnapMetadata'
GO

insert into GXDBVersions values(2, 'MM_SMGetCordSnapMetadata',  '00000000000000000000', 'MM_SMGetCordSnapMetadata', '00000000000000000000')
GO

