

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetCloneSourceTarget.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetCloneSourceTarget.sp,v $ $Id: MM_SMGetCloneSourceTarget.sp,v 1.6.32.3 2018/03/20 00:16:51 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetCloneSourceTarget <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetCloneSourceTarget')
	drop procedure MM_SMGetCloneSourceTarget
IF EXISTS (select * from GxQscripts where name='MM_SMGetCloneSourceTarget')
	delete from GxQscripts where name = 'MM_SMGetCloneSourceTarget'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetCloneSourceTarget')
	delete from GXDBVersions where aliasname = 'MM_SMGetCloneSourceTarget'
GO
print '... Creating Procedure: MM_SMGetCloneSourceTarget'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetCloneSourceTarget
  @xmlTextInput XML,
  @userId int,
  @o_xmlText XML	OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @i_apptypeId	INT
	DECLARE @i_clientId		INT
	DECLARE @i_sourceInstanceId	INT
	DECLARE @i_subClientId	INT
	-- @CloneSourceTargetNumberLimit is the default number of clients for whom all the details are send irrespective of the number of clients. For the remaining, only the client name and id is sent
	DECLARE @CloneSourceTargetNumberLimit INT
	DECLARE @errorCode				INT=0
	DECLARE @errorString			NVARCHAR(MAX)=N''
	DECLARE @sourceClientId			INT=0
	DECLARE	 @CloneCrtSnapTypeAllowed INT = 0
	DECLARE @tblClientInfo TABLE
	(
		clientId		INT,
		clientName		nvarchar(1024)
	)
	DECLARE @tblInstanceInfo TABLE
	(
		clientId		INT,
		instanceId		INT,
		instanceName	nvarchar(1024)
	)
	DECLARE @databaseInfo TABLE
	(
		instanceId		INT,
		subclientId		INT,
		subclientName	nvarchar(1024),
		databaseName	nvarchar(1024)
	)
	SET @i_apptypeId = ISNULL(( SELECT ref.value('@applicationId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetClientInfoReq/appType') R ( ref ) ),
						0)
	SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetClientInfoReq/clientId') R ( ref ) ),
						0)
	SET @CloneSourceTargetNumberLimit = ISNULL((select Value from MMConfigs(NOLOCK) where name = 'MMS2_CONFIG_CLONE_SOURCE_TARGET_NUMBER_LIMIT')
						, 20)
	SET @i_sourceInstanceId = ISNULL(( SELECT ref.value('@instanceId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetClientInfoReq/sourceInstance') R ( ref ) ),
						0)
	SET @i_subClientId = ISNULL(( SELECT ref.value('@subclientId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetClientInfoReq/subClient') R ( ref ) ),
						0)
	IF NOT EXISTS (SELECT * FROM APP_iDAType IdaType WITH (NOLOCK) WHERE IdaType.type = @i_apptypeId)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'App type with the id ' + CONVERT (NVARCHAR,@i_apptypeId) + ' does not exist'
		GOTO ERROR_EXIT
	END
	IF @i_subClientId > 0
	BEGIN
		SET @CloneCrtSnapTypeAllowed = (	SELECT	CASE WHEN ENG.capabilities & 33554432/*SM_SNAPSHOT_ENGINE_CAPABILITY_TESTENV_DO_NOT_ALLOW_EXISTING_JOBS*/ = 33554432 THEN 2 ELSE 7 END
										FROM	APP_SubClientProp SC (NOLOCK) INNER JOIN SMSnapShotEngine ENG (NOLOCK) ON SC.attrVal =ENG.snapshotengineid
										WHERE	SC.componentNameId = @i_subclientId AND SC.attrName=N'Snap Engine' AND SC.modified = 0)
	END
	IF object_id('tempdb.dbo.#tempClientObjects') IS NOT Null DROP TABLE #tempClientObjects
	create table  #tempClientObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null, [clientGroupId] int	NOT null, [clntId]      int	NOT null, [appTypeId]     int	NOT null, [instanceId]    int	NOT null, [backupsetId]   int	NOT null, [subClientId]   int	NOT null, [mediaAgentId]  int	NOT null, [libraryId]     int	NOT null, [archGroupId]   int	NOT null, [vtContainerId] int	NOT null, [vtPolicyId]    int	NOT null, [vtShelfId]     int	NOT null, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2009, 0, '#tempClientObjects'
	INSERT		@tblClientInfo
	SELECT      DISTINCT    UM.clientId, ''
	FROM        sec_getClientOwners(1) UM
	INNER JOIN  APP_IDAName IDA WITH(NOLOCK) ON UM.clientId = IDA.clientId AND IDA.appTypeId in (81)
	WHERE       UM.userId = @userId --'CLIENT_ITEM
	DELETE @tblClientInfo
	WHERE NOT EXISTS (SELECT * FROM #tempClientObjects WHERE clntId In (0, clientId))
	SELECT @sourceClientId  = (	SELECT DISTINCT TOP 1 clientId
	FROM APP_Application APP WITH (NOLOCK) WHERE instance = @i_sourceInstanceId )
	DELETE	@tblClientInfo
	FROM	@tblClientInfo CLNT
			LEFT OUTER JOIN MMHost HOST (NOLOCK) ON CLNT.clientId = HOST.ClientId
	WHERE	HOST.ClientId <> @sourceClientId
			AND ( HOST.ClientId IS NULL
					OR HOST.MmHostEnabled = 0
					OR HOST.MmHostSoftState = 0
					OR HOST.OfflineReason > 0 )
	UPDATE	@tblClientInfo
	SET		clientName = CLNT.name
	FROM	@tblClientInfo T_CLNT
			INNER JOIN App_Client CLNT ON CLNT.id = T_CLNT.clientId
	INSERT INTO		@tblInstanceInfo
	SELECT			DISTINCT CLNT.clientId,  APP.instance AS 'instanceId', INST.name AS 'instanceName'
	--FROM			( SELECT ROW_NUMBER() OVER (ORDER BY clientName) as rowId, clientId, clientName FROM @tblClientInfo  ) CLNT
	FROM			@tblClientInfo CLNT
	INNER JOIN		APP_Application APP WITH (NOLOCK) ON CLNT.clientId=APP.clientId
	INNER JOIN		APP_InstanceName INST WITH(NOLOCK) ON APP.instance=INST.id
	INNER JOIN		APP_InstanceProp PROP WITH(NOLOCK) ON INST.id = PROP.componentNameId AND PROP.modified = 0 AND PROP.attrName='MSSQL Version'
	--WHERE			CLNT.rowId<= @CloneSourceTargetNumberLimit AND APP.appTypeId=@i_apptypeId
	WHERE			APP.appTypeId=@i_apptypeId
					AND CONVERT( INTEGER,SUBSTRING(PROP.ATTRVAL,0,CHARINDEX('.',PROP.attrVal)))
						>=
						(	SELECT CONVERT( INTEGER,SUBSTRING(PROP1.ATTRVAL,0,CHARINDEX('.',PROP1.attrVal)))
							FROM	APP_InstanceName INST1 WITH (NOLOCK)
							INNER JOIN	APP_InstanceProp PROP1 WITH (NOLOCK) ON INST1.id = PROP1.componentNameId
							WHERE		PROP1.modified = 0 AND PROP1.attrName='MSSQL Version'
										AND INST1.id = @i_sourceInstanceId )
	-- Delete the clients for whom there are no instances
	DELETE CLNT
	FROM @tblClientInfo CLNT
	LEFT JOIN	@tblInstanceInfo INST ON CLNT.clientId = INST.clientId
	WHERE INST.clientId IS NULL
	IF @i_apptypeId=81/*CV_APPTYPE_MSSQL*/
	BEGIN
		INSERT INTO		@databaseInfo
		SELECT 			INST.instanceId, APP.id AS 'subclientId',APP.subclientName AS 'subclientName', SUBCLNTPROP.attrName AS 'databaseName'
		FROM			@tblInstanceInfo INST
		INNER JOIN		APP_Application APP WITH (NOLOCK) ON INST.clientId=APP.clientId
		INNER JOIN		APP_SubClientProp SUBCLNTPROP WITH (NOLOCK) ON APP.id = SUBCLNTPROP.componentNameId
		WHERE			SUBCLNTPROP.attrType=118/*PROPERTY_MSSQL_DB*/ AND INST.instanceId=APP.instance
						AND	dbo.IsSubClientValid(APP.appTypeId,APP.subclientStatus,0)  = 1
AND ( APP.subclientStatus & 0x00002 ) <> 0x00002 /*CV_STATUS_UNINSTALLED*/
AND ( APP.subclientStatus & 0x00004 ) <> 0x00004 /*CV_STATUS_DELETED */
						AND 1 = (CASE WHEN EXISTS ( SELECT attrVal FROM APP_SubClientProp WITH(NOLOCK) where componentNameId = SUBCLNTPROP.componentNameId
						AND attrName=N'Enable Snap Backups' AND attrVal='1' AND modified=0) THEN 1 ELSE 0 END )
	END
	SET @o_xmlText =
		(
			SELECT 0 AS '@errorCode','Success' AS '@errorMsg',	 @CloneCrtSnapTypeAllowed AS '@CloneCrtSnapTypeAllowed',
			(
				SELECT CLNT.clientId AS 'Client/@clientId',CLNT.clientName AS 'Client/@clientName',
				(
						SELECT		instanceId as 'instance/@instanceId', instanceName as 'instance/@instanceName',
						(
							SELECT		DBINFO.databaseName AS '@database',DBINFO.subclientId as 'subclient/@subclientId', DBINFO.subclientName as 'subclient/@subclientName'
							FROM		@databaseInfo DBINFO
							WHERE		DBINFO.instanceId=INST.instanceId
							ORDER BY	databaseName
							FOR XML PATH('databases'),TYPE
						)
						FROM		@tblInstanceInfo INST WHERE INST.clientId=CLNT.clientId
						ORDER BY	instanceName
						FOR XML PATH('cloneInstances'),TYPE
				)
				FROM @tblClientInfo CLNT
				ORDER BY clientName
				FOR XML PATH('sourceTargetInfo'),TYPE
			)
			FOR XML PATH ('EVGui_GetClientInfoResp') ,TYPE
		)
ERROR_EXIT:
IF @errorCode <> 0
BEGIN
	SET @o_xmlText =
		(
			SELECT @errorCode AS '@errorCode',@errorString AS '@errorMsg', @CloneCrtSnapTypeAllowed AS '@CloneCrtSnapTypeAllowed',
			(
				SELECT '' FOR XML PATH('sourceTargetInfo'),TYPE
			)
			FOR XML PATH ('EVGui_GetClientInfoResp') ,TYPE
		)
END
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMGetCloneSourceTarget')
	delete from GxQscripts where name = 'MM_SMGetCloneSourceTarget'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetCloneSourceTarget')
	delete from GXDBVersions where aliasname = 'MM_SMGetCloneSourceTarget'
GO

insert into GXDBVersions values(2, 'MM_SMGetCloneSourceTarget',  '00010006003200030000', 'MM_SMGetCloneSourceTarget', '00010006003200030000')
GO

