

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetBackupCopyCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2020  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetBackupCopyCount.sp,v $ $Id: MM_SMGetBackupCopyCount.sp,v 1.1.2.1 2020/12/22 14:57:07 bbrindavan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMGetBackupCopyCount')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetBackupCopyCount <<<'
	drop procedure MM_SMGetBackupCopyCount
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetBackupCopyCount')
	delete from GxQscripts where name = 'MM_SMGetBackupCopyCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetBackupCopyCount')
	delete from GXDBVersions where aliasname = 'MM_SMGetBackupCopyCount'
GO
print '... Creating Procedure: MM_SMGetBackupCopyCount'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMGetBackupCopyCount
  @i_subClientId INTEGER,
  @i_reserveStr VARCHAR(1024)
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @o_subClientId INT
  DECLARE @o_toBeCopiedCount INT
  DECLARE @o_subClientLimit INT
  DECLARE @o_ErrorCode INT
  DECLARE @o_ErrorMsg VARCHAR(1024)
SET NOCOUNT ON
SET @o_ErrorCode = 0
SET @o_ErrorMsg = ''
SET @o_toBeCopiedCount = 0
-- Validate input subclient
IF NOT EXISTS (SELECT 1 FROM APP_Application WHERE id = @i_subClientId)
BEGIN
SET @o_ErrorCode = 44058
	SET @o_ErrorMsg = 'Invalid Subclient Id [' + CAST(@i_subClientId AS VARCHAR(10)) + ']'
	GOTO ERR_EXIT
END
-- Get number of pending Backup copy jobs on the subclient
SELECT @o_toBeCopiedCount = COUNT(JMS.jobId)
FROM JMJobSnapshotStats JMS
	INNER JOIN JMBkpStats JM
		ON JMS.jobId = JM.jobId
			AND JMS.commcellId = JM.commCellId
			AND JMS.materializationStatus IN (101,102,103) -- CVCopyDataState.NODATACOPIED, NODATAVALID, PARTIALDATA
AND (JMS.disabled & 1) = 0
			AND JM.appId = @i_subClientId
-- SubclientId, PendingBackupCopyJobCount, SubclientThreshold, ErrorCode, ErrorString
SELECT @i_subClientId, @o_toBeCopiedCount, 0, 0, ''
RETURN
ERR_EXIT:
SELECT 0, 0, 0, @o_ErrorCode, @o_ErrorMsg
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetBackupCopyCount')
	delete from GxQscripts where name = 'MM_SMGetBackupCopyCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetBackupCopyCount')
	delete from GXDBVersions where aliasname = 'MM_SMGetBackupCopyCount'
GO

insert into GXDBVersions values(2, 'MM_SMGetBackupCopyCount',  '00010001000200010000', 'MM_SMGetBackupCopyCount', '00010001000200010000')
GO

