

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetAvailableClones.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetAvailableClones.sp,v $ $Id: MM_SMGetAvailableClones.sp,v 1.6.2.3 2018/07/06 16:49:27 mtayal Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetAvailableClones <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetAvailableClones')
	drop procedure MM_SMGetAvailableClones
IF EXISTS (select * from GxQscripts where name='MM_SMGetAvailableClones')
	delete from GxQscripts where name = 'MM_SMGetAvailableClones'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetAvailableClones')
	delete from GXDBVersions where aliasname = 'MM_SMGetAvailableClones'
GO
print '... Creating Procedure: MM_SMGetAvailableClones'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetAvailableClones
  @xmlTextInput XML,
  @o_xmlText XML	OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @i_apptypeId			INT=0
	DECLARE @i_userId				INT=0
	DECLARE @i_subclientId			INT=0
	DECLARE @i_clientId				INT=0
	DECLARE @i_instanceId			INT=0
	DECLARE @i_sourceDatabaseName	NVARCHAR(1024)=N''
	-- Job Status - Killed (Include\JobManager\CVjob.h)
	DECLARE @JOB_STATUS_KILLED		INT=4
	DECLARE @JOB_STATUS_FAILED		INT=2
	DECLARE @defaultCommcellId		INT=2
	DECLARE @errorCode				INT=0
	DECLARE @errorString			NVARCHAR(MAX)=N''
	SET @i_apptypeId = ISNULL(( SELECT ref.value('@applicationId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetAvailableClonesReq/appType') R ( ref ) ),
						0)
	SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetAvailableClonesReq/client') R ( ref ) ),
						0)
	SET @i_subclientId = ISNULL(( SELECT ref.value('@subclientId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetAvailableClonesReq/subclient') R ( ref ) ),
						0)
	SET @i_instanceId = ISNULL(( SELECT ref.value('@instanceId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetAvailableClonesReq/instance') R ( ref ) ),
						0)
	SET @i_userId = ISNULL(( SELECT ref.value('@userId', 'int')
							FROM @xmlTextInput.nodes('EVGui_GetAvailableClonesReq/userId') R ( ref ) ),
						0)
	--SET @i_sourceDatabaseName = ISNULL( ( SELECT ref.value('@sourceDatabaseName', 'nvarchar(1024)')
	--						FROM @xmlTextInput.nodes('EVGui_GetAvailableClonesReq') R ( ref ) ),
	--					N'')
	SET @i_sourceDatabaseName = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@sourceDatabaseName', 'nvarchar(1024)'))
							FROM @xmlTextInput.nodes('EVGui_GetAvailableClonesReq') R ( ref ) ),
						N'')
	--Check for valid input parameters
	IF NOT EXISTS (SELECT * FROM APP_Client CLNT WITH (NOLOCK) WHERE CLNT.id = @i_clientId)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Client with the id ' + CONVERT (NVARCHAR,@i_clientId) + ' does not exist'
		GOTO ERROR_EXIT
	END
	IF NOT EXISTS (SELECT * FROM APP_Application APP WITH (NOLOCK) WHERE APP.id = @i_subclientId)
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Sub client with the id ' + CONVERT (NVARCHAR,@i_subclientId) + ' does not exist'
		GOTO ERROR_EXIT
	END
	IF OBJECT_ID('tempdb.dbo.#tbl_GAC_SMVolume') IS NOT NULL
		DROP TABLE #tbl_GAC_SMVolume
	CREATE TABLE #tbl_GAC_SMVolume
	(
		SMVolumeId int,
		AppId int,
		CopyId int,
		ControlHostId int
	)
	DECLARE @tblMountVolume TABLE (
		t_MntSMVolumeId int,
		t_MntCloneJobId int,
		t_MntCreationTime int,
		t_MntExpireTime int,
		t_MntMountPath nvarchar(1024),
		t_MnttgtClientId int,
		t_MnttgtClientName nvarchar(1024),
		t_sourceDatabaseName nvarchar(1024),
		t_TTargetInstance nvarchar(1024),
		t_TTargetDatabase nvarchar(1024)
	)
	DECLARE @tblSourceInfo TABLE (  -- SourceInfo
		t_SMVolumeId int,
		t_snapJobId int,
		t_sourceClientId int,
		t_sourceClientName nvarchar(1024),
		t_sourceInstanceId int,
		t_sourceInstanceName nvarchar(1024),
		t_userName nvarchar(1024),
		t_arrayId int,
		t_arrayName nvarchar(1024),
		t_AppId int,
		t_appTypeName  nvarchar(1024)
	)
	DECLARE @tblWorkflowJobsDetails TABLE (
		t_workflowJobId int,
		t_sourceClientId int,
		t_sourceClientName nvarchar(1024),
		t_sourceInstanceId int,
		t_sourceInstanceName nvarchar(1024),
		t_sourceDatabase 	nvarchar(1024),
		t_tgtClientId int,
		t_tgtClientName nvarchar(1024),
		t_tgtInstanceId int,
		t_tgtInstanceName nvarchar(1024),
		t_tgtDatabase 	nvarchar(1024),
		t_CloneStatusId int,
		t_CloneStatusName nvarchar(1024)
	)
	INSERT INTO @tblWorkflowJobsDetails
	SELECT
				D.jobID ,
				d.createCloneXml.value('(EVGui_CreateNewCloneReq/sourceClient/@clientId)[1]','int'),
				d.createCloneXml.value('(EVGui_CreateNewCloneReq/sourceClient/@clientName)[1]','nvarchar(max)'),
				d.createCloneXml.value('(EVGui_CreateNewCloneReq/sourceInstance/@instanceId)[1]','int'),
				d.createCloneXml.value('(EVGui_CreateNewCloneReq/sourceInstance/@instanceName)[1]','nvarchar(max)'),
				d.createCloneXml.value('(EVGui_CreateNewCloneReq/@sourceDatabase)[1]','nvarchar(max)'),
				d.createCloneXml.value('(EVGui_CreateNewCloneReq/tgtClient/@clientId)[1]','int'),
				d.createCloneXml.value('(EVGui_CreateNewCloneReq/tgtClient/@clientName)[1]','nvarchar(max)'),
				d.createCloneXml.value('(EVGui_CreateNewCloneReq/tgtInstance/@instanceId)[1]','int'),
				d.createCloneXml.value('(EVGui_CreateNewCloneReq/tgtInstance/@instanceName)[1]','nvarchar(max)'),
				d.createCloneXml.value('(EVGui_CreateNewCloneReq/@tgtDatabase)[1]','nvarchar(max)'),
				2 , 'In Progress'
			FROM
			(
				SELECT
					CONVERT(xml,c.options.value('(/inputs/inputXml)[1]','nvarchar(max)')) as createCloneXml,C.jobID
				FROM
				(
					SELECT
						 CONVERT(XML, A.xmlJobInfo.value('(/Workflow_StartWorkflow/@options)[1]','nvarchar(max)')) as options,A.jobID
					FROM
					(
						SELECT CONVERT(xml,REPLACE(xmlJobInfo, 'UTF-8', 'UTF-16')) AS xmlJobInfo,jobID FROM RunningAdminJobs WITH(NOLOCK) WHERE workflowName='Snap-CreateTestClone' AND state NOT IN (4,9,10,11)/*CVJobState*/
					) A
				) C
			) D
	--WHERE 	d.createCloneXml.value('(EVGui_CreateNewCloneReq/@sourceDatabase)[1]','nvarchar(max)') = @i_sourceDatabaseName
	WHERE 	@i_sourceDatabaseName =  (SELECT dbo.DecodeInvalidXMLChar (d.createCloneXml.value('(EVGui_CreateNewCloneReq/@sourceDatabase)[1]','nvarchar(max)') ))
	INSERT INTO		#tbl_GAC_SMVolume
	SELECT			DISTINCT VOL.SMVolumeId, VOL.AppId, VOL.CopyId, SNAP.ControlHostId
	FROM			SMVolume VOL WITH (NOLOCK)
					INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.id = VOL.AppId
					INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = VOL.SMVolumeId
					INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
	WHERE			VOL.AppTypeId=@i_apptypeID AND VOL.PruneFlags = 1 /*MM_SM_PRUNEFLAGS_ACTIVE*/
					AND VOL.AppId = @i_subclientId AND APP.instance = @i_instanceId AND APP.clientId = @i_clientId
					AND VOL.CommCellId = @defaultCommcellId
	--
	-- Security - remove those where the subclients are not visible for this user.
	--
	IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
        DROP TABLE #tblSecCheck
	CREATE TABLE #tblSecCheck (
		EntityType int,
		EntityId int,
		EntityVisible int
	)
	INSERT INTO #tblSecCheck
SELECT DISTINCT 1, CopyId, 0  FROM #tbl_GAC_SMVolume
	INSERT INTO #tblSecCheck
SELECT DISTINCT 2, ControlHostId, 0  FROM #tbl_GAC_SMVolume
	INSERT INTO #tblSecCheck
SELECT DISTINCT 3, AppId, 0  FROM #tbl_GAC_SMVolume
	EXEC sec_isSnapshotVisible @i_userId
	DELETE	A
	FROM	#tbl_GAC_SMVolume A
INNER JOIN #tblSecCheck B_Copy ON A.CopyId = B_Copy.EntityId AND B_Copy.EntityType = 1
INNER JOIN #tblSecCheck B_CHost ON A.ControlHostId = B_CHost.EntityId AND B_CHost.EntityType = 2
INNER JOIN #tblSecCheck B_App ON A.AppId = B_App.EntityId AND B_App.EntityType = 3
	WHERE	B_Copy.EntityVisible <=0
			AND B_CHost.EntityVisible <=0
			AND B_App.EntityVisible <=0
	IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
		DROP TABLE #tblSecCheck
	--
	IF @i_apptypeId=81/*CV_APPTYPE_MSSQL*/
	BEGIN
		INSERT INTO		@tblMountVolume
		SELECT			A.SMVolumeId,A.CloneJobId,A.CreationTime,A.ExpireTime,A.MountPath,A.MountHostId, N'',
						ISNULL(SQLiDA.databaseList.value('./@sourceDatabaseName','nvarchar(max)'),N''),
						SQLiDA.databaseList.value('(/SQLiDA_AttachDBMsg/@instanceName)[1]','nvarchar(max)'),
						SQLiDA.databaseList.value('./@databaseName','nvarchar(max)')
		FROM
		(
		SELECT			MVOL.SMVolumeId,MVOL.MountJobId AS CloneJobId,MVOL.CreationTime,MVOL.ExpireTime,MVOL.MountPath,MVOL.MountHostId, CONVERT(xml,REPLACE(MD.Metadata, 'UTF-8', 'UTF-16')) as cloneMetaData
		FROM			SMMountVolume MVOL WITH (NOLOCK)
		INNER JOIN		#tbl_GAC_SMVolume VOL ON VOL.t_SMVolumeId=MVOL.SMVolumeId
		INNER JOIN		SMMetaData MD WITH (NOLOCK) ON MVOL.Id=MD.RefId
		WHERE			MVOL.MountStatus=59 /*SM_VS_MNT_MOUNTED*/ AND MD.MetaDataType=38 /*SM_MDT_TEST_ENV_APP_INFO*/
						AND MD.RefType=10 /*SM_MRT_MOUNT_VOLUME*/
						AND MVOL.MountJobId NOT IN (SELECT jobId FROM JMJobInfo WITH(NOLOCK) UNION SELECT jobId FROM JMRestoreStats WITH(NOLOCK) WHERE status IN (@JOB_STATUS_KILLED,@JOB_STATUS_FAILED))
		) A
		CROSS APPLY     A.cloneMetaData.nodes('/SQLiDA_AttachDBMsg/databaseList') SQLiDA(databaseList)
		DELETE	@tblMountVolume WHERE t_sourceDatabaseName <> @i_sourceDatabaseName
		DELETE  @tblMountVolume WHERE t_MntSMVolumeId NOT IN  ( SELECT MIN(t_MntSMVolumeId) FROM @tblMountVolume GROUP BY t_MntCloneJobId)
	END
	INSERT INTO @tblSourceInfo
	SELECT DISTINCT t_MntSMVolumeId,0,0,N'',0,N'',N'',0,N'',0,N'' FROM @tblMountVolume
	UPDATE	@tblSourceInfo
	SET		t_snapJobId=VOL.JobId,
			t_sourceClientId=VOL.SourceClientId,
			t_AppId=VOL.AppId,
			t_sourceClientName=CLNT.name
	FROM	@tblSourceInfo A
			INNER JOIN SMVolume VOL WITH (NOLOCK) ON A.t_SMVolumeId=VOL.SMVolumeId
			INNER JOIN APP_Client CLNT WITH (NOLOCK) ON VOL.SourceClientId=CLNT.id
	UPDATE	@tblMountVolume
	SET		t_MnttgtClientName=CLNT.name
	FROM	@tblMountVolume A
			INNER JOIN APP_Client CLNT WITH (NOLOCK) ON A.t_MnttgtClientId=CLNT.id
	UPDATE	@tblSourceInfo
	SET		t_sourceInstanceId=APP.instance,
			t_sourceInstanceName=INST.name
	FROM	@tblSourceInfo A
			INNER JOIN APP_Application APP WITH (NOLOCK) ON A.t_sourceClientId =APP.clientId AND APP.appTypeId=@i_apptypeID AND APP.id=A.t_AppId
			INNER JOIN APP_InstanceName INST WITH (NOLOCK) ON APP.instance=INST.id
	UPDATE	@tblSourceInfo
	SET		t_arrayId=SNAP.ControlHostId,
			t_arrayName=CH.SMArrayId
	FROM	@tblSourceInfo A
			INNER JOIN SMVolSnapMap MAP WITH (NOLOCK) ON A.t_SMVolumeId=MAP.SMVolumeId
			INNER JOIN SMSnap SNAP WITH (NOLOCK) ON MAP.SMSnapId=SNAP.SMSnapId
			INNER JOIN SMControlHost CH WITH (NOLOCK) ON SNAP.ControlHostId=CH.ControlHostId
	UPDATE	@tblSourceInfo
	SET		t_appTypeName=IDATYPE.name
	FROM	@tblSourceInfo A
			INNER JOIN APP_iDAType IDATYPE WITH (NOLOCK) ON IDATYPE.type=@i_apptypeID
	BEGIN
	SET @o_xmlText =
		(SELECT 0 AS '@errorCode','Success' AS '@errorMsg' ,
		(
			SELECT	t_workflowJobId AS '@workflowJobId',
					t_tgtClientId AS 'tgtClient/@clientId', t_tgtClientName AS 'tgtClient/@clientName',
					t_tgtInstanceId AS 'tgtInstance/@instanceId', t_tgtInstanceName AS 'tgtInstance/@instanceName',
					0 AS 'tgtDatabase/@id',t_tgtDatabase AS 'tgtDatabase/@name',
					t_CloneStatusId AS 'cloneStatus/@id', t_CloneStatusName AS 'cloneStatus/@name'
			FROM	@tblWorkflowJobsDetails
			FOR XML PATH('listOfClones'),TYPE  ),
		(
			SELECT		RES.t_SnapJobId AS '@snapJobId',
						MVOL.t_MntCloneJobId AS '@cloneJobId',
						MVOL.t_MntCreationTime AS '@creationDate',
						MVOL.t_MntExpireTime AS '@expiryDate',
						0 AS '@workflowJobId',
						LEFT (MVOL.t_MntMountPath,LEN(MVOL.t_MntMountPath)- CHARINDEX('\',reverse(MVOL.t_MntMountPath),2))AS '@mountPath',
						MVOL.t_MnttgtClientId AS 'tgtClient/@clientId',MVOL.t_MnttgtClientName AS 'tgtClient/@clientName',
						--(ISNULL( (SELECT id FROM APP_InstanceName WITH (NOLOCK) WHERE name=tdb.t_TTargetInstance) ,0) )AS 'tgtInstance/@id',
						0 AS 'tgtInstance/@instanceId',
						MVOL.t_TTargetInstance AS 'tgtInstance/@instanceName',
						0 AS 'tgtDatabase/@id',MVOL.t_TTargetDatabase AS 'tgtDatabase/@name',
						RES.t_sourceClientId AS 'sourceClient/@clientId', RES.t_sourceClientName AS 'sourceClient/@clientName',
						RES.t_sourceInstanceId AS 'sourceInstance/@instanceId', RES.t_sourceInstanceName AS 'sourceInstance/@instanceName',
						0 AS 'sourceDatabase/@id',MVOL.t_sourceDatabaseName AS 'sourceDatabase/@name',
						@i_userId AS 'user/@userId', RES.t_userName AS 'user/@userName',
						@i_apptypeID AS 'appType/@applicationId', RES.t_appTypeName AS 'appType/@appName',
						RES.t_arrayId AS 'array/@id', RES.t_arrayName AS 'array/@name',
						1 AS 'cloneStatus/@id', 'Active' AS 'cloneStatus/@name'
			FROM		@tblMountVolume MVOL
						INNER JOIN @tblSourceInfo RES  ON MVOL.t_MntSMVolumeId=RES.t_SMVolumeId
			WHERE		0=( SELECT COUNT(*)
							FROM @tblWorkflowJobsDetails WorkFlowDet
							WHERE WorkFlowDet.t_tgtClientId=MVOL.t_MnttgtClientId AND WorkFlowDet.t_tgtClientName=MVOL.t_MnttgtClientName
							AND WorkFlowDet.t_tgtInstanceName=MVOL.t_TTargetInstance AND WorkFlowDet.t_tgtDatabase=MVOL.t_TTargetDatabase	)
			ORDER BY	MVOL.t_MntCreationTime DESC
			FOR XML PATH('listOfClones'),TYPE  )
			FOR XML PATH ('EVGui_GetAvailableClonesResp')
		)
	END
	IF OBJECT_ID('tempdb.dbo.#tbl_GAC_SMVolume') IS NOT NULL
		DROP TABLE #tbl_GAC_SMVolume
ERROR_EXIT:
IF @errorCode <> 0
BEGIN
	SET @o_xmlText =
		(	SELECT @errorCode AS '@errorCode',@errorString AS '@errorMsg'
			FOR XML PATH ('EVGui_GetAvailableClonesResp')
		)
END
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMGetAvailableClones')
	delete from GxQscripts where name = 'MM_SMGetAvailableClones'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetAvailableClones')
	delete from GXDBVersions where aliasname = 'MM_SMGetAvailableClones'
GO

insert into GXDBVersions values(2, 'MM_SMGetAvailableClones',  '00010006000200030000', 'MM_SMGetAvailableClones', '00010006000200030000')
GO

