

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetArrayInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetArrayInfo.sp,v $ $Id: MM_SMGetArrayInfo.sp,v 1.9.12.15 2020/12/19 05:04:43 mmani Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMGetArrayInfo')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetArrayInfo <<<'
	drop procedure MM_SMGetArrayInfo
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetArrayInfo')
	delete from GxQscripts where name = 'MM_SMGetArrayInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetArrayInfo')
	delete from GXDBVersions where aliasname = 'MM_SMGetArrayInfo'
GO
print '... Creating Procedure: MM_SMGetArrayInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMGetArrayInfo
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_ControlHostId INTEGER
  DECLARE @o_MetaDataId INTEGER
  DECLARE @o_ArrayAlias VARCHAR(4000)
  DECLARE @o_ArrayName VARCHAR(2048)
  DECLARE @o_Flag INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
  DECLARE @o_ReserveParam1 INTEGER
  DECLARE @o_ReserveParam2 INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	-- Constants
	DECLARE	@C_SM_ARRAY_ALIAS_DELIM		NVARCHAR(2) = N'|'
	DECLARE @C_SM_CMODE_ALIAS_MARKER	NVARCHAR(10) = N'##CMODE##'
	-- Sample CMode array alias input : ##cmode##3$nac1vs1,172.19.103.163|1$172.19.103.162|2$172.19.103.162|6$172.19.103.164|
	DECLARE @C_SM_NETAPP_MULTI_TEN_MARKER NVARCHAR(15) = N'##arrayNum##'
	DECLARE	@C_SM_NETAPP_MULTI_TEN_DELIM	NVARCHAR(5) = N'##'
	-- NetApp Multi-Tenancy Changes - new format
	--	Sample for 7 mode
	-- ##arrayNum##10##172.19.74.90##172.19.74.90|172.24.18.40
	-- Sample for C mode
	-- ##arrayNum##11##172.19.74.90####cmode##3$nac1vs1,172.19.103.163|1$172.19.103.162|2$172.19.103.162|6$172.19.103.164|
	DECLARE @arrayNumInReq INTEGER = 0
	DECLARE @dataIterfaceInReq NVARCHAR(MAX) = N''
	DECLARE	@C_CV_PROP_NAS_VSERVER_NAME	NVARCHAR(1024) = N'NAS vServer Name'
	-- Constants for Vendor name
DECLARE	@C_SM_SNAPSHOT_ENGINE_NETAPP_VENDORNAME	NVARCHAR(16) = 'NetApp'
DECLARE	@C_SM_SNAPSHOT_ENGINE_ISILON_VENDORNAME	NVARCHAR(16) = 'Dell EMC Isilon'
DECLARE	@C_SM_SNAPSHOT_ENGINE_NETAPP_FALSHRAY_VENDORNAME	NVARCHAR(16) = 'NetApp FlashRay'
DECLARE	@C_SM_SNAPSHOT_ENGINE_HDS_VENDORNAME	NVARCHAR(16) = 'Hitachi Vantara'
	-- Constants for Array Configs
	DECLARE	@SMCONFIG_NAME_AUTO_UPDATE_ARRAY_HOST_ALIASES_KEY NVARCHAR(64) = 'SMCONFIG_NAME_AUTO_UPDATE_ARRAY_HOST_ALIASES'
	DECLARE	@SMCONFIG_NAME_ARRAY_HOST_ALIASES_KEY NVARCHAR(64) = 'SMCONFIG_NAME_ARRAY_HOST_ALIASES'
	SET	@o_ControlHostId = 0
	SET	@o_MetaDataId = 0
	--SET	@o_ArrayAlias = ''
	SET	@o_ArrayName = ''
	DECLARE	@arrayId				INTEGER = 0		-- Output CtrlHostId
	DECLARE @x_arrayName			NVARCHAR(MAX) = N''
	DECLARE @x_ctrlHostId			INTEGER = 0
	DECLARE @x_clientId				INTEGER = 0
	DECLARE @x_clientName			NVARCHAR(2048) = N''
	DECLARE @x_snapEngineId			INTEGER = 0
	DECLARE @x_flags				INTEGER = 0
	DECLARE @x_addrType				INTEGER = 0
	DECLARE @x_baseArrayName		NVARCHAR(MAX) = N''
	DECLARE @x_reqClientId			INTEGER = 0
	-- Get the input params from XML
	SET @x_arrayName = ISNULL(( SELECT R.ref.value('.', 'NVARCHAR(MAX)') FROM @i_xmlTextInput.nodes('/MM_SMGetArrayInfo/ArrayName') R(ref)), N'')
	SET @x_ctrlHostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetArrayInfo/CtrlHostId') R(ref)), 0)
	SET @x_snapEngineId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetArrayInfo/SnapEngineId') R(ref)), 0)
	SET @x_clientName = ISNULL(( SELECT R.ref.value('.', 'NVARCHAR(2048)') FROM @i_xmlTextInput.nodes('/MM_SMGetArrayInfo/ClientName') R(ref)), N'')
	SET @x_clientId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetArrayInfo/ClientId') R(ref)), 0)
	SET @x_flags = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetArrayInfo/Flags') R(ref)), 0)
	SET @x_addrType = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetArrayInfo/AddrType') R(ref)), 0)
	SET @x_baseArrayName = ISNULL(( SELECT R.ref.value('.', 'NVARCHAR(MAX)') FROM @i_xmlTextInput.nodes('/MM_SMGetArrayInfo/BaseArrayName') R(ref)), N'')
	SET @x_reqClientId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMGetArrayInfo/ReqClntId') R(ref)), 0)
	DECLARE @arrayName NVARCHAR(MAX) = N''
	DECLARE @doNotUpdateArrayAliases INT = 0
	--MultiSite changes
	DECLARE @isMultiTenantSite 			INT = 0
	DECLARE @proxyRegionId 				INT = 0
	DECLARE @arrayRegionId 				INT = 0
	DECLARE @arrayRegionName 			NVARCHAR(256) = N''
	DECLARE @proxyRegionName 			NVARCHAR(256) = N''
	DECLARE @proxyClientName 			NVARCHAR(1024) = N''
	DECLARE @isClientMSiteSEnabled		INT = 0
	SET @isMultiTenantSite = ISNULL((select Value from MMConfigs (NOLOCK) where name = 'MMS2_CONFIG_SNAP_MULTI_TENANT_SITE'), 0)
	-- Validate the input params
IF (@x_flags & 65536 = 65536) AND @x_ctrlHostId = 0
	BEGIN
SELECT	0, 0, '', '', 0, 60293 /*E_MM_SM_SB_INVALID_PARAMS*/, N'Control Host Id not passed', 0, 0
		RETURN
	END
IF( @x_flags & 131072 = 131072) AND (@x_ctrlHostId = 0 OR @x_addrType = 0)
	BEGIN
SELECT	0, 0, '', '', 0, 60293 /*E_MM_SM_SB_INVALID_PARAMS*/, N'Address Type Valid flag is set but Address Type or ControlHost Id is not passed.', 0, 0
		RETURN
	END
	IF @x_ctrlHostId > 0
	BEGIN
IF @x_flags & 65536 = 65536
		BEGIN
			SELECT	@o_ControlHostId = PHY_CTRLHOST.ControlHostId
			FROM	APP_VMToPMMap VM2PM WITH(NOLOCK) INNER JOIN SMControlHost VIRT_CTRLHOST WITH(NOLOCK) ON VM2PM.VMClientId = VIRT_CTRLHOST.ClientId
					INNER JOIN SMControlHost PHY_CTRLHOST WITH(NOLOCK) ON VM2PM.PMClientId = PHY_CTRLHOST.ClientId
			WHERE	VIRT_CTRLHOST.ControlHostId = @x_ctrlHostId
			IF @o_ControlHostId <= 0
			BEGIN
SELECT	0, 0, '', '', 0, 60254 /*E_MM_SM_SB_GET_CONTROL_HOST_INFO_FAILED*/, N'No matching array found in database for CtrlHostId[' + CAST(@x_ctrlHostId AS NVARCHAR) + N']', 0, 0
				RETURN
			END
			GOTO PROC_EXIT
		END
		ELSE
		BEGIN
			IF EXISTS(SELECT ControlHostId FROM SMControlHost WITH(NOLOCK) WHERE ControlHostId = @x_ctrlHostId)
			BEGIN
				SET @arrayId = @x_ctrlHostId
				SET	@o_ControlHostId = @x_ctrlHostId
IF @x_flags & 131072 = 131072
				BEGIN
					SELECT	@o_ArrayAlias = COALESCE(@o_ArrayAlias + '|', '') + Address
					FROM	SMEndPoint EP WITH (NOLOCK) JOIN SMControlHost HOST WITH(NOLOCK)
					ON		(HOST.ClientId = EP.ClientId)
					WHERE	HOST.ControlHostId = @arrayId AND EP.AddressType = @x_addrType
				END
				ELSE
				BEGIN
					SELECT	@o_ArrayAlias = COALESCE(@o_ArrayAlias + '|', '') + AliasName
					FROM	SMHostAlias WITH (NOLOCK)
					WHERE	RefId = @arrayId
				END
				GOTO PROC_EXIT
			END
			ELSE
			BEGIN
SELECT	0, 0, '', '', 0, 60254 /*E_MM_SM_SB_GET_CONTROL_HOST_INFO_FAILED*/, N'No matching array found in database for CtrlHostId[' + CAST(@x_ctrlHostId AS NVARCHAR) + N']', 0, 0
				RETURN
			END
		END
	END
	IF @x_clientId > 0
	BEGIN
		SELECT @arrayId = ControlHostId FROM SMControlHost WITH(NOLOCK) WHERE ClientId = @x_clientId
		IF @arrayId > 0
		BEGIN
			SET	@o_ControlHostId = @arrayId
			SELECT	@o_ArrayAlias = COALESCE(@o_ArrayAlias + '|', '') + AliasName
			FROM	SMHostAlias WITH (NOLOCK)
			WHERE	RefId = @arrayId
			GOTO PROC_EXIT
		END
		ELSE
SELECT	0, 0, '', '', 0, 60254 /*E_MM_SM_SB_GET_CONTROL_HOST_INFO_FAILED*/, N'No matching array found in database for ClientId[' + CAST(@x_clientId AS NVARCHAR) + N']', 0, 0
			RETURN
	END
	IF @x_clientName <> N''
	BEGIN
		SELECT @arrayId = HOST.ControlHostId FROM SMControlHost HOST WITH (NOLOCK) JOIN APP_Client CLIENT WITH (NOLOCK)
				ON ( (CLIENT.name = @x_clientName OR CLIENT.net_hostname = @x_clientName) AND HOST.ClientId = CLIENT.id)
		IF @arrayId > 0
		BEGIN
			SET	@o_ControlHostId = @arrayId
			SELECT	@o_ArrayAlias = COALESCE(@o_ArrayAlias + '|', '') + AliasName
			FROM	SMHostAlias WITH (NOLOCK)
			WHERE	RefId = @arrayId
			GOTO PROC_EXIT
		END
		ELSE
SELECT	0, 0, '', '', 0, 60254 /*E_MM_SM_SB_GET_CONTROL_HOST_INFO_FAILED*/, N'No matching array found in database for Client[' + @x_clientName + N']', 0, 0
			RETURN
	END
	-- Validate the input params
	IF @x_arrayName = N'' AND @x_snapEngineId = 0
	BEGIN
SELECT	0, 0, '', '', 0, 60293 /*E_MM_SM_SB_INVALID_PARAMS*/, N'All the params passed to get Array Info are empty', 0, 0
		RETURN
	END
	-- Check whether the NetApp Multi-Tenancy marker is set
	BEGIN TRY
		IF CHARINDEX(@C_SM_NETAPP_MULTI_TEN_MARKER, @x_arrayName, 0) > 0
		BEGIN
			SET @arrayName = @x_arrayName
			-- Remove the marker ##arrayNum##
			SET @arrayName = SUBSTRING(@arrayName, LEN(@C_SM_NETAPP_MULTI_TEN_MARKER)+1, LEN(@arrayName))
			-- Get the controlhostId
			SET @arrayNumInReq = SUBSTRING(@arrayName,0, CHARINDEX(@C_SM_NETAPP_MULTI_TEN_DELIM, @arrayName, 0) )
			-- Remove the controlhostId and the next delim
			SET @arrayName = SUBSTRING(@arrayName, LEN(@C_SM_NETAPP_MULTI_TEN_DELIM)+LEN(@arrayNumInReq)+1, LEN(@arrayName))
			-- Get the data interface in request
			SET @dataIterfaceInReq  = SUBSTRING(@arrayName,0, CHARINDEX(@C_SM_NETAPP_MULTI_TEN_DELIM, @arrayName, 0) )
			-- Remove the data interface in req
			SET @arrayName = SUBSTRING(@arrayName, LEN(@C_SM_NETAPP_MULTI_TEN_DELIM)+LEN(@dataIterfaceInReq)+1, LEN(@arrayName))
			SET @x_arrayName = @arrayName
		END
	END TRY
	BEGIN CATCH
SELECT	0, 0, '', '', 0, 60254 /*E_MM_SM_SB_GET_CONTROL_HOST_INFO_FAILED*/, N'Failed to parse the array id input [' + @x_arrayName + '].', 0, 0
		RETURN
	END CATCH
	DECLARE	@tblInputNames TABLE (protocol INT, ArrayName NVARCHAR(2048))
	-- Check whether Array name is sent or Array alias list is sent in XML
	IF CHARINDEX(@C_SM_CMODE_ALIAS_MARKER, @x_arrayName, 0) > 0
	BEGIN
		SET @arrayName = @x_arrayName
		SET @arrayName = SUBSTRING(@arrayName, LEN(@c_SM_CMODE_ALIAS_MARKER)+1, LEN(@arrayName))
		DECLARE @pDelimPos INT = 0
		DECLARE @dDelimPos INT = 0
		DECLARE @type INT = 0
		DECLARE @subAlias NVARCHAR(MAX) = N''
		DECLARE @aliases NVARCHAR(MAX) = N''
		--SET @x_arrayName =  SUBSTRING(@x_arrayName, LEN('##CMODE##')+1, LEN(@x_arrayName))
		WHILE LEN(@arrayName) > 0
		BEGIN
			SET @pDelimPos = CHARINDEX('|', @arrayName)
			--SELECT @pDelimPos
			IF @pDelimPos > 0
			BEGIN
				SET @subAlias = SUBSTRING(@arrayName, 0, @pDelimPos)
				--SELECT @subAlias
				SET @dDelimPos = CHARINDEX('$', @subAlias)
				IF @dDelimPos > 0
				BEGIN
					SET @type = SUBSTRING(@subAlias, 0, @dDelimPos)
					SET @aliases = SUBSTRING(@subAlias, @dDelimPos + 1, LEN(@subAlias))
					INSERT INTO @tblInputNames
					SELECT DISTINCT @type, _ID FROM SplitStringByDelimiter(@aliases, ',' )
				END
			END
			SET @arrayName = SUBSTRING(@arrayName, @pDelimPos + 1, LEN(@arrayName))
		END
	END
	ELSE IF CHARINDEX(@C_SM_ARRAY_ALIAS_DELIM, @x_arrayName, 0) > 0
	BEGIN
		INSERT	INTO @tblInputNames(ArrayName)
		SELECT	DISTINCT _ID FROM SplitStringByDelimiter(@x_arrayName, @C_SM_ARRAY_ALIAS_DELIM )
	END
	ELSE
		INSERT	INTO @tblInputNames(ArrayName) VALUES (@x_arrayName)
	DECLARE	@arrayAliasesStr	NVARCHAR(MAX)
	DECLARE @isHDS INT = 0
	DECLARE @isNetApp INT = 0
	DECLARE @arrayCnt INT = 0
	-- Checking the  input aliases against SMControlHost as for HDS the query is always by the array name (SMArrayId)
	SELECT @isHDS = 1 FROM @tblInputNames TMP INNER JOIN SMControlHost(NOLOCK) CTRL ON TMP.ArrayName = CTRL.SMArrayId AND CTRL.SnapVendorName = @C_SM_SNAPSHOT_ENGINE_HDS_VENDORNAME
	IF EXISTS ( SELECT	1
				FROM	SMHostAlias ALIAS (NOLOCK)
						INNER JOIN SMControlHost CTRL (NOLOCK) ON CTRL.ControlHostId = ALIAS.RefId and RefType = 5
						INNER JOIN @tblInputNames INP ON INP.ArrayName = ALIAS.AliasName
				WHERE	CTRL.SnapVendorName = @C_SM_SNAPSHOT_ENGINE_NETAPP_VENDORNAME )
	BEGIN
		SET @isNetApp = 1
	END
	SELECT @arrayCnt = COUNT(DISTINCT RefId) FROM SMHostAlias (NOLOCK) WHERE AliasName IN (SELECT ArrayName FROM @tblInputNames)
	IF @isHDS = 1
	BEGIN
		-- Check whether the given Array Name is there in SMHostAlias or not
		IF @x_baseArrayName <> N''
		BEGIN
				SELECT	@arrayId = RefId
				FROM	SMHostAlias SHA WITH (NOLOCK) INNER JOIN SMConfigs CFG WITH (NOLOCK) ON CFG.ArrayId = SHA.RefId
						INNER JOIN SMMasterConfigs MCF WITH (NOLOCK) ON MCF.Id = CFG.MasterConfigId
				WHERE	AliasName IN (SELECT ArrayName FROM @tblInputNames)
AND MCF.Id = 164
AND CFG.AssocType	= 3
						AND CFG.ValueStr	= @x_baseArrayName
		END
		ELSE IF @arrayCnt > 1
		BEGIN
			SELECT	@arrayId = RefId
				FROM	SMHostAlias SHA WITH (NOLOCK) INNER JOIN SMConfigs CFG WITH (NOLOCK) ON CFG.ArrayId = SHA.RefId
						INNER JOIN SMMasterConfigs MCF WITH (NOLOCK) ON MCF.Id = CFG.MasterConfigId
				WHERE	AliasName IN (SELECT ArrayName FROM @tblInputNames)
AND MCF.Id = 164
AND CFG.AssocType	= 3
						AND CFG.ValueStr	= N''
		END
	END
	ELSE
	BEGIN
		-- Unpatched engines will come here as well as all snap engines
		-- When engine does the lookup using only one interface, below code will be executed
		IF @arrayCnt = 1
		BEGIN
			SELECT	@arrayId = RefId FROM SMHostAlias WITH(NOLOCK) WHERE AliasName IN (SELECT ArrayName FROM @tblInputNames)
			--Check if the array is associated to a region. If yes, then validate if the array and proxy beling to the same region or not. If yes, return the array. If not, error out.
			IF @isNetApp = 1 AND @isMultiTenantSite = 1 AND @x_reqClientId > 0
			BEGIN
				SELECT @arrayRegionId = CONVERT(INT, CONVERT(NVARCHAR(MAX), APPADV.value)) FROM APP_AdvanceSettings APPADV WITH (NOLOCK)
WHERE APPADV.entityId = @arrayId AND APPADV.enabled = 1 AND APPADV.keyName = 'Region Id' AND APPADV.deleted = 0 AND CONVERT(INT, CONVERT(NVARCHAR(MAX), APPADV.value)) > 0 AND APPADV.entityType = 153 /*ARRAY_ENTITY*/
				IF @arrayRegionId > 0
				BEGIN
					SELECT @proxyRegionId = CONVERT(INT, CONVERT(NVARCHAR(MAX), APPADV.value)) FROM APP_AdvanceSettings APPADV WITH (NOLOCK)
WHERE APPADV.entityId = @x_reqClientId AND APPADV.enabled = 1 AND APPADV.keyName = 'Region Id' AND APPADV.deleted = 0 AND CONVERT(INT, CONVERT(NVARCHAR(MAX), APPADV.value)) > 0 AND APPADV.entityType = 3 /*CLIENT_ENTITY*/
					IF @arrayRegionId <> @proxyRegionId
					BEGIN
						SELECT @proxyClientName = name FROM APP_Client (READUNCOMMITTED) WHERE id = @x_reqClientId
						IF @proxyRegionId = 0
						BEGIN
SET @o_ErrorCode = 60374  /*60374*/
							SET @o_ErrorStr = 'The data access node ['+@proxyClientName+'] is not associated to any region. Please associate the data access node to a region and try again.'
						END
						ELSE
						BEGIN
							SELECT @arrayRegionName = name FROM APP_Region (READUNCOMMITTED) WHERE id = @arrayRegionId
							SELECT @proxyRegionName = name FROM APP_Region (READUNCOMMITTED) WHERE id = @proxyRegionId
							SELECT @arrayName = SMArrayId FROM SMControlHost (READUNCOMMITTED) where ControlHostId = @arrayId
SET @o_ErrorCode = 60375 /*60375*/
							SET @o_ErrorStr = 'The array [' +@arrayName+'] is associated to region ['+@arrayRegionName+'] and data access node [' +@proxyClientName+ '] is associated to a different region [' +@proxyRegionName+ ']. Please ensure that both array and access node belong to the same region and try again'
						END
						SELECT  0, 0, '', '', 0, @o_ErrorCode,@o_ErrorStr, 0, 0
						RETURN
					END
				END
			END
		END
		ELSE IF @arrayCnt > 1
		BEGIN
			-- If non-NetApp, then error out.
			IF @isNetApp = 0
			BEGIN
SELECT  0, 0, '', '', 0, 60254 /*E_MM_SM_SB_GET_CONTROL_HOST_INFO_FAILED*/, N'More than one array entry found.', 0, 0
				 RETURN
			END
			ELSE
			BEGIN
		-- Patched engines will be sending the request in the new format
		IF @arrayNumInReq > 0
		BEGIN
			IF NOT EXISTS (SELECT 1 FROM SMControlHost (NOLOCK) WHERE ControlHostId = @arrayNumInReq)
			BEGIN
SELECT	0, 0, '', '', 0, 60254 /*E_MM_SM_SB_GET_CONTROL_HOST_INFO_FAILED*/, N'Input ControlHostId does not exist in the SMControlHost table.', 0, 0
				RETURN
			END
			SET	@o_ControlHostId = @arrayNumInReq
			SET @arrayId = @arrayNumInReq
			SELECT	@arrayAliasesStr = COALESCE(@arrayAliasesStr + '|', '') + AliasName
			FROM	SMHostAlias WITH(NOLOCK)
			WHERE	RefId = @arrayId
			SET	@o_ArrayAlias = @arrayAliasesStr
			GOTO PROC_EXIT
		END
		/*This change is specific to MultiSite. Get the list of arrays that belong to the same region as that of the proxyMA*/
			IF @isMultiTenantSite = 1
			BEGIN
				IF @x_reqClientId > 0
				BEGIN
					--Get the region that is associated with the proxy
					SELECT @proxyRegionId = CONVERT(INT, CONVERT(NVARCHAR(MAX), APPADV.value)) FROM APP_AdvanceSettings APPADV WITH (NOLOCK)
WHERE APPADV.entityId = @x_reqClientId AND APPADV.enabled = 1 AND APPADV.keyName = 'Region Id' AND APPADV.deleted = 0 AND CONVERT(INT, CONVERT(NVARCHAR(MAX), APPADV.value)) > 0 AND APPADV.entityType = 3 /*CLIENT_ENTITY*/
					IF @proxyRegionId <= 0
					BEGIN
						SELECT @proxyClientName = name FROM APP_Client (READUNCOMMITTED) WHERE id = @x_reqClientId
						SET @o_ErrorStr = 'The data access node ['+@proxyClientName+'] is not associated to any region. Please associate the data access node to a region and try again.'
SELECT	0, 0, '', '', 0, 60374 /*60374*/, @o_ErrorStr, 0, 0
						RETURN
					END
					ELSE
					BEGIN
						DECLARE @ctrlHostIds TABLE (controlHostId int)
						INSERT INTO @ctrlHostIds
						SELECT DISTINCT RefId
						FROM SMHostAlias (NOLOCK) ALIAS INNER JOIN SMControlHost (NOLOCK) CHOST ON ALIAS.RefId = CHOST.ControlHostId
						INNER JOIN	APP_AdvanceSettings (NOLOCK) APPADV ON CHOST.ControlHostId = APPADV.entityId
WHERE ALIAS.AliasName IN (SELECT ArrayName FROM @tblInputNames) AND CONVERT(INT, CONVERT(NVARCHAR(MAX), APPADV.value))  = @proxyRegionId AND APPADV.enabled = 1 AND APPADV.keyName = 'Region Id' AND APPADV.deleted = 0
						SELECT @arrayCnt = COUNT(controlHostId) FROM @ctrlHostIds
						IF @arrayCnt = 0
						BEGIN
SELECT	0, 0, '', '', 0, 60376, N'More than one array has been identified and no array is in the same region as that of the data access node. Please verify the configuration.', 0, 0
							RETURN
						END
						ELSE IF @arrayCnt > 1
						BEGIN
SELECT	0, 0, '', '', 0, 60377, N'More than one array has been identified that is associated to the same REGION as that of the data access node. Please verify the configuration.', 0, 0
							RETURN
						END
						ELSE
						BEGIN
							SET @doNotUpdateArrayAliases = 1
							SELECT @arrayId = controlhostId FROM @ctrlHostIds
						END
					END
				END
				ELSE
				BEGIN
SELECT	0, 0, '', '', 0, 60254, N'The proxy MA Id used to get the array details is not valid/empty', 0, 0
					RETURN
				END
			END
		END
	END
END
	IF @arrayId > 0
	BEGIN
		SET	@o_ControlHostId = @arrayId
		SELECT	@arrayAliasesStr = COALESCE(@arrayAliasesStr + '|', '') + AliasName
		FROM	SMHostAlias WITH(NOLOCK)
		WHERE	RefId = @arrayId
		SET	@o_ArrayAlias = @arrayAliasesStr
		GOTO PROC_EXIT
	END
	-- Check whether the given Array Name is found in SMControlHost or not
	SET		@arrayId = 0
	SET		@arrayAliasesStr = N''
	IF @x_baseArrayName <> N''
		BEGIN
			SELECT	@arrayId = ControlHostId
			FROM	SMControlHost SCH WITH(NOLOCK) INNER JOIN SMConfigs CFG WITH (NOLOCK) ON CFG.ArrayId = SCH.ControlHostId
					INNER JOIN SMMasterConfigs MCF WITH (NOLOCK) ON CFG.MasterConfigId = MCF.Id
			WHERE	SCH.SMArrayId IN (SELECT ArrayName FROM @tblInputNames)
AND MCF.Id = 164
AND CFG.AssocType	= 3
					AND CFG.ValueStr	= @x_baseArrayName
		END
	ELSE
		SELECT	@arrayId = ControlHostId FROM SMControlHost WITH (NOLOCK) WHERE SMArrayId IN (SELECT ArrayName From @tblInputNames)
	IF @arrayId > 0
	BEGIN
		SET	@o_ControlHostId = @arrayId
		GOTO PROC_EXIT
	END
PROC_EXIT:
	--If MultiSite is on and the data access node used is not compatible to run MultiSite related operations, then return failure
	IF @arrayId > 0 AND @isNetApp = 1 AND @isMultiTenantSite = 1 AND @x_reqClientId > 0
	BEGIN
		IF OBJECT_ID('tempdb..#AppCheckIfClientMultiSiteEnabledResultTable') IS NOT NULL DROP TABLE #AppCheckIfClientMultiSiteEnabledResultTable
		CREATE TABLE #AppCheckIfClientMultiSiteEnabledResultTable(oIsMSEnabled INT)
		EXEC AppCheckIfClientMultiSiteEnabled @x_reqClientId
		SELECT @isClientMSiteSEnabled = oIsMSEnabled
		FROM	#AppCheckIfClientMultiSiteEnabledResultTable
		IF @isClientMSiteSEnabled = 0
		BEGIN
			SELECT @proxyClientName = name FROM APP_Client (READUNCOMMITTED) WHERE id = @x_reqClientId
			SELECT	0, 0, '', '', 0, 60378 /*E_MM_SM_SP_ACCESS_NODE_NOT_MULTISITE_ENABLED*/, N'The data access node ['+@proxyClientName+'] used to get array information does not meet the requirements to run Multisite related operations', 0, 0
			RETURN
		END
	END
	DECLARE @HostAliasMasterCfgId INTEGER = 0
	DECLARE @HostAliasAutoUpdateMasterCfgId INTEGER = 0
	DECLARE @HostAliasAutoUpdateCfgValue INT = 1
DECLARE @MMSM_AT_ARRAY_LEVEL		INTEGER = 3/*MMSM_AT_ARRAY*/
	DECLARE @currTime INTEGER = dbo.GetUnixTime(GetUTCDate())
	SELECT @HostAliasAutoUpdateMasterCfgId = MCONFIG.Id FROM SMMasterConfigs MCONFIG (NOLOCK) INNER JOIN SMConfigs CFG (NOLOCK) ON CFG.MasterConfigId = MCONFIG.Id
	WHERE MCONFIG.KeyName = @SMCONFIG_NAME_AUTO_UPDATE_ARRAY_HOST_ALIASES_KEY AND CFG.Arrayid = @arrayId
	SELECT @HostAliasMasterCfgId = MCONFIG.Id FROM SMMasterConfigs MCONFIG (NOLOCK)
												INNER JOIN SMVendor VEN (NOLOCK) ON VEN.Id = MCONFIG.VendorId
												INNER JOIN SMControlHost CTRL (NOLOCK) ON CTRL.SnapVendorName = VEN.Name
						WHERE MCONFIG.KeyName = @SMCONFIG_NAME_ARRAY_HOST_ALIASES_KEY AND CTRL.ControlHostId = @arrayId
	SET @HostAliasAutoUpdateCfgValue = ISNULL ( (SELECT ValueInt FROM SMConfigs (NOLOCK) WHERE MasterConfigId = @HostAliasAutoUpdateMasterCfgId AND ArrayId = @arrayId ), 1)
	BEGIN TRY
	BEGIN TRANSACTION GetArrayInfoTran
		-- Update SMHostAlias table
		IF @arrayId > 0
		BEGIN
				IF @HostAliasAutoUpdateCfgValue = 1 AND @doNotUpdateArrayAliases = 0
				BEGIN
					INSERT	INTO SMHostAlias
SELECT	5, @arrayId, 0, 0, AN.ArrayName, GETUTCDate(), 0, NEWID(), 0, 0, 0, 0, N''
					FROM	(SELECT DISTINCT ArrayName FROM @tblInputNames) AN
					LEFT OUTER JOIN SMHostAlias HA WITH(NOLOCK) ON AN.ArrayName = HA.AliasName WHERE HA.AliasName IS NULL
				END
				IF @HostAliasAutoUpdateCfgValue = 1 AND @HostAliasMasterCfgId > 0 AND @doNotUpdateArrayAliases = 0
				BEGIN
					INSERT	INTO SMConfigsList
					SELECT	@HostAliasMasterCfgId, @arrayId, @arrayId, @MMSM_AT_ARRAY_LEVEL,
							0, 1, 1, 0,
							0, 0, H_ALIAS.AliasName,
							@currTime, 0, 2, newid(), 1, H_ALIAS.Id
					FROM	SMHostAlias (NOLOCK) H_ALIAS
					LEFT OUTER JOIN SMConfigsList (NOLOCK) CFG ON H_ALIAS.Id = CFG.RefId
WHERE   H_ALIAS.RefType = 5
							AND H_ALIAS.RefId = @arrayId
							AND CFG.ValueStr IS NULL
							AND H_ALIAS.AliasName NOT IN (SELECT SMArrayId FROM SMControlHost (NOLOCK) WHERE ControlHostId = @arrayId)
				END
		END
		-- For NetApp vServer, return the vServer name from Client Properties
		DECLARE	@arrayClientId INTEGER = 0
		SELECT	@arrayClientId = ClientId FROM SMControlHost WITH(NOLOCK)
		WHERE	ControlHostId = @arrayId
				AND SnapVendorName = @C_SM_SNAPSHOT_ENGINE_NETAPP_VENDORNAME
AND (SMHostFlags & 8 = 8 OR
SMHostFlags & 32 = 32 )
		IF @arrayClientId > 0
		BEGIN
			IF @HostAliasAutoUpdateCfgValue = 1  AND @doNotUpdateArrayAliases = 0
			BEGIN
					INSERT INTO SMEndPoint
					SELECT @arrayClientId, 0, 0, 0, 0, 0, 0, I_ALIAS.protocol, I_ALIAS.ArrayName,
					GETUTCDATE(), GETUTCDATE(), 0, N'', 0, NEWID(), 0, 0, 0, 0, N''
					FROM (SELECT DISTINCT protocol, ArrayName FROM @tblInputNames WHERE protocol > 0) I_ALIAS
					LEFT OUTER JOIN SMEndPoint EP WITH(NOLOCK) ON I_ALIAS.ArrayName = EP.Address
					WHERE EP.Address IS NULL
			END
			SELECT	@o_ArrayName = attrVal FROM APP_ClientProp WITH(NOLOCK)
			WHERE	componentNameId = @arrayClientId
					AND attrName = @C_CV_PROP_NAS_VSERVER_NAME
					AND modified = 0
			SELECT	@o_ControlHostId, @o_MetaDataId, @o_ArrayAlias, @o_ArrayName, 0, 0, '', 0, 0
		END
		ELSE
			SELECT	@o_ControlHostId, @o_MetaDataId, @o_ArrayAlias, '', 0, 0, '', 0, 0
		COMMIT TRANSACTION GetArrayInfoTran
		RETURN
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		ROLLBACK TRANSACTION GetArrayInfoTran
		GOTO ERROR_EXIT
	END CATCH
ERROR_EXIT:
SELECT	0, 0, '', '', 0, 60254 /*E_MM_SM_SB_GET_CONTROL_HOST_INFO_FAILED*/, N'Failed to update host aliases in database for name[' + @x_arrayName + N']', 0, 0
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetArrayInfo')
	delete from GxQscripts where name = 'MM_SMGetArrayInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetArrayInfo')
	delete from GXDBVersions where aliasname = 'MM_SMGetArrayInfo'
GO

insert into GXDBVersions values(2, 'MM_SMGetArrayInfo',  '00010009001200150000', 'MM_SMGetArrayInfo', '00010009001200150000')
GO

