

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetArrayControllersList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetArrayControllersList <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetArrayControllersList')
	drop procedure MM_SMGetArrayControllersList
IF EXISTS (select * from GxQscripts where name='MM_SMGetArrayControllersList')
	delete from GxQscripts where name = 'MM_SMGetArrayControllersList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetArrayControllersList')
	delete from GXDBVersions where aliasname = 'MM_SMGetArrayControllersList'
GO
print '... Creating Procedure: MM_SMGetArrayControllersList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetArrayControllersList
  @i_xmlText XML,
  @i_role INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_ArrayControllerId INT
  DECLARE @o_ControlHostId INT
  DECLARE @o_ClientId INT
  DECLARE @o_AssocId INT
  DECLARE @o_AssocType INT
  DECLARE @o_Options INT
  DECLARE @o_Flag INT
  DECLARE @o_ErrorCode INT
  DECLARE @o_ErrorMsg VARCHAR(1024)
SET NOCOUNT ON
/*
SP Input
<MM_SMGetArrayControllersList>
	<controlHostId>72</controlHostId>
	<controlHostId>74</controlHostId>
	<controlHostId>82</controlHostId>
	<controlHostId>59</controlHostId>
</MM_SMGetArrayControllersList>
*/
BEGIN
	SET @o_ErrorCode = 0
	SET @o_ErrorMsg = ''
	DECLARE @tbl_Input TABLE (
		ControlHostId		INT
	)
	INSERT INTO @tbl_Input
	SELECT	R.ref.value('.','int') controlHostId
	FROM	@i_xmlText.nodes('/MM_SMGetArrayControllersList/controlHostId') R(ref)
	IF  (SELECT COUNT(*) FROM SMControlHost (NOLOCK) WHERE ControlHostId in (SELECT ControlHostId FROM @tbl_Input) ) <> ( SELECT COUNT(*) FROM @tbl_Input )
	BEGIN
SET @o_ErrorCode = 60295
		GOTO ERR_EXIT
	END
	SELECT	AC.*, @o_ErrorCode, @o_ErrorMsg
	FROM	@tbl_Input INP INNER JOIN SMArrayController AC (NOLOCK) ON INP.ControlHostId = AC.ArrayNum
			INNER JOIN MMHost HOST (NOLOCK) ON AC.MMHostId = HOST.ClientId AND HOST.MmHostSoftState = 1
				AND HOST.MmHostEnabled = 1 AND HOST.OfflineReason = 0
	WHERE	AC.Options & @i_role > 0
	IF @@ROWCOUNT = 0
	BEGIN
SET @o_ErrorCode = 60915
		GOTO ERR_EXIT
	END
	RETURN
END
ERR_EXIT:
	SELECT 0, 0, 0, 0, 0, 0, 0, @o_ErrorCode, @o_ErrorMsg
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetArrayControllersList')
	delete from GxQscripts where name = 'MM_SMGetArrayControllersList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetArrayControllersList')
	delete from GXDBVersions where aliasname = 'MM_SMGetArrayControllersList'
GO

insert into GXDBVersions values(2, 'MM_SMGetArrayControllersList',  '00000000000000000000', 'MM_SMGetArrayControllersList', '00000000000000000000')
GO

