

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetArrayControllers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetArrayControllers.sp,v $ $Id: MM_SMGetArrayControllers.sp,v 1.3.12.3 2018/08/26 16:58:32 vimalkumar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetArrayControllers <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetArrayControllers')
	drop procedure MM_SMGetArrayControllers
IF EXISTS (select * from GxQscripts where name='MM_SMGetArrayControllers')
	delete from GxQscripts where name = 'MM_SMGetArrayControllers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetArrayControllers')
	delete from GXDBVersions where aliasname = 'MM_SMGetArrayControllers'
GO
print '... Creating Procedure: MM_SMGetArrayControllers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetArrayControllers
  @i_ctrlHostId INTEGER,
  @i_assocType INTEGER,
  @i_assocId INTEGER,
  @i_flags INTEGER,
  @i_role INTEGER,
  @i_reserveInt INTEGER,
  @i_reserveStr VARCHAR(1024)
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_ArrayControllerId INT
  DECLARE @o_ControlHostId INT
  DECLARE @o_ClientId INT
  DECLARE @o_AssocId INT
  DECLARE @o_AssocType INT
  DECLARE @o_Options INT
  DECLARE @o_Flag INT
  DECLARE @o_ClientName NVARCHAR(256)
  DECLARE @o_ErrorCode INT
  DECLARE @o_ErrorMsg VARCHAR(1024)
SET NOCOUNT ON
BEGIN
	SET @o_ErrorCode = 0
	SET @o_ErrorMsg = ''
	SET @o_ClientName = ''
	IF NOT EXISTS (SELECT * FROM SMControlHost (NOLOCK) WHERE ControlHostId = @i_ctrlHostId)
	BEGIN
SET @o_ErrorCode = 60295
		GOTO ERR_EXIT
	END
	SELECT	AC.*, C.name as ClientName, @o_ErrorCode, @o_ErrorMsg
	FROM	SMArrayController AC (NOLOCK)
			INNER JOIN MMHost HOST (NOLOCK) ON AC.MMHostId = HOST.ClientId AND HOST.MmHostSoftState = 1
				AND HOST.MmHostEnabled = 1 AND HOST.OfflineReason = 0
			JOIN App_Client C WITH (NOLOCK) ON C.id = AC.MMHostId
	WHERE	AC.ArrayNum = @i_ctrlHostId
	IF @@ROWCOUNT = 0
	BEGIN
SET @o_ErrorCode = 60915
		IF NOT EXISTS (SELECT * FROM SMArrayController (NOLOCK) WHERE ArrayNum = @i_ctrlHostId)
			SET @o_ErrorMsg = 'There are no controllers configured for the array. Please set the array controller(s).'
		ELSE
			SET @o_ErrorMsg = 'Please ensure that the array controllers are enabled and online.'
		GOTO ERR_EXIT
END
ERR_EXIT:
	SELECT 0, 0, 0, 0, 0, 0, 0, @o_ClientName, @o_ErrorCode, @o_ErrorMsg
END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetArrayControllers')
	delete from GxQscripts where name = 'MM_SMGetArrayControllers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetArrayControllers')
	delete from GXDBVersions where aliasname = 'MM_SMGetArrayControllers'
GO

insert into GXDBVersions values(2, 'MM_SMGetArrayControllers',  '00010003001200030000', 'MM_SMGetArrayControllers', '00010003001200030000')
GO

