

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetAgedDataSetsAndMembersByMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetAgedDataSetsAndMembersByMA.sp,v $ $Id: MM_SMGetAgedDataSetsAndMembersByMA.sp,v 1.1.2.7 2018/03/20 00:12:12 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMGetAgedDataSetsAndMembersByMA <<<'

IF EXISTS (select * from sysobjects where name='MM_SMGetAgedDataSetsAndMembersByMA')
	drop procedure MM_SMGetAgedDataSetsAndMembersByMA
IF EXISTS (select * from GxQscripts where name='MM_SMGetAgedDataSetsAndMembersByMA')
	delete from GxQscripts where name = 'MM_SMGetAgedDataSetsAndMembersByMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetAgedDataSetsAndMembersByMA')
	delete from GXDBVersions where aliasname = 'MM_SMGetAgedDataSetsAndMembersByMA'
GO
print '... Creating Procedure: MM_SMGetAgedDataSetsAndMembersByMA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetAgedDataSetsAndMembersByMA
  @i_reserveInt INTEGER,
  @i_reserveStr VARCHAR(255)
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_ControlHostId INT;
  DECLARE @o_SMRelationId INT;
  DECLARE @o_DataSetId INT;
  DECLARE @o_DataSetMemberId INT;
  DECLARE @o_OpType INT;
  DECLARE @o_Flags INT;
  DECLARE @o_MAClientId INT;
  DECLARE @o_ErrCode INT;
  DECLARE @o_ErrMsg VARCHAR(255);
SET NOCOUNT ON
BEGIN
	DECLARE @tblDSMembers TABLE
		(
			ControlHostId			int,
			SMRelationId			int,
			DataSetId				int,
			DataSetMemberId			int,
			OpType					int,
			Flags					int,
			MAClientId				int
		)
	DECLARE @errCode	INT = 0
	DECLARE @errMsg		VARCHAR(255) = ''
	INSERT  INTO @tblDSMembers
	SELECT	ControlHostId, SMRelationId, DataSetId, 0, 1, 0, 0
	FROM	SMDataSet DS (NOLOCK)
WHERE	DS.Flags & 256 = 256 /*SM_FLAGS_AGED_DB*/
AND DS.Flags & 512 <> 512
			AND NOT EXISTS (SELECT * FROM SMDataSetMember DSM (NOLOCK) WHERE DS.DataSetId = DSM.DataSetId
AND DSM.Flags & 1 = 1)
	SET @errCode = @@ERROR
	IF @errCode > 0
	BEGIN
		SET @errMsg = 'Failed to get aged DFM DataSets.'
		GOTO ERR_EXIT
	END
	INSERT	INTO @tblDSMembers
	SELECT	DS.ControlHostId, DS.SMRelationId, DS.DataSetId, DSM.DataSetMemberId, 2, 0, 0
	FROM	SMDataSet DS (NOLOCK)
			INNER JOIN SMDataSetMember DSM(NOLOCK) ON DS.DataSetID = DSM.DataSetId
WHERE	DSM.Flags & 256 = 256 /*SM_FLAGS_AGED_DB*/
AND DS.Flags & 512 <> 512 /*SM_FLAGS_NOSB_PRIMARY_DS*/
AND DSM.Flags & 1 = 1  /*SM_FLAGS_PRIMARY_DB*/
			AND DS.DataSetId NOT IN (SELECT DataSetId FROM @tblDSMembers)
			AND NOT EXISTS (SELECT * FROM SMDataSetMember DSM2 (NOLOCK) WHERE DSM.ExtDataSetMemberId = DSM2.ExtDataSetMemberId
AND DSM.DataSetId = DSM2.DataSetId AND DSM2.Flags & 1 = 1
AND DSM2.Flags & 256 <> 256)
	SET @errCode = @@ERROR
	IF @errCode > 0
	BEGIN
		SET @errMsg = 'Failed to get aged DFM DataSet Members.'
		GOTO ERR_EXIT
	END
	DELETE	TMP
	FROM	@tblDSMembers TMP
			INNER JOIN SMControlHost CTRL(NOLOCK) ON TMP.ControlHostId = CTRL.ControlHostId
WHERE	(CTRL.Flags & 2) = 2
	DECLARE @tblArrayMA TABLE (ClientId INT, ReleaseId INT, SPMajor INT, useForPruning INT)
	INSERT INTO @tblArrayMA
	SELECT DISTINCT AC.MMHostId, 0, 0, 0
	FROM @tblDSMembers TMP
		INNER JOIN SMArrayController AC (NOLOCK) ON AC.ArrayNum = TMP.ControlHostID
	;WITH ClientSPLevel AS (
			SELECT
				TMP.ClientId AS ClientId,
				CLIENT.ReleaseId AS ReleaseId,
				PKG.HighestSP AS SPMajor,
				PKG.SpMinorVersion AS SPMinor,
				ROW_NUMBER() OVER (PARTITION BY TMP.ClientId
				ORDER BY TMP.ClientId, CLIENT.ReleaseId, PKG.HighestSP, PKG.SpMinorVersion) AS RowNum
			FROM
				@tblArrayMA TMP
				LEFT OUTER JOIN APP_VMToPMMap MAP (NOLOCK) ON MAP.VMClientId = TMP.ClientId
				INNER JOIN SimInstalledPackages PKG (NOLOCK) ON PKG.ClientId = ISNULL(MAP.PMClientId, TMP.ClientId)
				INNER JOIN APP_Client CLIENT (NOLOCK) ON CLIENT.id = ISNULL(MAP.PMClientId, TMP.ClientId)
			WHERE
PKG.simPackageID in (51 /*N_WIN_PACKAGE_MEDIAAGENT*/, 1301 /*N_UNIX_PACKAGES_MEDIA_AGENT*/))
	UPDATE  @tblArrayMA
	SET     ReleaseId = SPL.ReleaseId,
			SPMajor = SPL.SPMajor
	FROM    @tblArrayMA TMP, ClientSPLevel SPL
	WHERE   SPL.RowNum = 1
			AND TMP.ClientId = SPL.ClientId
	UPDATE	@tblArrayMA
	SET		useForPruning = 1
WHERE	ReleaseId =  16 /*SIM_ID_GX_REL110*/
			AND SPMajor >= 5
	-- Update MAClientId
	UPDATE	TMP
	SET		TMP.MAClientId = MA.ClientId
	FROM	@tblDSMembers TMP
			INNER JOIN SMArrayController AC (NOLOCK) ON AC.ArrayNum = TMP.ControlHostID
			INNER JOIN @tblArrayMA MA ON MA.ClientId = AC.MMHostId AND MA.useForPruning = 1
			INNER JOIN MMHost HOST (NOLOCK)
				ON MA.ClientId = HOST.ClientId AND HOST.MmHostEnabled = 1 AND HOST.MmHostSoftState = 1 AND HOST.OfflineReason = 0
	/*
	-- Update MAClientId
	-- Pick V11 array controller that has SP5 or higher installed
	UPDATE	TMP
	SET		TMP.MAClientId = AC.MMHostId
	FROM	@tblDSMembers TMP
			INNER JOIN SMArrayController AC (NOLOCK) ON AC.ArrayNum = TMP.ControlHostID
			INNER JOIN MMHost HOST (NOLOCK)
			ON AC.MMHostId = HOST.ClientId AND HOST.MmHostEnabled = 1 AND HOST.MmHostSoftState = 1 AND HOST.OfflineReason = 0
			INNER JOIN APP_Client CLNT (NOLOCK)
ON CLNT.id = HOST.ClientId AND CLNT.releaseId = 16 /*SIM_ID_GX_REL110*/
			INNER JOIN simInstalledPackages PCKG (NOLOCK)
				ON CLNT.id = PCKG.ClientId
AND PCKG.simPackageID IN (51 /*N_WIN_PACKAGE_MEDIAAGENT*/, 1301 /*N_UNIX_PACKAGES_MEDIA_AGENT*/)
					AND PCKG.HighestSP >= 5
	*/
	DELETE
	FROM	@tblDSMembers
	WHERE	MAClientId = 0
	SELECT	*,  @errCode, @errMsg
	FROM	@tblDSMembers
	ORDER	BY MAClientId, ControlHostId DESC, DatasetId ASC
	RETURN
ERR_EXIT:
	SELECT	0, 0, 0, 0, 0, 0, 0, @errCode, @errMsg
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetAgedDataSetsAndMembersByMA')
	delete from GxQscripts where name = 'MM_SMGetAgedDataSetsAndMembersByMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetAgedDataSetsAndMembersByMA')
	delete from GXDBVersions where aliasname = 'MM_SMGetAgedDataSetsAndMembersByMA'
GO

insert into GXDBVersions values(2, 'MM_SMGetAgedDataSetsAndMembersByMA',  '00010001000200070000', 'MM_SMGetAgedDataSetsAndMembersByMA', '00010001000200070000')
GO

