

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMGetAgedDFMDataSetsAndMembers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMGetAgedDFMDataSetsAndMembers.sp,v $ $Id: MM_SMGetAgedDFMDataSetsAndMembers.sp,v 1.8.2.6 2018/12/22 12:11:30 mtayal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMGetAgedDFMDataSetsAndMembers')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMGetAgedDFMDataSetsAndMembers <<<'
	drop procedure MM_SMGetAgedDFMDataSetsAndMembers
END
IF EXISTS (select * from GxQscripts where name='MM_SMGetAgedDFMDataSetsAndMembers')
	delete from GxQscripts where name = 'MM_SMGetAgedDFMDataSetsAndMembers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetAgedDFMDataSetsAndMembers')
	delete from GXDBVersions where aliasname = 'MM_SMGetAgedDFMDataSetsAndMembers'
GO
print '... Creating Procedure: MM_SMGetAgedDFMDataSetsAndMembers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMGetAgedDFMDataSetsAndMembers
  @i_reserveInt INTEGER,
  @i_reserveStr VARCHAR(255)
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_DataSetId INT;
  DECLARE @o_DataSetMemberId INT;
  DECLARE @o_ControlHostId INT;
  DECLARE @o_SMArrayId NVARCHAR(255);
  DECLARE @o_SMHostUserName NVARCHAR(255);
  DECLARE @o_SMHostPassword NVARCHAR(255);
  DECLARE @o_ExtDataSetId NVARCHAR(512);
  DECLARE @o_ExtDataSetName NVARCHAR(255);
  DECLARE @o_ExtDataSetMemberId NVARCHAR(512);
  DECLARE @o_ExtDataSetMemberName NVARCHAR(255);
  DECLARE @o_Flags INT;
  DECLARE @o_UseTunneling INT;
  DECLARE @o_VolumeName NVARCHAR(255);
  DECLARE @o_vServerName NVARCHAR(255);
  DECLARE @o_errCode INT;
  DECLARE @o_errMsg VARCHAR(255);
SET NOCOUNT ON
BEGIN
	DECLARE @tblDSMembers TABLE
		(
			DataSetId				int,
			DataSetMemberId			int,
			ControlHostId			int,
			ExtDataSetId			NVARCHAR(512),
			ExtDataSetName			NVARCHAR(255),
			ExtDataSetMemberId		NVARCHAR(512),
			ExtDataSetMemberName	NVARCHAR(255),
			Flags					int
		)
	DECLARE @tblResult TABLE
		(
			DataSetId INT,
			DataSetMemberId INT,
			ControlHostId INT,
			SMArrayId NVARCHAR(255),
			SMHostUserName NVARCHAR(255),
			SMHostPassword NVARCHAR(255),
			ExtDataSetId NVARCHAR(512),
			ExtDataSetName NVARCHAR(255),
			ExtDataSetMemberId NVARCHAR(512),
			ExtDataSetMemberName NVARCHAR(255),
			Flags INT,
			UseTunneling INT,
			VolumeName NVARCHAR(255),
			vServerName NVARCHAR(255),
			credAssocId INT
		)
	DECLARE @errCode	INT = 0
	DECLARE @errMsg		VARCHAR(255) = ''
	DECLARE @CV_PROP_NAS_VSERVER_NAME NVARCHAR(1024) = N'NAS vServer Name'
	IF @i_reserveInt = 0
	BEGIN
		INSERT  INTO @tblDSMembers
		SELECT	DataSetId, 0, ControlHostId, ExtDataSetId, ExtDataSetName, N'', N'', 1
		FROM	SMDataSet DS (NOLOCK)
WHERE	DS.Flags & 256 = 256 /*SM_FLAGS_AGED_DB*/
AND DS.Flags & 512 <> 512
				AND NOT EXISTS (SELECT * FROM SMDataSetMember DSM (NOLOCK) WHERE DS.DataSetId = DSM.DataSetId
AND DSM.Flags & 1 = 1)
		SET @errCode = @@ERROR
		IF @errCode > 0
		BEGIN
			SET @errMsg = 'Failed to get aged DFM DataSets.'
			GOTO ERR_EXIT
		END
		INSERT	INTO @tblDSMembers
		SELECT	DS.DataSetId, DSM.DataSetMemberId, DS.ControlHostId, DS.ExtDataSetId,
				DS.ExtDataSetName, DSM.ExtDataSetMemberId, DSM.ExtDataSetMemberName, 2
		FROM	SMDataSet DS (NOLOCK)
				INNER JOIN SMDataSetMember DSM(NOLOCK) ON DS.DataSetID = DSM.DataSetId
WHERE	DSM.Flags & 256 = 256 /*SM_FLAGS_AGED_DB*/
AND DS.Flags & 512 <> 512 /*SM_FLAGS_NOSB_PRIMARY_DS*/
AND DSM.Flags & 1 = 1  /*SM_FLAGS_PRIMARY_DB*/
				AND DS.DataSetId NOT IN (SELECT DataSetId FROM @tblDSMembers)
				AND NOT EXISTS (SELECT * FROM SMDataSetMember DSM2 (NOLOCK) WHERE DSM.ExtDataSetMemberId = DSM2.ExtDataSetMemberId
AND DSM.DataSetId = DSM2.DataSetId AND DSM2.Flags & 1 = 1
AND DSM2.Flags & 256 <> 256)
		SET @errCode = @@ERROR
		IF @errCode > 0
		BEGIN
			SET @errMsg = 'Failed to get aged DFM DataSet Members.'
			GOTO ERR_EXIT
		END
		-- Dummy row to group dataset members for removal
		IF EXISTS (SELECT * FROM @tblDSMembers)
		BEGIN
			INSERT	INTO @tblDSMembers
			SELECT	0, 0, 0, '', '', '', '', 0
		END
		INSERT	INTO @tblResult
		SELECT	DataSetId, DataSetMemberId, DS.ControlHostId,
				HOST.SMArrayId, HOST.SMHostUserName, HOST.SMHostPassword,
					ExtDataSetId, ExtDataSetName, ExtDataSetMemberId, ExtDataSetMemberName, DS.Flags, 0, '', '', HOST.CredentialId
		FROM	@tblDSMembers DS
				INNER JOIN SMControlHost HOST (NOLOCK) ON HOST.ControlHostId = DS.ControlHostId
	END
	IF @i_reserveInt = 1 -- NOSB
	BEGIN
		INSERT	INTO @tblDSMembers
		SELECT	DS.DataSetId, DSM.DataSetMemberId,
				REL.vFilerId,
				DS.ExtDataSetId, DS.ExtDataSetName, DSM.ExtDataSetMemberId, DSM.ExtDataSetMemberName, 512
		FROM	SMDataSet DS (NOLOCK)
				INNER JOIN SMDataSetMember DSM(NOLOCK) ON DS.DataSetID = DSM.DataSetId
				INNER JOIN SMRelationNode REL (NOLOCK) ON DS.SMRelationId = REL.SMRelationId
WHERE	DSM.Flags & 256 = 256 /*SM_FLAGS_AGED_DB*/
AND DS.Flags & 512 = 512 /*SM_FLAGS_NOSB_PRIMARY_DS*/
AND DSM.Flags & 1 = 1  /*SM_FLAGS_PRIMARY_DB*/
		SET @errCode = @@ERROR
		IF @errCode > 0
		BEGIN
			SET @errMsg = 'Failed to get aged NOSB DataSet Members.'
			GOTO ERR_EXIT
		END
		INSERT	INTO @tblResult
		SELECT	DataSetId, DataSetMemberId, DS.ControlHostId,
				HOST.SMArrayId, HOST.SMHostUserName, HOST.SMHostPassword,
				ExtDataSetId, ExtDataSetName, ExtDataSetMemberId, ExtDataSetMemberName, DS.Flags, CFG.ValueInt, '', '', HOST.CredentialId
		FROM	@tblDSMembers DS
				INNER JOIN SMControlHost HOST (NOLOCK) ON HOST.ControlHostId = DS.ControlHostId
				INNER JOIN SMConfigs CFG (NOLOCK) ON HOST.ControlHostId = CFG.ArrayId AND CFG.AssocId = HOST.ControlHostId
				INNER JOIN SMMasterConfigs MCFG (NOLOCK) ON MCFG.KeyName = 'SMCONFIG_NAME_USE_TUNNELING' AND MCFG.VendorId = 3
					AND MCFg.ID = CFG.MasterConfigId
		UPDATE	TMP
		SET		TMP.SMArrayId = PHY_HOST.SMArrayId,
				TMP.SMHostUserName = PHY_HOST.SMHostUserName,
				TMP.SMHostPassword = PHY_HOST.SMHostPassword,
				TMP.credAssocId    = PHY_HOST.CredentialId
		FROM	@tblResult TMP
				INNER JOIN SMControlHost HOST(NOLOCK)
					ON HOST.ControlhostId = TMP.ControlHostId
				INNER JOIN APP_VMToPMMap MAP (NOLOCK) ON MAP.VMClientId = HOST.ClientId
				INNER JOIN SMControlHost PHY_HOST (NOLOCK) ON PHY_HOST.ClientId = MAP.PMClientId
		WHERE	TMP.UseTunneling = 1
		UPDATE	TMP
		SET		TMP.vServerName = PROP.attrVal
		FROM	@tblResult TMP
				INNER JOIN SMControlHost HOST(NOLOCK)
					ON HOST.ControlhostId = TMP.ControlHostId
				INNER JOIN APP_ClientProp PROP (NOLOCK) ON PROP.componentNameId = HOST.ClientId
					AND PROP.attrName = @CV_PROP_NAS_VSERVER_NAME
		WHERE	TMP.UseTunneling = 1
	END
	--update credentials if credentials are stored in credential manager
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#AssocToCMCredentials') IS NOT NULL DROP TABLE #AssocToCMCredentials
		CREATE TABLE #AssocToCMCredentials (
		assocId 			INTEGER,
		credentialId 		INTEGER,
		userName			nvarchar(MAX) default '',
		password			nvarchar(MAX) default '',
		credentialInfoXml   xml default '',
		flags				int default 0,
		recordType			int default 0
		)
		INSERT INTO #AssocToCMCredentials (assocId, credentialId)
			SELECT DISTINCT InArray.credAssocId, 0
			FROM @tblResult InArray
			WHERE InArray.credAssocId > 0
		exec AppGetAssocToCMCredentialsList
		UPDATE InArray
		SET	InArray.SMHostUserName = Creds.userName, InArray.SMHostPassword = Creds.password
		FROM @tblResult InArray
			INNER JOIN #AssocToCMCredentials Creds ON Creds.assocId = InArray.credAssocId
		IF OBJECT_ID('tempdb.dbo.#AssocToCMCredentials') IS NOT NULL DROP TABLE #AssocToCMCredentials
	END
	SELECT	DataSetId, DataSetMemberId, ControlHostId, SMArrayId, SMHostUserName, SMHostPassword, ExtDataSetId , ExtDataSetName, ExtDataSetMemberId, ExtDataSetMemberName , Flags, UseTunneling, VolumeName, vServerName, @errCode, @errMsg
	FROM	@tblResult
	ORDER	BY ControlHostId DESC, DatasetId ASC, Flags
	RETURN
ERR_EXIT:
	SELECT	0, 0, 0, '', '', '', '', '', '', '', 0, 0, '', '', @errCode, @errMsg
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMGetAgedDFMDataSetsAndMembers')
	delete from GxQscripts where name = 'MM_SMGetAgedDFMDataSetsAndMembers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMGetAgedDFMDataSetsAndMembers')
	delete from GXDBVersions where aliasname = 'MM_SMGetAgedDFMDataSetsAndMembers'
GO

insert into GXDBVersions values(2, 'MM_SMGetAgedDFMDataSetsAndMembers',  '00010008000200060000', 'MM_SMGetAgedDFMDataSetsAndMembers', '00010008000200060000')
GO

