

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMFetchSVMNameUsingArrayNum.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMFetchSVMNameUsingArrayNum')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMFetchSVMNameUsingArrayNum <<<'
	drop procedure MM_SMFetchSVMNameUsingArrayNum
END
IF EXISTS (select * from GxQscripts where name='MM_SMFetchSVMNameUsingArrayNum')
	delete from GxQscripts where name = 'MM_SMFetchSVMNameUsingArrayNum'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMFetchSVMNameUsingArrayNum')
	delete from GXDBVersions where aliasname = 'MM_SMFetchSVMNameUsingArrayNum'
GO
print '... Creating Procedure: MM_SMFetchSVMNameUsingArrayNum'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMFetchSVMNameUsingArrayNum
  @i_xmlTextInput XML
AS
  DECLARE @o_ArrayNum integer
  DECLARE @o_SVMName nvarchar(1024)
  DECLARE @o_SVMUUID nvarchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/*
	<MM_SMFetchSVMNameUsingArrayNum>
		<ArrayNum></ArrayNum>
	</MM_SMFetchSVMNameUsingArrayNum>
*/
DECLARE @tblArrayNums TABLE (ControlHostId int, SVMName nvarchar(1024), SVMUUID nvarchar(1024))
INSERT	INTO @tblArrayNums
SELECT R.ref.value('.', 'int'), '', ''
FROM @i_xmlTextInput.nodes('/MM_SMFetchSVMNameUsingArrayNum/ArrayNum') R(ref)
-- Fetch the SVM name from the Client properties
UPDATE	T
SET		T.SVMName = PROP.attrVal
FROM	@tblArrayNums T
		INNER JOIN SMControlHost CTRL (NOLOCK) ON T.ControlHostId = CTRL.ControlHostId
		INNER JOIN APP_ClientProp PROP (NOLOCK) ON PROP.componentNameId = CTRL.ClientId
WHERE	CTRL.ClientId > 1
		AND PROP.attrName = 'NAS vServer Name'
		AND PROP.modified = 0
-- If the SVM name is not present in the client properties, then fetch the SVM name from the Array Config
UPDATE	T
SET		T.SVMName = CFGS.ValueStr
FROM	@tblArrayNums T INNER JOIN SMConfigs (NOLOCK) CFGS ON T.ControlHostId = CFGS.ArrayId
WHERE	LEN(T.SVMName) = 0
AND CFGS.MasterConfigId = 200 /*SMCONFIG_NETAPP_NAME_CLUSTER_SVM_NAME*/
AND CFGS.AssocType = 3 /*MMSM_AT_ARRAY*/
-- Set UUID
UPDATE	T
SET		T.SVMUUID = CTRL.UniqueIdentifier
FROM	@tblArrayNums T
		INNER JOIN SMControlHost CTRL (NOLOCK) ON T.ControlHostId = CTRL.ControlHostId
SELECT	ControlHostId, SVMName, SVMUUID FROM @tblArrayNums
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMFetchSVMNameUsingArrayNum')
	delete from GxQscripts where name = 'MM_SMFetchSVMNameUsingArrayNum'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMFetchSVMNameUsingArrayNum')
	delete from GXDBVersions where aliasname = 'MM_SMFetchSVMNameUsingArrayNum'
GO

insert into GXDBVersions values(2, 'MM_SMFetchSVMNameUsingArrayNum',  '00000000000000000000', 'MM_SMFetchSVMNameUsingArrayNum', '00000000000000000000')
GO

