

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMFetchPruneReqDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMFetchPruneReqDetails.sp,v $ $Id: MM_SMFetchPruneReqDetails.sp,v 1.1.4.11 2020/12/19 05:03:33 kkumar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMFetchPruneReqDetails')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMFetchPruneReqDetails <<<'
	drop procedure MM_SMFetchPruneReqDetails
END
IF EXISTS (select * from GxQscripts where name='MM_SMFetchPruneReqDetails')
	delete from GxQscripts where name = 'MM_SMFetchPruneReqDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMFetchPruneReqDetails')
	delete from GXDBVersions where aliasname = 'MM_SMFetchPruneReqDetails'
GO
print '... Creating Procedure: MM_SMFetchPruneReqDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMFetchPruneReqDetails
  @i_xmlText XML
AS
  DECLARE @o_SMVolSnapMapId integer
  DECLARE @o_SMVolumeId integer
  DECLARE @o_SMSnapId integer
  DECLARE @o_SMMetaDataId integer
  DECLARE @o_IsSnapLinked integer
  DECLARE @o_MAForDeletion integer
  DECLARE @o_KeyForDel varchar(1024)
  DECLARE @o_MMErrorCode integer
  DECLARE @o_ErrorMsg varchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	 DECLARE @retVal integer = 0
	 DECLARE @errorMsg   varchar(MAX) =''
	/*
	SP input to fetch the details for the requests
	<MM_SMFetchPruneReqDetails>
		<callForNewlyAgedSnaps>1</callForNewlyAgedSnaps>
		<req Eng="3" Ctrl="74" MAId="3495" IsAC="0" />
		<req Eng="3" Ctrl="76" MAId="2716" IsAC="0" />
		<req Eng="3" Ctrl="7" MAId="1012" IsAC="1" />
		<req Eng="3" Ctrl="82" MAId="1012" IsAC="1" />
		<req Eng="3" Ctrl="84" MAId="1013" IsAC="1" />
		<req Eng="3" Ctrl="7" MAId="1015" IsAC="1" />
	</MM_SMFetchPruneReqDetails>'
	*/
	DECLARE @tbl_Input TABLE (
		SnapShotEngineId	INT,
		ControlHostId		INT,
		MAId				INT,
		IsAnAC				INT,
		ReqNum				INT
	)
	INSERT INTO @tbl_Input
	SELECT	R.ref.value('./@Eng','int') SnapEngineId,
			R.ref.value('./@Ctrl','int') ControlHostId,
			R.ref.value('./@MAId','int') MAId ,
			R.ref.value('./@IsAC','int') IsAnAC,
			CASE WHEN R.ref.value('./@IsAC','int')  = 1 THEN
				ROW_NUMBER() OVER (PARTITION BY R.ref.value('./@Eng','int') ,R.ref.value('./@Ctrl','int') ORDER BY R.ref.value('./@MAId','int'))
			ELSE
				ROW_NUMBER() OVER (PARTITION BY R.ref.value('./@Eng','int') ,R.ref.value('./@Ctrl','int'), R.ref.value('./@MAId','int') ORDER BY R.ref.value('./@MAId','int'))
			END
	FROM	@i_xmlText.nodes('/MM_SMFetchPruneReqDetails/req') R(ref)
	IF object_id('tempdb.dbo.#tblSMVolumeMountStatus') IS NOT Null DROP TABLE #tblSMVolumeMountStatus
	create table	#tblSMVolumeMountStatus  (
			MountStatus integer,
			primary key (mountstatus)
		)
	INSERT INTO #tblSMVolumeMountStatus SELECT 0					/*SM_VS_NONE*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 10			/*SM_VS_PRP_STARTED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 11			/*SM_VS_PRP_DV_DSCVRD*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 12	/*SM_VS_PRP_DV_DSCVR_FAILED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 18				/*SM_VS_PRP_FAILED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 19			/*SM_VS_PRP_PREPARED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 20			/*SM_VS_UPRP_STARTED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 28			/*SM_VS_UPRP_FAILED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 29			/*SM_VS_UPRP_FINISHED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 30			/*SM_VS_CRT_STARTED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 38				/*SM_VS_CRT_FAILED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 39			/*SM_VS_CRT_CREATED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 79			/*SM_VS_UMT_UNMOUNTED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 89			/*SM_VS_RVT_REVERTED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 90			/*SM_VS_DEL_STARTED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 97		/*SM_VS_DEL_EXT_DELETED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 98				/*SM_VS_DEL_FAILED*/
	IF object_id('tempdb.dbo.#tblSMVolumePruneFlags') IS NOT Null DROP TABLE #tblSMVolumePruneFlags
	create table #tblSMVolumePruneFlags (
		PruneFlags integer,
		primary key (PruneFlags)
		)
	INSERT INTO #tblSMVolumePruneFlags SELECT 0		/*MM_SM_PRUNEFLAGS_INACTIVE*/
	INSERT INTO #tblSMVolumePruneFlags SELECT 1		/*MM_SM_PRUNEFLAGS_ACTIVE*/
	INSERT INTO #tblSMVolumePruneFlags SELECT 2		/*MM_SM_PRUNEFLAGS_TOBEAGED*/
	INSERT INTO #tblSMVolumePruneFlags SELECT 6		/*MM_SM_PRUNEFLAGS_PHYSIC*/
	DECLARE @RetryParam integer = 0
SET @RetryParam = ISNULL((select Value from MMConfigs (NOLOCK) where name = 'MMS2_CONFIG_VOLSNAP_RETRY_COUNT'), 50/*MMS2_CONFIG_VOLSNAP_RETRY_COUNT_DEFAULT*/)
	DECLARE @i_callForNewlyAgedSnaps INT = 0
	SET @i_callForNewlyAgedSnaps = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMFetchPruneReqDetails/callForNewlyAgedSnaps') R(ref)), 1)
	-- Batch hint for the number of snap per request
	DECLARE @SCNumOfSnapsPerDelReq INT = 0
SET @SCNumOfSnapsPerDelReq = ISNULL(( SELECT Value FROM MMConfigs (NOLOCK) WHERE name = 'MMS2_CONFIG_NUM_OF_SNAPS_PER_DEL_REQ'), 100)
	DECLARE @CurrentTime	INT = 0
	SET @CurrentTime = dbo.GetUnixTime(GETUTCDATE())
	IF object_id('tempdb.dbo.#tblMapAged') IS NOT NULL DROP TABLE #tblMapAged
	CREATE TABLE #tblMapAged (
		SMVolSnapMapId		integer,
		SMVolumeId			integer,
		SMSnapId			integer,
		MetaDataId			integer,
		IsSnapLinked		integer,
		SnapShotEngineId	integer,
		ControlHostId		integer,
		MAForDeletion		integer,
		KeyForDel			varchar(512),
		AppId				integer,
		CommcellId			integer,
		CopyId				integer,
		JobId				integer,
		MasterJobId 		integer,
		RecoveryPointId 	integer
	)
	-- If this flag is set, prune only the newly aged
	IF @i_callForNewlyAgedSnaps = 1
	BEGIN
		INSERT INTO #tblMapAged
		SELECT		A.SMVolSnapMapId, A.SMVolumeId, A.SMSnapId, 0,0, A.SnapShotEngineId, A.ControlHostId, B.MAId,
					CASE WHEN B.IsAnAC = 1 THEN ( CAST( A.SnapShotEngineId AS VARCHAR)+ '_' + CAST(A.ControlHostId AS VARCHAR)+ '_' + CAST(B.reqNum AS VARCHAR) )
					ELSE ( CAST( A.SnapShotEngineId AS VARCHAR)+ '_' + CAST(A.ControlHostId AS VARCHAR)+ '_' + CAST(B.MAId AS VARCHAR)+ '_' + CAST(B.reqNum AS VARCHAR) ) END
					, A.AppId , A.CommCellId , A.CopyId, A.JobId, A.MasterJobId, A.RecoveryPointId
		FROM
		(
		SELECT		DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, SNAP.SMSnapId, SNAP.SnapShotEngineId, SNAP.ControlHostId, VOL.MountStatusUpdateTime, CASE WHEN INP.IsAnAC = 1 THEN 1 ELSE VOL.SourceClientId END AS clientId,
					CASE WHEN INP.IsAnAC = 1 THEN (ceiling(DENSE_RANK() over (partition by SNAP.SnapShotEngineId, SNAP.ControlHostId order by VOL.MountStatusUpdateTime asc, SNAP.SMSnapId ) / CAST(@SCNumOfSnapsPerDelReq AS FLOAT)) )
					ELSE (ceiling(DENSE_RANK() over (partition by SNAP.SnapShotEngineId, SNAP.ControlHostId, VOL.SourceClientId order by VOL.MountStatusUpdateTime asc, SNAP.SMSnapId ) / CAST(@SCNumOfSnapsPerDelReq AS FLOAT)) ) END as reqNum
					, VOL.AppId , VOL.CommCellId , VOL.CopyId, VOL.JobId, VOL.MasterJobId, VOL.RecoveryPointId
		FROM		@tbl_Input INP INNER JOIN SMSnap (NOLOCK) SNAP ON INP.SnapShotEngineId = SNAP.SnapShotEngineId AND INP.ControlHostId = SNAP.ControlHostId
					INNER JOIN SMVolSnapMap (NOLOCK) MAP ON MAP.SMSnapId = SNAP.SMSnapId
					INNER JOIN SMVolume (NOLOCK) VOL ON MAP.SMVolumeId = VOL.SMVolumeId
					LEFT JOIN archFileCopy AFC (NOLOCK) ON AFC.archFileId = VOL.ArchFileId AND AFC.archCopyId = VOL.CopyId AND AFC.commCellId = VOL.CommCellId
		WHERE		VOL.PruneFlags NOT IN (SELECT PruneFlags FROM #tblSMVolumePruneFlags)
					AND VOL.MountStatus IN (SELECT MountStatus FROM #tblSMVolumeMountStatus)
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMSnapResource (NOLOCK))
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMVolAction (NOLOCK))
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMMountVolume (NOLOCK) WHERE MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/ )
					AND VOL.MountStatus < 99 /*SM_VS_DEL_DELETED*/
					AND VOL.RetryCount = 0
					AND VOL.SnapSource = 0 /*SM_SS_CV*/
					AND VOL.CopyId NOT IN (SELECT ID FROM archGroupCopy (NOLOCK) WHERE isSnapCopy = 1 AND isMirrorCopy = 1)
AND ( (SNAP.ControlHostId > 0) OR (SNAP.ControlHostId = 0 AND SNAP.SnapShotEngineId IN(1, 53, 48, 58, 59)) )
					AND (INP.IsAnAC = 1 OR (INP.MAId = VOL.SourceClientId))
AND ( VOL.PruneFlags < 7 OR (VOL.PruneFlags = 7 AND (AFC.flags & 256/*CVA_AGED_DATA_FLAG*/ > 0 OR AFC.flags IS NULL)) )
					AND SNAP.SnapStatus <> 20 /*CVSO::DELETED*/
		) A
		INNER JOIN @tbl_Input B ON A.ControlHostId = B.ControlHostId AND A.SnapShotEngineId = B.SnapShotEngineId AND (CASE WHEN B.IsAnAC = 1 THEN 1 ELSE B.MAId END) = A.clientId
		WHERE A.reqNum = B.reqNum
		ORDER BY A.SnapShotEngineId, A.ControlHostId, B.ReqNum
	END
	-- prune the entries which have already been attempted once
	ELSE
	BEGIN
		INSERT INTO #tblMapAged
		SELECT		A.SMVolSnapMapId, A.SMVolumeId, A.SMSnapId, 0,0, A.SnapShotEngineId, A.ControlHostId, B.MAId,
					CASE WHEN B.IsAnAC = 1 THEN ( CAST( A.SnapShotEngineId AS VARCHAR)+ '_' + CAST(A.ControlHostId AS VARCHAR)+ '_' + CAST(B.reqNum AS VARCHAR) )
					ELSE ( CAST( A.SnapShotEngineId AS VARCHAR)+ '_' + CAST(A.ControlHostId AS VARCHAR)+ '_' + CAST(B.MAId AS VARCHAR)+ '_' + CAST(B.reqNum AS VARCHAR) ) END
					, A.AppId , A.CommCellId , A.CopyId, A.JobId, A.MasterJobId, A.RecoveryPointId
		FROM
		(
		SELECT		DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, SNAP.SMSnapId, SNAP.SnapShotEngineId, SNAP.ControlHostId, VOL.MountStatusUpdateTime, CASE WHEN INP.IsAnAC = 1 THEN 1 ELSE VOL.SourceClientId END AS clientId,
					CASE WHEN INP.IsAnAC = 1 THEN (ceiling(DENSE_RANK() over (partition by SNAP.SnapShotEngineId, SNAP.ControlHostId order by VOL.MountStatusUpdateTime asc, SNAP.SMSnapId ) / CAST(@SCNumOfSnapsPerDelReq AS FLOAT)) )
					ELSE (ceiling(DENSE_RANK() over (partition by SNAP.SnapShotEngineId, SNAP.ControlHostId, VOL.SourceClientId order by VOL.MountStatusUpdateTime asc, SNAP.SMSnapId ) / CAST(@SCNumOfSnapsPerDelReq AS FLOAT)) ) END as reqNum
					, VOL.AppId , VOL.CommCellId , VOL.CopyId , VOL.JobId, VOL.MasterJobId, VOL.RecoveryPointId
		FROM		@tbl_Input INP INNER JOIN SMSnap (NOLOCK) SNAP ON INP.SnapShotEngineId = SNAP.SnapShotEngineId AND INP.ControlHostId = SNAP.ControlHostId
					INNER JOIN SMVolSnapMap (NOLOCK) MAP ON MAP.SMSnapId = SNAP.SMSnapId
					INNER JOIN SMVolume (NOLOCK) VOL ON MAP.SMVolumeId = VOL.SMVolumeId
					INNER JOIN SMSnapShotEngine ENG (NOLOCK) ON ENG.SnapShotEngineId = SNAP.SnapshotEngineId
					LEFT JOIN archFileCopy AFC (NOLOCK) ON AFC.archFileId = VOL.ArchFileId AND AFC.archCopyId = VOL.CopyId AND AFC.commCellId = VOL.CommCellId
		WHERE		VOL.PruneFlags NOT IN (SELECT PruneFlags FROM #tblSMVolumePruneFlags)
					AND VOL.MountStatus IN (SELECT MountStatus FROM #tblSMVolumeMountStatus)
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMSnapResource (NOLOCK))
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMVolAction (NOLOCK))
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMMountVolume (NOLOCK) WHERE MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/ )
					AND VOL.MountStatus < 99 /*SM_VS_DEL_DELETED*/
					AND VOL.RetryCount > 0 AND VOL.RetryCount <= @RetryParam
					AND VOL.SnapSource = 0 /*SM_SS_CV*/
					AND VOL.CopyId NOT IN (SELECT ID FROM archGroupCopy (NOLOCK) WHERE isSnapCopy = 1 AND isMirrorCopy = 1)
					AND (  (VOL.MountStatusUpdateTime + (ENG.DeleteCleanupInterval * 60)) < @CurrentTime)
AND ( (SNAP.ControlHostId > 0) OR (SNAP.ControlHostId = 0 AND SNAP.SnapShotEngineId IN(1, 53, 48, 58, 59)) )
					AND (INP.IsAnAC = 1 OR (INP.MAId = VOL.SourceClientId))
AND ( VOL.PruneFlags < 7 OR (VOL.PruneFlags = 7 AND (AFC.flags & 256/*CVA_AGED_DATA_FLAG*/ > 0 OR AFC.flags IS NULL)) )
					AND SNAP.SnapStatus <> 20 /*CVSO::DELETED*/
		) A
		INNER JOIN @tbl_Input B ON A.ControlHostId = B.ControlHostId AND A.SnapShotEngineId = B.SnapShotEngineId AND (CASE WHEN B.IsAnAC = 1 THEN 1 ELSE B.MAId END) = A.clientId
		WHERE A.reqNum = B.reqNum
		ORDER BY A.SnapShotEngineId, A.ControlHostId, B.ReqNum
	END
	-----------------------------------------------------------------------------------
	-- SKIP deletion of snaps in latest cycle while Synth full job running.
	-----------------------------------------------------------------------------------
	DECLARE @SynthFullJobId INT  = 0
	DECLARE @SnapJobId INT = 0
	DECLARE @BkpLevelSynthFull INT = 64
	DECLARE @jobStatusCompleted INT = 1
	DECLARE @jobStatusCompletedWError INT = 3
	DECLARE @jobStatusCompletedWWarning INT = 14
	declare @tblToSkipForsynthFullJob TABLE ( SynthFullJobId INT, SnapJob INT , AppId INT, SMVolumeId INT)
	--
	-- collect all the snaps which belongs TMP.appid where synthfull job is running
	-- we have to skip all the volume deletion
	--
	INSERT 	INTO @tblToSkipForsynthFullJob
	SELECT	BKPINFO.jobId, TMP.JobId, TMP.AppId, TMP.SMVolumeId
	FROM	#tblMapAged TMP
				INNER JOIN archGroup AG (READUNCOMMITTED)
					ON TMP.CopyId = AG.defaultSnapCopy
				INNER JOIN APP_SubClientProp PROP (READUNCOMMITTED)
					ON PROP.componentNameId = TMP.AppId
					AND PROP.attrName = 'sys:full cycle num'
					AND PROP.modified = 0
				INNER JOIN JMBkpStats BKP (READUNCOMMITTED)
					ON BKP.jobId = TMP.JobId
					AND BKP.commCellId = TMP.CommCellId
					AND BKP.fullCycleNum = PROP.attrVal
					AND BKP.status IN (@jobStatusCompleted, @jobStatusCompletedWError, @jobStatusCompletedWWarning)
				INNER JOIN JMBkpJobInfo BKPINFO (READUNCOMMITTED)
					ON BKPINFO.applicationId = TMP.AppId
					AND BKPINFO.commcellId = TMP.CommCellId
					AND BKPINFO.bkpLevel = @BkpLevelSynthFull
	WHERE 	BKPINFO.jobId > 0
	--
	-- REMOVE smvolumes entries that we collected above , using appid + smvolumeid for joining
	-- Instead of failing whole batch which has other subclient's snaps too which should be allowed to delete
	-- caused a TR ; SP16 (V11) - ACP IT Solutions GmbH - Austria - FE261 - SP16 - Snapshots not removed from Array - 200312-180 CVLT::0098059027
    DELETE	FROM  VOL
	FROM 	#tblMapAged AS VOL
			INNER JOIN	@tblToSkipForsynthFullJob SKIP_Synth
				ON	VOL.SMVolumeid = SKIP_Synth.SMVolumeId
				AND VOL.AppId = SKIP_Synth.AppId
	-- Remove volumes whose shared volume is mounted or has entries in smsnapresource as if we let those volumes go
	-- they are causing whole batch of delete failure and causing buildup on file server. This is very common for vsa v2 ( they consider whole masterjob as shared ) .
	    -----------------------------------------------------------------------------
    -- Remove all volumes within SCG or LREP group -- Use RecoveryPointId as Group Id
    -----------------------------------------------------------------------------
	-- 	Validation MM_SMVolSnapsToDelete : line :281
	--    SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM SMSnapResource (READUNCOMMITTED) WHERE SMVolumeId IN (SELECT SMVolumeId FROM @tblSharedVols))
	DELETE	FROM  VOL
	FROM 	#tblMapAged AS VOL
    INNER JOIN    SMVolume A (READUNCOMMITTED)
		ON VOL.RecoveryPointId  = A.RecoveryPointId
	INNER JOIN    SMSnapResource RES (READUNCOMMITTED)
		ON A.SMVolumeId = RES.SMVolumeId
    WHERE   (
                A.RecoveryPointId > 0
                AND (
						(
A.AppTypeId = 22
							AND
(A.VolumeFlags & 8192 > 0) 	/*CVSM_VOLUMEFLAGS_SCG_VOLUMES*/
						)
						OR
(A.VolumeFlags & 4096 > 0 ) 	/*CVSM_VOLUMEFLAGS_LREP_JOB_ENV_DB*/
					)
            )
	-- Remove VSA V2 volumes too whose shared  volume is reserved
	DELETE	FROM  VOL
	FROM 	#tblMapAged AS VOL
    INNER JOIN    SMVolume A (READUNCOMMITTED)
		ON A.MasterJobId  = VOL.MasterJobId
	INNER JOIN    SMSnapResource RES (READUNCOMMITTED)
		ON A.SMVolumeId = RES.SMVolumeId
    WHERE   (
                ---- For VSA VMware V2 and Hyper-V V2
                (
(A.AppTypeId = 106        )
                    OR
(A.AppTypeId = 33    )
                )
AND ( A.VolumeFlags & CAST(4294967296 AS BIGINT) > 0)
                AND  A.MasterJobId > 0
            )
	-------------------------------------------------------------------------------------------
	-- All SMvolume entries for a single snapshot (in case of qtrees) must be deleted together for VSA V2 DS snaps
	-------------------------------------------------------------------------------------------
	DECLARE @tblVSAVolGroups  TABLE ( SMVolumeId integer, GroupId INTEGER, SMSnapId INTEGER  )
	INSERT	INTO @tblVSAVolGroups
	SELECT	DISTINCT TVOL.SMVolumeId, SNAP.GroupId, SNAP.SMSnapId
	FROM	#tblMapAged TVOL
			INNER JOIN SMVolume VOL (READUNCOMMITTED)
				ON 	VOL.SMVolumeId = TVOL.SMVolumeId
AND VOL.VolumeFlags & CAST( 4294967296 AS BIGINT) /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/ > 0
			INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED)
				ON MAP.SMVolumeId = VOL.SMVolumeId
			INNER JOIN SMSnap SNAP (READUNCOMMITTED)
				ON MAP.SMSnapId = SNAP.SMSnapId
	--
	-- Get All SM snaps dependent volumes for above selected smvolume in tblVSAVolGroups
	--
	DECLARE @tblFUllMap  TABLE ( SMVolumeId integer, SMSnapId integer )
	INSERT	INTO @tblFUllMap
	SELECT	DISTINCT MAP.SMVolumeId, MAP.SMSnapId
	FROM	@tblVSAVolGroups TVOL
			INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED)
				ON MAP.SMSnapId = TVOL.SMSnapId
			INNER JOIN SMSnap SNAP (READUNCOMMITTED)
				ON MAP.SMSnapId = SNAP.SMSnapId
    --
	-- Remove smvolume entries whose snaps is having more entries in volsnapmap , means they are not the last one
	--
    DELETE
	FROM  @tblVSAVolGroups
	WHERE  SMSnapId IN (
						-- Right outer join means full map of snap has some volumes which are not there
						-- in selected for deletion group and their respective entry is NULL.
 						SELECT  fullSnapMap.SMSnapId
							FROM @tblVSAVolGroups tgroup
								RIGHT OUTER JOIN @tblFUllMap fullSnapMap
									ON fullSnapMap.SMVolumeId = tgroup.SMVolumeId
						WHERE tgroup.SMSnapId IS  NULL
					)
	-- use above volumes of VSA v2 ( tblVSAVolGroups ) which are given for delete and they are the last for their snaps ( means hw delete will happen )
	-- As these are the last volume snap or all volumes of this snap are in the selected list , lets see if it has groupid which
	-- is matching to some other snap not part of delete request .
	DELETE  TVOL
	FROM #tblMapAged TVOL
	INNER JOIN SMVolume VOL (READUNCOMMITTED)
			ON 	VOL.CopyId = TVOL.CopyId
				AND VOL.MasterJobId = TVOL.MasterJobId
				AND VOL.MasterJobId > 0
AND VOL.VolumeFlags & CAST( 4294967296 AS BIGINT) /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/ > 0
AND VOL.VolumeFlags & CAST( 536870912 AS BIGINT) /*CVSM_VOLUMEFLAGS_VM_LEVEL_SNAP_DB*/ = 0
	INNER JOIN @tblVSAVolGroups TGROUP
			ON  TVOL.SMVolumeId = TGROUP.SMVolumeId
	INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED)
			ON VOL.SMVolumeId = MAP.SMVolumeId
	INNER JOIN SMSnap SNAP	(READUNCOMMITTED)
			ON MAP.SMSnapId = SNAP.SMSnapId
	WHERE  	-- Not to check for non-NetApp engine for group id , even any volume within same master job pending is good enough to block
		  	(
SNAP.SnapShotEngineId <> 3
				OR
				(
					TGROUP.GroupId = SNAP.GroupId
					AND SNAP.GroupId > 0
				)
			)
			AND VOL.SMVolumeId <> TVOL.SMVolumeId
			AND VOL.PruneFlags = 1
			AND VOL.CommCellId = TVOL.CommCellId
	------------------------------------------------------------------
    -- Snap linked to active volumes
    ------------------------------------------------------------------
    UPDATE  B SET IsSnapLinked = 1
    FROM    #tblMapAged B INNER JOIN SMVolSnapMap A (NOLOCK) ON A.SMSnapId = B.SMSnapId
            INNER JOIN SMVolume C (NOLOCK) ON A.SMVolumeId = C.SMVolumeId
            LEFT JOIN #tblMapAged VOL ON C.SMVolumeId = VOL.SMVolumeId
    WHERE   VOL.SMVolumeId IS NULL
            AND C.MountStatus < 99
    ------------------------------------------------------------------
    -- Get all metadata for volumes
    ------------------------------------------------------------------
    INSERT  INTO #tblMapAged
    SELECT  0, RefId, 0, MetaDataId, 0, 0, 0, 0,'',0,0,0,0,0,0
    FROM    SMMetaData WITH (READUNCOMMITTED)
WHERE   RefType = 1 /*MM_SM_METADATA_REFTYPE_SMVOLUME*/
    AND     RefId in (SELECT DISTINCT SMVolumeId FROM #tblMapAged)
    ------------------------------------------------------------------
    -- Get all metadata for snaps
    ------------------------------------------------------------------
    INSERT  INTO #tblMapAged
    SELECT  0, 0, RefId, MetaDataId, 0, 0, 0, 0,'',0,0,0,0,0,0
    FROM    SMMetaData WITH (READUNCOMMITTED)
WHERE   RefType = 2 /*MM_SM_METADATA_REFTYPE_SMSNAP*/
    AND     RefId in (SELECT DISTINCT SMSnapId FROM #tblMapAged)
	SELECT SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, IsSnapLinked, MAForDeletion, KeyForDel, @retVal, @errorMsg
    FROM #tblMapAged
    ORDER BY KeyForDel DESC
	IF object_id('tempdb.dbo.#tblSMVolumeMountStatus') IS NOT Null DROP TABLE #tblSMVolumeMountStatus
	IF object_id('tempdb.dbo.#tblSMVolumePruneFlags') IS NOT Null DROP TABLE #tblSMVolumePruneFlags
	IF object_id('tempdb.dbo.#tblMapAged') IS NOT NULL DROP TABLE #tblMapAged
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMFetchPruneReqDetails')
	delete from GxQscripts where name = 'MM_SMFetchPruneReqDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMFetchPruneReqDetails')
	delete from GXDBVersions where aliasname = 'MM_SMFetchPruneReqDetails'
GO

insert into GXDBVersions values(2, 'MM_SMFetchPruneReqDetails',  '00010001000400110000', 'MM_SMFetchPruneReqDetails', '00010001000400110000')
GO

